/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.stokstic;

import com.dassault.cecilia.core.plugin.AbstractPlugPanelInfo;
import com.dassault.cecilia.core.plugin.AbstractPlugTask;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mbsa.stokstic.MocaLaunch;
import com.dassault.cecilia.plugin.mbsa.stokstic.PluginCmdMocaRP;
import com.dassault.cecilia.plugin.mbsa.stokstic.ResMoca;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class MocaTask
extends AbstractPlugTask {
    Plugable _launcher;
    String _filePath;
    IModel _model;
    double _duration;
    long _seed;
    int _nbrStory;
    int _delay;
    MocaLaunch _moK;
    ArrayList<String> _moKResult;
    StringWriter _outWriter;
    int _nbrStep;
    int _curStep;
    boolean _errorFlag;

    public MocaTask(Plugable launcher, IModel model, String filePath, double duration, int nbrStory, long seed, int delay) {
        this._launcher = launcher;
        this._model = model;
        this._filePath = filePath;
        this._duration = duration;
        this._nbrStory = nbrStory;
        this._seed = seed;
        this._delay = delay;
    }

    public void init() throws IOException {
        this._errorFlag = false;
        this._curStep = 1;
        this._nbrStep = PlugableUtility.getIntOpt((Plugable)this._launcher, (String)PluginCmdMocaRP.OPT_MOCA_STEP, (int)10);
        if (this._nbrStep <= 0) {
            this._nbrStep = 1;
        }
        if (this._nbrStep > this._nbrStory) {
            this._nbrStep = this._nbrStory;
        }
        this._outWriter = new StringWriter();
        String cmd = PlugableUtility.getStrOpt((Plugable)this._launcher, (String)PluginCmdMocaRP.OPT_MOCABIN, (String)"Moca.exe");
        this._moK = new MocaLaunch(cmd);
        this._moK.setPrompt("Moca >");
        this._moKResult = new ArrayList();
        if (!this._moK.openSession()) {
            throw new IOException(this._moK.getException());
        }
        this._moK.sendCommand("load Moca \"" + this._filePath + "\" ;\n", this._moKResult);
        if (this._moKResult.size() > 1) {
            for (int i = 0; i < this._moKResult.size(); ++i) {
                this._outWriter.append(this._moKResult.get(i)).append("\n");
            }
            this._moKResult.clear();
        }
    }

    private void cmdSend(String cmd, int nbrOutput, boolean traceInput) throws Throwable {
        if (!this._moK.sendCommand(cmd, this._moKResult)) {
            throw this._moK.getException();
        }
        if (this._moKResult.size() > nbrOutput) {
            if (traceInput) {
                this._outWriter.append("Moca > ").append(cmd);
            }
            for (int i = 0; i < this._moKResult.size(); ++i) {
                this._outWriter.append(this._moKResult.get(i)).append("\n");
            }
        }
        this._moKResult.clear();
    }

    private void cmdSend(String cmd, int nbrOutput) throws Throwable {
        this.cmdSend(cmd, nbrOutput, true);
    }

    private void cmdBeg() throws Throwable {
        this.cmdSend("set net 'Alta.net' ;\nduration " + this._duration + " ;\nexit;\n", 2);
        this.cmdSend("set seed " + this._seed + " ;\n", 1);
        this.cmdSend("set delay " + this._delay + " ;\n", 1);
        this.cmdSend("set max-loop " + PlugableUtility.getIntOpt((Plugable)this._launcher, (String)PluginCmdMocaRP.OPT_MOCA_LOOP, (int)100) + " ;\n", 1);
        this.cmdSend("set timer MocaTask ;\n", 1);
        this.cmdSend("timer MocaTask start ;\n", 1);
    }

    private void cmdSimul(int nbr) throws Throwable {
        this.cmdSend("simul 'Alta.net' {story " + nbr + "} ;\n", 3);
    }

    private void cmdEnd(String pathResult) throws Throwable {
        this.cmdSend("display result 'Alta.net' > \"" + pathResult + "\" ;\n", 2);
        this.cmdSend("timer MocaTask stop ;\n", 1);
        this.cmdSend("display timer MocaTask \"Time simulation : %U [%R]\" ;\n", 0, false);
        this.cmdSend("exit ;\n", -1);
    }

    public boolean isPriority() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInfo(String key) {
        if (key.equals("process.msg")) {
            MocaTask mocaTask = this;
            synchronized (mocaTask) {
                if (this._curStep < 0) {
                    return ResMoca.getString("PRV_CMD_MOK_WAIT");
                }
                if (this._curStep == Integer.MAX_VALUE) {
                    return ResMoca.getString("PRV_CMD_MOK_STOP_PROCESS");
                }
                if (this._curStep >= this._nbrStep) {
                    return ResMoca.getString("PRV_CMD_MOK_FINISH");
                }
                return ResMoca.getString("PRV_CMD_MOK_WORK") + this._curStep;
            }
        }
        if (key.equals("process.msg.high")) {
            StringBuffer msg = new StringBuffer(10);
            msg.append(this._curStep >= this._nbrStep ? this._nbrStep : this._curStep);
            msg.append("/");
            msg.append(this._nbrStep);
            return msg.toString();
        }
        if (key.equals("process.p1000")) {
            return Integer.toString(this._curStep < 0 ? 0 : (int)((double)(this._curStep - 1) / (double)this._nbrStep * 1000.0));
        }
        if (key.equals("plugin.name")) {
            return "Moca-RPc";
        }
        if (key.equals("ptask.desc")) {
            return ResMoca.getString("PLUG_CMD_MOCARP_NAME");
        }
        return null;
    }

    public Icon getIcon(String key) {
        if (key.equals("ptask.icon")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("C-05.svg"));
        }
        return super.getIcon(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block23: {
            try {
                this.init();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this._launcher.getWindow()), ResMoca.getString("MSG_CMD_MOK_ERROR_LAUNCH") + e.getMessage());
                return;
            }
            try {
                if (this._errorFlag) {
                    this.displayResult(new File(this._filePath));
                    this.cmdSend("exit ;\n", -1);
                    Thread.sleep(250L);
                    return;
                }
                this.cmdBeg();
                while (!this.checkStopped() && this._curStep <= this._nbrStep) {
                    this.checkSuspended(false);
                    if (this._curStep <= this._nbrStep) {
                        int nbr = this._nbrStory / this._nbrStep;
                        if (this._curStep == this._nbrStep) {
                            nbr += this._nbrStory % this._nbrStep;
                        }
                        this.cmdSimul(nbr);
                    }
                    ++this._curStep;
                }
                if (this.checkStopped()) break block23;
                File resFile = null;
                try {
                    resFile = File.createTempFile("Moca", ".res");
                    this.cmdEnd(resFile.getAbsolutePath());
                    this.displayResult(resFile);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this._launcher.getWindow()), ResMoca.getString("ERR_TMP_FILE"), ResMoca.getString("DEF_TITLE"), 0);
                }
                finally {
                    if (resFile != null && !resFile.delete()) {
                        resFile.deleteOnExit();
                    }
                }
            }
            catch (InterruptedException e) {
                if (this.checkStopped()) {
                    return;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (this.checkStopped()) {
                    return;
                }
            }
            finally {
                if (!this._moK.closeSession()) {
                    this._moK.getException().printStackTrace();
                }
                this._moK = null;
            }
        }
    }

    private void displayResult(File fileResult) {
        try {
            AbstractPlugPanelInfo pPane = new AbstractPlugPanelInfo(){

                protected String getLabel() {
                    return ResMoca.getString("PRV_CMD_MOK_INFO_LBL");
                }

                public String getInfo(String key) {
                    if (key.equals("ppanel.title")) {
                        return ResMoca.getString("PRV_CMD_MOK_INFO_TITLE");
                    }
                    if (key.equals("ppanel.default.width")) {
                        return "600";
                    }
                    if (key.equals("ppanel.default.height")) {
                        return "480";
                    }
                    return super.getInfo(key);
                }
            };
            pPane.reset();
            if (fileResult != null) {
                pPane.load(fileResult);
            } else {
                pPane.append(ResMoca.getString("MSG_CMD_MOK_CANCEL_SIMUL"));
            }
            pPane.append("\n\n");
            pPane.append(ResMoca.getString("MSG_CMD_MOK_BARTRACE"));
            pPane.append(this._outWriter.toString());
            this._launcher.addPanel((PlugPanel)pPane, this._model.getUID());
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this._launcher.getWindow()), "Display result file : " + e1.getMessage(), ResMoca.getString("DEF_TITLE"), 0);
        }
    }
}

