/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.compute;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.compute.ARALIA4Computor;
import com.dassault.cecilia.lib.distrib.compute.CmdLauncher;
import com.dassault.cecilia.lib.distrib.compute.CopyStream;
import com.dassault.cecilia.lib.distrib.compute.ProcessComputor;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.request.Request;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public abstract class ARALIAComputor
extends ProcessComputor {
    public static final int MEMORYEXHAUSTED = -100;
    public static final int TIMEELAPSED = -200;
    public static final int BADLICENSE = -300;
    public static final int NODLL = -400;
    public static final int BADVERSION = -500;
    public static final int YOURANSWER = -600;
    public static final int UNABLETOOPENFILE = -700;
    public static final String THATSALLFOLKS = "THATSALLFOLKS";
    protected List<String> _processLaunchArray;
    protected String _configurationPath;
    protected String versionMessage;
    protected String version = "";

    public ARALIAComputor() {
        this.initErrorMessage();
    }

    protected abstract void initErrorMessage();

    @Override
    public boolean sendResultIfError() {
        return false;
    }

    @Override
    public boolean compute(Request req) {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.compute(req);
    }

    @Override
    protected void launchExecutable(Request req) throws IOException {
        File cmdFile = new File(JXTAProperties.getTempDir(), req.getCmdFileName());
        String[] cmds = new String[this._processLaunchArray.size() + (this._configurationPath == null ? 1 : 2)];
        cmds = this._processLaunchArray.toArray(cmds);
        int idx = this._processLaunchArray.size();
        if (this._configurationPath != null) {
            cmds[idx++] = this._configurationPath;
        }
        cmds[idx] = cmdFile.getAbsolutePath();
        this._proc = CmdLauncher.execute(req.getShortNumber(), cmds, null, JXTAProperties.getTempDir());
    }

    protected String getEndOfSession() {
        return THATSALLFOLKS;
    }

    @Override
    protected void launchOutputThread(final String id) throws IOException {
        CopyStream outThread = new CopyStream("ENGINE-OUT-" + id){

            @Override
            protected void println(String line) {
                super.println(line);
                String killerLine = ARALIAComputor.this.getEndOfSession();
                boolean flag = true;
                if (flag) {
                    int err = ARALIAComputor.this.containsErrorDuringComputing(line, true);
                    if (err != 12345) {
                        Loggeur.log(this.getClass(), Loggeur.FINE, "FINISHED because error in stdout");
                        ARALIAComputor.this.changeComputingState(1, err);
                        flag = false;
                        this.close();
                    }
                    if (line.equals(killerLine)) {
                        Thread killer = new Thread(){

                            @Override
                            public void run() {
                                if ((this).ARALIAComputor.this._proc != null) {
                                    try {
                                        1.sleep(2000L);
                                        (this).ARALIAComputor.this._proc.exitValue();
                                    }
                                    catch (Exception e) {
                                        Loggeur.log(this.getClass(), Loggeur.FINE, String.valueOf(id) + " - FINISHED because killer line in stdout");
                                        ARALIAComputor.this.changeComputingState(1, -800);
                                        (this).ARALIAComputor.this._proc.destroy();
                                    }
                                }
                            }
                        };
                        killer.start();
                    }
                }
            }
        };
        outThread.setIn(this._proc.getInputStream());
        outThread.setOut(System.out);
        outThread.start();
    }

    @Override
    protected void launchInputThread(String id) throws IOException {
        StringBuffer loadAndExit = new StringBuffer(64);
        loadAndExit.append("echo \"");
        loadAndExit.append(THATSALLFOLKS);
        loadAndExit.append("\";\n");
        loadAndExit.append("exit;\n");
        OutputStream entreeStd = this._proc.getOutputStream();
        byte[] loadexit = loadAndExit.toString().getBytes();
        entreeStd.write(loadexit);
        try {
            entreeStd.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String createMessage(int err) {
        return ARALIAComputor.createErrMessage(err);
    }

    public static String createErrMessage(int err) {
        switch (err) {
            case -100: {
                return ResJXTA.getString("ENGINE_ARALIA_MEMORYEXHAUSTED");
            }
            case -200: {
                return ResJXTA.getString("ENGINE_ARALIA_TIMEELAPSED");
            }
            case -300: {
                return ResJXTA.getString("ENGINE_ARALIA_ERROR_BAD_LICENSE");
            }
            case -400: {
                return ResJXTA.getString("ENGINE_ARALIA_ERROR_NO_DLL");
            }
            case -500: {
                return ResJXTA.getString("ENGINE_ARALIA_ERROR_VERSION");
            }
            case -600: {
                return ResJXTA.getString("ENGINE_ARALIA_YOURANSWER");
            }
            case -700: {
                return ResJXTA.getString("ENGINE_ARALIA_UNABLETOOPENFILE");
            }
        }
        return ProcessComputor.createErrMessage(err);
    }

    public abstract int containsErrorDuringTest(String var1, boolean var2);

    public String getVersion(String line) {
        if (!line.contains(this.versionMessage)) {
            return "";
        }
        int beginIndex = this.versionMessage.length();
        line.substring(beginIndex, beginIndex + 4);
        return line.substring(beginIndex, beginIndex + 4);
    }

    public static void main(String[] args) {
        JXTAProperties.initLaunchIni();
        System.setProperty("cecilia.jxta.path.temp", ".");
        Request req = new Request("123456789");
        req.setEngine("ARALIA4");
        req.setCmdFileName("cmdV2.ara");
        ARALIA4Computor computor = new ARALIA4Computor();
        computor.compute(req);
    }
}

