/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.entityinfo;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.PeerChangeListener;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.jxta.endpoint.Message;
import net.jxta.impl.protocol.PeerAdv;
import net.jxta.peer.PeerID;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.util.JxtaBiDiPipe;

public class InfoPeerJXTA {
    public static final int ONLINE = 1;
    public static final int NOTONLINE = 0;
    public static final int UNDERTIMATED = -1;
    protected String _type = "";
    protected PeerID _peerID;
    protected String _peerIDString;
    protected String _hostname = "";
    protected String _version = "0.0.0";
    protected String _name;
    protected String _desc;
    protected String _advDesc;
    protected int _status;
    protected PeerChangeListener.Reason _statusReason;
    protected PeerAdvertisement _peerAdv;
    protected int _networkErrorCount = 0;
    protected JxtaBiDiPipe _bidiPipe;
    public boolean _flag = false;
    protected PipeAdvertisement _pipeAdv;
    protected List<String> _authorizedTypes;
    protected int _cpuFrequency = 0;
    protected int _memory = 0;
    private ArrayList<PeerChangeListener> _changeListener = new ArrayList();

    public InfoPeerJXTA(PeerAdvertisement peerAdv) {
        this._peerID = peerAdv.getPeerID();
        this._peerIDString = this._peerID.toString();
        this._name = peerAdv.getName();
        this._status = 0;
        this._peerAdv = peerAdv;
    }

    public int getStatus() {
        return this._status;
    }

    public PeerChangeListener.Reason getStatusReason() {
        return this._statusReason;
    }

    public void setStatus(int status, PeerChangeListener.Reason reason) {
        if (this._status == 1) {
            this._networkErrorCount = 0;
        }
        if (this._status == status && this._statusReason == reason) {
            return;
        }
        if (this._status != status && reason != PeerChangeListener.Reason.BECAUSE_OF_NEWDISCOVERY) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getName());
            sb.append(" ");
            sb.append(status == 1 ? "ONLINE" : "NOTONLINE");
            sb.append(" ");
            sb.append(reason.name());
            Loggeur.log(this.getClass(), Loggeur.INFO, sb.toString());
        }
        this._statusReason = reason;
        int old = this._status;
        this._status = status;
        for (PeerChangeListener listener : this._changeListener) {
            listener.peerStatusChange(this._peerIDString, old, this._status, reason);
        }
    }

    public int getNetworkErrorCount() {
        return this._networkErrorCount;
    }

    public void setNetworkErrorCount(int count) {
        this._networkErrorCount = count;
    }

    public String getName() {
        return this._name;
    }

    public String getHostName() {
        return this._hostname;
    }

    public void setHostName(String hostname) {
        this._hostname = hostname;
    }

    public String getVersion() {
        return this._version;
    }

    public boolean isGoodVersion() {
        StringTokenizer stLocal;
        StringTokenizer stRemote;
        block3: {
            try {
                stRemote = new StringTokenizer(this.getVersion(), ".");
                stLocal = new StringTokenizer("1.8.4", ".");
                if (stRemote.nextToken().equals(stLocal.nextToken())) break block3;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return stRemote.nextToken().equals(stLocal.nextToken());
    }

    public void setVersion(String v) {
        this._version = v;
    }

    public PeerAdvertisement getPeerAdv() {
        return this._peerAdv;
    }

    public void setPeerAdv(PeerAdv peerAdv) {
        this._peerAdv = peerAdv;
    }

    public PeerID getPeerID() {
        return this._peerID;
    }

    public String getPeerIDString() {
        return this._peerIDString;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getAdvDesc() {
        return this._advDesc;
    }

    public void setAdvDesc(String desc) {
        this._advDesc = desc;
    }

    public String getUserDesc() {
        return this._desc;
    }

    public void setUserDesc(String desc) {
        this._desc = desc;
    }

    public List<String> getAuthorizedTypes() {
        return this._authorizedTypes;
    }

    public void setAuthorizedTypes(List<String> authorizedTypes) {
        this._authorizedTypes = authorizedTypes;
    }

    public void setBidiPipe(JxtaBiDiPipe bidiPipe) {
        this._bidiPipe = bidiPipe;
    }

    public synchronized boolean sendMessage(Message message) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        boolean sendOK = false;
        try {
            sendOK = this._bidiPipe.sendMessage(message);
            if (!sendOK) {
                throw new IOException();
            }
        }
        catch (Exception ioe) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, String.valueOf(this.toString()) + " Message not sent");
            this.setStatus(0, PeerChangeListener.Reason.BECAUSE_OF_BROKEN_PIPE);
            return false;
        }
        return true;
    }

    public boolean isBound() {
        return this._bidiPipe != null ? this._bidiPipe.isBound() : false;
    }

    public void closeConnection() {
        try {
            if (!this.isBound()) {
                return;
            }
            Loggeur.log(this.getClass(), Loggeur.INFO, MessageFormat.format(ResJXTA.getString("NETWORK_PIPE_CLOSING"), this._name));
            this._bidiPipe.close();
            Loggeur.log(this.getClass(), Loggeur.INFO, MessageFormat.format(ResJXTA.getString("NETWORK_PIPE_CLOSING_OK"), this._name));
        }
        catch (IOException e) {
            Loggeur.log(this.getClass(), Loggeur.INFO, MessageFormat.format(ResJXTA.getString("NETWORK_PIPE_CLOSING_ERROR"), this._name));
        }
    }

    public void addChangeListener(PeerChangeListener listener) {
        if (!this._changeListener.contains(listener)) {
            this._changeListener.add(listener);
        }
    }

    public void removeChangeListener(PeerChangeListener listener) {
        this._changeListener.remove(listener);
    }

    public void removeChangeListeners() {
        this._changeListener.clear();
    }

    public PipeAdvertisement getPipeAdv() {
        return this._pipeAdv;
    }

    public void setPipeAdv(PipeAdvertisement pipeAdv) {
        this._pipeAdv = pipeAdv;
    }

    public int getCpuFrequency() {
        return this._cpuFrequency;
    }

    public void setCpuFrequency(int frequency) {
        this._cpuFrequency = frequency;
    }

    public int getMemory() {
        return this._memory;
    }

    public void setMemory(int mem) {
        this._memory = mem;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(" ");
        sb.append(this._type);
        sb.append(" ");
        switch (this._status) {
            case 1: {
                sb.append("ONLINE");
                break;
            }
            case 0: {
                sb.append("NOTONLINE");
                break;
            }
            case -1: {
                sb.append("UNDERTIMATED");
            }
        }
        if (!this.isBound()) {
            sb.append(" NOT_CONNECTED");
        }
        return sb.toString();
    }

    public String toStringObject() {
        return super.toString();
    }
}

