/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.entityinfo;

import com.dassault.cecilia.lib.distrib.entityinfo.InfoAppList;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerApp;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoServerApp;
import com.dassault.cecilia.lib.distrib.entityinfo.PeerChangeListener;
import com.dassault.cecilia.lib.distrib.entityinfo.RemoteServerChangeListener;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import java.util.ArrayList;
import java.util.Iterator;

public class InfoServersApp
implements InfoAppList,
RemoteServerChangeListener {
    private ArrayList<RemoteServerChangeListener> _listeners;
    protected int _index = 0;
    protected ArrayList<InfoServerApp> _serversApp = new ArrayList();

    public InfoServersApp() {
        this._listeners = new ArrayList();
    }

    public synchronized void addServer(InfoServerApp s) {
        InfoServerApp oldServer = this.getServer(s.getPeerID());
        if (oldServer != null) {
            this._serversApp.remove(oldServer);
        }
        this._serversApp.add(s);
        s.addChangeListener(this);
        this.serveurListChange();
    }

    public synchronized void removeServer(InfoServerApp s) {
        if (s == null) {
            return;
        }
        this._serversApp.remove(s);
        s.removeChangeListener(this);
        this.serveurListChange();
    }

    public synchronized void clear() {
        this._serversApp.clear();
        this.serveurListChange();
    }

    public int size() {
        return this._serversApp.size();
    }

    @Override
    public InfoServerApp get(int index) {
        try {
            return this._serversApp.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public int getIndexOf(InfoServerApp peer) {
        return this._serversApp.indexOf(peer);
    }

    @Override
    public InfoPeerApp getRemoteInfoPeerApp(String peerID) {
        return this.getServer(peerID);
    }

    public int getNumberOfOKServer() {
        Iterator<InfoServerApp> it = this._serversApp.iterator();
        int i = 0;
        while (it.hasNext()) {
            InfoServerApp serveur = it.next();
            if (!serveur.canBeUsedForComputation()) continue;
            ++i;
        }
        return i;
    }

    public Iterator<InfoServerApp> iterator() {
        return new ArrayList<InfoServerApp>(this._serversApp).iterator();
    }

    public InfoServerApp getServer(String peerID) {
        for (InfoServerApp serverApp : this._serversApp) {
            if (!serverApp.getPeerID().equals(peerID)) continue;
            return serverApp;
        }
        return null;
    }

    public synchronized InfoServerApp getNextOnlineServer(int algorithm, String engine) {
        return this.getNextOnlineServer(algorithm, engine, 0, false);
    }

    private synchronized InfoServerApp getNextOnlineServer(int algorithm, String engine, int loopsDone, boolean allowNetError) {
        InfoServerApp serveur2;
        if (this._serversApp.size() == 0) {
            return null;
        }
        if (loopsDone >= this._serversApp.size()) {
            return null;
        }
        for (InfoServerApp serveur2 : this._serversApp) {
            if (serveur2.getStockSize() != 0 || !serveur2.canBeUsedForComputation(engine)) continue;
            return serveur2;
        }
        if (loopsDone == 0) {
            boolean alLeastOneOK = false;
            for (InfoServerApp serveur3 : this._serversApp) {
                if (!serveur3.canBeUsedForComputation(engine) || serveur3.getPeerJXTA().getNetworkErrorCount() != 0) continue;
                alLeastOneOK = true;
                break;
            }
            if (!alLeastOneOK) {
                allowNetError = true;
            }
        }
        serveur2 = null;
        try {
            serveur2 = this._serversApp.get(this._index);
        }
        catch (Exception e) {
            if (this._serversApp.size() > 0) {
                serveur2 = this._serversApp.get(0);
            }
            this._index = 0;
            if (serveur2 != null && serveur2.canBeUsedForComputation(engine)) {
                return serveur2;
            }
            return null;
        }
        this._index = this._index < this._serversApp.size() - 1 ? ++this._index : 0;
        if (serveur2 != null && serveur2.canBeUsedForComputation(engine) && (serveur2.getPeerJXTA().getNetworkErrorCount() == 0 || allowNetError)) {
            return serveur2;
        }
        return this.getNextOnlineServer(algorithm, engine, loopsDone + 1, allowNetError);
    }

    public void setOfLineServersOlderThan(long time) {
        Iterator<InfoServerApp> it = this.iterator();
        while (it.hasNext()) {
            InfoServerApp remote = it.next();
            InfoPeerJXTA peerRemote = remote.getPeerJXTA();
            int peerNetworkError = peerRemote.getNetworkErrorCount();
            if (remote.getLastInfoTime() < time) {
                Loggeur.log(this.getClass(), Loggeur.WARNING, String.valueOf(remote.getName()) + "didn't replyed");
                if (peerNetworkError >= 2) {
                    peerRemote.setStatus(0, PeerChangeListener.Reason.BECAUSE_OF_LACK_OF_INFO_REPONSE);
                    continue;
                }
                peerRemote.setNetworkErrorCount(peerNetworkError + 1);
                continue;
            }
            peerRemote.setNetworkErrorCount(0);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (InfoServerApp serveurApp : this._serversApp) {
            sb.append(serveurApp.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public void addListener(RemoteServerChangeListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public void removeListener(RemoteServerChangeListener listener) {
        this._listeners.remove(listener);
    }

    @Override
    public void serveurListChange() {
        for (RemoteServerChangeListener listener : this._listeners) {
            listener.serveurListChange();
        }
    }

    @Override
    public boolean engineErrorCountChange(String peerID, int oldCount, int newCount) {
        for (RemoteServerChangeListener listener : this._listeners) {
            listener.engineErrorCountChange(peerID, oldCount, newCount);
        }
        return true;
    }

    @Override
    public void stockSizeChange(String peerID, int oldSize, int newSize) {
        for (RemoteServerChangeListener listener : this._listeners) {
            listener.stockSizeChange(peerID, oldSize, newSize);
        }
    }
}

