/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.filetransfert;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.filetransfert.ZipUtility;
import com.dassault.cecilia.lib.distrib.jxtautility.DistribException;
import com.dassault.cecilia.lib.distrib.jxtautility.FileDirDeletor;
import com.dassault.cecilia.lib.distrib.jxtautility.JXTAException;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.PeerJXTA;
import com.dassault.cecilia.lib.distrib.xmlutility.MessageInfoAnalyser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;

public class ByteFileReceiver {
    protected static Map<String, ByteFileReceiver> _fileReceivers = new HashMap<String, ByteFileReceiver>();
    protected String _filename;
    protected int _lastpart = -1;
    protected boolean _zipped = false;
    protected byte[][] _parts;
    protected String mutex = "mutexWrite";
    protected boolean _alreadyWriten = false;

    protected ByteFileReceiver(MessageInfoAnalyser info) throws DistribException {
        this.initialize(info);
    }

    public static synchronized ByteFileReceiver getFileReceiver(MessageInfoAnalyser info) throws DistribException {
        String filename = info.getAttribut("FILENAME");
        ByteFileReceiver receiver = _fileReceivers.get(filename);
        if (receiver == null) {
            receiver = new ByteFileReceiver(info);
            _fileReceivers.put(filename, receiver);
        }
        return receiver;
    }

    protected void initialize(MessageInfoAnalyser info) throws DistribException {
        String last = info.getAttribut("NUMBEROFPARTS");
        String name = info.getAttribut("FILENAME");
        if (last == null || name == null || name.equals("")) {
            throw new DistribException("No Valid Info Element in message");
        }
        String format = info.getAttribut("FILEFORMAT");
        if (format != null && format.equals("ZIPPED")) {
            this._zipped = true;
        }
        this._lastpart = Integer.parseInt(last);
        this._parts = new byte[this._lastpart][];
        this._filename = name;
    }

    protected boolean isEveryPartOK() {
        int i = 0;
        while (i < this._lastpart) {
            byte[] part = this._parts[i];
            if (part == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean writeFile() {
        if (this._zipped) {
            try {
                File tmpZip = File.createTempFile("tmp", ".zip", JXTAProperties.getTempDir());
                RandomAccessFile raf = new RandomAccessFile(tmpZip, "rw");
                int i = 0;
                while (i < this._lastpart) {
                    raf.seek(i * 63000);
                    raf.write(this._parts[i]);
                    ++i;
                }
                raf.close();
                ZipUtility.unCompressFiles(tmpZip.getAbsolutePath(), JXTAProperties.getTempDir().getAbsolutePath());
                FileDirDeletor.deleteIfNotDir(tmpZip, true);
            }
            catch (IOException e1) {
                Loggeur.log(this.getClass(), Loggeur.ERROR, "ZIP " + e1.getMessage());
                Loggeur.log(PeerJXTA.class, Loggeur.ERROR, e1);
                this.cleanMemory();
                return false;
            }
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(JXTAProperties.getTempDir(), this._filename));
            if (this._lastpart == 0) {
                Loggeur.log(this.getClass(), Loggeur.DEBUG, "Writing empty file : " + this._filename);
                fos.write(new byte[0]);
            } else {
                int i = 0;
                while (i < this._lastpart) {
                    fos.write(this._parts[i]);
                    ++i;
                }
            }
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            try {
                fos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Loggeur.log(this.getClass(), Loggeur.ERROR, e.getMessage());
            Loggeur.log(PeerJXTA.class, Loggeur.ERROR, e);
            this.cleanMemory();
            return false;
        }
        this.cleanMemory();
        return true;
    }

    protected void cleanMemory() {
        int i = 0;
        while (i < this._lastpart) {
            this._parts[i] = null;
            ++i;
        }
        _fileReceivers.remove(this._filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manageMessage(Message message) throws DistribException {
        JXTAException ex = new JXTAException();
        ex.setTypeOfError(2);
        MessageElement infoElt = message.getMessageElement("INFO");
        MessageElement fileElt = message.getMessageElement("FILE");
        if (infoElt == null) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, "Receiving File transfert Message with no INFO");
            ex.setCondition("Receiving File transfert Message with no INFO");
            throw ex;
        }
        if (fileElt == null) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, "Receiving File transfert Message with no FILE ELEMENT");
            ex.setCondition("Receiving File transfert Message with no FILE ELEMENT");
            throw ex;
        }
        MessageInfoAnalyser info = new MessageInfoAnalyser(infoElt);
        String string = this.mutex;
        synchronized (string) {
            String curPart;
            if (this._alreadyWriten) {
                Loggeur.log(this.getClass(), Loggeur.SEVERE, "File already writen :" + this._filename);
                Loggeur.log(PeerJXTA.class, Loggeur.SEVERE, "File already writen :" + this._filename);
                return;
            }
            if (this._lastpart == -1) {
                this.initialize(info);
            }
            if ((curPart = info.getAttribut("PARTNUMBER")) == null) {
                ex.setCondition("Receiving File transfert Message with no PARTNUMBER");
                throw ex;
            }
            int partnumber = Integer.parseInt(curPart);
            if (this._lastpart != 0) {
                this._parts[partnumber] = fileElt.getBytes(false);
            }
            Loggeur.log(this.getClass(), Loggeur.FINE, String.valueOf(this._filename) + " " + (partnumber + 1) + "/" + this._lastpart);
            if (this.isEveryPartOK()) {
                this.writeFile();
                this._alreadyWriten = true;
            }
        }
    }
}

