/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.filetransfert;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.filetransfert.ByteFileReceiver;
import com.dassault.cecilia.lib.distrib.jxtautility.DistribException;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.distrib.peers.PeerJXTA;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonClient;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.xmlutility.MessageInfoAnalyser;
import java.text.MessageFormat;

public class ClientFileReceiver
extends ByteFileReceiver {
    protected String associatedRequest;
    protected CECILIAClient _client;

    protected ClientFileReceiver(CECILIAClient client, MessageInfoAnalyser info) throws DistribException {
        super(info);
        this._client = client;
    }

    public static synchronized ClientFileReceiver getFileReceiver(CECILIAClient client, MessageInfoAnalyser info) throws DistribException {
        String filename = info.getAttribut("FILENAME");
        ClientFileReceiver receiver = (ClientFileReceiver)_fileReceivers.get(filename);
        if (receiver == null) {
            receiver = new ClientFileReceiver(client, info);
            _fileReceivers.put(filename, receiver);
        }
        return receiver;
    }

    @Override
    protected void initialize(MessageInfoAnalyser info) throws DistribException {
        super.initialize(info);
        this.associatedRequest = info.getAttribut("UID");
    }

    @Override
    protected boolean writeFile() {
        if (this.associatedRequest == null) {
            return true;
        }
        Request requete = this._client.getRequestStock().getRequest(this.associatedRequest);
        if (requete == null) {
            Loggeur.log(this.getClass(), Loggeur.WARNING, String.valueOf(ResJXTA.getString("REQUEST_NO_MORE_IN_STOK")) + this.associatedRequest);
            return true;
        }
        requete.setWritingFile(true);
        boolean result = super.writeFile();
        requete.setWritingFile(false);
        if (!result) {
            Loggeur.log(this.getClass(), Loggeur.SEVERE, MessageFormat.format(ResJXTA.getString("FILE_WRITING_ERROR"), this._filename));
            Loggeur.log(PeerJXTA.class, Loggeur.SEVERE, MessageFormat.format(ResJXTA.getString("FILE_WRITING_ERROR"), this._filename));
            requete.setInfo(MessageFormat.format(ResJXTA.getString("FILE_WRITING_ERROR"), this._filename));
            ReqAutomatonClient.fireEvent(requete, ReqAutomatonClient.EvtClient.CANCEL_BY_SOFTWARE);
        } else {
            this._client.fireFileArrived(requete, this._filename);
        }
        return result;
    }
}

