/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.filetransfert;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.filetransfert.ByteFileSender;
import com.dassault.cecilia.lib.distrib.filetransfert.ZipUtility;
import com.dassault.cecilia.lib.distrib.jxtautility.DistribException;
import com.dassault.cecilia.lib.distrib.jxtautility.FileDirDeletor;
import com.dassault.cecilia.lib.distrib.jxtautility.StackTracePrinter;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import java.io.File;
import java.io.IOException;

public class CompressingSender {
    private ByteFileSender _sender;
    private File _tmpZipFile;
    private File _originalFile;
    private String _futurName;
    private InfoPeerJXTA _remotePeer;
    private String _reqID;
    private String _senderID;

    public CompressingSender(File file, String futurName, String senderID, InfoPeerJXTA remotePeer, String reqID) {
        this._originalFile = file;
        this._futurName = futurName;
        this._remotePeer = remotePeer;
        this._reqID = reqID;
        this._senderID = senderID;
    }

    private boolean compressFile() {
        try {
            this._tmpZipFile = File.createTempFile("file", "zip", JXTAProperties.getTempDir());
            ZipUtility.compress(this._originalFile, this._futurName, this._tmpZipFile);
        }
        catch (IOException e) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, StackTracePrinter.getStackTrace(e));
            Loggeur.log(this.getClass(), Loggeur.ERROR, "Original " + this._originalFile.getAbsolutePath());
            Loggeur.log(this.getClass(), Loggeur.ERROR, "Unique " + this._futurName);
            try {
                Loggeur.log(this.getClass(), Loggeur.ERROR, "Zip " + this._tmpZipFile.getAbsolutePath());
            }
            catch (Exception e2) {
                Loggeur.log(this.getClass(), Loggeur.ERROR, "No Zip");
            }
            return false;
        }
        this._sender = new ByteFileSender(this._tmpZipFile, this._futurName, this._senderID, this._remotePeer, this._reqID);
        this._sender.setZipped(true);
        return true;
    }

    public void sendFileIter() throws DistribException {
        if (!this.compressFile()) {
            DistribException ex = new DistribException("Problem while reading file");
            ex.setFilename(this._originalFile.getAbsolutePath());
            throw ex;
        }
        if (this._sender == null) {
            return;
        }
        this._sender.sendFileIter();
        if (this._tmpZipFile != null) {
            FileDirDeletor.deleteIfNotDir(this._tmpZipFile, true);
        }
    }
}

