/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.filetransfert;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.filetransfert.ZipUtility;
import com.dassault.cecilia.lib.distrib.jxtautility.FileDirDeletor;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.PeerJXTA;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileCopy {
    public static final int BUFFER = 4096;
    public static final int BIGTRUNK = 0x3200000;
    private static CopyMethod __method = FileCopy.checkMethod();

    private static CopyMethod checkMethod() {
        String forceRename = System.getProperty("cecilia.jxta.copy");
        if (forceRename == null) {
            return null;
        }
        try {
            return CopyMethod.valueOf(forceRename.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void copyFile(File src, File dest) throws Exception {
        if (__method == null) {
            FileCopy.copyFile(src, dest, CopyMethod.COPY);
        } else {
            FileCopy.copyFile(src, dest, __method);
        }
    }

    protected static void copyFile(File src, File dest, CopyMethod method) throws Exception {
        if (dest.exists() && !FileDirDeletor.deleteIfNotDir(dest)) {
            throw new IOException("Can't overwrite destination :" + dest.getAbsolutePath());
        }
        StringBuffer sbdebug = new StringBuffer();
        sbdebug.append(ResJXTA.getString("FILE_COPY"));
        sbdebug.append(src.getAbsolutePath());
        sbdebug.append(" --");
        sbdebug.append(String.valueOf((Object)method));
        sbdebug.append("--> ");
        sbdebug.append(dest.getAbsolutePath());
        Loggeur.log(FileCopy.class, Loggeur.DEBUG, sbdebug.toString());
        switch (method) {
            case RENAME: {
                FileCopy.copyRename(src, dest);
                break;
            }
            case CHANNEL: {
                FileCopy.copyByChannel(src, dest);
                break;
            }
            case TRUNKING: {
                FileCopy.CopyTrunking(src, dest);
                break;
            }
            case CLOSEANDAPPENDS: {
                FileCopy.CopyCloseAndAppend(src, dest);
                break;
            }
            case COPY: {
                FileCopy.CopyCloseAndAppend2(src, dest);
                break;
            }
            case ZIPUNZIP: {
                FileCopy.copyZipUnzip(src, dest);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown method");
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append(ResJXTA.getString("FILE_COPY_OK"));
        sb.append(src.getAbsolutePath());
        sb.append(" -> ");
        sb.append(dest.getAbsolutePath());
        Loggeur.log(FileCopy.class, Loggeur.INFO, sb.toString());
    }

    protected static void CopyTrunking(File sourceFile, File dest) throws IOException {
        int count;
        FileInputStream fis = new FileInputStream(sourceFile);
        FileOutputStream fos = new FileOutputStream(dest);
        BufferedOutputStream bos = new BufferedOutputStream(fos, 4096);
        BufferedInputStream bis = new BufferedInputStream(fis, 4096);
        byte[] data = new byte[4096];
        int i = 0;
        while ((count = bis.read(data, 0, 4096)) != -1) {
            bos.write(data, 0, count);
            if (i % 1280 == 0 && i != 0) {
                Loggeur.log(FileCopy.class, Loggeur.DEBUG, dest + " => + 10 MB\n");
            }
            ++i;
        }
        bos.close();
        bis.close();
    }

    protected static void CopyCloseAndAppend(File sourceFile, File dest) throws IOException {
        int count;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile), 4096);
        int morceau = 1;
        do {
            FileOutputStream fos = new FileOutputStream(dest, true);
            BufferedOutputStream bos = new BufferedOutputStream(fos, 4096);
            int sizeoftrunk = 0;
            byte[] data = new byte[4096];
            Loggeur.log(FileCopy.class, Loggeur.DEBUG, "morceau " + morceau);
            while ((count = bis.read(data, 0, 4096)) != -1) {
                bos.write(data, 0, count);
                if ((sizeoftrunk += count) >= 0x3200000) break;
            }
            bos.close();
            ++morceau;
        } while (count != -1);
        bis.close();
    }

    protected static void CopyCloseAndAppend2(File sourceFile, File dest) throws IOException {
        int count;
        long pos = 0L;
        int morceau = 1;
        do {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(dest, true), 4096);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile), 4096);
            bis.skip(pos);
            int sizeoftrunk = 0;
            byte[] data = new byte[4096];
            Loggeur.log(FileCopy.class, Loggeur.DEBUG, "morceau " + morceau);
            while ((count = bis.read(data, 0, 4096)) != -1) {
                bos.write(data, 0, count);
                pos += (long)count;
                if ((sizeoftrunk += count) >= 0x3200000) break;
            }
            bos.close();
            bis.close();
            ++morceau;
        } while (count != -1);
    }

    protected static void copyRename(File src, File dest) throws Exception {
        if (!src.renameTo(dest)) {
            throw new IOException("Can't rename");
        }
    }

    protected static void copyByChannel(File src, File dest) throws Exception {
        FileInputStream fis = new FileInputStream(src);
        FileOutputStream fos = new FileOutputStream(dest);
        FileChannel channelSrc = fis.getChannel();
        FileChannel channelDest = fos.getChannel();
        channelSrc.transferTo(0L, channelSrc.size(), channelDest);
        fis.close();
        fos.close();
    }

    protected static void copyZipUnzip(File src, File dest) throws Exception {
        File tmp = File.createTempFile("tmp", ".copy.zip", JXTAProperties.getTempDir());
        ZipUtility.compress(src, dest.getName(), tmp);
        ZipUtility.unCompressFiles(tmp.getAbsolutePath(), dest.getParent());
        FileDirDeletor.deleteIfNotDir(tmp, true);
    }

    public static void readFile(File file, Appendable writer) {
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new FileReader(file));
                String line = null;
                while ((line = br.readLine()) != null) {
                    writer.append(line);
                }
            }
            catch (Exception e) {
                Loggeur.log(FileCopy.class, Loggeur.SEVERE, e);
                Loggeur.log(PeerJXTA.class, Loggeur.SEVERE, e);
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void main(String[] args) {
        try {
            FileCopy.copyFile(new File("e:\\debian-31r4-i386-binary-1.zip"), new File("e:\\debian-31r4-i386-binary-1-copie.zip"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static enum CopyMethod {
        RENAME,
        CHANNEL,
        TRUNKING,
        CLOSEANDAPPENDS,
        ZIPUNZIP,
        COPY;

    }
}

