/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.ihm;

import com.dassault.cecilia.lib.distrib.ihm.BoxDialog;
import com.dassault.cecilia.lib.distrib.ihm.ResJXTAIHM;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BoxInfoServer
extends BoxDialog {
    protected String name = "";
    protected String version = "0.0.0";
    protected String hostname = "";
    protected String peerID = "";
    protected String desc = "";
    protected int stockSize = 0;
    protected String currentReq = "";
    protected String[] engines = new String[0];
    protected boolean online = false;
    protected boolean connected = false;
    protected boolean authorized = false;
    protected boolean toBeUsed = false;
    protected int mem = 0;
    protected int cpufreq = 0;
    protected long lastTimeInfo = 0L;
    protected JLabel _nameLbl;
    protected JLabel _versionLbl;
    protected JLabel _hostnameLbl;
    protected JLabel _peerIDLbl;
    protected JLabel _descLbl;
    protected JLabel _stockSizeLbl;
    protected JLabel _currentReqLbl;
    protected JLabel _enginesLbl;
    protected JLabel _onlineCbx;
    protected JLabel _connectedCbx;
    protected JLabel _authorizedCbx;
    protected JCheckBox _toBeUsedCbx;
    protected JLabel _memLbl;
    protected JLabel _cpufreqLbl;
    protected JLabel _lastTimeInfoLbl;

    public BoxInfoServer(JDialog parent) {
        super(parent);
        assert (parent != null);
    }

    public BoxInfoServer(JFrame parent) {
        super(parent);
        assert (parent != null);
    }

    @Override
    protected boolean create() {
        if (!super.create()) {
            return false;
        }
        this.setTitle(ResJXTAIHM.getString("DLG_CARD_TITLE"));
        this.setSize(400, 400);
        this._nameLbl = new JLabel();
        this._versionLbl = new JLabel();
        this._hostnameLbl = new JLabel();
        this._peerIDLbl = new JLabel();
        this._descLbl = new JLabel();
        this._stockSizeLbl = new JLabel();
        this._currentReqLbl = new JLabel();
        this._enginesLbl = new JLabel();
        this._onlineCbx = new JLabel();
        this._connectedCbx = new JLabel();
        this._authorizedCbx = new JLabel();
        this._toBeUsedCbx = new JCheckBox();
        this._memLbl = new JLabel();
        this._cpufreqLbl = new JLabel();
        this._lastTimeInfoLbl = new JLabel();
        this.createCard();
        this.getContentPane().add(this._root);
        this.addButtons(false);
        this.pack();
        this.centerBox();
        return true;
    }

    protected void createCard() {
        JPanel main = new JPanel(new GridBagLayout());
        main.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        int y = 0;
        main.add((Component)this.createLine(this.createLabel("GLOBAL_NAME"), this._nameLbl), new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        main.add((Component)this.createLine(this.createLabel("GLOBAL_VERSION"), this._versionLbl), new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        main.add((Component)this.createLine(this.createLabel("GLOBAL_HOSTNAME"), this._hostnameLbl), new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        main.add((Component)this.createLine(this.createLabel("GLOBAL_DESCRIPTION"), this._descLbl), new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        main.add((Component)this.createLine(this.createLabel("GLOBAL_STOCK_SIZE"), this._stockSizeLbl), new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        main.add((Component)this.createLine(this.createLabel("GLOBAL_CURRENT_REQ"), this._currentReqLbl), new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        main.add((Component)this.createLine(this.createLabel("GLOBAL_ENGINES"), this._enginesLbl), new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        main.add((Component)this.createLine(this.createLabel("GLOBAL_ONLINE"), this._onlineCbx), new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        main.add((Component)this.createLine(this.createLabel("GLOBAL_AUTHORIZED"), this._authorizedCbx), new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        main.add((Component)this.createLine(this.createLabel("DLG_TOBEUSED"), this._toBeUsedCbx), new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        main.add((Component)this.createLine(this.createLabel("GLOBAL_CPU"), this._cpufreqLbl), new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        main.add((Component)this.createLine(this.createLabel("GLOBAL_MEM"), this._memLbl), new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._root.add((Component)main, "Center");
    }

    @Override
    public void copyToCtrl() {
        this._nameLbl.setText(this.name);
        this._versionLbl.setText(this.version);
        this._hostnameLbl.setText(this.hostname);
        this._peerIDLbl.setText(this.peerID);
        this._descLbl.setText(this.desc);
        this._stockSizeLbl.setText(String.valueOf(String.valueOf(this.stockSize)) + " " + ResJXTAIHM.getString("GLOBAL_REQS"));
        this._currentReqLbl.setText(this.currentReq);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.engines.length) {
            sb.append(this.engines[i]);
            if (i < this.engines.length - 1) {
                sb.append(",");
            }
            ++i;
        }
        this._enginesLbl.setText(sb.toString());
        this._onlineCbx.setText(BoxInfoServer.getBool(this.online));
        this._connectedCbx.setText(BoxInfoServer.getBool(this.connected));
        this._authorizedCbx.setText(BoxInfoServer.getBool(this.authorized));
        this._toBeUsedCbx.setSelected(this.toBeUsed);
        this._memLbl.setText(String.valueOf(String.valueOf(this.mem)) + " MB");
        this._cpufreqLbl.setText(String.valueOf(String.valueOf(this.cpufreq)) + " MHz");
        this._lastTimeInfoLbl.setText(new Date(this.lastTimeInfo).toString());
        this.pack();
        this.centerBox();
    }

    private static String getBool(boolean bool) {
        return bool ? ResJXTAIHM.getString("GLOBAL_YES") : ResJXTAIHM.getString("GLOBAL_NO");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event == null) {
            return;
        }
        String cmd = event.getActionCommand();
        if (cmd == null) {
            return;
        }
        if (cmd.equals("OK")) {
            this.copyFromControl();
        }
        super.actionPerformed(event);
    }

    public void copyFromControl() {
        this.toBeUsed = this._toBeUsedCbx.isSelected();
    }

    protected JLabel createLabel(String keyString) {
        return new JLabel(String.valueOf(ResJXTAIHM.getString(keyString)) + " : ");
    }

    protected JPanel createLine(JLabel label, JComponent comp) {
        assert (label != null);
        assert (comp != null);
        JPanel line = new JPanel(new GridBagLayout());
        line.setBorder(BorderFactory.createEmptyBorder());
        line.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0));
        line.add((Component)comp, new GridBagConstraints(1, 0, 1, 1, 100.0, 100.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        return line;
    }
}

