/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.ihm;

import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerApp;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoServerApp;
import com.dassault.cecilia.lib.distrib.ihm.BoxInfoServerAdmin;
import com.dassault.cecilia.lib.distrib.ihm.BoxWaiting;
import com.dassault.cecilia.lib.distrib.ihm.DistribAbstractAction;
import com.dassault.cecilia.lib.distrib.ihm.InfoClientsJXTATableModel;
import com.dassault.cecilia.lib.distrib.ihm.InfoServersAppTableModelAdmin;
import com.dassault.cecilia.lib.distrib.ihm.JTableHightLight;
import com.dassault.cecilia.lib.distrib.ihm.ResJXTAIHM;
import com.dassault.cecilia.lib.distrib.peers.CECILIAAdmin;
import com.dassault.cecilia.lib.distrib.request.Request;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class IHMAdmin
extends JFrame {
    private JTable _tableSrv;
    private InfoServersAppTableModelAdmin _modelSrvs;
    private JTable _tableClt;
    private InfoClientsJXTATableModel _modelClts;
    private CECILIAAdmin _admin;
    private ArrayList<DistribAbstractAction> _menuRequetes;
    private ArrayList<DistribAbstractAction> _menuNetWork;
    private JTabbedPane _tabPanne;
    private boolean _reader = false;

    public IHMAdmin(boolean reader) {
        this._reader = reader;
    }

    public void init(CECILIAAdmin admin) {
        this._admin = admin;
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                IHMAdmin.this.actionStop();
            }
        });
        this._menuRequetes = new ArrayList();
        this._menuNetWork = new ArrayList();
        this.createActions();
        this.setJMenuBar(this.createMenuBar());
        this.add((Component)this.createToolBar(), "North");
        this._tabPanne = new JTabbedPane();
        this._tabPanne.addTab(ResJXTAIHM.getString("GLOBAL_SERVEURS"), this.createServeursTab());
        this._tabPanne.addTab(ResJXTAIHM.getString("GLOBAL_CLIENTS"), this.createClientTab());
        this.add((Component)this._tabPanne, "Center");
        this.pack();
        this.setTitle(this._admin.getPeerJXTA().getPeerName());
    }

    private void createActions() {
        DistribAbstractAction actionCancelAll = new DistribAbstractAction("cancelAllAdmin.gif", "MENU_CANCEL_CANCEL_ALL", "MENU_CANCEL_CANCEL_ALL"){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHMAdmin.this.actionCancelAll();
            }
        };
        DistribAbstractAction actionCancelServeur = new DistribAbstractAction("cancelServeur.gif", "MENU_CANCEL_SERVER", "MENU_CANCEL_SERVER"){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHMAdmin.this.actionCancelServeur();
            }
        };
        DistribAbstractAction actionCancelClient = new DistribAbstractAction("cancelClient.gif", "MENU_CANCEL_CLIENT", "MENU_CANCEL_CLIENT"){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHMAdmin.this.actionCancelClient();
            }
        };
        DistribAbstractAction actionChangePrioClient = new DistribAbstractAction("prio.gif", "MENU_PRIO_CHANGE_CLIENT", "MENU_PRIO_CHANGE_CLIENT"){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHMAdmin.this.actionChangePrioClient();
            }
        };
        this._menuRequetes.add(actionCancelAll);
        this._menuRequetes.add(actionCancelServeur);
        this._menuRequetes.add(actionCancelClient);
        this._menuRequetes.add(actionChangePrioClient);
        if (this._reader) {
            actionCancelAll.setEnabled(false);
            actionCancelServeur.setEnabled(false);
            actionCancelClient.setEnabled(false);
            actionChangePrioClient.setEnabled(false);
        }
        DistribAbstractAction actionRefresh = new DistribAbstractAction("search.gif", "MENU_NETWORK_REFRESH", "MENU_NETWORK_REFRESH"){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHMAdmin.this.actionRefreshNetwork();
            }
        };
        DistribAbstractAction actionDetailCard = new DistribAbstractAction("card.gif", "MENU_NETWORK_SERVER_CARD", "MENU_NETWORK_SERVER_CARD"){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHMAdmin.this.actionDetailedCard();
            }
        };
        DistribAbstractAction actionAskInfo = new DistribAbstractAction("info.gif", "MENU_NETWORK_ASK_INFO", "MENU_NETWORK_ASK_INFO"){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHMAdmin.this.actionAskInfo();
            }
        };
        DistribAbstractAction actionShutDownSrv = new DistribAbstractAction("shutDownServer.gif", "MENU_NETWORK_SERVER_SHUTDOWN", "MENU_NETWORK_SERVER_SHUTDOWN"){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHMAdmin.this.actionShutdownServer();
            }
        };
        DistribAbstractAction actionStop = new DistribAbstractAction("cancelAll.gif", "GLOBAL_STOP", "GLOBAL_STOP"){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHMAdmin.this.actionStop();
            }
        };
        this._menuNetWork.add(actionRefresh);
        this._menuNetWork.add(actionDetailCard);
        this._menuNetWork.add(actionAskInfo);
        this._menuNetWork.add(actionShutDownSrv);
        this._menuNetWork.add(actionStop);
        if (this._reader) {
            actionShutDownSrv.setEnabled(false);
        }
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menuCancel = new JMenu(ResJXTAIHM.getString("GLOBAL_REQS"));
        for (DistribAbstractAction action : this._menuRequetes) {
            menuCancel.add(new JMenuItem(action));
        }
        JMenu menuNet = new JMenu(ResJXTAIHM.getString("MENU_NETWORK"));
        for (DistribAbstractAction action : this._menuNetWork) {
            menuNet.add(new JMenuItem(action));
        }
        menuBar.add(menuCancel);
        menuBar.add(menuNet);
        return menuBar;
    }

    private JToolBar createToolBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        for (DistribAbstractAction action : this._menuRequetes) {
            bar.add(action.createButton());
        }
        bar.add(Box.createHorizontalStrut(5));
        for (DistribAbstractAction action : this._menuNetWork) {
            bar.add(action.createButton());
        }
        return bar;
    }

    private JComponent createServeursTab() {
        JPanel panelSrvs = new JPanel(new GridBagLayout());
        this._modelSrvs = new InfoServersAppTableModelAdmin(this._admin.getServersApp(), this._admin.getPeerJXTA());
        this._tableSrv = new JTableHightLight(this._modelSrvs);
        this._tableSrv.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                IHMAdmin.this.actionDetailedCard();
            }
        });
        this._modelSrvs.resizeCols(this._tableSrv);
        panelSrvs.add((Component)new JScrollPane(this._tableSrv), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panelSrvs;
    }

    private JComponent createClientTab() {
        ArrayList<InfoPeerJXTA> clients = new ArrayList<InfoPeerJXTA>();
        Iterator<InfoPeerJXTA> it = this._admin.getPeerJXTA().remotePeerIterator();
        while (it.hasNext()) {
            InfoPeerJXTA peer = it.next();
            if (!peer.getType().equals("CLIENT")) continue;
            clients.add(peer);
        }
        JPanel panelSrvs = new JPanel(new GridBagLayout());
        this._modelClts = new InfoClientsJXTATableModel(clients, this._admin.getPeerJXTA());
        this._tableClt = new JTable(this._modelClts);
        this._modelClts.resizeCols(this._tableClt);
        panelSrvs.add((Component)new JScrollPane(this._tableClt), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panelSrvs;
    }

    private void actionRefreshNetwork() {
        BoxWaiting wait = new BoxWaiting(this){

            @Override
            protected String getBoxTitle() {
                return ResJXTAIHM.getString("MENU_NETWORK_REFRESH");
            }

            @Override
            protected void waintingAction() {
                IHMAdmin.this._admin.refreshNetwork();
                IHMAdmin.this._modelSrvs.serveurListChange();
                ArrayList<InfoPeerJXTA> clients = new ArrayList<InfoPeerJXTA>();
                Iterator<InfoPeerJXTA> it = IHMAdmin.this._admin.getPeerJXTA().remotePeerIterator();
                while (it.hasNext()) {
                    InfoPeerJXTA peer = it.next();
                    if (!peer.getType().equals("CLIENT")) continue;
                    clients.add(peer);
                }
                IHMAdmin.this._modelClts.setClients(clients);
            }
        };
        wait.start();
    }

    private void actionShutdownServer() {
        this._tabPanne.setSelectedIndex(0);
        InfoPeerApp peer = this._admin.getRemoteAppList().get(this._tableSrv.getSelectedRow());
        if (peer == null) {
            JOptionPane.showMessageDialog(this, ResJXTAIHM.getString("DLG_SELECT_SERVER"));
            return;
        }
        int res = JOptionPane.showConfirmDialog(this._tableSrv, String.valueOf(ResJXTAIHM.getString("DLG_SHUTDOWN_SERVER")) + peer.getName(), "", 0);
        if (res == 0) {
            this._admin.remoteShutdown(peer.getPeerJXTA());
        }
    }

    private void actionStop() {
        this._admin.shutdown();
        System.exit(0);
    }

    private void actionCancelAll() {
        int res = JOptionPane.showConfirmDialog(this._tableSrv, ResJXTAIHM.getString("DLG_CANCEL_ALL_REQ"), "", 0);
        if (res == 0) {
            this._admin.remoteStopRequests();
        }
    }

    private void actionCancelServeur() {
        this._tabPanne.setSelectedIndex(0);
        InfoPeerApp peer = this._admin.getRemoteAppList().get(this._tableSrv.getSelectedRow());
        if (peer == null) {
            JOptionPane.showMessageDialog(this, ResJXTAIHM.getString("DLG_SELECT_SERVER"));
            return;
        }
        int res = JOptionPane.showConfirmDialog(this._tableSrv, String.valueOf(ResJXTAIHM.getString("DLG_CANCEL_ON_SERVER")) + peer.getName(), "", 0);
        if (res == 0) {
            this._admin.remoteStopRequests((InfoServerApp)peer);
        }
    }

    private void actionCancelClient() {
        this._tabPanne.setSelectedIndex(1);
        int idx = this._tableClt.getSelectedRow();
        if (idx == -1) {
            JOptionPane.showMessageDialog(this, ResJXTAIHM.getString("DLG_SELECT_CLIENT"));
            return;
        }
        InfoPeerJXTA peer = this._modelClts.getClient(idx);
        if (peer == null) {
            return;
        }
        int res = JOptionPane.showConfirmDialog(this._tableClt, String.valueOf(ResJXTAIHM.getString("DLG_CANCEL_FROM_CLIENT")) + peer.getName(), "", 0);
        if (res == 0) {
            this._admin.remoteStopRequestsFromClient(peer);
        }
    }

    private void actionChangePrioClient() {
        this._tabPanne.setSelectedIndex(1);
        int idx = this._tableClt.getSelectedRow();
        if (idx == -1) {
            JOptionPane.showMessageDialog(this, ResJXTAIHM.getString("DLG_SELECT_CLIENT"));
            return;
        }
        InfoPeerJXTA peer = this._modelClts.getClient(idx);
        if (peer == null) {
            return;
        }
        while (true) {
            String res;
            if ((res = JOptionPane.showInputDialog(this._tableClt, MessageFormat.format(ResJXTAIHM.getString("DLG_NEW_PRIORITY_CLIENT"), peer.getName()), "")) == null || res.equals("")) {
                return;
            }
            try {
                this._admin.remoteChangePriorityClient(peer, Integer.parseInt(res));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, ResJXTAIHM.getString("DLG_NEW_PRIORITY_CLIENT_ERROR"));
                continue;
            }
            break;
        }
    }

    private void actionDetailedCard() {
        this._tabPanne.setSelectedIndex(0);
        int row = this._tableSrv.getSelectedRow();
        if (row == -1) {
            JOptionPane.showMessageDialog(this, ResJXTAIHM.getString("DLG_SELECT_SERVER"));
            return;
        }
        InfoServerApp server = this._admin.getServersApp().get(row);
        BoxInfoServerAdmin card = new BoxInfoServerAdmin(this, this._reader);
        card.version = server.getVersion();
        card.authorized = server.isAuthorized();
        card.cpufreq = server.getCpuFrequency();
        card.currentReq = Request.convertToUserFriendly(server.getCurrentReqID(), this._admin.getPeerJXTA());
        card.desc = server.getUserDesc();
        card.engines = server.getOriginalEngines();
        card.authorizedEngines = server.getAuthorizedEngines();
        card.hostname = server.getHostName();
        card.mem = server.getMemory();
        card.name = server.getName();
        card.online = server.isOnline();
        card.connected = server.isBound();
        card.peerID = server.getPeerID();
        card.stockSize = server.getStockSize();
        card.toBeUsed = server.shouldBeUsed();
        card.lastTimeInfo = server.getLastInfoTime();
        if (card.doModal() && !this._reader) {
            this._admin.remoteChangeServerEngines(server.getPeerJXTA(), card.authorizedEngines);
        }
    }

    private void actionAskInfo() {
        BoxWaiting wait = new BoxWaiting(this){

            @Override
            protected String getBoxTitle() {
                return ResJXTAIHM.getString("MENU_NETWORK_ASK_INFO");
            }

            @Override
            protected void waintingAction() {
                IHMAdmin.this._admin.remoteAskInfo();
            }
        };
        wait.start();
    }

    @Override
    public void dispose() {
        this._modelSrvs.dispose();
        super.dispose();
    }
}

