/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.ihm;

import com.dassault.cecilia.lib.distrib.entityinfo.InfoServerApp;
import com.dassault.cecilia.lib.distrib.ihm.ReqHistoryDisplayer;
import com.dassault.cecilia.lib.distrib.ihm.ResJXTAIHM;
import com.dassault.cecilia.lib.distrib.ihm.UtilTableModel;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.distrib.peers.PeerJXTA;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.requestManagement.RequestStock;
import java.awt.Component;
import java.awt.Dimension;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class StockClientTableModel
extends UtilTableModel
implements ReqHistoryDisplayer {
    private RequestStock _stock;
    private CECILIAClient _client;

    public StockClientTableModel(CECILIAClient client, RequestStock stock) {
        this._stock = stock;
        this._client = client;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 3;
    }

    @Override
    public int getRowCount() {
        return this._stock.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Request req = this._stock.get(rowIndex);
        if (req == null) {
            return "null";
        }
        switch (columnIndex) {
            case 0: {
                return req.getShortNumber();
            }
            case 1: {
                return req.getState();
            }
            case 2: {
                InfoServerApp server = this._client.getServersApp().getServer(req.getServerID());
                if (server == null) {
                    return "null";
                }
                return server.getName();
            }
            case 3: {
                return req.getHisto().toStringShort();
            }
        }
        return "err";
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return ResJXTAIHM.getString("GLOBAL_REQ");
            }
            case 1: {
                return ResJXTAIHM.getString("GLOBAL_STATE");
            }
            case 2: {
                return ResJXTAIHM.getString("GLOBAL_SERVEUR");
            }
            case 3: {
                return ResJXTAIHM.getString("GLOBAL_HISTO");
            }
        }
        return "err";
    }

    @Override
    public int getColumnSize(int column) {
        switch (column) {
            case 0: {
                return 100;
            }
            case 1: {
                return 100;
            }
            case 2: {
                return 100;
            }
            case 3: {
                return 80;
            }
        }
        return 30;
    }

    @Override
    public int getColumnSizeMax(int col) {
        return super.getColumnSizeMax(col);
    }

    @Override
    public boolean mustBeHighlightedBold(int row) {
        return false;
    }

    @Override
    public void displayHisto(Component parent, int row, PeerJXTA localPeer) {
        if (row == -1) {
            return;
        }
        Request req = this._stock.get(row);
        if (req == null) {
            return;
        }
        String msg = req.getHistoString(localPeer);
        StringTokenizer st = new StringTokenizer(msg, "\n", false);
        int width = 0;
        int height = 0;
        while (st.hasMoreTokens()) {
            width = Math.max(st.nextToken().length(), width);
            ++height;
        }
        if (width > 120 || height > 12) {
            JTextArea ctrlMess = new JTextArea();
            ctrlMess.setLineWrap(false);
            ctrlMess.setWrapStyleWord(false);
            ctrlMess.setEditable(false);
            ctrlMess.setTabSize(4);
            ctrlMess.setText(msg);
            JScrollPane scrMess = new JScrollPane(ctrlMess);
            scrMess.setPreferredSize(new Dimension(500, 300));
            JOptionPane.showMessageDialog(parent, scrMess);
        } else {
            JOptionPane.showMessageDialog(parent, msg);
        }
    }
}

