/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.jxtautility;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.PeerChangeListener;
import com.dassault.cecilia.lib.distrib.jxtautility.SearchAdvThread;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.PeerJXTA;
import com.dassault.cecilia.lib.distrib.xmlutility.AdvertisementAnalyser;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Iterator;
import net.jxta.protocol.ModuleSpecAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;

public class NetworkUtility {
    public static final int TIMEOUTFORONLINECHECKING = 5000;

    public static int getTimeOutForSearch() {
        return Integer.getInteger("cecilia.jxta.search.time", 5000);
    }

    public static void updateRemoteStatus(PeerJXTA peer) {
        Iterator<InfoPeerJXTA> it = peer.remotePeerIterator();
        while (it.hasNext()) {
            InfoPeerJXTA infoPeerJXTA = it.next();
            infoPeerJXTA.setStatus(1, PeerChangeListener.Reason.BECAUSE_OF_NEWDISCOVERY);
        }
    }

    public static boolean searchServerAdv(PeerJXTA localPeer, InfoPeerJXTA server) {
        boolean found;
        block7: {
            assert (server.getType().equals("SERVER"));
            found = false;
            Enumeration enume = null;
            try {
                localPeer.getDiscoSvc().getRemoteAdvertisements(server.getPeerIDString(), 2, "Name", "JXTASPEC:JXTA-CECILIA", 100, null);
                try {
                    Thread.sleep(NetworkUtility.getTimeOutForSearch());
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                enume = localPeer.getDiscoSvc().getLocalAdvertisements(2, "Name", "JXTASPEC:JXTA-CECILIA");
                if (enume == null) break block7;
                while (enume.hasMoreElements()) {
                    ModuleSpecAdvertisement mdsadv = (ModuleSpecAdvertisement)enume.nextElement();
                    PipeAdvertisement serveurPipeAdv = mdsadv.getPipeAdvertisement();
                    AdvertisementAnalyser analyser = new AdvertisementAnalyser(serveurPipeAdv);
                    String peerID = analyser.getDescription("SERVERID");
                    if (!server.getPeerIDString().equals(peerID)) continue;
                    server.setPipeAdv(serveurPipeAdv);
                    found = true;
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!found) {
            Loggeur.log(NetworkUtility.class, Loggeur.ERROR, MessageFormat.format(ResJXTA.getString("NETWORK_PIPE_CONNECT_ERROR"), server.getName()));
            server.setStatus(0, PeerChangeListener.Reason.BECAUSE_OF_CAN_NOT_CONNECT);
            localPeer.removeRemote(server);
        }
        return found;
    }

    public static void searchServerAdv(PeerJXTA localPeer) {
        Iterator<InfoPeerJXTA> remotePeers = localPeer.remotePeerIterator();
        while (remotePeers.hasNext()) {
            InfoPeerJXTA peer = remotePeers.next();
            if (peer.getStatus() != 1 || !peer.getType().equals("SERVER")) continue;
            new SearchAdvThread(localPeer, peer).start();
        }
    }

    public static void searchServerAdvBloquing(PeerJXTA localPeer) {
        Enumeration enume = null;
        try {
            localPeer.getDiscoSvc().getRemoteAdvertisements(null, 2, "Name", "JXTASPEC:JXTA-CECILIA", 100, null);
            try {
                Thread.sleep(NetworkUtility.getTimeOutForSearch());
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            enume = localPeer.getDiscoSvc().getLocalAdvertisements(2, "Name", "JXTASPEC:JXTA-CECILIA");
            if (enume != null) {
                while (enume.hasMoreElements()) {
                    ModuleSpecAdvertisement mdsadv = (ModuleSpecAdvertisement)enume.nextElement();
                    PipeAdvertisement serveurPipeAdv = mdsadv.getPipeAdvertisement();
                    AdvertisementAnalyser analyser = new AdvertisementAnalyser(serveurPipeAdv);
                    String peerID = analyser.getDescription("SERVERID");
                    InfoPeerJXTA remote = localPeer.getRemotePeer(peerID);
                    if (remote != null) {
                        remote.setPipeAdv(serveurPipeAdv);
                        localPeer.removeUnreachablePeer(peerID);
                        continue;
                    }
                    Loggeur.log(NetworkUtility.class, Loggeur.INFO, "New Pipe Detected");
                    PeerAdvertisement peerAdv = localPeer.getNetworkManager().searchForPeerAdvertisements(peerID);
                    if (peerAdv != null) {
                        InfoPeerJXTA newServer = new InfoPeerJXTA(peerAdv);
                        localPeer.addRemotePeer(newServer);
                        NetworkUtility.updateRemoteStatus(localPeer);
                        newServer.setPipeAdv(serveurPipeAdv);
                        Loggeur.log(NetworkUtility.class, Loggeur.INFO, "New Server Detected : " + peerAdv.getName());
                        continue;
                    }
                    if (!localPeer.addUnreachablePeer(peerID)) continue;
                    Loggeur.log(NetworkUtility.class, Loggeur.WARNING, "pipeserver.adv from unknow peer " + peerID);
                    Loggeur.log(NetworkUtility.class, Loggeur.FINEST, serveurPipeAdv.toString());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

