/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.peers;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.PeerChangeListener;
import com.dassault.cecilia.lib.distrib.jxtautility.DistribException;
import com.dassault.cecilia.lib.distrib.jxtautility.JXTAException;
import com.dassault.cecilia.lib.distrib.jxtautility.MessageUtility;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.PeerAdmin;
import com.dassault.cecilia.lib.distrib.xmlutility.MessageInfoAnalyser;
import java.io.IOException;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.util.JxtaBiDiPipe;

public class BidiPipeAdmin
extends Thread
implements PipeMsgListener {
    protected JxtaBiDiPipe _bipipe;
    protected InfoPeerJXTA _infoServeur;
    protected PeerAdmin _peerAdmin;

    public BidiPipeAdmin(PeerAdmin admin, InfoPeerJXTA serveur) {
        assert (serveur.getType().equals("SERVER"));
        this._infoServeur = serveur;
        this._peerAdmin = admin;
    }

    public boolean connect() {
        if (this._infoServeur.getPipeAdv() == null) {
            this._peerAdmin.removeRemote(this._infoServeur);
            Loggeur.log(this.getClass(), Loggeur.INFO, String.valueOf(this._infoServeur.getName()) + " " + "No PipeAdv");
            return false;
        }
        if (this._bipipe != null) {
            try {
                this._bipipe.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this._bipipe = new JxtaBiDiPipe();
        try {
            this._bipipe.setReliable(true);
            this._bipipe.connect(this._peerAdmin.getNetPeerGroup(), this._infoServeur.getPeerID(), this._infoServeur.getPipeAdv(), 60000, (PipeMsgListener)this);
            this._infoServeur.setBidiPipe(this._bipipe);
        }
        catch (IOException e) {
            this._infoServeur.setStatus(0, PeerChangeListener.Reason.BECAUSE_OF_BROKEN_PIPE);
            JXTAException ex = new JXTAException();
            ex.setCondition("During Connection");
            ex.setRemotePeer(this._infoServeur);
            ex.setTypeOfError(1);
            this._peerAdmin.reportDistribException(ex);
            return false;
        }
        catch (NullPointerException npe) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, npe);
            this._infoServeur.setStatus(0, PeerChangeListener.Reason.BECAUSE_OF_BROKEN_PIPE);
            this._peerAdmin.removeRemote(this._infoServeur);
            return false;
        }
        catch (Exception e) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, e);
            this._infoServeur.setStatus(0, PeerChangeListener.Reason.BECAUSE_OF_BROKEN_PIPE);
            this._peerAdmin.removeRemote(this._infoServeur);
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        if (this.connect()) {
            Loggeur.log(this.getClass(), Loggeur.INFO, String.valueOf(this._infoServeur.getName()) + " " + "OK");
        } else {
            Loggeur.log(this.getClass(), Loggeur.INFO, String.valueOf(this._infoServeur.getName()) + " " + "KO");
        }
        if (this._bipipe != null) {
            this._bipipe.setMessageListener((PipeMsgListener)this);
        }
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        Message message = event.getMessage();
        MessageElement element = message.getMessageElement("INFO");
        if (element == null) {
            this._peerAdmin.getClientCecilia().printError("un message ne contenant pas d'info a ete recu de " + this._infoServeur.getName());
            return;
        }
        MessageInfoAnalyser info = null;
        try {
            info = new MessageInfoAnalyser(element);
        }
        catch (DistribException e1) {
            this._peerAdmin.getClientCecilia().printError("Message invalide recu de " + this._infoServeur.getName() + " : " + e1.getMessage());
            return;
        }
        String type = info.getType();
        if (!(type.equals("FILETRANSFERT") || type.equals("CECILIARESPONSE") || type.equals("REQSTATE"))) {
            if (type.equals("ADMINISTRATION")) {
                if (!this.verifyEltAtt(info, "ADMINTYPE", element)) {
                    return;
                }
                if (!this.verifyEltAtt(info, "SENDERID", element)) {
                    return;
                }
                this._peerAdmin.getClientCecilia().manageAdminMessage(message, info);
            } else if (!type.equals("ISSUE")) {
                if (type.equals("ERROR")) {
                    this._peerAdmin.getClientCecilia().printError(String.valueOf(this._infoServeur.getName()) + "n'a pas compris un de mes messages : ");
                    MessageElement eltErr = message.getMessageElement("ERROR");
                    if (eltErr == null) {
                        this._peerAdmin.getClientCecilia().printError("aucune info n'est disponible sur le message errone");
                    } else {
                        this._peerAdmin.getClientCecilia().printError(eltErr.toString());
                    }
                } else {
                    this.reportBadMessage(element);
                }
            }
        }
    }

    private void reportBadMessage(MessageElement element) {
        System.err.println("Bad Message !!!!!!!\n################");
        this._infoServeur.sendMessage(MessageUtility.createErrorMessage(element));
    }

    private boolean verifyEltAtt(MessageInfoAnalyser info, String attribut, MessageElement element) {
        String toverify = info.getAttribut(attribut);
        if (toverify == null || toverify.equals("")) {
            Loggeur.log(this.getClass(), Loggeur.FATAL, String.valueOf(ResJXTA.getString("NETWORK_MESSAGE_FROM_UNKNOWN_PEER")) + attribut);
            this.reportBadMessage(element);
            return false;
        }
        return true;
    }
}

