/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.peers;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoClientApp;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.PeerChangeListener;
import com.dassault.cecilia.lib.distrib.filetransfert.ByteFileReceiver;
import com.dassault.cecilia.lib.distrib.jxtautility.DistribException;
import com.dassault.cecilia.lib.distrib.jxtautility.MessageUtility;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.CECILIAServer;
import com.dassault.cecilia.lib.distrib.peers.PeerServer;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonException;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonServer;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.xmlutility.AdvertisementAnalyser;
import com.dassault.cecilia.lib.distrib.xmlutility.MessageInfoAnalyser;
import java.text.MessageFormat;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.util.JxtaBiDiPipe;
import net.jxta.util.PipeEventListener;

public class BidiPipeServer
extends Thread
implements PipeMsgListener,
PipeEventListener {
    protected JxtaBiDiPipe _bipipe;
    protected InfoPeerJXTA _client;
    protected PeerServer _peerServer;
    protected CECILIAServer _serveurCECILIA;

    public BidiPipeServer(JxtaBiDiPipe bipipe, PeerServer server) {
        this._bipipe = bipipe;
        this._bipipe.setPipeEventListener((PipeEventListener)this);
        this._peerServer = server;
        this._serveurCECILIA = server.getServeurCecilia();
    }

    @Override
    public void run() {
        this._bipipe.setMessageListener((PipeMsgListener)this);
        PeerAdvertisement peerAdv = this._bipipe.getRemotePeerAdvertisement();
        InfoPeerJXTA client = new InfoPeerJXTA(peerAdv);
        AdvertisementAnalyser aa = new AdvertisementAnalyser(peerAdv);
        aa.updatePeerInfo(client);
        client.addChangeListener(this._serveurCECILIA);
        client.setStatus(1, PeerChangeListener.Reason.BECAUSE_OF_NEWDISCOVERY);
        client.setBidiPipe(this._bipipe);
        InfoClientApp clientApp = new InfoClientApp(client);
        if (this._peerServer.getAuthorizedTypes().length() == 0 || this._peerServer.isAuthorized(client, false)) {
            this._peerServer.print(MessageFormat.format(ResJXTA.getString("NETWORK_CLIENT_AUTHORIZED"), peerAdv.getName()));
            clientApp.setAuthorized(true);
        } else {
            this._peerServer.print(MessageFormat.format(ResJXTA.getString("NETWORK_CLIENT_FORBIDEN"), String.valueOf(peerAdv.getName()) + " " + clientApp.getVersion()));
            clientApp.setAuthorized(false);
            Loggeur.log(this.getClass(), Loggeur.DEBUG, String.valueOf(this._peerServer.getAuthorizedTypes()) + " != " + aa.getDescription("APPTYPES"));
        }
        this._client = client;
        this._peerServer.addRemotePeer(client);
        this._serveurCECILIA.getClientsApp().addClient(clientApp);
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        try {
            Message message = event.getMessage();
            MessageElement element = message.getMessageElement("INFO");
            if (element == null) {
                this._peerServer.print("un message ne contenant pas d'info a ete recu de " + this._client.getName());
                this.reportBadMessage(null);
                return;
            }
            MessageInfoAnalyser info = null;
            try {
                info = new MessageInfoAnalyser(element);
            }
            catch (DistribException e1) {
                this._peerServer.print("invalid message info :" + e1.getMessage());
                this.reportBadMessage(null);
                return;
            }
            String senderID = info.getSenderID();
            if (senderID == null) {
                this._peerServer.print(ResJXTA.getString("NETWORK_MESSAGE_FROM_UNKNOWN_PEER"));
                return;
            }
            InfoClientApp client = this._serveurCECILIA.getClientsApp().getClient(senderID);
            if (client == null) {
                this._peerServer.print(String.valueOf(ResJXTA.getString("NETWORK_MESSAGE_FROM_UNKNOWN_PEER")) + senderID);
                return;
            }
            if (!client.isAuthorized()) {
                this._peerServer.print(String.valueOf(ResJXTA.getString("NETWORK_CLIENT_FORBIDEN_MESSAGE")) + client.getName());
                if (!client.isDisconnecting()) {
                    this._serveurCECILIA.refuseConnection(client);
                    client.getPeerJXTA().closeConnection();
                }
                return;
            }
            if (!client.isGoodVersion()) {
                this._peerServer.print(String.valueOf(ResJXTA.getString("NETWORK_CLIENT_FORBIDEN_WRONG_VERSION_MESSAGE")) + client.getName() + " " + client.getVersion());
                if (!client.isDisconnecting()) {
                    this._serveurCECILIA.refuseConnection(client);
                    client.getPeerJXTA().closeConnection();
                }
                return;
            }
            String type = info.getType();
            if (type.equals("FILETRANSFERT")) {
                if (!this.verifyEltAtt(info, "FILENAME", element)) {
                    return;
                }
                try {
                    ByteFileReceiver receiver = ByteFileReceiver.getFileReceiver(info);
                    receiver.manageMessage(message);
                }
                catch (DistribException e2) {
                    this._peerServer.print(e2.getMessage());
                    e2.printStackTrace();
                }
            } else if (type.equals("CECILIAREQUEST")) {
                if (!this.verifyEltAtt(info, "UID", element)) {
                    return;
                }
                this._serveurCECILIA.manageCeciliaRequestMessage(message, info);
            } else if (type.equals("REQSTATE")) {
                if (!this.verifyEltAtt(info, "UID", element)) {
                    return;
                }
                if (!this.verifyEltAtt(info, "SENDERID", element)) {
                    return;
                }
                this._serveurCECILIA.manageStateMessage(info);
            } else if (type.equals("ADMINISTRATION")) {
                String typeStr = info.getAttribut("ADMINTYPE");
                String ownerID = info.getAttribut("SENDERID");
                if (typeStr == null || typeStr.equals("") || ownerID == null) {
                    this._peerServer.print("Mauvais message admin");
                    this.reportBadMessage(element);
                    return;
                }
                this._serveurCECILIA.manageAdminMessage(message, info);
            } else if (type.equals("ERROR")) {
                this._peerServer.print(String.valueOf(this._client.getName()) + "n'a pas compris un de mes messages : ");
                MessageElement eltErr = message.getMessageElement("INFO");
                if (eltErr == null) {
                    this._peerServer.print("aucune info n'est disponible sur le message errone");
                } else {
                    this._peerServer.print(eltErr.toString());
                }
            } else {
                this.reportBadMessage(element);
            }
        }
        catch (ReqAutomatonException e) {
            Request req = e.getRequest();
            req.setInfo("pipeMsgEventServert" + e.getMessage());
            ReqAutomatonServer.fireEvent(req, ReqAutomatonServer.EvtServer.CANCEL_BY_SOFTWARE);
        }
    }

    private void reportBadMessage(MessageElement element) {
        this._client.sendMessage(MessageUtility.createErrorMessage(element));
    }

    private boolean verifyEltAtt(MessageInfoAnalyser info, String attribut, MessageElement element) {
        String toverify = info.getAttribut(attribut);
        if (toverify == null || toverify.equals("")) {
            this.reportBadMessage(element);
            return false;
        }
        return true;
    }

    public void pipeEvent(int event) {
        if (event == 1) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, "PIPE_CLOSED_EVENT for " + this._client.getName());
            this._client.setStatus(0, PeerChangeListener.Reason.BECAUSE_OF_PIPE_CLOSED_BY_REMOTE);
        }
    }
}

