/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.peers;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerList;
import com.dassault.cecilia.lib.distrib.jxtautility.FileDirDeletor;
import com.dassault.cecilia.lib.distrib.jxtautility.NetworkManager25;
import com.dassault.cecilia.lib.distrib.jxtautility.NetworkStartUtility;
import com.dassault.cecilia.lib.distrib.jxtautility.NetworkUtility;
import com.dassault.cecilia.lib.distrib.jxtautility.StackTracePrinter;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.CECILIAServer;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.exception.PeerGroupException;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.rendezvous.RendezVousService;

public abstract class PeerJXTA {
    public static final String MODULECLASSNAME = "JXTAMOD:JXTA-CECILIA";
    public static final String SERVICENAME = "JXTASPEC:JXTA-CECILIA";
    public static final String GROUP = "GROUP-CECILIA";
    public static final String VERSION = "1.8.4";
    public static final String VERSION_DATE = "27/04/2023 14h18";
    protected PeerGroup netPeerGroup;
    protected DiscoveryService discoSvc;
    private PeerID _peerID = null;
    protected boolean _isShutingDown = false;
    protected InfoPeerList _remotePeerList;
    protected NetworkManager25 _manager;
    private Timer _timerCheck;
    private Timer _timerDisplay;
    protected ArrayList<String> _types;
    private Timer _timerMemory;
    TreeSet<String> _oldPeersID = new TreeSet();

    public PeerJXTA() {
        Loggeur.log(this.getClass(), Loggeur.INFO, "\n##############################\n# Version 1.8.4 (27/04/2023 14h18) #\n##############################");
        this._remotePeerList = new InfoPeerList();
    }

    public void startJxta() {
        int memPeriod;
        this.constructTypeList();
        Loggeur.log(this.getClass(), Loggeur.INFO, "Type = " + this.getAuthorizedTypes());
        try {
            this._manager = NetworkStartUtility.createManager();
            Loggeur.log(this.getClass(), Loggeur.INFO, ResJXTA.getString("CONFIG_START"));
            this._manager.startNetwork();
        }
        catch (IOException e) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, e.getMessage());
        }
        catch (PeerGroupException pge) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, pge.getMessage());
        }
        this.netPeerGroup = this._manager.getNetPeerGroup();
        this._peerID = this.netPeerGroup.getPeerID();
        this.discoSvc = this.netPeerGroup.getDiscoveryService();
        this._manager.waitForRendezvousConnection(10000L);
        this.flushCacheJXTA();
        this.publishPeerAdv();
        Loggeur.log(this.getClass(), Loggeur.INFO, ResJXTA.getString("CONFIG_CONNECTED"));
        RendezVousService rdvSvc = this._manager.getNetPeerGroup().getRendezVousService();
        if (rdvSvc.isRendezVous()) {
            Loggeur.log(this.getClass(), Loggeur.INFO, ResJXTA.getString("CONFIG_CONNECTED_IS_RENDEZ_VOUS"));
        }
        if ((memPeriod = Integer.getInteger("cecilia.jxta.mem.period", -1).intValue()) > 0) {
            MemoryUsage memusage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
            StringBuffer sb = new StringBuffer();
            sb.append("Mem : init=");
            sb.append(memusage.getInit() / 0x100000L);
            sb.append("Mo max=");
            sb.append(memusage.getMax() / 0x100000L);
            sb.append("Mo");
            Loggeur.log(this.getClass(), Loggeur.INFO, sb.toString());
            this._timerMemory = new Timer();
            this._timerMemory.schedule(new TimerTask(){

                @Override
                public void run() {
                    MemoryUsage usage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("Mem : used=");
                    buffer.append(usage.getUsed() / 0x100000L);
                    buffer.append("Mo committed=");
                    buffer.append(usage.getCommitted() / 0x100000L);
                    buffer.append("Mo");
                    Loggeur.log(PeerJXTA.this.getClass(), Loggeur.INFO, buffer.toString());
                }
            }, 1000L, (long)memPeriod);
        }
    }

    public ArrayList<InfoPeerJXTA> refreshNetwork() {
        ArrayList<InfoPeerJXTA> toBeTrashed = this._remotePeerList.trashWrongPeers();
        this._manager.searchForPeers(this);
        return toBeTrashed;
    }

    public String getJXTAHome() {
        return this._manager.getConfigHelper().getJxtaHome();
    }

    public void flushCacheJXTA() {
        this.print("Flush des caches JXTA");
        try {
            Advertisement anAdv;
            Enumeration eachAdv = this.discoSvc.getLocalAdvertisements(2, null, null);
            while (eachAdv.hasMoreElements()) {
                anAdv = (Advertisement)eachAdv.nextElement();
                this.discoSvc.flushAdvertisement(anAdv);
            }
            eachAdv = this.discoSvc.getLocalAdvertisements(0, null, null);
            while (eachAdv.hasMoreElements()) {
                anAdv = (Advertisement)eachAdv.nextElement();
                this.discoSvc.flushAdvertisement(anAdv);
            }
        }
        catch (Exception e) {
            this.print("Erreur lors du Flush des caches JXTA");
            try {
                FileDirDeletor del = new FileDirDeletor(new File(this._manager.getInstanceHome()), "cm");
                del.deleteAll();
            }
            catch (Exception e2) {
                e.printStackTrace();
            }
        }
    }

    public void publishPeerAdv() {
        this.print("Publication PeerAdvertisement");
        try {
            PeerAdvertisement peerAdv = this.netPeerGroup.getPeerAdvertisement();
            peerAdv.setDescription(this.createDescription());
            this.discoSvc.publish((Advertisement)this.netPeerGroup.getPeerAdvertisement());
        }
        catch (IOException e) {
            this.print("Erreur lors de la publication du PeerAdvertisement");
            e.printStackTrace();
        }
    }

    public abstract String createDescription();

    private void constructTypeList() {
        this._types = new ArrayList();
        String typeList = System.getProperty("cecilia.jxta.types", "");
        try {
            StringTokenizer st = new StringTokenizer(typeList, ",; ");
            while (st.hasMoreElements()) {
                String type = st.nextToken().trim();
                this._types.add(type);
            }
        }
        catch (Exception e) {
            Loggeur.log(this.getClass(), Loggeur.DEBUG, "cecilia.jxta.types error");
        }
    }

    public String getAuthorizedTypes() {
        StringBuffer sb = new StringBuffer();
        if (this._types == null) {
            return "";
        }
        int i = 0;
        while (i < this._types.size()) {
            sb.append(this._types.get(i));
            if (i < this._types.size() - 1) {
                sb.append(" ");
            }
            ++i;
        }
        return sb.toString();
    }

    public void displayPeerInfo() {
        this.print("Mon Peer Name est : " + this.getPeerName());
        this.print("Mon PeerID est : " + this.getPeerIDString());
    }

    public void print(String s) {
        Loggeur.log(this.getClass(), Loggeur.INFO, s);
    }

    public void periodicCheckOnlineStatus() {
        TimerTask display = new TimerTask(){

            @Override
            public void run() {
                NetworkUtility.updateRemoteStatus(PeerJXTA.this);
            }
        };
        this._timerCheck = new Timer("PERIODIC CHECK", true);
        this._timerCheck.schedule(display, 60000L, 60000L);
    }

    public void periodicDisplayRemote() {
        TimerTask display = new TimerTask(){

            @Override
            public void run() {
                Loggeur.log(CECILIAServer.class, Loggeur.INFO, PeerJXTA.this.printRemote());
            }
        };
        this._timerDisplay = new Timer("DISPLAY PEER", true);
        this._timerDisplay.schedule(display, 60000L, 60000L);
    }

    protected ArrayList<InfoPeerJXTA> connectServers() {
        ArrayList<InfoPeerJXTA> toBeTrash = new ArrayList<InfoPeerJXTA>();
        Loggeur.log(this.getClass(), Loggeur.INFO, ResJXTA.getString("NETWORK_CONNECT_BEGIN"));
        Iterator<InfoPeerJXTA> it = this._remotePeerList.iterator();
        while (it.hasNext()) {
            InfoPeerJXTA serveur = it.next();
            if (!serveur.getType().equals("SERVER") || serveur.isBound()) continue;
            if (serveur.getStatus() == 1) {
                Loggeur.log(this.getClass(), Loggeur.INFO, serveur.getName());
                Thread bidipipeThread = this.createBidiPipe(serveur);
                if (bidipipeThread == null) continue;
                bidipipeThread.start();
                continue;
            }
            toBeTrash.add(serveur);
            Loggeur.log(this.getClass(), Loggeur.INFO, String.valueOf(serveur.getName()) + " " + ResJXTA.getString("NETWORK_CONNECT_NOT_ONLINE"));
        }
        try {
            Thread.sleep(6000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (InfoPeerJXTA peerJXTA : toBeTrash) {
            this._remotePeerList.remove(peerJXTA);
        }
        Loggeur.log(this.getClass(), Loggeur.INFO, ResJXTA.getString("NETWORK_CONNECT_FINISHED"));
        return toBeTrash;
    }

    protected Thread createBidiPipe(InfoPeerJXTA serveur) {
        return null;
    }

    public Iterator<InfoPeerJXTA> remotePeerIterator() {
        return this._remotePeerList.iterator();
    }

    public void addRemotePeer(InfoPeerJXTA remotePeer) {
        InfoPeerJXTA oldPeer = this.getRemotePeer(remotePeer.getPeerIDString());
        if (oldPeer != null) {
            oldPeer.removeChangeListeners();
            this._remotePeerList.remove(oldPeer);
        }
        this._remotePeerList.add(remotePeer);
    }

    public void removeRemote(InfoPeerJXTA remotePeer) {
        this._remotePeerList.remove(remotePeer);
    }

    public InfoPeerJXTA getRemotePeer(String peerIDString) {
        return this._remotePeerList.getRemotePeer(peerIDString);
    }

    public DiscoveryService getDiscoSvc() {
        return this.discoSvc;
    }

    public PeerGroup getNetPeerGroup() {
        return this.netPeerGroup;
    }

    public NetworkManager25 getNetworkManager() {
        return this._manager;
    }

    public void stop() {
        try {
            Iterator<InfoPeerJXTA> it = this._remotePeerList.iterator();
            while (it.hasNext()) {
                InfoPeerJXTA remote = it.next();
                remote.closeConnection();
            }
            if (this._timerCheck != null) {
                this._timerCheck.cancel();
            }
            if (this._timerDisplay != null) {
                this._timerDisplay.cancel();
            }
            if (this._manager != null) {
                this._manager.stopNetwork();
            }
            if (this._timerMemory != null) {
                this._timerMemory.cancel();
            }
        }
        catch (Exception e) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, String.valueOf(ResJXTA.getString("PEER_STOP_ERROR")) + StackTracePrinter.getStackTrace(e));
            System.err.println(ResJXTA.getString("PEER_STOP_ERROR"));
        }
    }

    public boolean isStopped() {
        return this._manager.isStopped();
    }

    public PeerID getPeerID() {
        return this._peerID;
    }

    public String getPeerIDString() {
        return this.getPeerID().toString();
    }

    public String getPeerName() {
        return this._manager.getNetPeerGroup().getPeerName();
    }

    public boolean isShutingDown() {
        return this._isShutingDown;
    }

    public void setShutingDown() {
        this._isShutingDown = true;
    }

    public String printRemote() {
        return this._remotePeerList.toString();
    }

    public boolean isAuthorized(InfoPeerJXTA remotePeer, boolean noTypeAutorized) {
        if ("ADMIN".equals(remotePeer.getType())) {
            return true;
        }
        List<String> remoteTypes = remotePeer.getAuthorizedTypes();
        if (remoteTypes.size() == 0 && noTypeAutorized) {
            return true;
        }
        for (String string : remoteTypes) {
            if (!this._types.contains(string)) continue;
            return true;
        }
        return false;
    }

    public boolean addUnreachablePeer(String peerID) {
        return this._oldPeersID.add(peerID);
    }

    public boolean removeUnreachablePeer(String peerID) {
        return this._oldPeersID.remove(peerID);
    }
}

