/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.peers;

import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.CECILIAServer;
import com.dassault.cecilia.lib.distrib.peers.ConnectionsListennerThread;
import com.dassault.cecilia.lib.distrib.peers.PeerJXTA;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleClassAdvertisement;
import net.jxta.protocol.ModuleSpecAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.util.JxtaServerPipe;

public class PeerServer
extends PeerJXTA {
    public static final String PIPE_SERVER_ADV = "pipeserver.adv";
    protected String _pipeAdvFile;
    protected PipeAdvertisement _pipeAdv;
    protected JxtaServerPipe _serverPipe;
    protected CECILIAServer _serveurCecilia;
    private ConnectionsListennerThread _threadListenConnec;
    private Timer _timerPublish;

    public PeerServer(CECILIAServer serveurCecilia) {
        this._serveurCecilia = serveurCecilia;
    }

    @Override
    public void startJxta() {
        super.startJxta();
        StringBuffer sb = new StringBuffer();
        sb.append(new File(this._manager.getConfigHelper().getInstanceHomeURI()).getAbsolutePath());
        sb.append(File.separator);
        sb.append(PIPE_SERVER_ADV);
        this._pipeAdvFile = sb.toString();
        this.publishPipeAdv();
        this.createServerPipe();
    }

    protected void verificationOfNewIPorNewPort() {
    }

    public void createServerPipe() {
        try {
            this._serverPipe = new JxtaServerPipe(this.netPeerGroup, this._pipeAdv);
            this._serverPipe.setPipeTimeout(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void publishPipeAdv() {
        this.print("Publication PipeAdvertisement");
        try {
            final int publishPeriod = Integer.getInteger("cecilia.jxta.publish.period", 3600) * 1000;
            final ModuleClassAdvertisement mcadv = (ModuleClassAdvertisement)AdvertisementFactory.newAdvertisement((String)ModuleClassAdvertisement.getAdvertisementType());
            ModuleClassID mcID = null;
            mcadv.setName("JXTAMOD:JXTA-CECILIA");
            mcadv.setDescription("Module de calculs distribues CECILIA");
            mcID = IDFactory.newModuleClassID();
            mcadv.setModuleClassID(mcID);
            Loggeur.log(this.getClass(), Loggeur.FINEST, "Module Class ID : " + mcID);
            if (publishPeriod > 1000) {
                this.discoSvc.publish((Advertisement)mcadv, (long)(2 * publishPeriod), (long)(2 * publishPeriod));
                this.discoSvc.remotePublish((Advertisement)mcadv, (long)(2 * publishPeriod));
            } else {
                this.discoSvc.publish((Advertisement)mcadv);
                this.discoSvc.remotePublish((Advertisement)mcadv);
            }
            File fileAdv = new File(this._pipeAdvFile);
            if (!fileAdv.exists()) {
                PipeAdvertisement pipeAdvTmp = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
                pipeAdvTmp.setPipeID((ID)IDFactory.newPipeID((PeerGroupID)this.netPeerGroup.getPeerGroupID()));
                Loggeur.log(this.getClass(), Loggeur.FINEST, "Pipe Adv ID : " + pipeAdvTmp.getPipeID());
                pipeAdvTmp.setType("JxtaUnicast");
                pipeAdvTmp.setName(this.getPeerName());
                StringBuffer sb = new StringBuffer();
                sb.append("SERVERID");
                sb.append("=");
                sb.append(this.getPeerIDString());
                pipeAdvTmp.setDescription(sb.toString());
                FileWriter fileWriter = new FileWriter(fileAdv);
                fileWriter.write(pipeAdvTmp.toString());
                fileWriter.flush();
                fileWriter.close();
            }
            FileInputStream is = new FileInputStream(this._pipeAdvFile);
            XMLDocument doc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument((MimeMediaType)new MimeMediaType("text/xml"), (InputStream)is);
            this._pipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((XMLElement)doc.getRoot());
            is.close();
            final ModuleSpecAdvertisement mdadv = (ModuleSpecAdvertisement)AdvertisementFactory.newAdvertisement((String)ModuleSpecAdvertisement.getAdvertisementType());
            mdadv.setName("JXTASPEC:JXTA-CECILIA");
            mdadv.setVersion("Version 1.0");
            mdadv.setCreator("CXU");
            ModuleSpecID mspecID = IDFactory.newModuleSpecID((ModuleClassID)mcID);
            Loggeur.log(this.getClass(), Loggeur.FINEST, "Module Spec ID : " + mcID);
            mdadv.setModuleSpecID(mspecID);
            mdadv.setPipeAdvertisement(this._pipeAdv);
            if (publishPeriod > 1000) {
                this.discoSvc.publish((Advertisement)mdadv, (long)(2 * publishPeriod), (long)(2 * publishPeriod));
                this.discoSvc.remotePublish((Advertisement)mdadv, (long)(2 * publishPeriod));
            } else {
                this.discoSvc.publish((Advertisement)mdadv);
                this.discoSvc.remotePublish((Advertisement)mdadv);
            }
            if (publishPeriod > 0) {
                this._timerPublish = new Timer();
                this._timerPublish.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            PeerServer.this.discoSvc.publish((Advertisement)mcadv, (long)(2 * publishPeriod), (long)(2 * publishPeriod));
                            PeerServer.this.discoSvc.remotePublish((Advertisement)mcadv, (long)(2 * publishPeriod));
                            PeerServer.this.discoSvc.publish((Advertisement)mdadv, (long)(2 * publishPeriod), (long)(2 * publishPeriod));
                            PeerServer.this.discoSvc.remotePublish((Advertisement)mdadv, (long)(2 * publishPeriod));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }, publishPeriod, (long)publishPeriod);
            }
        }
        catch (IOException e) {
            this.print("failed to read/parse pipe advertisement");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.print("Server: Error publishing the module");
        }
    }

    public void waitForConnection() {
        this.print("starting ServerPipe");
        this._threadListenConnec = new ConnectionsListennerThread(this);
        this._threadListenConnec.start();
    }

    @Override
    public void stop() {
        this._threadListenConnec.closeConnection();
        super.stop();
    }

    @Override
    public String createDescription() {
        StringBuffer sb = new StringBuffer(32);
        sb.append("PEERTYPE");
        sb.append("=");
        sb.append("SERVER");
        sb.append(",");
        sb.append("VERSION");
        sb.append("=");
        sb.append("1.8.4");
        sb.append(",");
        sb.append("DESCRIPTION");
        sb.append("=");
        String desc = System.getProperty("cecilia.jxta.desc");
        if (desc == null || desc.equals("")) {
            sb.append("");
        } else {
            sb.append(desc.replace(",", "__"));
        }
        sb.append(",");
        sb.append("HOSTNAME");
        sb.append("=");
        try {
            sb.append(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            sb.append("");
        }
        sb.append(",");
        sb.append("APPTYPES");
        sb.append("=");
        Iterator types = this._types.iterator();
        while (types.hasNext()) {
            String type = (String)types.next();
            sb.append(type);
            if (!types.hasNext()) continue;
            sb.append(" ");
        }
        sb.append(",");
        sb.append("AVAILABLEENGINE");
        sb.append("=");
        Iterator<String> engines = this._serveurCecilia.getComputor().getEnginesList().iterator();
        while (engines.hasNext()) {
            String engine = engines.next();
            sb.append(engine);
            if (!engines.hasNext()) continue;
            sb.append(" ");
        }
        sb.append(",");
        return sb.toString();
    }

    public JxtaServerPipe getServerPipe() {
        return this._serverPipe;
    }

    public PipeAdvertisement getPipeAdv() {
        return this._pipeAdv;
    }

    public CECILIAServer getServeurCecilia() {
        return this._serveurCecilia;
    }
}

