/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.request;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonException;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.Request;

public class ReqAutomatonClient {
    public static void fireEvent(Request req, EvtClient reqAutomatonClientEvtClient) throws ReqAutomatonException {
        ReqState oldStatus = req.getState();
        if (ReqAutomatonClient.isAbsorbantState(oldStatus)) {
            return;
        }
        block0 : switch (reqAutomatonClientEvtClient) {
            case CANCEL_BY_ADMIN: {
                if (ReqAutomatonClient.isAbsorbantState(oldStatus)) break;
                req.setState(ReqState.CANCEL_BY_ADMIN);
                break;
            }
            case CANCEL_BY_USER: {
                if (ReqAutomatonClient.isAbsorbantState(oldStatus)) break;
                req.setState(ReqState.CANCEL_BY_USER);
                break;
            }
            case CANCEL_BY_SOFTWARE: {
                if (ReqAutomatonClient.isAbsorbantState(oldStatus)) break;
                req.setState(ReqState.CANCEL_BY_SOFTWARE);
                break;
            }
            case TOO_MANY_ERROR: {
                switch (oldStatus) {
                    case COMPUTING: 
                    case MISSING_FILE_TO_COMPUTE: 
                    case ENGINE_ERROR: 
                    case WRONG_RESULT: 
                    case RESULTS_TRANSFERT_ERROR: {
                        req.setState(ReqState.TOO_MANY_ERRORS);
                        break block0;
                    }
                }
                throw new ReqAutomatonException(req, oldStatus, EvtClient.TOO_MANY_ERROR.toString());
            }
            case NEW_2_PREPROCESS_ERROR: {
                if (oldStatus == ReqState.NEW) {
                    req.setState(ReqState.PREPROCESS_ERROR);
                    break;
                }
                throw new ReqAutomatonException(req, oldStatus, EvtClient.NEW_2_PREPROCESS_ERROR.toString());
            }
            case NEW_2_SENDING_REQUEST: {
                if (oldStatus == ReqState.NEW) {
                    req.setState(ReqState.SENDING_REQUEST);
                    break;
                }
                throw new ReqAutomatonException(req, oldStatus, EvtClient.NEW_2_SENDING_REQUEST.toString());
            }
            case NEW_2_NO_SERVER_AVAILABLE: {
                if (oldStatus == ReqState.NEW) {
                    req.setState(ReqState.NO_SERVER_AVAILABLE);
                    break;
                }
                throw new ReqAutomatonException(req, oldStatus, EvtClient.NEW_2_NO_SERVER_AVAILABLE.toString());
            }
            case SENDING_REQUEST_2_REQUEST_SENT: {
                if (oldStatus == ReqState.SENDING_REQUEST) {
                    req.setState(ReqState.REQUEST_SENT);
                    break;
                }
                if (oldStatus == ReqState.REQUEST_SENT || oldStatus == ReqState.REQUEST_SENT) break;
                throw new ReqAutomatonException(req, oldStatus, EvtClient.SENDING_REQUEST_2_REQUEST_SENT.toString());
            }
            case SENDING_REQUEST_2_MISSING_FILE_TO_SEND: {
                if (oldStatus == ReqState.SENDING_REQUEST) {
                    req.setState(ReqState.WRONG_DATA_FILE);
                    break;
                }
                throw new ReqAutomatonException(req, oldStatus, EvtClient.SENDING_REQUEST_2_MISSING_FILE_TO_SEND.toString());
            }
            case REQUEST_SENT_2_WAIT_COMPUTING: {
                if (oldStatus == ReqState.REQUEST_SENT || oldStatus == ReqState.SENDING_REQUEST) {
                    req.setState(ReqState.WAIT_COMPUTING);
                    break;
                }
                if (oldStatus == ReqState.WAIT_COMPUTING || oldStatus == ReqState.COMPUTING) break;
                throw new ReqAutomatonException(req, oldStatus, EvtClient.REQUEST_SENT_2_WAIT_COMPUTING.toString());
            }
            case WAIT_COMPUTING_2_COMPUTING: {
                if (oldStatus == ReqState.WAIT_COMPUTING || oldStatus == ReqState.REQUEST_SENT) {
                    req.setState(ReqState.COMPUTING);
                    break;
                }
                if (oldStatus == ReqState.COMPUTING || oldStatus == ReqState.COMPUTE_FINISHED) break;
                throw new ReqAutomatonException(req, oldStatus, EvtClient.WAIT_COMPUTING_2_COMPUTING.toString());
            }
            case WAIT_COMPUTING_2_SERVER_DOESNTT_HAVE_ENGINE: {
                if (oldStatus == ReqState.WAIT_COMPUTING) {
                    req.setState(ReqState.SERVER_DOESNT_HAVE_ENGINE);
                    break;
                }
                throw new ReqAutomatonException(req, oldStatus, EvtClient.WAIT_COMPUTING_2_SERVER_DOESNTT_HAVE_ENGINE.toString());
            }
            case WAIT_COMPUTING_2_MISSING_FILE_TO_COMPUTE: {
                if (oldStatus == ReqState.WAIT_COMPUTING) {
                    req.setState(ReqState.MISSING_FILE_TO_COMPUTE);
                    break;
                }
                throw new ReqAutomatonException(req, oldStatus, EvtClient.WAIT_COMPUTING_2_MISSING_FILE_TO_COMPUTE.toString());
            }
            case COMPUTING_2_COMPUTE_FINISHED: {
                if (oldStatus == ReqState.COMPUTING || oldStatus == ReqState.WAIT_COMPUTING) {
                    req.setState(ReqState.COMPUTE_FINISHED);
                    break;
                }
                if (oldStatus == ReqState.COMPUTE_FINISHED || oldStatus == ReqState.SENDING_RESULT) break;
                throw new ReqAutomatonException(req, oldStatus, EvtClient.COMPUTING_2_COMPUTE_FINISHED.toString());
            }
            case COMPUTING_2_ENGINE_ERROR: {
                if (oldStatus == ReqState.COMPUTING) {
                    req.setState(ReqState.ENGINE_ERROR);
                    break;
                }
                throw new ReqAutomatonException(req, oldStatus, EvtClient.COMPUTING_2_ENGINE_ERROR.toString());
            }
            case COMPUTE_FINISHED_2_SENDING_RESULT: {
                if (oldStatus == ReqState.COMPUTE_FINISHED || oldStatus == ReqState.COMPUTING) {
                    req.setState(ReqState.SENDING_RESULT);
                    break;
                }
                if (oldStatus == ReqState.SENDING_RESULT || oldStatus == ReqState.RESULT_SENT) break;
                throw new ReqAutomatonException(req, oldStatus, EvtClient.COMPUTE_FINISHED_2_SENDING_RESULT.toString());
            }
            case SENDING_RESULT_2_WRONG_RESULT: {
                if (oldStatus == ReqState.SENDING_RESULT) {
                    req.setState(ReqState.WRONG_RESULT);
                    break;
                }
                throw new ReqAutomatonException(req, oldStatus, EvtClient.SENDING_RESULT_2_WRONG_RESULT.toString());
            }
            case SENDING_RESULT_2_RESULT_SENT: {
                if (oldStatus == ReqState.SENDING_RESULT || oldStatus == ReqState.COMPUTE_FINISHED) {
                    req.setState(ReqState.RESULT_SENT);
                    break;
                }
                if (oldStatus == ReqState.RESULT_SENT || oldStatus == ReqState.COPYING_RESULT_TO_DEST) break;
                throw new ReqAutomatonException(req, oldStatus, EvtClient.SENDING_RESULT_2_RESULT_SENT.toString());
            }
            case SENDING_RESULT_2_RESULTS_TRANFERT_ERROR: {
                if (oldStatus == ReqState.SENDING_RESULT) {
                    req.setState(ReqState.RESULTS_TRANSFERT_ERROR);
                    break;
                }
                throw new ReqAutomatonException(req, oldStatus, EvtClient.SENDING_RESULT_2_RESULTS_TRANFERT_ERROR.toString());
            }
            case RESULT_TRANSFERT_ERROR_2_SENDING_RESULT: {
                if (oldStatus == ReqState.RESULTS_TRANSFERT_ERROR) {
                    req.setState(ReqState.SENDING_RESULT);
                    break;
                }
                throw new ReqAutomatonException(req, oldStatus, EvtClient.RESULT_TRANSFERT_ERROR_2_SENDING_RESULT.toString());
            }
            case RESULT_SENT_2_COPYING_RESULT: {
                if (oldStatus == ReqState.RESULT_SENT) {
                    req.setState(ReqState.COPYING_RESULT_TO_DEST);
                    break;
                }
                throw new ReqAutomatonException(req, oldStatus, EvtClient.RESULT_SENT_2_COPYING_RESULT.toString());
            }
            case COPYING_RESULT_2_SPECIFIC_THREATMENT: {
                if (oldStatus == ReqState.COPYING_RESULT_TO_DEST) {
                    req.setState(ReqState.SPECIFIC_THREATMENT);
                    break;
                }
                throw new ReqAutomatonException(req, oldStatus, EvtClient.COPYING_RESULT_2_SPECIFIC_THREATMENT.toString());
            }
            case COPYING_RESULT_2_COPYING_ERROR: {
                if (oldStatus == ReqState.COPYING_RESULT_TO_DEST) {
                    req.setState(ReqState.COPYING_ERROR);
                    break;
                }
                throw new ReqAutomatonException(req, oldStatus, EvtClient.COPYING_RESULT_2_COPYING_ERROR.toString());
            }
            case SPECIFIC_THREATMENT_2_FINISHED_SUCCESFULY: {
                if (oldStatus == ReqState.SPECIFIC_THREATMENT) {
                    req.setState(ReqState.FINISHED_SUCCESFULY);
                    break;
                }
                throw new ReqAutomatonException(req, oldStatus, EvtClient.SPECIFIC_THREATMENT_2_FINISHED_SUCCESFULY.toString());
            }
            case SPECIFIC_THREATMENT_2_SPECIFIC_THREATMENT_ERROR: {
                if (oldStatus == ReqState.SPECIFIC_THREATMENT) {
                    req.setState(ReqState.SPECIFIC_THREATMENT_ERROR);
                    break;
                }
                throw new ReqAutomatonException(req, oldStatus, EvtClient.SPECIFIC_THREATMENT_2_SPECIFIC_THREATMENT_ERROR.toString());
            }
            case NETWORK_DISCONNECT: {
                if (ReqAutomatonClient.isAbsorbantState(oldStatus)) break;
                req.setState(ReqState.NETWORK_DISCONNECT);
                break;
            }
            case RELAUNCH: {
                switch (oldStatus) {
                    case NEW: 
                    case SENDING_REQUEST: 
                    case REQUEST_SENT: 
                    case WAIT_COMPUTING: 
                    case SERVER_DOESNT_HAVE_ENGINE: 
                    case MISSING_FILE_TO_COMPUTE: 
                    case ENGINE_ERROR: 
                    case WRONG_RESULT: 
                    case WRONG_DATA_FILE: 
                    case NETWORK_DISCONNECT: {
                        req.setState(ReqState.NEW);
                        break block0;
                    }
                    case COMPUTING: 
                    case COMPUTE_FINISHED: 
                    case SENDING_RESULT: 
                    case RESULT_SENT: 
                    case COPYING_RESULT_TO_DEST: 
                    case SPECIFIC_THREATMENT: {
                        Loggeur.log(ReqAutomatonClient.class, Loggeur.WARNING, ResJXTA.getString("REQUEST_RELAUNCH_BAD"));
                        req.setState(ReqState.NEW);
                        break block0;
                    }
                }
                throw new ReqAutomatonException(req, oldStatus, EvtClient.CANCEL_BY_SOFTWARE.toString());
            }
        }
    }

    public static boolean isAbsorbantState(ReqState state) {
        switch (state) {
            case FINISHED_SUCCESFULY: 
            case NO_SERVER_AVAILABLE: 
            case PREPROCESS_ERROR: 
            case WRONG_DATA_FILE: 
            case COPYING_ERROR: 
            case SPECIFIC_THREATMENT_ERROR: 
            case TOO_MANY_ERRORS: 
            case CANCEL_BY_USER: 
            case CANCEL_BY_SOFTWARE: 
            case CANCEL_BY_ADMIN: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTemporaryErrorState(ReqState state) {
        switch (state) {
            case SERVER_DOESNT_HAVE_ENGINE: 
            case MISSING_FILE_TO_COMPUTE: 
            case ENGINE_ERROR: 
            case WRONG_RESULT: 
            case RESULTS_TRANSFERT_ERROR: {
                return true;
            }
        }
        return false;
    }

    public static boolean mustBeReportedToRemote(ReqState state) {
        return state == ReqState.RESULT_SENT || state == ReqState.RESULTS_TRANSFERT_ERROR || state == ReqState.CANCEL_BY_SOFTWARE;
    }

    public static enum EvtClient {
        NEW_2_SENDING_REQUEST,
        NEW_2_NO_SERVER_AVAILABLE,
        NEW_2_PREPROCESS_ERROR,
        SENDING_REQUEST_2_REQUEST_SENT,
        SENDING_REQUEST_2_MISSING_FILE_TO_SEND,
        REQUEST_SENT_2_WAIT_COMPUTING,
        WAIT_COMPUTING_2_COMPUTING,
        WAIT_COMPUTING_2_SERVER_DOESNTT_HAVE_ENGINE,
        WAIT_COMPUTING_2_MISSING_FILE_TO_COMPUTE,
        COMPUTING_2_COMPUTE_FINISHED,
        COMPUTING_2_ENGINE_ERROR,
        COMPUTE_FINISHED_2_SENDING_RESULT,
        SENDING_RESULT_2_RESULT_SENT,
        SENDING_RESULT_2_RESULTS_TRANFERT_ERROR,
        SENDING_RESULT_2_WRONG_RESULT,
        RESULT_TRANSFERT_ERROR_2_SENDING_RESULT,
        RESULT_SENT_2_COPYING_RESULT,
        COPYING_RESULT_2_SPECIFIC_THREATMENT,
        COPYING_RESULT_2_COPYING_ERROR,
        SPECIFIC_THREATMENT_2_FINISHED_SUCCESFULY,
        SPECIFIC_THREATMENT_2_SPECIFIC_THREATMENT_ERROR,
        TOO_MANY_ERROR,
        CANCEL_BY_ADMIN,
        CANCEL_BY_USER,
        CANCEL_BY_SOFTWARE,
        RELAUNCH,
        NETWORK_DISCONNECT;

    }
}

