/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.request;

import com.dassault.cecilia.lib.distrib.request.ReqAutomatonException;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.Request;

public class ReqAutomatonServer {
    public static void fireEvent(Request req, EvtServer reqAutomatonServerEvtServer) throws ReqAutomatonException {
        if (ReqAutomatonServer.isAbsorbantState(req.getState())) {
            return;
        }
        switch (reqAutomatonServerEvtServer) {
            case CANCEL_BY_ADMIN: {
                if (ReqAutomatonServer.isAbsorbantState(req.getState())) break;
                req.setState(ReqState.CANCEL_BY_ADMIN);
                break;
            }
            case CANCEL_BY_USER: {
                if (ReqAutomatonServer.isAbsorbantState(req.getState())) break;
                req.setState(ReqState.CANCEL_BY_USER);
                break;
            }
            case CANCEL_BY_SOFTWARE: {
                if (ReqAutomatonServer.isAbsorbantState(req.getState())) break;
                req.setState(ReqState.CANCEL_BY_SOFTWARE);
                break;
            }
            case NETWORK_DISCONNECT: {
                if (ReqAutomatonServer.isAbsorbantState(req.getState())) break;
                req.setState(ReqState.NETWORK_DISCONNECT);
                break;
            }
            case NEW_2_WAIT_COMPUTING: {
                if (req.getState() == ReqState.NEW) {
                    req.setState(ReqState.WAIT_COMPUTING);
                    break;
                }
                throw new ReqAutomatonException(req, req.getState(), EvtServer.NEW_2_WAIT_COMPUTING.toString());
            }
            case WAIT_COMPUTING_2_COMPUTING: {
                if (req.getState() == ReqState.WAIT_COMPUTING) {
                    req.setState(ReqState.COMPUTING);
                    break;
                }
                throw new ReqAutomatonException(req, req.getState(), EvtServer.WAIT_COMPUTING_2_COMPUTING.toString());
            }
            case WAIT_COMPUTING_2_SERVER_DOESNTT_HAVE_ENGINE: {
                if (req.getState() == ReqState.WAIT_COMPUTING) {
                    req.setState(ReqState.SERVER_DOESNT_HAVE_ENGINE);
                    break;
                }
                throw new ReqAutomatonException(req, req.getState(), EvtServer.WAIT_COMPUTING_2_SERVER_DOESNTT_HAVE_ENGINE.toString());
            }
            case WAIT_COMPUTING_2_MISSING_FILE_TO_COMPUTE: {
                if (req.getState() == ReqState.WAIT_COMPUTING) {
                    req.setState(ReqState.MISSING_FILE_TO_COMPUTE);
                    break;
                }
                throw new ReqAutomatonException(req, req.getState(), EvtServer.WAIT_COMPUTING_2_MISSING_FILE_TO_COMPUTE.toString());
            }
            case COMPUTING_2_COMPUTE_FINISHED: {
                if (req.getState() == ReqState.COMPUTING) {
                    req.setState(ReqState.COMPUTE_FINISHED);
                    break;
                }
                throw new ReqAutomatonException(req, req.getState(), EvtServer.COMPUTING_2_COMPUTE_FINISHED.toString());
            }
            case COMPUTING_2_ENGINE_ERROR: {
                if (req.getState() == ReqState.COMPUTING) {
                    req.setState(ReqState.ENGINE_ERROR);
                    break;
                }
                throw new ReqAutomatonException(req, req.getState(), EvtServer.COMPUTING_2_ENGINE_ERROR.toString());
            }
            case COMPUTE_FINISHED_2_SENDING_RESULT: {
                if (req.getState() == ReqState.COMPUTE_FINISHED) {
                    req.setState(ReqState.SENDING_RESULT);
                    break;
                }
                throw new ReqAutomatonException(req, req.getState(), EvtServer.COMPUTE_FINISHED_2_SENDING_RESULT.toString());
            }
            case SENDING_RESULT_2_WRONG_RESULT: {
                if (req.getState() == ReqState.SENDING_RESULT) {
                    req.setState(ReqState.WRONG_RESULT);
                    break;
                }
                throw new ReqAutomatonException(req, req.getState(), EvtServer.SENDING_RESULT_2_WRONG_RESULT.toString());
            }
            case SENDING_RESULT_2_RESULT_SENT: {
                if (req.getState() == ReqState.SENDING_RESULT) {
                    req.setState(ReqState.RESULT_SENT);
                    break;
                }
                throw new ReqAutomatonException(req, req.getState(), EvtServer.SENDING_RESULT_2_RESULT_SENT.toString());
            }
            case SENDING_RESULT_2_RESULT_TRANSFERT_ERROR: {
                if (req.getState() == ReqState.SENDING_RESULT) {
                    req.setState(ReqState.RESULTS_TRANSFERT_ERROR);
                    break;
                }
                throw new ReqAutomatonException(req, req.getState(), EvtServer.SENDING_RESULT_2_RESULT_TRANSFERT_ERROR.toString());
            }
            case RESULT_TRANSFERT_ERROR_2_SENDING_RESULT: {
                if (req.getState() == ReqState.RESULTS_TRANSFERT_ERROR) {
                    req.setState(ReqState.SENDING_RESULT);
                    break;
                }
                throw new ReqAutomatonException(req, req.getState(), EvtServer.RESULT_TRANSFERT_ERROR_2_SENDING_RESULT.toString());
            }
        }
    }

    public static boolean isAbsorbantState(ReqState state) {
        switch (state) {
            case RESULT_SENT: 
            case SERVER_DOESNT_HAVE_ENGINE: 
            case MISSING_FILE_TO_COMPUTE: 
            case ENGINE_ERROR: 
            case WRONG_RESULT: 
            case NETWORK_DISCONNECT: 
            case CANCEL_BY_USER: 
            case CANCEL_BY_SOFTWARE: 
            case CANCEL_BY_ADMIN: {
                return true;
            }
        }
        return false;
    }

    public static boolean isErrorState(ReqState state) {
        switch (state) {
            case SERVER_DOESNT_HAVE_ENGINE: 
            case MISSING_FILE_TO_COMPUTE: 
            case ENGINE_ERROR: 
            case WRONG_RESULT: {
                return true;
            }
        }
        return false;
    }

    public static boolean mustBeReportedToRemote(ReqState state) {
        switch (state) {
            case WAIT_COMPUTING: 
            case COMPUTING: 
            case COMPUTE_FINISHED: 
            case SENDING_RESULT: 
            case CANCEL_BY_SOFTWARE: 
            case CANCEL_BY_ADMIN: {
                return true;
            }
        }
        return false;
    }

    public static enum EvtServer {
        NEW_2_WAIT_COMPUTING,
        WAIT_COMPUTING_2_COMPUTING,
        WAIT_COMPUTING_2_SERVER_DOESNTT_HAVE_ENGINE,
        WAIT_COMPUTING_2_MISSING_FILE_TO_COMPUTE,
        COMPUTING_2_COMPUTE_FINISHED,
        COMPUTING_2_ENGINE_ERROR,
        COMPUTE_FINISHED_2_SENDING_RESULT,
        SENDING_RESULT_2_RESULT_SENT,
        SENDING_RESULT_2_WRONG_RESULT,
        SENDING_RESULT_2_RESULT_TRANSFERT_ERROR,
        RESULT_TRANSFERT_ERROR_2_SENDING_RESULT,
        CANCEL_BY_ADMIN,
        CANCEL_BY_USER,
        CANCEL_BY_SOFTWARE,
        NETWORK_DISCONNECT;

    }
}

