/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.request;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.filetransfert.FileNameUtility;
import com.dassault.cecilia.lib.distrib.ihm.ResJXTAIHM;
import com.dassault.cecilia.lib.distrib.jxtautility.FileDirDeletor;
import com.dassault.cecilia.lib.distrib.jxtautility.MessageUtility;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.PeerJXTA;
import com.dassault.cecilia.lib.distrib.request.CommandFileWriter;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonClient;
import com.dassault.cecilia.lib.distrib.request.ReqChangeListener;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.RequestHisto;
import com.dassault.cecilia.lib.distrib.xmlutility.MessageInfoAnalyser;
import com.dassault.cecilia.lib.distrib.xmlutility.XMLEscape;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.jxta.endpoint.Message;

public class Request {
    public static final int NOERROR = 12345;
    public static final int PRIO_DELTA = Integer.getInteger("cecilia.jxta.prio", 0);
    private String _uniqueID;
    private String _peerIDClient;
    private String _peerIDServer;
    private ReqState _etat;
    private String _info;
    private boolean _parsed;
    private String _commandFile;
    private List<String> _neededFiles;
    private List<String> _resultFiles;
    private List<String> _receivedFiles;
    private String _engine;
    private String _engineOptions = "";
    private int _numberOfErr = 0;
    private int _priotity = 0;
    private RequestHisto _histo;
    private static Object __idLock = new Object();
    private static long __createID = 0L;
    private long _requestCreationID;
    private boolean _redistributed;
    private boolean _soonArrived;
    public ArrayList<ReqChangeListener> _changeListener = new ArrayList();
    public boolean flagWaitComputingReported = false;
    public boolean flagComputingReported = false;
    public boolean flagComputFinishedReported = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request() {
        Object object = __idLock;
        synchronized (object) {
            this._requestCreationID = __createID++;
        }
    }

    public long getCreationID() {
        return this._requestCreationID;
    }

    public String getAllID() {
        StringBuffer sb = new StringBuffer(128);
        sb.append(" shortID=");
        sb.append(this.getShortNumber());
        sb.append(" creationID=");
        sb.append(this.getCreationID());
        sb.append(" jxtaUID=");
        sb.append(this.getID());
        return sb.toString();
    }

    public static String createName(String peerID, int count) {
        StringBuffer sb = new StringBuffer();
        sb.append(peerID);
        sb.append("_R_");
        sb.append(String.valueOf(count));
        return sb.toString();
    }

    public static String retrievePeerID(String reqID) {
        StringTokenizer st = new StringTokenizer(reqID, "_");
        return st.nextToken();
    }

    public static String retrieveCounter(String reqID) {
        try {
            StringTokenizer st = new StringTokenizer(reqID, "_");
            st.nextElement();
            st.nextElement();
            String cnt = st.nextToken();
            assert (cnt.length() > 0);
            return cnt;
        }
        catch (NoSuchElementException e) {
            return "";
        }
    }

    public Request(String uniqueID) {
        this._uniqueID = uniqueID;
        this._neededFiles = new ArrayList<String>();
        this._resultFiles = new ArrayList<String>();
        this._receivedFiles = new ArrayList<String>();
        this._changeListener = new ArrayList();
        this._histo = new RequestHisto();
        this._engine = "";
        this._peerIDClient = "";
        this._peerIDServer = "";
        this._etat = ReqState.NEW;
        this._info = "";
        this._parsed = false;
        this._redistributed = false;
        this._priotity = PRIO_DELTA;
        this._histo.record(this);
    }

    public void initialiseFromMessage(MessageInfoAnalyser infoAnalyser) {
        this._neededFiles = infoAnalyser.getList("NEEDEDFILE");
        this._resultFiles = infoAnalyser.getList("RESULTFILE");
        this._commandFile = infoAnalyser.getAttribut("COMMAND");
        this._engine = infoAnalyser.getAttribut("ENGINE");
        this._engineOptions = XMLEscape.fromXML(infoAnalyser.getAttribut("ENGINEOPTIONS"));
        this._peerIDClient = infoAnalyser.getAttribut("CLIENTID");
        try {
            this._priotity = Integer.valueOf(infoAnalyser.getAttribut("PRIO"));
        }
        catch (Exception e) {
            Loggeur.log(this.getClass(), Loggeur.DEBUG, "Wong PRIO " + infoAnalyser.getAttribut("PRIO"));
        }
    }

    public void fileIsArrived(String fileName) {
        if (!this._receivedFiles.contains(fileName)) {
            this._receivedFiles.add(fileName);
        }
    }

    public boolean isFinished() {
        return ReqAutomatonClient.isAbsorbantState(this._etat);
    }

    public boolean isInError() {
        return this.isFinished() && this._etat != ReqState.FINISHED_SUCCESFULY;
    }

    public boolean allFilesArrived() {
        boolean containsAll = this._receivedFiles.containsAll(this._resultFiles);
        return containsAll;
    }

    public Message createRequestMessage() {
        StringBuffer sb = new StringBuffer(128);
        Iterator<String> it = this._neededFiles.iterator();
        while (it.hasNext()) {
            String file = it.next();
            sb.append(file);
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        String needed = sb.toString();
        sb = new StringBuffer(128);
        it = this._resultFiles.iterator();
        while (it.hasNext()) {
            String file = it.next();
            sb.append(file);
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        String results = sb.toString();
        HashMap<String, String> attMap = new HashMap<String, String>();
        attMap.put("MESSAGETYPE", "CECILIAREQUEST");
        attMap.put("UID", this._uniqueID);
        attMap.put("NEEDEDFILE", needed);
        attMap.put("RESULTFILE", results);
        attMap.put("COMMAND", this._commandFile);
        attMap.put("ENGINE", this._engine);
        attMap.put("ENGINEOPTIONS", XMLEscape.toXML(this._engineOptions));
        attMap.put("CLIENTID", this._peerIDClient);
        attMap.put("PRIO", String.valueOf(this._priotity));
        return MessageUtility.createMessageWithInfo(attMap, this._peerIDClient);
    }

    public void deleteNeededFile() {
        if (JXTAProperties.getBoolProperty("cecilia.jxta.keeptmp")) {
            return;
        }
        for (String uniqueFilename : this._neededFiles) {
            if (FileNameUtility.retrieveDiffuseFile(uniqueFilename)) continue;
            File file = new File(JXTAProperties.getTempDir(), uniqueFilename);
            FileDirDeletor.deleteIfNotDir(file);
        }
    }

    public void deleteResultFiles() {
        if (JXTAProperties.getBoolProperty("cecilia.jxta.keeptmp")) {
            return;
        }
        for (String uniqueFilename : this._resultFiles) {
            File file = new File(JXTAProperties.getTempDir(), uniqueFilename);
            FileDirDeletor.deleteIfNotDir(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relaunch() {
        StringBuffer sb = new StringBuffer();
        sb.append("REQUEST_RELAUNCH");
        sb.append(this.getShortNumber());
        Loggeur.log(this.getClass(), Loggeur.INFO, sb.toString());
        Request request = this;
        synchronized (request) {
            this.setServerID("");
            ReqAutomatonClient.fireEvent(this, ReqAutomatonClient.EvtClient.RELAUNCH);
        }
        this.setInfo("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relaunchOn(String serverID) {
        StringBuffer sb = new StringBuffer();
        sb.append("REQUEST_RELAUNCH_ON");
        sb.append(this.getShortNumber());
        sb.append(" -> ");
        sb.append(serverID);
        Loggeur.log(this.getClass(), Loggeur.INFO, sb.toString());
        Request request = this;
        synchronized (request) {
            this.setServerID(serverID);
            ReqAutomatonClient.fireEvent(this, ReqAutomatonClient.EvtClient.RELAUNCH);
        }
    }

    public void addNeededFile(String fileName) {
        if (!this._neededFiles.contains(fileName)) {
            this._neededFiles.add(fileName);
        }
    }

    public void addResultFile(String fileName) {
        if (!this._resultFiles.contains(fileName)) {
            this._resultFiles.add(fileName);
        }
    }

    public List<String> getNeededFiles() {
        return this._neededFiles;
    }

    public List<String> getResultFiles() {
        return this._resultFiles;
    }

    public String getClientID() {
        return this._peerIDClient;
    }

    public void setClientID(String client) {
        this._peerIDClient = client;
    }

    public String getServerID() {
        return this._peerIDServer;
    }

    public void setServerID(String server) {
        if (server == null || server.equals("")) {
            Loggeur.log(this.getClass(), Loggeur.DEBUG, "Server null : " + this.getShortNumber());
        }
        this._peerIDServer = server;
    }

    public String getCmdFileName() {
        return this._commandFile;
    }

    public void setCmdFileName(String commandFile) {
        this._neededFiles.remove(this._commandFile);
        this._commandFile = commandFile;
        this._neededFiles.add(this._commandFile);
    }

    public void setCmdFileName(CommandFileWriter commandFW) {
        this.setCmdFileName(commandFW.getUniqueFileName());
    }

    protected void setState(ReqState etat) {
        ReqState old = this._etat;
        this._etat = etat;
        this._histo.record(this);
        StringBuffer sb = new StringBuffer();
        sb.append(this.getShortNumber());
        sb.append(" (");
        sb.append((Object)old);
        sb.append(" -> ");
        sb.append((Object)etat);
        sb.append(")");
        Loggeur.log(this.getClass(), Loggeur.DEBUG, sb.toString());
        this.fireStateChange(old, etat);
    }

    public ReqState getState() {
        return this._etat;
    }

    public String getID() {
        return this._uniqueID;
    }

    public String getShortNumber() {
        return Request.retrieveCounter(this._uniqueID);
    }

    public String getEngine() {
        return this._engine;
    }

    public void setEngine(String engine) {
        this._engine = engine;
    }

    public String getEngineOptions() {
        return this._engineOptions;
    }

    public void setEngineOptions(String engineOpts) {
        this._engineOptions = engineOpts;
    }

    public boolean isParsed() {
        return this._parsed;
    }

    public void setParsed(boolean parsed) {
        this._parsed = parsed;
    }

    public boolean isRedistributed() {
        return this._redistributed;
    }

    public void setRedistributed(boolean redistributed) {
        this._redistributed = redistributed;
    }

    public boolean isWritingFile() {
        return this._soonArrived;
    }

    public void setWritingFile(boolean soonArrived) {
        this._soonArrived = soonArrived;
    }

    public int getGeneratedError() {
        try {
            return Integer.parseInt(this._info);
        }
        catch (Exception e) {
            return 12345;
        }
    }

    public String getInfo() {
        return this._info;
    }

    public void setInfo(String info) {
        this._info = info;
    }

    public String toString() {
        return this._uniqueID;
    }

    public RequestHisto getHisto() {
        return this._histo;
    }

    public String getHistoString(PeerJXTA peer) {
        StringBuffer sb = new StringBuffer();
        sb.append(ResJXTAIHM.getString("GLOBAL_REQ"));
        sb.append(" ");
        sb.append(this.getShortNumber());
        sb.append("\n");
        sb.append(this._histo.toString(peer));
        return sb.toString();
    }

    public void addChangeListener(ReqChangeListener listener) {
        if (!this._changeListener.contains(listener)) {
            this._changeListener.add(listener);
        }
    }

    public void removeChangeListener(ReqChangeListener listener) {
        this._changeListener.remove(listener);
    }

    private void fireStateChange(ReqState oldState, ReqState newState) {
        for (ReqChangeListener listener : this._changeListener) {
            listener.requestStateChange(this, oldState, newState);
        }
    }

    public int getNumberOfErr() {
        return this._numberOfErr;
    }

    public void setNumberOfErr(int ofErr) {
        this._numberOfErr = ofErr;
    }

    public void setPriority(int newPrio) {
        this._priotity = PRIO_DELTA + newPrio;
    }

    public int getPriority() {
        return this._priotity;
    }

    public static String convertToUserFriendly(String requestID, PeerJXTA localJXTA) {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("urn:jxta:uuid-");
            sb.append(Request.retrievePeerID(requestID));
            InfoPeerJXTA client = localJXTA.getRemotePeer(sb.toString());
            if (client == null) {
                return Request.retrieveCounter(requestID);
            }
            return String.valueOf(client.getName()) + "_" + Request.retrieveCounter(requestID);
        }
        catch (Exception e) {
            return "";
        }
    }

    public void fireStateReportedToRemote(ReqState state) {
        if (state == ReqState.WAIT_COMPUTING) {
            this.flagWaitComputingReported = true;
        }
        if (state == ReqState.COMPUTING) {
            this.flagComputingReported = true;
        }
        if (state == ReqState.COMPUTE_FINISHED) {
            this.flagComputFinishedReported = true;
        }
    }
}

