/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.request;

import com.dassault.cecilia.lib.distrib.peers.PeerJXTA;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonClient;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.request.RequestHistoElt;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RequestHisto {
    private ArrayList<RequestHistoElt> _elts = new ArrayList();

    public void record(Request req) {
        ReqState state = req.getState();
        String complementaryInfo = null;
        switch (state) {
            case ENGINE_ERROR: {
                complementaryInfo = req.getInfo();
                break;
            }
            default: {
                complementaryInfo = req.getInfo();
            }
        }
        this._elts.add(new RequestHistoElt(req.getState(), req.getServerID(), new Date(System.currentTimeMillis()), complementaryInfo, req.getPriority()));
    }

    public void record(Request req, Object complementaryInfo) {
        this._elts.add(new RequestHistoElt(req.getState(), req.getServerID(), new Date(System.currentTimeMillis()), complementaryInfo, req.getPriority()));
    }

    public int countState(ReqState state) {
        int count = 0;
        for (RequestHistoElt elt : this._elts) {
            if (elt._state != state) continue;
            ++count;
        }
        return count;
    }

    public int countState(ReqState state, String info) {
        int count = 0;
        for (RequestHistoElt elt : this._elts) {
            if (elt._state != state || !elt._complementaryInfo.equals(info)) continue;
            ++count;
        }
        return count;
    }

    public int countTmpErr() {
        int count = 0;
        for (RequestHistoElt elt : this._elts) {
            if (!ReqAutomatonClient.isTemporaryErrorState(elt._state)) continue;
            ++count;
        }
        return count;
    }

    public int size() {
        return this._elts.size();
    }

    public ReqState getIemeState(int index) {
        if (index < 0 || index >= this._elts.size()) {
            return null;
        }
        return this._elts.get((int)index)._state;
    }

    public Date getIemeDate(int index) {
        if (index < 0 || index >= this._elts.size()) {
            return null;
        }
        return this._elts.get((int)index)._date;
    }

    public String getLastServeur() {
        return this._elts.get((int)(this._elts.size() - 1))._onServeurID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this._elts.size()) {
            sb.append(this._elts.get(i).toString());
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    protected String toString(PeerJXTA peer) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this._elts.size()) {
            sb.append(this._elts.get(i).toString(peer));
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public String toStringShort() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this._elts.size()) {
            sb.append((Object)this._elts.get((int)i)._state);
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    public List<ReqState> getStateList() {
        ArrayList<ReqState> list = new ArrayList<ReqState>();
        int i = 0;
        while (i < this._elts.size()) {
            list.add(this._elts.get((int)i)._state);
            ++i;
        }
        return list;
    }

    public boolean compareToList(ReqState[] list) {
        if (list.length != this._elts.size()) {
            return false;
        }
        int i = 0;
        while (i < list.length) {
            if (list[i] != this._elts.get((int)i)._state) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean endsWithList(ReqState[] list) {
        int delta = this._elts.size() - list.length;
        if (delta < 0) {
            return false;
        }
        int i = list.length - 1;
        while (i >= 0) {
            if (list[i] != this._elts.get((int)(i + delta))._state) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static void main(String[] args) {
        ReqState[] GOOD_LIST = new ReqState[]{ReqState.NEW, ReqState.SENDING_REQUEST, ReqState.REQUEST_SENT, ReqState.WAIT_COMPUTING, ReqState.COMPUTING, ReqState.COMPUTE_FINISHED, ReqState.SENDING_RESULT, ReqState.RESULT_SENT, ReqState.COPYING_RESULT_TO_DEST, ReqState.SPECIFIC_THREATMENT, ReqState.FINISHED_SUCCESFULY};
        RequestHisto histo = new RequestHisto();
        histo._elts.add(new RequestHistoElt(ReqState.NEW, "id", new Date(), "", 0));
        histo._elts.add(new RequestHistoElt(ReqState.SENDING_REQUEST, "id", new Date(), "", 0));
        histo._elts.add(new RequestHistoElt(ReqState.REQUEST_SENT, "id", new Date(), "", 0));
        histo._elts.add(new RequestHistoElt(ReqState.WAIT_COMPUTING, "id", new Date(), "", 0));
        histo._elts.add(new RequestHistoElt(ReqState.COMPUTING, "id", new Date(), "", 0));
        histo._elts.add(new RequestHistoElt(ReqState.COMPUTE_FINISHED, "id", new Date(), "", 0));
        histo._elts.add(new RequestHistoElt(ReqState.SENDING_RESULT, "id", new Date(), "", 0));
        histo._elts.add(new RequestHistoElt(ReqState.RESULT_SENT, "id", new Date(), "", 0));
        histo._elts.add(new RequestHistoElt(ReqState.COPYING_RESULT_TO_DEST, "id", new Date(), "", 0));
        histo._elts.add(new RequestHistoElt(ReqState.SPECIFIC_THREATMENT, "id", new Date(), "", 0));
        histo._elts.add(new RequestHistoElt(ReqState.FINISHED_SUCCESFULY, "id", new Date(), "", 0));
        assert (histo.compareToList(GOOD_LIST));
        if (histo.compareToList(GOOD_LIST)) {
            System.out.println("compare OK");
        } else {
            System.out.println("compare KO");
        }
        RequestHisto histoRelaunch = new RequestHisto();
        histoRelaunch._elts.add(new RequestHistoElt(ReqState.NEW, "id", new Date(), "", 0));
        histoRelaunch._elts.add(new RequestHistoElt(ReqState.SENDING_REQUEST, "id", new Date(), "", 0));
        histoRelaunch._elts.add(new RequestHistoElt(ReqState.REQUEST_SENT, "id", new Date(), "", 0));
        histoRelaunch._elts.add(new RequestHistoElt(ReqState.WAIT_COMPUTING, "id", new Date(), "", 0));
        histoRelaunch._elts.add(new RequestHistoElt(ReqState.COMPUTING, "id", new Date(), "", 0));
        histoRelaunch._elts.add(new RequestHistoElt(ReqState.NEW, "id", new Date(), "", 0));
        histoRelaunch._elts.add(new RequestHistoElt(ReqState.SENDING_REQUEST, "id", new Date(), "", 0));
        histoRelaunch._elts.add(new RequestHistoElt(ReqState.REQUEST_SENT, "id", new Date(), "", 0));
        histoRelaunch._elts.add(new RequestHistoElt(ReqState.WAIT_COMPUTING, "id", new Date(), "", 0));
        histoRelaunch._elts.add(new RequestHistoElt(ReqState.COMPUTING, "id", new Date(), "", 0));
        histoRelaunch._elts.add(new RequestHistoElt(ReqState.COMPUTE_FINISHED, "id", new Date(), "", 0));
        histoRelaunch._elts.add(new RequestHistoElt(ReqState.SENDING_RESULT, "id", new Date(), "", 0));
        histoRelaunch._elts.add(new RequestHistoElt(ReqState.RESULT_SENT, "id", new Date(), "", 0));
        histoRelaunch._elts.add(new RequestHistoElt(ReqState.COPYING_RESULT_TO_DEST, "id", new Date(), "", 0));
        histoRelaunch._elts.add(new RequestHistoElt(ReqState.SPECIFIC_THREATMENT, "id", new Date(), "", 0));
        histoRelaunch._elts.add(new RequestHistoElt(ReqState.FINISHED_SUCCESFULY, "id", new Date(), "", 0));
        if (histoRelaunch.endsWithList(GOOD_LIST)) {
            System.out.println("endsWithList OK");
        } else {
            System.out.println("endsWithList KO");
        }
    }
}

