/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.requestManagement;

import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.requestManagement.TrashListenner;
import java.util.ArrayList;

public class RequestTrash {
    private ArrayList<Request> _requests;
    private int _maxSize = Integer.getInteger("cecilia.jxta.trash.size", 1000);
    private int _curSize = 0;
    private int _nextIndex;
    private ArrayList<TrashListenner> _listenners;

    public RequestTrash() {
        this._requests = new ArrayList();
        this._listenners = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Request o) {
        ArrayList<Request> arrayList = this._requests;
        synchronized (arrayList) {
            if (this._curSize < this._maxSize) {
                this._requests.add(o);
                ++this._curSize;
                ++this._nextIndex;
            } else {
                if (this._nextIndex >= this._maxSize) {
                    this._nextIndex = 0;
                }
                this._requests.set(this._nextIndex, o);
                ++this._nextIndex;
            }
        }
        this.fireChange();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<Request> arrayList = this._requests;
        synchronized (arrayList) {
            this._requests.clear();
            this._curSize = 0;
            this._nextIndex = 0;
        }
        this.fireChange();
    }

    public Request get(int index) {
        if (index >= 0 && index < this._requests.size()) {
            return this._requests.get(index);
        }
        return null;
    }

    public int size() {
        return this._requests.size();
    }

    public int getCurrentSize() {
        return this._curSize;
    }

    public int getMaxSize() {
        return this._maxSize;
    }

    public int getNextIndex() {
        return this._nextIndex;
    }

    public void addListenner(TrashListenner listenner) {
        if (!this._listenners.contains(listenner)) {
            this._listenners.add(listenner);
        }
    }

    public void removeListenner(TrashListenner listenner) {
        if (this._listenners.contains(listenner)) {
            this._listenners.remove(listenner);
        }
    }

    private void fireChange() {
        for (TrashListenner listenner : this._listenners) {
            listenner.trashChange();
        }
    }
}

