/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.test;

import com.dassault.cecilia.lib.distrib.request.Command;
import com.dassault.cecilia.lib.distrib.request.CommandFileWriter;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.test.TestJXTAClient;
import com.dassault.cecilia.lib.distrib.test.TestRessources;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class TestClientTransfertTimeOutServer
extends TestJXTAClient {
    private int nbTest = 0;

    @Test
    public void testSizeOf() {
        Request req = this.createAndLaunchTestRequest(15);
        this.waitEmptyStock();
        Assert.assertTrue((String)req.getHisto().toString(), (boolean)req.getHisto().endsWithList(GOOD_LIST));
    }

    @Test
    public void testBigResult() {
        Request req0 = this._client.getNewRequest();
        req0.setEngine("ARALIA4");
        Command command = this._client.getCommandWriter(req0);
        command.append("load \"");
        command.addInputFile(TestRessources.getRessource("bigresultv4.dag"));
        command.append("\";\n");
        command.append("r := [@,3,roots(*)];\n");
        command.append("compute BDD r;\n");
        command.append("compute ZQC r;\n");
        command.append("approximate product-number ZQC r;\n");
        command.append("display products ZQC r > \"");
        command.addOutputFile(new File(".\\BigRes.res"));
        command.append("\";\n");
        command.append("exit;\n");
        req0.setCmdFileName(command.getFileName());
        req0.setParsed(true);
        this._client.addRequestToStock(req0);
        this.waitEmptyStock();
        File big = new File(".\\BigRes.res");
        Assert.assertTrue((String)(String.valueOf(big.length()) + " Octets"), (big.length() == 296881226L ? 1 : 0) != 0);
        Assert.assertTrue((String)req0.getHistoString(this._client.getPeerJXTA()), (boolean)req0.getHisto().endsWithList(GOOD_LIST));
    }

    @Test
    public void testBigResultWithOther() {
        ArrayList<Request> reqs = new ArrayList<Request>();
        int i = 0;
        while (i < 50) {
            reqs.add(this.createAndLaunchTestRequest(5));
            ++i;
        }
        this.testBigResult();
        i = 0;
        while (i < 50) {
            Assert.assertTrue((((Request)reqs.get(i)).getState() == ReqState.FINISHED_SUCCESFULY ? 1 : 0) != 0);
            ++i;
        }
        this.waitEmptyTrash();
    }

    public Request createAndLaunchTestRequest(int executionTime) {
        File file = new File(".\\taille" + this.nbTest + ".txt");
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        Request req = this._client.getNewRequest();
        req.setEngine("TESTFILE");
        req.setParsed(true);
        try {
            CommandFileWriter fw = new CommandFileWriter(this._client, req);
            fw.writeText("sizeof ");
            fw.writeInputFile(TestRessources.getRessource("bigresultv4.dag"));
            fw.writeText(" > ");
            fw.writeOutputFile(file);
            fw.writeText(" wait ");
            fw.writeText(String.valueOf(executionTime));
            fw.flushAndClose();
            req.setCmdFileName(fw);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        this._client.addRequestToStock(req);
        ++this.nbTest;
        return req;
    }
}

