/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.xmlutility;

import com.dassault.cecilia.lib.distrib.jxtautility.JXTAException;
import com.dassault.cecilia.lib.distrib.xmlutility.XMLUtility;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.jxta.endpoint.MessageElement;
import org.xml.sax.InputSource;

public class MessageInfoAnalyser {
    protected String _type;
    protected Map _attMap;
    protected ArrayList<String> _neededFiles;
    protected ArrayList<String> _resultFiles;
    protected String _senderID;

    public MessageInfoAnalyser(MessageElement elt) throws JXTAException {
        String element = elt.toString();
        InputSource infoSource = new InputSource(new StringReader(element));
        this._attMap = new XMLUtility(infoSource).findEntity("INFO");
        this._type = (String)this._attMap.get("MESSAGETYPE");
        this._senderID = (String)this._attMap.get("SENDERID");
        if (this._type == null) {
            JXTAException ex = new JXTAException();
            ex.setTypeOfError(3);
            ex.setCondition("During Info Analyse");
            ex.setElt(elt);
            throw ex;
        }
        if (this._type.equals("CECILIAREQUEST")) {
            this._neededFiles = new ArrayList();
            this._resultFiles = new ArrayList();
            this.initializeForCeciliaRequest();
        }
    }

    private void initializeForCeciliaRequest() throws JXTAException {
        JXTAException ex = new JXTAException();
        ex.setTypeOfError(3);
        ex.setCondition("During Request Info Analyse");
        String neededFilesString = (String)this._attMap.get("NEEDEDFILE");
        if (neededFilesString == null) {
            throw ex;
        }
        StringTokenizer st = new StringTokenizer(neededFilesString, ",");
        while (st.hasMoreTokens()) {
            this._neededFiles.add(st.nextToken());
        }
        String resultFilesString = (String)this._attMap.get("RESULTFILE");
        if (resultFilesString == null) {
            throw ex;
        }
        st = new StringTokenizer(resultFilesString, ",");
        while (st.hasMoreTokens()) {
            this._resultFiles.add(st.nextToken());
        }
    }

    public String getAttribut(String attname) {
        return (String)this._attMap.get(attname);
    }

    public List<String> getList(String listName) {
        if (listName == "NEEDEDFILE") {
            return this._neededFiles;
        }
        if (listName == "RESULTFILE") {
            return this._resultFiles;
        }
        return null;
    }

    public String getType() {
        return this._type;
    }

    public String getSenderID() {
        return this._senderID;
    }
}

