/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mcs;

import com.dassault.cecilia.lib.mcs.CutUser;
import com.dassault.cecilia.lib.mcs.McsReader;
import com.dassault.cecilia.lib.mcs.McsUser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;

public class McsToAralia
implements McsUser {
    File _input;
    PrintWriter _araWriter;
    int _sizeBlock;
    char _sepGate;
    String _top;
    ArrayList<Idx> _idxLst;
    private static final Pattern PATTERN_SIMPLE_ID = Pattern.compile("[A-Za-z][A-Za-z0-9_\\-\\.\\^]*");
    private static String SYNTAX = "Syntax : java -classpath ... " + McsToAralia.class.getName() + " \n   [--input <input>]    \n   [-i <input>]         // input file\n   [--output <output>]  \n   [-o <output>]        // output file\n   [--size <size>]      // integer > 1\n   [--separator <sep>]  // only one character\nIf input ou output not define, launch a system FileChooser.";

    public McsToAralia(File input, Writer araWriter) {
        this(input, araWriter, 100, '.');
    }

    public McsToAralia(File input, Writer araWriter, int size, char sep) {
        this._input = input;
        this._araWriter = new PrintWriter(araWriter);
        this._sizeBlock = Math.max(size, 2);
        this._sepGate = sep;
        this.beginTop("root");
    }

    @Override
    public void beginSet() throws IOException {
    }

    @Override
    public void setTop(String top) {
        this.beginTop(top);
    }

    @Override
    public void addCut(CutUser cut) throws IOException {
        this.addMCS(cut.getEvents());
    }

    @Override
    public void endSet() throws IOException {
        this.endTop();
    }

    private int incIdx(int rg) {
        Idx idx = this._idxLst.get(rg);
        return ++idx._idx;
    }

    private void beginTop(String top) {
        this._top = top;
        this._idxLst = new ArrayList();
        this._idxLst.add(new Idx(0));
    }

    private void writeGroupMCS(int num, int rg) throws IOException {
        if (num % this._sizeBlock != 0) {
            return;
        }
        if (this._idxLst.size() == rg + 1) {
            this._idxLst.add(new Idx(0));
        }
        StringBuffer sb = new StringBuffer(3 + rg * 2);
        sb.append("g");
        sb.append(this._sepGate);
        for (int i = 0; i < rg; ++i) {
            sb.append(this._sizeBlock);
            sb.append(this._sepGate);
        }
        String baseName = sb.toString();
        int idx = this.incIdx(rg + 1);
        this._araWriter.print(baseName);
        this._araWriter.print(this._sizeBlock);
        this._araWriter.print(this._sepGate);
        this._araWriter.print(idx);
        this._araWriter.print(" := (");
        int beg = num % this._sizeBlock;
        beg = beg == 0 ? num - this._sizeBlock : num - beg;
        for (int i = beg; i < num; ++i) {
            this._araWriter.print(baseName);
            this._araWriter.print(i + 1);
            if (i + 1 >= num) continue;
            this._araWriter.print(" | ");
        }
        this._araWriter.print(");\n");
        this.writeGroupMCS(idx, rg + 1);
    }

    private void addMCS(Collection<String> mcs) throws IOException {
        int idx = this.incIdx(0);
        this._araWriter.print("g");
        this._araWriter.print(this._sepGate);
        this._araWriter.print(idx);
        this._araWriter.print(" := ");
        if (mcs.size() == 0) {
            this._araWriter.print("1");
        } else {
            this._araWriter.print("(");
            Iterator<String> iter = mcs.iterator();
            while (iter.hasNext()) {
                String evt = iter.next();
                if (evt.length() > 2 && (evt.charAt(0) == '\'' || evt.charAt(0) == '`')) {
                    this._araWriter.print(evt);
                } else if (PATTERN_SIMPLE_ID.matcher(evt).matches()) {
                    this._araWriter.print(evt);
                } else {
                    this._araWriter.print("'");
                    this._araWriter.print(evt);
                    this._araWriter.print("'");
                }
                if (!iter.hasNext()) continue;
                this._araWriter.print(" & ");
            }
            this._araWriter.print(")");
        }
        this._araWriter.print(";\n");
        this.writeGroupMCS(idx, 0);
    }

    private void finishGroupMCS(int num, int rg, boolean force) throws IOException {
        if (this._idxLst.size() <= rg + 1) {
            return;
        }
        if (this._idxLst.size() == rg + 1) {
            this._idxLst.add(new Idx(0));
        }
        Idx idx = this._idxLst.get(rg + 1);
        if (force || num % this._sizeBlock != 0) {
            force = true;
            StringBuffer sb = new StringBuffer(3 + rg * 2);
            sb.append("g");
            sb.append(this._sepGate);
            for (int i = 0; i < rg; ++i) {
                sb.append(this._sizeBlock);
                sb.append(this._sepGate);
            }
            String baseName = sb.toString();
            ++idx._idx;
            this._araWriter.print(baseName);
            this._araWriter.print(this._sizeBlock);
            this._araWriter.print(this._sepGate);
            this._araWriter.print(idx._idx);
            this._araWriter.print(" := (");
            int beg = num % this._sizeBlock;
            beg = beg == 0 ? num - this._sizeBlock : num - beg;
            for (int i = beg; i < num; ++i) {
                this._araWriter.print(baseName);
                this._araWriter.print(i + 1);
                if (i + 1 >= num) continue;
                this._araWriter.print(" | ");
            }
            this._araWriter.print(");\n");
        }
        this.finishGroupMCS(idx._idx, rg + 1, force);
    }

    private void endTop() throws IOException {
        int idx = this._idxLst.get((int)0)._idx;
        if (this._idxLst.size() == 1 && idx == 0) {
            this._araWriter.print(this._top);
            this._araWriter.print(" := 0;\n");
            return;
        }
        this.finishGroupMCS(idx, 0, false);
        int rg = this._idxLst.size() - 1;
        int num = this._idxLst.get((int)rg)._idx;
        StringBuffer sb = new StringBuffer(3 + rg * 2);
        sb.append("g");
        sb.append(this._sepGate);
        for (int i = 0; i < rg; ++i) {
            sb.append(this._sizeBlock);
            sb.append(this._sepGate);
        }
        String baseName = sb.toString();
        this._araWriter.print(this._top);
        this._araWriter.print(" := (");
        for (int i = 0; i < num; ++i) {
            this._araWriter.print(baseName);
            this._araWriter.print(i + 1);
            if (i + 1 >= num) continue;
            this._araWriter.print(" | ");
        }
        this._araWriter.print(");\n");
    }

    public void action() throws IOException {
        McsReader reader = new McsReader(this);
        reader.readXxx(this._input, null);
    }

    public static void main(String[] args) {
        Writer writer = null;
        int size = 10;
        char sep = '.';
        File input = null;
        String errorMsg = null;
        if (errorMsg == null) {
            for (int idx = 0; idx < args.length && errorMsg == null; ++idx) {
                if (args[idx].equals("--input") || args[idx].equals("-i")) {
                    if (++idx == args.length) {
                        errorMsg = "Number argument of '--input'";
                        continue;
                    }
                    input = new File(args[idx]);
                    continue;
                }
                if (args[idx].equals("--output") || args[idx].equals("-o")) {
                    if (++idx == args.length) {
                        errorMsg = "Number argument of '--output'";
                        continue;
                    }
                    try {
                        writer = new FileWriter(args[idx]);
                    }
                    catch (IOException e) {
                        System.err.println(e.getMessage());
                        errorMsg = "Output exception";
                    }
                    continue;
                }
                if (args[idx].equals("--size") || args[idx].equals("-s")) {
                    if (++idx == args.length) {
                        errorMsg = "Number argument of '--size'";
                        continue;
                    }
                    int nbr = -1;
                    try {
                        nbr = Integer.parseInt(args[idx]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (nbr < 2) {
                        errorMsg = "'size' format (must be integer > 1)";
                        continue;
                    }
                    size = nbr;
                    continue;
                }
                if (args[idx].equals("--separator")) {
                    if (++idx == args.length) {
                        errorMsg = "Number argument of '--separator'";
                        continue;
                    }
                    String sepStr = args[idx];
                    if (sepStr.isEmpty() || sepStr.length() > 1) {
                        errorMsg = "'separator' format (must be only one character)";
                        continue;
                    }
                    sep = sepStr.charAt(0);
                    continue;
                }
                if (args[idx].equals("--help")) {
                    System.out.println(SYNTAX);
                    System.exit(0);
                    continue;
                }
                errorMsg = "Unkown argument: " + args[idx];
            }
        }
        if (errorMsg == null) {
            JFileChooser dlg = null;
            if (input == null) {
                if (dlg == null) {
                    dlg = new JFileChooser();
                    dlg.setCurrentDirectory(new File("."));
                }
                if (dlg.showOpenDialog(null) == 1) {
                    errorMsg = "Cancel input";
                } else {
                    input = dlg.getSelectedFile();
                }
            }
            if (errorMsg == null && input == null) {
                errorMsg = "No input";
            }
            if (writer == null) {
                if (dlg == null) {
                    dlg = new JFileChooser();
                    dlg.setCurrentDirectory(new File("."));
                }
                if (dlg.showSaveDialog(null) == 1) {
                    errorMsg = "Cancel output";
                } else if (dlg.getSelectedFile() == null) {
                    errorMsg = "No select output";
                } else {
                    try {
                        writer = new FileWriter(dlg.getSelectedFile());
                    }
                    catch (IOException e) {
                        System.err.println(e.getMessage());
                        errorMsg = "Output exception";
                    }
                }
            }
            if (errorMsg == null && writer == null) {
                errorMsg = "No output";
            }
        }
        if (errorMsg == null) {
            try {
                McsToAralia conv = new McsToAralia(input, writer, size, sep);
                conv.action();
                writer.close();
                System.exit(0);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
        } else {
            System.err.println(errorMsg);
            System.err.println();
            System.err.println(SYNTAX);
            System.exit(3);
        }
    }

    class Idx {
        int _idx;

        public Idx(int idx) {
            this._idx = idx;
        }
    }
}

