/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.cstepper.opt;

import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.mbsa.inference.StepperInference;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mbsa.cstepper.ResCStep;
import com.dassault.cecilia.plugin.mbsa.cstepper.opt.PluginCmdIAralia;
import com.dassault.cecilia.plugin.mbsa.cstepper.opt.TaskITree;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class TaskIAralia
extends TaskITree {
    String _script;
    String _exec;
    List<String> _araliaFile;

    public TaskIAralia(Plugable launcher, IModel model, StepperInference infStepper, String pathInfo) {
        super(launcher, model, infStepper, pathInfo);
        this._script = PlugableUtility.getStrOpt((Plugable)launcher, (String)PluginCmdIAralia.OPT_SCRIPT, (String)"compute BDD roots(*);\ncompute ZQC roots(*);\ndisplay orders ZQC roots(*);\ndisplay orders ZQC roots(*) > \"%res%\";\ndisplay products ZQC roots(*) >> \"%res%\";\n");
        this._exec = PlugableUtility.getStrOpt((Plugable)launcher, (String)PluginCmdIAralia.OPT_EXEC_ARALIA, (String)"aralia");
        this._araliaFile = new ArrayList<String>();
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("ptask.icon")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A2-01.svg"));
        }
        return super.getIcon(key);
    }

    @Override
    public void addCompute(TargetModel tgt) {
        super.addCompute(tgt);
        this._araliaFile.add(tgt.getFilePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void launchCompute(int cpt) throws InterruptedException {
        super.launchCompute(cpt);
        Thread.sleep(100L);
        String pathDag = this._araliaFile.get(cpt);
        String pathRes = pathDag + ".res";
        StringBuffer script = new StringBuffer(this._script.length() * 3 / 2);
        script.append("load \"");
        script.append(pathDag);
        script.append("\";\n");
        String pathReplace = pathRes.replaceAll("\\\\", "\\\\\\\\");
        script.append(this._script.replaceAll("%res%", pathReplace));
        script.append("\nexit;\n");
        try (PrintWriter writer = null;){
            writer = new PrintWriter((Writer)new FileWriter(new File(this._pathInfo), true), true);
            Process process = Runtime.getRuntime().exec(this._exec);
            new CopyStream().setIn(process.getInputStream()).setOut(writer).start();
            new CopyStream().setIn(process.getErrorStream()).setOut(writer).start();
            new CopyStream().setIn(new StringReader(script.toString())).setOut(process.getOutputStream()).start();
            Thread.sleep(100L);
            process.waitFor();
            writer.print("\n");
            writer.println(ResCStep.getString("PRV_CMD_IARALIA_END"));
            writer.println("\n");
        }
    }

    protected boolean stopCompute(String msg) {
        String display = ResCStep.msgFormat("PRV_CMD_IARALIA_STOP", msg);
        int res = JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf((Component)this._launcher.getWindow()), display, "TaskITreeAralia", 0);
        return res == 0;
    }

    public class CopyStream
    extends Thread {
        BufferedReader _inTxt;
        PrintWriter _outTxt;

        public CopyStream setIn(InputStream in) {
            this._inTxt = new BufferedReader(new InputStreamReader(in));
            return this;
        }

        public CopyStream setIn(Reader in) {
            this._inTxt = new BufferedReader(in);
            return this;
        }

        public CopyStream setOut(OutputStream out) {
            this._outTxt = new PrintWriter((Writer)new OutputStreamWriter(out), true);
            return this;
        }

        public CopyStream setOut(PrintWriter out) {
            this._outTxt = out;
            return this;
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this._inTxt.readLine()) != null) {
                    this._outTxt.println(line);
                }
                this._inTxt.close();
            }
            catch (IOException e) {
                ResCStep.LOG.severe("IOException in CopyStream:Run : \n" + e.getMessage());
            }
        }
    }
}

