/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.lib.util.TestUtility;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanExpression;
import org.junit.Assert;
import org.junit.Test;

public class BooleanExpressionTest
extends TestUtility {
    protected void assertCompute(BooleanExpression expr, double marge, double ... values) {
        int i = 0;
        while (i + 1 < values.length) {
            double tps = values[i++];
            Assert.assertEquals((String)("@<" + tps + ">"), (double)values[i++], (double)expr.getValue(tps), (double)marge);
        }
    }

    @Test
    public void testExponential() {
        BooleanExpression expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.EXP, BooleanExpression.createParameterFloat(0.001));
        this.assertCompute(expr, 1.0E-10, 0.0, 0.0, 1.0, 9.99500166624978E-4, 10.0, 0.009950166250831893, 100.0, 0.09516258196404048, 323.23, 0.2761926404709489, 1000.0, 0.6321205588285577, 10000.0, 0.9999546000702375);
    }

    @Test
    public void testConstant() {
        Assert.assertEquals((double)0.01, (double)BooleanExpression.createLaw(BooleanExpression.TypeLaw.CST, BooleanExpression.createParameterFloat(0.01)).getValue(1.0), (double)1.0E-10);
    }

    @Test
    public void testCMT() {
        Assert.assertEquals((double)0.0, (double)BooleanExpression.createLaw(BooleanExpression.TypeLaw.CMT, BooleanExpression.createParameterFloat(0.001), BooleanExpression.createParameterFloat(0.0), BooleanExpression.createParameterFloat(0.0)).getValue(1.0), (double)1.0E-10);
        Assert.assertEquals((double)0.009950166250831893, (double)BooleanExpression.createLaw(BooleanExpression.TypeLaw.CMT, BooleanExpression.createParameterFloat(0.001), BooleanExpression.createParameterFloat(10.0), BooleanExpression.createParameterFloat(0.0)).getValue(1.0), (double)1.0E-10);
        Assert.assertEquals((double)0.2761926404709489, (double)BooleanExpression.createLaw(BooleanExpression.TypeLaw.CMT, BooleanExpression.createParameterFloat(0.001), BooleanExpression.createParameterFloat(323.23), BooleanExpression.createParameterFloat(0.0)).getValue(1.0), (double)1.0E-10);
        Assert.assertEquals((double)0.9999546000702375, (double)BooleanExpression.createLaw(BooleanExpression.TypeLaw.CMT, BooleanExpression.createParameterFloat(0.001), BooleanExpression.createParameterFloat(10000.0), BooleanExpression.createParameterFloat(0.0)).getValue(1.0), (double)1.0E-10);
        Assert.assertEquals((double)0.4761926404709489, (double)BooleanExpression.createLaw(BooleanExpression.TypeLaw.CMT, BooleanExpression.createParameterFloat(0.001), BooleanExpression.createParameterFloat(323.23), BooleanExpression.createParameterFloat(0.2)).getValue(1.0), (double)1.0E-10);
    }

    @Test
    public void testDormant() {
        Assert.assertEquals((double)0.0, (double)BooleanExpression.createLaw(BooleanExpression.TypeLaw.DRM, BooleanExpression.createParameterFloat(0.001), BooleanExpression.createParameterFloat(0.0), BooleanExpression.createParameterFloat(1.0E-7)).getValue(1.0), (double)1.0E-10);
        Assert.assertEquals((double)0.004983374916810689, (double)BooleanExpression.createLaw(BooleanExpression.TypeLaw.DRM, BooleanExpression.createParameterFloat(0.001), BooleanExpression.createParameterFloat(0.0), BooleanExpression.createParameterFloat(10.0)).getValue(1.0), (double)1.0E-10);
        Assert.assertEquals((double)0.1455228769886801, (double)BooleanExpression.createLaw(BooleanExpression.TypeLaw.DRM, BooleanExpression.createParameterFloat(0.001), BooleanExpression.createParameterFloat(0.0), BooleanExpression.createParameterFloat(323.23)).getValue(1.0), (double)1.0E-10);
        Assert.assertEquals((double)0.9000045399929762, (double)BooleanExpression.createLaw(BooleanExpression.TypeLaw.DRM, BooleanExpression.createParameterFloat(0.001), BooleanExpression.createParameterFloat(0.0), BooleanExpression.createParameterFloat(10000.0)).getValue(1.0), (double)1.0E-10);
        Assert.assertEquals((double)0.2127883146026059, (double)BooleanExpression.createLaw(BooleanExpression.TypeLaw.DRM, BooleanExpression.createParameterFloat(0.001), BooleanExpression.createParameterFloat(100.0), BooleanExpression.createParameterFloat(323.23)).getValue(1.0), (double)1.0E-10);
    }

    @Test
    public void testNRD() {
        Assert.assertEquals((double)1.0, (double)BooleanExpression.createLaw(BooleanExpression.TypeLaw.NRD, BooleanExpression.createParameterFloat(0.01), BooleanExpression.createParameterFloat(0.0)).getValue(1.0), (double)1.0E-10);
        Assert.assertEquals((double)0.9048374180359595, (double)BooleanExpression.createLaw(BooleanExpression.TypeLaw.NRD, BooleanExpression.createParameterFloat(0.01), BooleanExpression.createParameterFloat(10.0)).getValue(1.0), (double)1.0E-10);
        Assert.assertEquals((double)0.3678794411714423, (double)BooleanExpression.createLaw(BooleanExpression.TypeLaw.NRD, BooleanExpression.createParameterFloat(0.01), BooleanExpression.createParameterFloat(100.0)).getValue(1.0), (double)1.0E-10);
    }

    @Test
    public void testGLMAsymptotic() {
        Assert.assertEquals((double)1.0, (double)BooleanExpression.createLaw(BooleanExpression.TypeLaw.GLMa, BooleanExpression.createParameterFloat(0.01), BooleanExpression.createParameterFloat(0.0)).getValue(1.0), (double)0.0);
        Assert.assertEquals((double)0.5, (double)BooleanExpression.createLaw(BooleanExpression.TypeLaw.GLMa, BooleanExpression.createParameterFloat(0.01), BooleanExpression.createParameterFloat(0.01)).getValue(1.0), (double)0.0);
        Assert.assertEquals((double)0.09090909090909091, (double)BooleanExpression.createLaw(BooleanExpression.TypeLaw.GLMa, BooleanExpression.createParameterFloat(0.01), BooleanExpression.createParameterFloat(0.1)).getValue(1.0), (double)0.0);
    }

    @Test
    public void testGLM() {
        BooleanExpression expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.GLM, BooleanExpression.createParameterFloat(0.1), BooleanExpression.createParameterFloat(0.001), BooleanExpression.createParameterFloat(0.01));
        this.assertCompute(expr, 1.0E-10, 0.0, 0.1, 1.0, 0.099900547988867, 10.0, 0.09905303759360481, 100.0, 0.09393519166998254, 323.23, 0.09116878391637383, 1000.0, 0.09090924274273446, 10000.0, 0.09090909090909091);
        expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.GLM, BooleanExpression.createParameterFloat(0.0), BooleanExpression.createParameterFloat(0.001), BooleanExpression.createParameterFloat(0.0));
        this.assertCompute(expr, 1.0E-10, 0.0, 0.0, 1.0, 9.99500166624978E-4, 10.0, 0.009950166250831893, 100.0, 0.09516258196404048, 323.23, 0.2761926404709489, 1000.0, 0.6321205588285577, 10000.0, 0.9999546000702375);
        expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.GLM, BooleanExpression.createParameterFloat(0.5), BooleanExpression.createParameterFloat(0.001), BooleanExpression.createParameterFloat(0.001));
        this.assertCompute(expr, 1.0E-10, 0.0, 0.5, 1.0, 0.5, 10.0, 0.5, 100.0, 0.5, 323.23, 0.5, 1000.0, 0.5, 10000.0, 0.5);
    }

    @Test
    public void testBoundTime() {
        BooleanExpression expr = BooleanExpression.createLawBound(BooleanExpression.createLaw(BooleanExpression.TypeLaw.EXP, BooleanExpression.createParameterFloat(0.001)), BooleanExpression.createParameterFloat(100.0), BooleanExpression.createParameterFloat(1000.0));
        this.assertCompute(expr, 1.0E-10, 0.0, 0.0, 50.0, 0.0, 100.0, 0.0, 101.0, 9.99500166624978E-4, 110.0, 0.009950166250831893, 200.0, 0.09516258196404048, 423.23, 0.2761926404709489, 1100.0, 0.6321205588285577, 1101.0, 0.6321205588285577, 10000.0, 0.6321205588285577);
    }

    @Test
    public void testWeibullWikipedia() {
        BooleanExpression expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.WEB, BooleanExpression.createParameterFloat(1.0), BooleanExpression.createParameterFloat(0.5), BooleanExpression.createParameterFloat(0.0));
        this.assertCompute(expr, 1.0E-10, 0.0, 0.0, 0.25, 0.3934693402873666, 0.5, 0.5069313086047602, 0.75, 0.5793799739458851, 1.0, 0.6321205588285577, 1.25, 0.6730781046482421, 1.5, 0.706167344121927, 1.75, 0.7336317836774711, 2.0, 0.7568832655657858, 2.25, 0.7768698398515702, 2.5, 0.7942593389161856);
        expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.WEB, BooleanExpression.createParameterFloat(1.0), BooleanExpression.createParameterFloat(1.0), BooleanExpression.createParameterFloat(0.0));
        this.assertCompute(expr, 1.0E-10, 0.0, 0.0, 0.25, 0.22119921692859512, 0.5, 0.3934693402873666, 0.75, 0.5276334472589853, 1.0, 0.6321205588285577, 1.25, 0.7134952031398099, 1.5, 0.7768698398515702, 1.75, 0.8262260565495549, 2.0, 0.8646647167633873, 2.25, 0.8946007754381357, 2.5, 0.9179150013761012);
        expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.WEB, BooleanExpression.createParameterFloat(1.0), BooleanExpression.createParameterFloat(1.5), BooleanExpression.createParameterFloat(0.0));
        this.assertCompute(expr, 1.0E-10, 0.0, 0.0, 0.25, 0.11750309741540454, 0.5, 0.29781149867344037, 0.75, 0.4777030864174585, 1.0, 0.6321205588285577, 1.25, 0.7527962752955224, 1.5, 0.8407240915099786, 1.75, 0.9012370156920284, 2.0, 0.9408942534380438, 2.25, 0.965781881688334, 2.5, 0.9808000398449904);
        expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.WEB, BooleanExpression.createParameterFloat(1.0), BooleanExpression.createParameterFloat(5.0), BooleanExpression.createParameterFloat(0.0));
        this.assertCompute(expr, 1.0E-10, 0.0, 0.0, 0.25, 9.760858180243304E-4, 0.5, 0.03076676552365587, 0.75, 0.21124907114638236, 1.0, 0.6321205588285577, 1.25, 0.9527242505937095, 1.5, 0.9994964109502631, 1.75, 0.999999925546118, 2.0, 0.9999999999999873, 2.25, 1.0, 2.5, 1.0);
    }

    @Test
    public void testTPS() {
        double[] result = new double[]{0.0, 0.0, Double.MIN_VALUE, 0.0, 1000.0, 0.009950166250831893, 2000.0, 0.019801326693244747, 3000.0, 0.029554466451491845, 4000.0, 0.03921056084767682, 5000.0, 0.048770575499285984, 6000.0, 0.05823546641575128, 7000.0, 0.06760618009405173, 8000.0, 0.07688365361336424, 9000.0, 0.08606881472877181, 10000.0, 0.09516258196404048, 11000.0, 0.10416586470347178, 12000.0, 0.11307956328284252, 13000.0, 0.1219045690794387, 14000.0, 0.13064176460119414, 15000.0, 0.1392920235749422, 16000.0, 0.14785621103378865, 17000.0, 0.1563351834036163, 18000.0, 0.164729788588728, 19000.0, 0.1730408660566377, 20000.0, 0.18126924692201818, 21000.0, 0.18941575402981292, 22000.0, 0.1974812020375215, 23000.0, 0.20546639749666595, 24000.0, 0.21337213893344664, 25000.0, 0.22119921692859512, 26000.0, 0.22894841419643375, 27000.0, 0.23662050566314685, 28000.0, 0.24421625854427453, 29000.0, 0.25173643242143484, 30000.0, 0.25918177931828223, 31000.0, 0.26655304377571076, 32000.0, 0.27385096292630906, 33000.0, 0.28107626656807383, 34000.0, 0.28822967723739024, 35000.0, 0.29531191028128656, 36000.0, 0.302323673928969, 37000.0, 0.30926566936264543, 38000.0, 0.31613859078764417, 39000.0, 0.32294312550183535, 40000.0, 0.3296799539643607, 41000.0, 0.3363497498636807, 42000.0, 0.34295318018494325, 43000.0, 0.3494909052766835, 44000.0, 0.3559635789168587, 45000.0, 0.3623718483782268, 46000.0, 0.36871635449307405, 47000.0, 0.3749977317172992, 48000.0, 0.38121660819385916, 49000.0, 0.387373605815584, 50000.0, 0.3934693402873666, 51000.0, 0.3995044211877341, 52000.0, 0.40547945202980573, 53000.0, 0.4113950303216448, 54000.0, 0.41725174762601036, 54320.99999999999, 0.41911937037793334, 54321.0, 0.0, 54321.00000000001, 1.110223E-16f, 55000.0, 0.006767000036027149, 56000.0, 0.016649833511481194, 57000.0, 0.026434331150825274, 58000.0, 0.03612147141197697, 59000.0, 0.045712223017035036, 60000.0, 0.05520754504915237, 61000.0, 0.06460838704844496, 62000.0, 0.07391568910694679, 63000.0, 0.08313038196261979, 64000.0, 0.09225338709242858, 65000.0, 0.10128561680448844, 66000.0, 0.11022797432929765, 67000.0, 0.1190813539100607, 68000.0, 0.1278466408921134, 69000.0, 0.13652471181145842, 70000.0, 0.1451164344824194, 71000.0, 0.15362266808442326, 72000.0, 0.16204426324791887, 73000.0, 0.17038206213944052, 74000.0, 0.17863689854582543, 75000.0, 0.18680959795759344, 76000.0, 0.19490097765149617, 77000.0, 0.20291184677224605, 78000.0, 0.2108430064134308, 79000.0, 0.21869524969762388, 80000.0, 0.22646936185569733, 81000.0, 0.23416612030534523, 82000.0, 0.24178629472882673, 83000.0, 0.24933064714993414, 84000.0, 0.2567999320101968, 85000.0, 0.2641948962443249, 86000.0, 0.2715162793549045, 87000.0, 0.27876481348634785, 88000.0, 0.28594122349810847, 89000.0, 0.2930462270371679, 90000.0, 0.300080534609801, 91000.0, 0.3070448496526269, 92000.0, 0.31393986860295353, 93000.0, 0.32076628096842175, 94000.0, 0.32752476939595687, 95000.0, 0.3342160097400336, 96000.0, 0.3408406711302625, 97000.0, 0.34739941603830327, 98000.0, 0.35389290034411214, 99000.0, 0.36032177340153104, 100000.0, 0.3666866781032232, 101000.0, 0.3729882509449628, 102000.0, 0.37922712208928533, 103000.0, 0.3854039154285043, 104000.0, 0.3915192486471011, 105000.0, 0.39757373328349355, 106000.0, 0.4035679747911909, 107000.0, 0.40950257259933887, 108000.0, 0.41537812017266396, 108641.99999999999, 0.41911937037793323, 108642.0, 0.0, 108642.00000000001, 1.110223E-16f, 109000.0, 0.0035735994402793514, 110000.0, 0.013488207782566652, 111000.0, 0.02330416412353631, 112000.0, 0.03302245006700244, 113000.0, 0.042644037449657834, 114000.0, 0.05216988843825909, 115000.0, 0.061600955625843, 116000.0, 0.07093818212698766, 117000.0, 0.08018250167212426, 118000.0, 0.08933483870091097, 119000.0, 0.09839610845467761, 120000.0, 0.1073672170679506, 121000.0, 0.11624906165906723, 122000.0, 0.12504253041988833, 123000.0, 0.1337485027046177, 124000.0, 0.1423678491177388, 125000.0, 0.15090143160107594, 126000.0, 0.15935010351998857, 127000.0, 0.1677147097487094, 128000.0, 0.17599608675483158, 129000.0, 0.18419506268295716, 130000.0, 0.19231245743751124, 131000.0, 0.20034908276473395, 132000.0, 0.20830574233385513, 133000.0, 0.21618323181746224, 134000.0, 0.22398233897106823, 135000.0, 0.2317038437118879, 136000.0, 0.23934851819682978, 137000.0, 0.246917126899713, 138000.0, 0.25441042668771496, 139000.0, 0.26182916689705915, 140000.0, 0.2691740894079485, 141000.0, 0.27644592871875506, 142000.0, 0.2836454120194698, 143000.0, 0.2907732592644223, 144000.0, 0.2978301832442769, 145000.0, 0.3048168896573126, 146000.0, 0.3117340771799928, 147000.0, 0.31858243753683413, 148000.0, 0.32536265556957933, 149000.0, 0.3320754093056817, 150000.0, 0.33872137002610914, 151000.0, 0.34530120233247164, 152000.0, 0.35181556421348337, 153000.0, 0.358265107110761, 154000.0, 0.3646504759839687, 155000.0, 0.3709723093753151, 156000.0, 0.37723123947340764, 157000.0, 0.3834278921764718, 158000.0, 0.3895628871549417, 159000.0, 0.39563683791342796, 160000.0, 0.4016503518520679, 161000.0, 0.40760403032726655, 162000.0, 0.41349846871183304, 162962.99999999997, 0.41911937037793323, 162963.0, 0.0, 162963.00000000003, 3.330669E-16f, 163000.0, 3.6993155844133874E-4, 164000.0, 0.010316416928765393, 165000.0, 0.020163933116043253, 166000.0, 0.029913464880099938, 167000.0, 0.03956598718223647, 168000.0, 0.0491224652827269, 169000.0, 0.05858385483734496, 170000.0, 0.06795110199293064};
        BooleanExpression expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.PT3, BooleanExpression.createParameterFloat(1.0E-5), BooleanExpression.createParameterFloat(54321.0), BooleanExpression.createParameterFloat(0.0));
        this.assertCompute(expr, 1.0E-10, result);
        expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.PT3, BooleanExpression.createParameterFloat(1.0E-5), BooleanExpression.createParameterFloat(54321.0), BooleanExpression.createParameterFloat(54321.0));
        this.assertCompute(expr, 1.0E-10, result);
    }

    @Test
    public void testTPEa() {
        double[] result = new double[]{0.0, 0.0, Double.MIN_VALUE, 0.0, 1.0, 0.009950166250831893, 2.0, 0.019801326693244747, 3.0, 0.029554466451491845, 4.0, 0.03921056084767682, 5.0, 0.048770575499285984, 6.0, 0.05823546641575128, 7.0, 0.06760618009405173, 8.0, 0.07688365361336424, 9.0, 0.08606881472877181, 10.0, 0.09516258196404048, 11.0, 0.10416586470347178, 12.0, 0.11307956328284252, 13.0, 0.1219045690794387, 14.0, 0.13064176460119414, 15.0, 0.1392920235749422, 16.0, 0.14785621103378865, 17.0, 0.1563351834036163, 18.0, 0.164729788588728, 19.0, 0.1730408660566377, 20.0, 0.18126924692201818, 21.0, 0.18941575402981292, 22.0, 0.1974812020375215, 23.0, 0.20546639749666595, 24.0, 0.21337213893344664, 25.0, 0.22119921692859512, 26.0, 0.22894841419643375, 27.0, 0.23662050566314685, 28.0, 0.24421625854427453, 29.0, 0.25173643242143484, 30.0, 0.2591817793182821, 31.0, 0.26655304377571076, 32.0, 0.27385096292630906, 33.0, 0.28107626656807383, 34.0, 0.28822967723739024, 35.0, 0.29531191028128656, 36.0, 0.302323673928969, 37.0, 0.3092656693626453, 38.0, 0.31613859078764417, 39.0, 0.32294312550183535, 40.0, 0.3296799539643607, 41.0, 0.3363497498636807, 42.0, 0.34295318018494325, 43.0, 0.3494909052766835, 44.0, 0.3559635789168587, 45.0, 0.3623718483782268, 46.0, 0.36871635449307405, 47.0, 0.3749977317172992, 48.0, 0.38121660819385916, 49.0, 0.3873736058155839, 50.0, 0.3934693402873666, 51.0, 0.3995044211877341, 52.0, 0.40547945202980573, 53.0, 0.4113950303216448, 54.0, 0.41725174762601036, 55.0, 0.42305018961951335, 56.0, 0.42879093615118513, 57.0, 0.4344745613004629, 58.0, 0.44010163343459796, 59.0, 0.4456727152654929, 60.0, 0.4511883639059735, 61.0, 0.4566491309255002, 62.0, 0.4620555624053255, 63.0, 0.4674081989931028, 64.0, 0.47270757595695145, 65.0, 0.47795422323898396, 66.0, 0.4831486655083008, 67.0, 0.48829142221345756, 68.0, 0.49338300763441045, 69.0, 0.49842393093394455, 70.0, 0.5034146962085906, 71.0, 0.5083558025390349, 72.0, 0.5132477440400283, 73.0, 0.5180910099097975, 74.0, 0.5228860844789656, 75.0, 0.5276334472589853, 76.0, 0.5323335729900908, 77.0, 0.5369869316887719, 78.0, 0.5415939886947765, 79.0, 0.5461552047176441, 80.0, 0.5506710358827784, 81.0, 0.5551419337770589, 82.0, 0.5595683454940008, 83.0, 0.5639507136784645, 84.0, 0.5682894765709203, 85.0, 0.5725850680512733, 86.0, 0.5768379176822511, 87.0, 0.581048450752361, 88.0, 0.5852170883184187, 89.0, 0.5893442472476546, 90.0, 0.5934303402594009, 91.0, 0.597475775966364, 92.0, 0.6014809589154858, 93.0, 0.6054462896283989, 94.0, 0.6093721646414789, 95.0, 0.6132589765454988, 96.0, 0.6171071140248879, 97.0, 0.6209169618966012, 98.0, 0.6246889011486004, 99.0, 0.6284233089779543, 99.99999999999999, 0.6321205588285577, 100.0, 0.6321205588285577, 100.00000000000001, 0.6321205588285568, 101.0, 0.5759315539398491, 102.0, 0.5259970687514803, 103.0, 0.4817128779512353, 104.0, 0.4425323457084308, 105.0, 0.4079609444162279, 106.0, 0.3775512950534756, 107.0, 0.35089867952733034, 108.0, 0.3276369800816592, 109.0, 0.30743500513045474, 110.0, 0.28999316474297565, 111.0, 0.27504046250676484, 112.0, 0.2623317736611275, 113.0, 0.25164538225874766, 114.0, 0.2427807527055762, 115.0, 0.23555651337486516, 116.0, 0.22980863211374525, 117.0, 0.2253887653812774, 118.0, 0.22216276449467753, 119.0, 0.2200093240328178, 120.0, 0.21881875886887459, 121.0, 0.218491897591362, 122.0, 0.21893908123765637, 123.0, 0.2200792573181285, 124.0, 0.2218391600627091, 125.0, 0.2241525686846606, 126.0, 0.22695963623716908, 127.0, 0.2302062823448836, 128.0, 0.2338436437318292, 129.0, 0.23782757704557, 130.0, 0.24211820900090353, 131.0, 0.2466795293399735, 132.0, 0.25147902253420296, 133.0, 0.2564873345412171, 134.0, 0.2616779712807561, 135.0, 0.26702702581105775, 136.0, 0.2725129314744261, 137.0, 0.27811623854063217, 138.0, 0.2838194121119616, 139.0, 0.2896066492665358, 140.0, 0.29546371360907786, 141.0, 0.30137778557252226, 142.0, 0.3073373269715154, 143.0, 0.31333195845149964, 144.0, 0.3193523486061408, 145.0, 0.3253901136526498, 146.0, 0.33143772666022286, 147.0, 0.3374884354224401, 148.0, 0.34353618815098297, 149.0, 0.34957556624631536, 150.0, 0.3556017234718096, 151.0, 0.3616103309218909, 152.0, 0.3675975272327692, 153.0, 0.37355987353680764, 154.0, 0.3794943127090521, 155.0, 0.3853981324974157, 156.0, 0.3912689321668852, 157.0, 0.3971045923232921, 158.0, 0.4029032476140193, 159.0, 0.4086632620318158, 160.0, 0.41438320657394556, 161.0, 0.42006183903248284, 162.0, 0.4256980857128956, 163.0, 0.43129102489736537, 164.0, 0.4368398718867612, 165.0, 0.442343965470988, 166.0, 0.44780275569173356, 167.0, 0.4532157927745766, 168.0, 0.45858271711912957, 169.0, 0.46390325024648105, 170.0, 0.4691771866127956, 171.0, 0.47440438620659353, 172.0, 0.4795847678550913, 173.0, 0.4847183031720792, 174.0, 0.4898050110862402, 175.0, 0.49484495289463004, 176.0, 0.4998382277912987, 177.0, 0.5047849688257912, 178.0, 0.5096853392505782, 179.0, 0.5145395292203615, 180.0, 0.5193477528097256, 181.0, 0.5241102453187979, 182.0, 0.5288272608394711, 183.0, 0.5334990700573462, 184.0, 0.5381259582669274, 185.0, 0.5427082235797323, 186.0, 0.5472461753069197, 187.0, 0.5517401324997873, 188.0, 0.5561904226330783, 189.0, 0.5605973804174639, 190.0, 0.5649613467288763, 191.0, 0.5692826676435279, 192.0, 0.5735616935685265, 193.0, 0.5777987784589486, 194.0, 0.5819942791131083, 195.0, 0.5861485545385424, 196.0, 0.5902619653819465, 197.0, 0.5943348734169404, 198.0, 0.598367641084123, 199.0, 0.6023606310784079, 199.99999999999997, 0.6063142059791012, 200.0, 0.6063142059791014, 200.00000000000003, 0.6063142059790998, 201.0, 0.5528253359994054, 202.0, 0.5053316027292146, 203.0, 0.4632534886020958, 204.0, 0.4260667140395642, 205.0, 0.3932969799699916, 206.0, 0.3645152106718623, 207.0, 0.3393332493291291, 208.0, 0.3173999632173322, 209.0, 0.29839771953887007, 210.0, 0.2820391966354109, 211.0, 0.2680644986619998, 212.0, 0.2562385448445845, 213.0, 0.24634870719080593, 214.0, 0.23820267301051667, 215.0, 0.23162651085247687, 216.0, 0.22646292049953054, 217.0, 0.22256964950670954, 218.0, 0.21981806043352514, 219.0, 0.21809183442992564, 220.0, 0.21728579820007243, 221.0, 0.2173048626029077, 222.0, 0.2180630622657913, 223.0, 0.21948268659846837, 224.0, 0.22149349350940084, 225.0, 0.22403199795421824, 226.0, 0.22704082819499938, 227.0, 0.23046814332677146, 228.0, 0.2342671062408126, 229.0, 0.23839540674917403, 230.0, 0.2428148300968822, 231.0, 0.24749086654254415, 232.0, 0.25239235809910787, 233.0, 0.2574911788984585, 234.0, 0.2627619459800472, 235.0, 0.26818175760826035, 236.0, 0.27372995649875365, 237.0, 0.27938791558328724, 238.0, 0.28513884416817403, 239.0, 0.2909676125455659, 240.0, 0.2968605933015003, 241.0, 0.3028055177317306, 242.0, 0.3087913459275884, 243.0, 0.3148081492309369, 244.0, 0.3208470038810807, 245.0, 0.3268998947885171, 246.0, 0.3329596284717713, 247.0, 0.3390197542852751, 248.0, 0.34507449314923244, 249.0, 0.35111867306750455, 250.0, 0.35714767078749465, 251.0, 0.3631573590174836, 252.0, 0.36914405867250055, 253.0, 0.3751044956701448, 254.0, 0.3810357618433171, 255.0, 0.38693527957803187, 256.0, 0.3928007698217655, 257.0, 0.39863022314154173, 258.0, 0.40442187354147696, 259.0, 0.410174174777137, 260.0, 0.41588577892905165, 261.0, 0.4215555170203449, 262.0, 0.4271823814839104, 263.0, 0.4327655103030721, 264.0, 0.43830417266642663, 265.0, 0.4437977559927264, 266.0, 0.44924575419537627, 267.0, 0.45464775706853033, 268.0, 0.4600034406880089, 269.0, 0.4653125587304118, 270.0, 0.47057493462300604, 271.0, 0.47579045444528123, 272.0, 0.48095906051059556, 273.0, 0.4860807455631493, 274.0, 0.49115554753168256, 275.0, 0.49618354478687454, 276.0, 0.5011648518544664, 277.0, 0.506099615540695, 278.0, 0.5109880114307594, 279.0, 0.5158302407247758, 280.0, 0.520626527379065, 281.0, 0.525377115523672, 282.0, 0.53008226712979, 283.0, 0.5347422599032654, 284.0, 0.539357385382629, 285.0, 0.5439279472221491, 286.0, 0.548454259642261, 287.0, 0.5529366460314018, 288.0, 0.557375437684807, 289.0, 0.561770972667194, 290.0, 0.5661235947875047, 291.0, 0.5704336526750073, 292.0, 0.5747014989470708, 293.0, 0.5789274894598537, 294.0, 0.5831119826339786, 295.0, 0.5872553388480193, 296.0, 0.5913579198933132, 297.0, 0.5954200884842257, 298.0, 0.5994422078185526, 299.0, 0.6034246411832586, 299.99999999999994, 0.607367751601197, 300.0, 0.6073677516011973, 300.00000000000006, 0.6073677516011939, 301.0, 0.553768648481272, 302.0, 0.5061752713941878, 303.0, 0.46400709407857665, 304.0, 0.42673892426086024, 305.0, 0.3938956370384672, 306.0, 0.3650474094567755, 307.0, 0.3398054085847997, 308.0, 0.3178178899334261, 309.0, 0.29876666716685096, 310.0, 0.2823639177739188, 311.0, 0.26834929272846175, 312.0, 0.2564873012101797, 313.0, 0.2465649442105058, 314.0, 0.23838957333883792, 315.0, 0.23178695339840494, 316.0, 0.2265995093404456, 317.0, 0.22268474005069905, 318.0, 0.21991378309193976, 319.0, 0.2181701160371068, 320.0, 0.2173483813946402, 321.0, 0.21735332336459123, 322.0, 0.21809882578332773, 323.0, 0.21950704162738832, 324.0, 0.22150760536341085, 325.0, 0.22403692026020816, 326.0, 0.22703751352933454, 327.0, 0.23045745283932917, 328.0, 0.23424981836309255, 329.0, 0.23837222507364553, 330.0, 0.2427863905064367, 331.0, 0.24745774366141493, 332.0, 0.25235507112982847, 333.0, 0.2574501969032883, 334.0, 0.26271769265972855, 335.0, 0.26813461562594554, 336.0, 0.27368027139238305, 337.0, 0.2793359993055853, 338.0, 0.2850849782896988, 339.0, 0.2909120511528802, 340.0, 0.2968035656194743, 341.0, 0.3027472304962333, 342.0, 0.3087319855323185, 343.0, 0.3147478836698896, 344.0, 0.3207859845060981, 345.0, 0.32683825789951937, 346.0, 0.33289749675559377, 347.0, 0.33895723811751655, 348.0, 0.3450116917721525, 349.0, 0.35105567565576745, 350.0, 0.3570845574124303, 351.0, 0.3630942015195264, 352.0, 0.3690809214505433, 353.0, 0.37504143639571474, 354.0, 0.38097283210673005, 355.0, 0.3868725254729962, 356.0, 0.3927382324742963, 357.0, 0.39856793918848266, 358.0, 0.40435987556342834, 359.0, 0.410112491690128, 360.0, 0.41582443633888255, 361.0, 0.42149453754315513, 362.0, 0.42712178503618414, 363.0, 0.4327053143639912, 364.0, 0.43824439251520386, 365.0, 0.4437384049232995, 366.0, 0.449186843710618, 367.0, 0.4545892970559242, 368.0, 0.45994543957855594, 369.0, 0.46525502364236226, 370.0, 0.47051787149186386, 371.0, 0.47573386814138485, 372.0, 0.48090295494546087, 373.0, 0.4860251237856419, 374.0, 0.49110041181499, 375.0, 0.49612889670715266, 376.0, 0.5011106923619542, 377.0, 0.5060459450240138, 378.0, 0.5109348297750461, 379.0, 0.5157775473642379, 380.0, 0.5205743213444876, 381.0, 0.5253253954853583, 382.0, 0.5300310314363705, 383.0, 0.5346915066167688, 384.0, 0.5393071123101709, 385.0, 0.5438781519445625, 386.0, 0.5484049395399573, 387.0, 0.5528877983077283, 388.0, 0.5573270593871394, 389.0, 0.5617230607059787, 390.0, 0.5660761459534482, 391.0, 0.5703866636545871, 392.0, 0.5746549663365306, 393.0, 0.5788814097778253, 394.0, 0.583066352332863, 395.0, 0.587210154324245, 396.0, 0.5913131774965785, 397.0, 0.5953757845258228, 398.0, 0.5993983385788614, 399.0, 0.6033812029184882, 399.99999999999994, 0.6073247405494488, 400.0, 0.6073247405494492, 400.00000000000006, 0.607324740549446, 401.0, 0.553730137702886, 402.0, 0.5061408285795186, 403.0, 0.4639763280979995, 404.0, 0.42671148124557234, 405.0, 0.3938711968342544, 406.0, 0.365025682415252, 407.0, 0.33978613266000535, 408.0, 0.31780082805472265, 409.0, 0.2987516048618244, 410.0, 0.2823506610174964, 411.0, 0.26833766599671605, 412.0, 0.2564771457193411, 413.0, 0.24655611632356, 414.0, 0.23838194312375793, 415.0, 0.2317804033235903, 416.0, 0.2265939330943092, 417.0, 0.2226800414735901, 418.0, 0.2199098752097104, 419.0, 0.21816692018665018, 420.0, 0.21734582643264932, 421.0, 0.21735134495161623, 422.0, 0.21809736573596838, 423.0, 0.21950604733213697, 424.0, 0.2215070292462782, 425.0, 0.22403671930682445, 426.0, 0.22703764885072308, 427.0, 0.2304578892790039, 428.0, 0.23425052414154923, 429.0, 0.23837317146668724, 430.0, 0.24278755155411302, 431.0, 0.2474590959046632, 432.0, 0.2523565933721801, 433.0, 0.25745186999525327, 434.0, 0.2627194993037034, 435.0, 0.26813654019968813, 436.0, 0.27368229978929004, 437.0, 0.27933811879017134, 438.0, 0.2850871773668322, 439.0, 0.29091431944946444, 440.0, 0.29680589377739297, 441.0, 0.3027496100754843, 442.0, 0.3087344089233699, 443.0, 0.3147503440143783, 444.0, 0.3207884756250776, 445.0, 0.32684077422853897, 446.0, 0.3329000332859573, 447.0, 0.3389597903431347, 448.0, 0.34501425564145527, 449.0, 0.3510582475281946, 450.0, 0.357087134019066, 451.0, 0.36309677992748135, 452.0, 0.36908349903072957, 453.0, 0.37504401079368943, 454.0, 0.380975401216316, 455.0, 0.3868750874124154, 456.0, 0.39274078556457703, 457.0, 0.3985704819339243, 458.0, 0.4043624066339262, 459.0, 0.41011500990518357, 460.0, 0.41582694065313797, 461.0, 0.4214970270333054, 462.0, 0.42712425888913774, 463.0, 0.4327077718661596, 464.0, 0.43824683304281253, 465.0, 0.4437408279336229, 466.0, 0.44918924873405064, 467.0, 0.4545916836888091, 468.0, 0.45994780747669706, 469.0, 0.46525737251515675, 470.0, 0.47052020109699444, 471.0, 0.4757361782800197, 472.0, 0.48090524545791213, 473.0, 0.4860273945474396, 474.0, 0.4911026627333309, 475.0, 0.4961311277176904, 476.0, 0.5011129034258951, 477.0, 0.5060481361254924, 478.0, 0.5109370009187516, 479.0, 0.515779698573269, 480.0, 0.5205764526584123, 481.0, 0.5253275069584618, 482.0, 0.53003312313607, 483.0, 0.5346935786221818, 484.0, 0.5393091647108222, 485.0, 0.5438801848392147, 486.0, 0.5484069530355553, 487.0, 0.5528897925184455, 488.0, 0.557329034433517, 489.0, 0.5617250167141477, 490.0, 0.5660780830544282, 491.0, 0.5703885819836527, 492.0, 0.5746568660326405, 493.0, 0.5788832909831065, 494.0, 0.5830682151921465, 495.0, 0.5872119989846465, 496.0, 0.5913150041071219, 497.0, 0.5953775932370999, 498.0, 0.5994001295427257, 499.0, 0.6033829762877801, 499.99999999999994, 0.6073264964777483, 500.0, 0.6073264964777485, 500.00000000000006, 0.6073264964777453, 501.0, 0.5537317099073045, 502.0, 0.5061422347091186, 503.0, 0.46397758412066703, 504.0, 0.4267126016080188, 505.0, 0.39387219460679135, 506.0, 0.365026569422789, 507.0, 0.3397869196005814, 508.0, 0.31780152460675837, 509.0, 0.2987522197811666, 510.0, 0.28235120222522825, 511.0, 0.2683381406586103, 512.0, 0.25647756031775315, 513.0, 0.24655647672247805, 514.0, 0.23838225462766316, 515.0, 0.23178067073071618, 516.0, 0.2265941607448314, 517.0, 0.22268023329323128, 518.0, 0.21991003474919424, 519.0, 0.21816705065740194, 520.0, 0.21734593073909803, 521.0, 0.2173514257204231, 522.0, 0.21809742534247367, 523.0, 0.21950608792428938, 524.0, 0.22150705276628835, 525.0, 0.2240367275107562, 526.0, 0.22703764332622078, 527.0, 0.23045787146133279, 528.0, 0.23425049532810904, 529.0, 0.23837313283014483, 530.0, 0.24278750415428463, 531.0, 0.24745904069926627, 532.0, 0.2523565312265613, 533.0, 0.25745180169119153, 534.0, 0.2627194255473744, 535.0, 0.2681364616288706, 536.0, 0.2736822169798867, 537.0, 0.27933803226210907, 538.0, 0.28508708758940027, 539.0, 0.2909142268461451, 540.0, 0.2968057987302315, 541.0, 0.3027495129290445, 542.0, 0.3087343099883113, 543.0, 0.3147502435706937, 544.0, 0.320788373925023, 545.0, 0.3268406714992832, 546.0, 0.33289992973198057, 547.0, 0.33895968614839855, 548.0, 0.3450141509713651, 549.0, 0.35105814253137646, 550.0, 0.3570870288289736, 551.0, 0.36309667466385, 552.0, 0.36908339380089195, 553.0, 0.3750439056937658, 554.0, 0.380975296332291, 555.0, 0.38687498282111277, 556.0, 0.392740681334541, 557.0, 0.39857037812621676, 558.0, 0.40436230330284884, 559.0, 0.4101149070989303, 560.0, 0.4158268384143855, 561.0, 0.4214969253997478, 562.0, 0.4271241578939694, 563.0, 0.432707671538513, 564.0, 0.4382467334081531, 565.0, 0.44374072901410744, 566.0, 0.4491891505488509, 567.0, 0.45459158625440443, 568.0, 0.45994771080713925, 569.0, 0.46525727662230965, 570.0, 0.47052010599075045, 571.0, 0.4757360839684964, 572.0, 0.48090515194762884, 573.0, 0.48602730184347775, 574.0, 0.49110257083947917, 575.0, 0.49613103663657565, 576.0, 0.5011128131591012, 577.0, 0.506048046673667, 578.0, 0.5109369122817033, 579.0, 0.5157796107500546, 580.0, 0.5205763656474167, 581.0, 0.5253274207574687, 582.0, 0.530033037742327, 583.0, 0.5346934940324591, 584.0, 0.5393090809214649, 585.0, 0.5438801018461907, 586.0, 0.5484068708344987, 587.0, 0.5528897111046951, 588.0, 0.5573289538021516, 589.0, 0.5617249368600182, 590.0, 0.5660780039721856, 591.0, 0.5703885036677745, 592.0, 0.5746567884774536, 593.0, 0.5788832141828086, 594.0, 0.5830681391408247, 595.0, 0.587211923676295, 596.0, 0.5913149295356569, 597.0, 0.5953775193963732, 598.0, 0.599400056426538, 599.0, 0.6033829038898917, 599.9999999999999, 0.607326424791889, 600.0, 0.6073264247918895, 600.0000000000001, 0.607326424791883, 601.0, 0.5537316457219819, 602.0, 0.5061421773038086, 603.0, 0.46397753284348, 604.0, 0.426712555869167, 605.0, 0.3938721538726785, 606.0, 0.3650265332106627, 607.0, 0.3397868874736938, 608.0, 0.3178014961699873, 609.0, 0.2987521946770543, 610.0, 0.28235118013039595, 611.0, 0.26833812128051515, 612.0, 0.25647754339175277, 613.0, 0.24655646200917447, 614.0, 0.23838224191050095, 615.0, 0.23178065981380713, 616.0, 0.2265941514509877, 617.0, 0.22268022546218502, 618.0, 0.21991002823598693, 619.0, 0.21816704533092712, 620.0, 0.21734592648078221, 621.0, 0.21735142242303263, 622.0, 0.2180974229090351, 623.0, 0.21950608626711277, 624.0, 0.22150705180608277, 625.0, 0.22403672717583034, 626.0, 0.22703764355175893, 627.0, 0.23045787218874003, 628.0, 0.2342504965044192, 629.0, 0.23837313440748353, 630.0, 0.24278750608938493, 631.0, 0.24745904295302934, 632.0, 0.2523565337636593, 633.0, 0.2574518044797083, 634.0, 0.2627194285584802, 635.0, 0.2681364648365281, 636.0, 0.27368222036058465, 637.0, 0.27933803579462146, 638.0, 0.28508709125456844, 639.0, 0.2909142306266801, 640.0, 0.2968058026105366, 641.0, 0.3027495168950527, 642.0, 0.30873431402734, 643.0, 0.3147502476713121, 644.0, 0.3207883780769327, 645.0, 0.32684067569321007, 646.0, 0.33289993395957684, 647.0, 0.3389596904021537, 648.0, 0.3450141552445266, 649.0, 0.3510581468178767, 650.0, 0.3570870331233642, 651.0, 0.36309667896124287, 652.0, 0.36908339809690516, 653.0, 0.37504390998447534, 654.0, 0.3809753006141865, 655.0, 0.38687498709105794, 656.0, 0.3927406855897373, 657.0, 0.3985703823641715, 658.0, 0.40436230752134517, 659.0, 0.41011491129600064, 660.0, 0.4158268425882876, 661.0, 0.4214969295489427, 662.0, 0.4271241620171021, 663.0, 0.43270767563439394, 664.0, 0.43824673747574305, 665.0, 0.4437407330525016, 666.0, 0.4491891545572665, 667.0, 0.4545915902321689, 668.0, 0.4599477147536787, 669.0, 0.4652572805371398, 670.0, 0.4705201098734676, 671.0, 0.4757360878187691, 672.0, 0.48090515576519066, 673.0, 0.48602730562812146, 674.0, 0.4911025745910502, 675.0, 0.4961310403549667, 676.0, 0.5011128168442474, 677.0, 0.506048050325542, 678.0, 0.5109369159003152, 679.0, 0.5157796143354416, 680.0, 0.5205763691996449, 681.0, 0.5253274242766285, 682.0, 0.5300330412285308, 683.0, 0.5346934974858387, 684.0, 0.5393090843421695, 685.0, 0.5438801052343851, 686.0, 0.5484068741903608, 687.0, 0.5528897144284155, 688.0, 0.557328957093931, 689.0, 0.561724940120067, 690.0, 0.566078007200722, 691.0, 0.5703885068650241, 692.0, 0.5746567916436478, 693.0, 0.5788832173181845, 694.0, 0.5830681422456236, 695.0, 0.5872119267507622, 696.0, 0.5913149325800406, 697.0, 0.5953775224109246, 698.0, 0.59940005941151, 699.0, 0.6033829068455391, 699.9999999999999, 0.6073264277184678, 700.0, 0.6073264277184682, 700.0000000000001, 0.6073264277184618, 701.0, 0.5537316483423508, 702.0, 0.5061421796473833, 703.0, 0.46397753493687366, 704.0, 0.4267125577364578, 705.0, 0.3938721555356506, 706.0, 0.36502653468902446, 707.0, 0.3397868887852755, 708.0, 0.3178014973309198, 709.0, 0.2987521957019308, 710.0, 0.28235118103241863, 711.0, 0.2683381220716268, 712.0, 0.25647754408275736, 713.0, 0.24655646260984576, 714.0, 0.23838224242967965, 715.0, 0.2317806602594905, 716.0, 0.22659415183040932, 717.0, 0.22268022578188784, 718.0, 0.2199100285018889, 719.0, 0.21816704554838073, 720.0, 0.21734592665462804, 721.0, 0.21735142255764872, 722.0, 0.2180974230083803, 723.0, 0.2195060863347671, 724.0, 0.22150705184528308, 725.0, 0.22403672718950363, 726.0, 0.22703764354255118, 727.0, 0.23045787215904356, 728.0, 0.23425049645639628, 729.0, 0.2383731343430886, 730.0, 0.24278750601038435, 731.0, 0.24745904286101927, 732.0, 0.25235653366008204, 733.0, 0.2574518043658669, 734.0, 0.2627194284355516, 735.0, 0.2681364647055753, 736.0, 0.2736822202225675, 737.0, 0.2793380356504065, 738.0, 0.2850870911049377, 739.0, 0.29091423047233955, 740.0, 0.29680580245212296, 741.0, 0.3027495167331402, 742.0, 0.3087343138624463, 743.0, 0.3147502475039041, 744.0, 0.32078837790743076, 745.0, 0.3268406755219928, 746.0, 0.3328999337869849, 747.0, 0.3389596902284939, 748.0, 0.3450141550700745, 749.0, 0.35105814664288015, 750.0, 0.35708703294804556, 751.0, 0.36309667878580165, 752.0, 0.3690833979215201, 753.0, 0.3750439098093068, 754.0, 0.3809753004393778, 755.0, 0.38687498691673716, 756.0, 0.3927406854160187, 757.0, 0.3985703821911568, 758.0, 0.4043623073491247, 759.0, 0.4101149111246549, 760.0, 0.4158268424178878, 761.0, 0.42149692937955163, 762.0, 0.427124161848775, 763.0, 0.4327076754671795, 764.0, 0.43824673730968344, 765.0, 0.44374073288763394, 766.0, 0.4491891543936227, 767.0, 0.45459159006977634, 768.0, 0.459947714592561, 769.0, 0.4652572803773166, 770.0, 0.4705201097149555, 771.0, 0.4757360876615815, 772.0, 0.48090515560933855, 773.0, 0.48602730547361317, 774.0, 0.49110257443789207, 775.0, 0.4961310402031631, 776.0, 0.5011128166938011, 777.0, 0.506048050176454, 778.0, 0.5109369157525852, 779.0, 0.515779614189068, 780.0, 0.520576369054625, 781.0, 0.5253274241329586, 782.0, 0.5300330410862063, 783.0, 0.5346934973448543, 784.0, 0.5393090842025191, 785.0, 0.5438801050960619, 786.0, 0.5484068740533575, 787.0, 0.5528897142927244, 788.0, 0.557328956959544, 789.0, 0.5617249399869753, 790.0, 0.5660780070689169, 791.0, 0.5703885067344963, 792.0, 0.5746567915143879, 793.0, 0.5788832171901827, 794.0, 0.58306814211887, 795.0, 0.5872119266252469, 796.0, 0.5913149324557534, 797.0, 0.5953775222878552, 798.0, 0.5994000592896482, 799.0, 0.6033829067248746, 799.9999999999999, 0.60732642759899, 800.0, 0.6073264275989905, 800.0000000000001, 0.607326427598984, 801.0, 0.553731648235374, 802.0, 0.5061421795517066, 803.0, 0.4639775348514107, 804.0, 0.42671255766022553, 805.0, 0.39387215546775967, 806.0, 0.3650265346286703, 807.0, 0.33978688873173, 808.0, 0.3178014972835247, 809.0, 0.29875219566009026, 810.0, 0.2823511809955934, 811.0, 0.2683381220393296, 812.0, 0.25647754405454715, 813.0, 0.24655646258532338, 814.0, 0.23838224240848416, 815.0, 0.2317806602412954, 816.0, 0.22659415181491938, 817.0, 0.22268022576883584, 818.0, 0.21991002849103336, 819.0, 0.21816704553950306, 820.0, 0.21734592664753083, 821.0, 0.217351422552153, 822.0, 0.21809742300432444, 823.0, 0.21950608633200508, 824.0, 0.2215070518436828, 825.0, 0.2240367271889454, 826.0, 0.2270376435429271, 827.0, 0.23045787216025593, 828.0, 0.23425049645835672, 829.0, 0.2383731343457175, 830.0, 0.24278750601360954, 831.0, 0.2474590428647756, 832.0, 0.25235653366431055, 833.0, 0.2574518043705145, 834.0, 0.26271942844057017, 835.0, 0.26813646471092145, 836.0, 0.2736822202282021, 837.0, 0.279338035656294, 838.0, 0.28508709111104635, 839.0, 0.2909142304786405, 840.0, 0.29680580245859023, 841.0, 0.30274951673975026, 842.0, 0.30873431386917816, 843.0, 0.31475024751073855, 844.0, 0.3207883779143508, 845.0, 0.32684067552898277, 846.0, 0.33289993379403104, 847.0, 0.3389596902355836, 848.0, 0.34501415507719657, 849.0, 0.3510581466500243, 850.0, 0.35708703295520294, 851.0, 0.36309667879296403, 852.0, 0.3690833979286803, 853.0, 0.3750439098164581, 854.0, 0.3809753004465144, 855.0, 0.3868749869238538, 856.0, 0.3927406854231108, 857.0, 0.39857038219822016, 858.0, 0.40436230735615564, 859.0, 0.4101149111316502, 860.0, 0.41582684242484447, 861.0, 0.421496929386467, 862.0, 0.42712416185564694, 863.0, 0.432707675474006, 864.0, 0.4382467373164628, 865.0, 0.44374073289436455, 866.0, 0.4491891544003035, 867.0, 0.45459159007640604, 868.0, 0.45994771459913864, 869.0, 0.4652572803838415, 870.0, 0.47052010972142666, 871.0, 0.4757360876679987, 872.0, 0.48090515561570124, 873.0, 0.486027305479921, 874.0, 0.49110257444414485, 875.0, 0.4961310402093605, 876.0, 0.5011128166999431, 877.0, 0.5060480501825406, 878.0, 0.5109369157586162, 879.0, 0.5157796141950438, 880.0, 0.5205763690605455, 881.0, 0.5253274241388239, 882.0, 0.5300330410920168, 883.0, 0.53469349735061, 884.0, 0.5393090842082203, 885.0, 0.5438801051017089, 886.0, 0.5484068740589507, 887.0, 0.5528897142982641, 888.0, 0.5573289569650304, 889.0, 0.5617249399924087, 890.0, 0.5660780070742978, 891.0, 0.570388506739825, 892.0, 0.5746567915196649, 893.0, 0.5788832171954084, 894.0, 0.5830681421240448, 895.0, 0.587211926630371, 896.0, 0.5913149324608274, 897.0, 0.5953775222928795, 898.0, 0.5994000592946234, 899.0, 0.6033829067298008, 899.9999999999999, 0.6073264276038677, 900.0, 0.6073264276038681, 900.0000000000001, 0.6073264276038617, 901.0, 0.5537316482397414, 902.0, 0.5061421795556127, 903.0, 0.4639775348548998, 904.0, 0.4267125576633377, 905.0, 0.39387215547053134, 906.0, 0.3650265346311343, 907.0, 0.33978688873391616, 908.0, 0.3178014972854597, 909.0, 0.29875219566179845, 910.0, 0.2823511809970969, 911.0, 0.2683381220406482, 912.0, 0.2564775440556989, 913.0, 0.24655646258632458, 914.0, 0.23838224240934958, 915.0, 0.23178066024203825, 916.0, 0.22659415181555176, 917.0, 0.22268022576936874, 918.0, 0.21991002849147656, 919.0, 0.21816704553986566, 920.0, 0.2173459266478206, 921.0, 0.21735142255237738, 922.0, 0.2180974230044901, 923.0, 0.21950608633211788, 924.0, 0.2215070518437482, 925.0, 0.22403672718896828, 926.0, 0.22703764354291178, 927.0, 0.23045787216020652, 928.0, 0.23425049645827678, 929.0, 0.23837313434561014, 930.0, 0.24278750601347798, 931.0, 0.24745904286462228, 932.0, 0.252356533664138, 933.0, 0.2574518043703248, 934.0, 0.26271942844036533, 935.0, 0.2681364647107032, 936.0, 0.27368222022797206, 937.0, 0.27933803565605375, 938.0, 0.285087091110797, 939.0, 0.2909142304783833, 940.0, 0.2968058024583262, 941.0, 0.3027495167394805, 942.0, 0.3087343138689034, 943.0, 0.31475024751045955, 944.0, 0.3207883779140682, 945.0, 0.32684067552869744, 946.0, 0.3328999337937434, 947.0, 0.33895969023529426, 948.0, 0.3450141550769059, 949.0, 0.35105814664973267, 950.0, 0.35708703295491073, 951.0, 0.3630966787926716, 952.0, 0.36908339792838807, 953.0, 0.3750439098161662, 954.0, 0.3809753004462231, 955.0, 0.38687498692356326, 956.0, 0.39274068542282126, 957.0, 0.39857038219793184, 958.0, 0.40436230735586864, 959.0, 0.41011491113136467, 960.0, 0.41582684242456047, 961.0, 0.42149692938618466, 962.0, 0.4271241618553664, 963.0, 0.43270767547372735, 964.0, 0.438246737316186, 965.0, 0.4437407328940899, 966.0, 0.4491891544000307, 967.0, 0.4545915900761355, 968.0, 0.4599477145988702, 969.0, 0.46525728038357506, 970.0, 0.47052010972116254, 971.0, 0.4757360876677368, 972.0, 0.48090515561544145, 973.0, 0.48602730547966355, 974.0, 0.4911025744438895, 975.0, 0.4961310402091075, 976.0, 0.5011128166996923, 977.0, 0.5060480501822922, 978.0, 0.51093691575837, 979.0, 0.5157796141947998, 980.0, 0.5205763690603038, 981.0, 0.5253274241385845, 982.0, 0.5300330410917795, 983.0, 0.534693497350375, 984.0, 0.5393090842079875, 985.0, 0.5438801051014784, 986.0, 0.5484068740587225, 987.0, 0.5528897142980378, 988.0, 0.5573289569648063, 989.0, 0.561724939992187, 990.0, 0.5660780070740781, 991.0, 0.5703885067396075, 992.0, 0.5746567915194494, 993.0, 0.578883217195195, 994.0, 0.5830681421238335, 995.0, 0.5872119266301619, 996.0, 0.5913149324606204, 997.0, 0.5953775222926745, 998.0, 0.5994000592944202, 999.0, 0.6033829067295996, 999.9999999999999, 0.6073264276036686, 1000.0, 0.607326427603669};
        BooleanExpression expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.PT4, BooleanExpression.createParameterFloat(0.01), BooleanExpression.createParameterFloat(0.1), BooleanExpression.createParameterFloat(100.0), BooleanExpression.createParameterFloat(0.0));
        this.assertCompute(expr, 1.0E-10, result);
        expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.PT4, BooleanExpression.createParameterFloat(0.01), BooleanExpression.createParameterFloat(0.1), BooleanExpression.createParameterFloat(100.0), BooleanExpression.createParameterFloat(100.0));
        this.assertCompute(expr, 1.0E-10, result);
    }

    @Test
    public void testTPEb() {
        double[] result = new double[]{0.0, 0.0, Double.MIN_VALUE, 0.0, 1.0, 9.999500016666385E-5, 2.0, 1.9998000133325533E-4, 3.0, 2.999550044996413E-4, 4.0, 3.999200106655776E-4, 5.0, 4.99875020830709E-4, 6.0, 5.998200359945693E-4, 7.0, 6.997550571566924E-4, 8.0, 7.996800853162789E-4, 9.0, 8.995951214726405E-4, 10.0, 9.99500166624978E-4, 11.0, 0.0010993952217723812, 12.0, 0.0011992802879136066, 13.0, 0.001299155366047744, 14.0, 0.0013990204571733278, 15.0, 0.0014988755622891148, 16.0, 0.0015987206823936395, 17.0, 0.0016985558184854366, 18.0, 0.0017983809715627075, 19.0, 0.0018981961426238758, 20.0, 0.001998001332666921, 21.0, 0.0020977965426900447, 22.0, 0.002197581773691004, 23.0, 0.00229735702666789, 24.0, 0.0023971223026182376, 25.0, 0.0024968776025399153, 26.0, 0.0025966229274302366, 27.0, 0.002696358278286848, 28.0, 0.0027960836561070623, 29.0, 0.0028957990618880824, 30.0, 0.0029955044966269995, 31.0, 0.0030951999613210157, 32.0, 0.0031948854569671115, 33.0, 0.003294560984561934, 34.0, 0.0033942265451023523, 35.0, 0.003493882139585125, 36.0, 0.003593527769006677, 37.0, 0.0036931634343634334, 38.0, 0.0037927891366518196, 39.0, 0.0038924048768681496, 40.0, 0.003992010656008516, 41.0, 0.0040916064750690095, 42.0, 0.004191192335045502, 43.0, 0.004290768236933862, 44.0, 0.00439033418172996, 45.0, 0.004489890170429445, 46.0, 0.0045894362040277414, 47.0, 0.004688972283520387, 48.0, 0.004788498409902808, 49.0, 0.004888014584170208, 50.0, 0.00498752080731768, 51.0, 0.005087017080340428, 52.0, 0.0051865034042332114, 53.0, 0.0052859797799911235, 54.0, 0.005385446208608813, 55.0, 0.005484902691080928, 56.0, 0.005584349228402119, 57.0, 0.005683785821566811, 58.0, 0.00578321247156921, 59.0, 0.005882629179403853, 60.0, 0.005982035946064723, 61.0, 0.006081432772546025, 62.0, 0.006180819659841519, 63.0, 0.006280196608945299, 64.0, 0.006379563620851014, 65.0, 0.006478920696552315, 66.0, 0.0065782678370428505, 67.0, 0.006677605043316048, 68.0, 0.006776932316365336, 69.0, 0.006876249657183808, 70.0, 0.0069755570667648925, 71.0, 0.007074854546101461, 72.0, 0.007174142096186609, 73.0, 0.007273419718013208, 74.0, 0.007372687412573908, 75.0, 0.007471945180861583, 76.0, 0.007571193023868661, 77.0, 0.007670430942587569, 78.0, 0.007769658938010848, 79.0, 0.007868877011130704, 80.0, 0.007968085162939342, 81.0, 0.008067283394428859, 82.0, 0.008166471706591127, 83.0, 0.008265650100418132, 84.0, 0.008364818576901634, 85.0, 0.008463977137033285, 86.0, 0.008563125781804737, 87.0, 0.008662264512207418, 88.0, 0.008761393329232758, 89.0, 0.008860512233871964, 90.0, 0.008959621227116354, 91.0, 0.009058720309956914, 92.0, 0.009157809483384627, 93.0, 0.00925688874839048, 94.0, 0.009355958105965234, 95.0, 0.009455017557099543, 96.0, 0.009554067102783947, 97.0, 0.009653106744009099, 98.0, 0.009752136481765317, 99.0, 0.009851156317042808, 100.0, 0.009950166250831893, 101.0, 0.010049166284122668, 102.0, 0.010148156417905119, 103.0, 0.01024713665316912, 104.0, 0.010346106990904436, 105.0, 0.010445067432100719, 106.0, 0.010544017977747844, 107.0, 0.01064295862883502, 108.0, 0.010741889386351788, 109.0, 0.01084081025128747, 110.0, 0.010939721224631271, 111.0, 0.011038622307372292, 112.0, 0.011137513500499518, 113.0, 0.011236394805001826, 114.0, 0.01133526622186809, 115.0, 0.011434127752086964, 116.0, 0.011532979396647214, 117.0, 0.011631821156537159, 118.0, 0.011730653032745342, 119.0, 0.011829475026259972, 120.0, 0.011928287138069482, 121.0, 0.012027089369161748, 122.0, 0.012125881720524978, 123.0, 0.012224664193146939, 124.0, 0.012323436788015618, 125.0, 0.012422199506118559, 126.0, 0.012520952348443526, 127.0, 0.012619695315978063, 128.0, 0.012718428409709492, 129.0, 0.012817151630625245, 130.0, 0.012915864979712421, 131.0, 0.013014568457958231, 132.0, 0.013113262066349773, 133.0, 0.013211945805873926, 134.0, 0.013310619677517566, 135.0, 0.013409283682267348, 136.0, 0.013507937821110039, 137.0, 0.01360658209503196, 138.0, 0.013705216505019768, 139.0, 0.013803841052059784, 140.0, 0.013902455737138109, 141.0, 0.014001060561241063, 142.0, 0.014099655525354526, 143.0, 0.014198240630464598, 144.0, 0.014296815877557045, 145.0, 0.014395381267617635, 146.0, 0.014493936801632024, 147.0, 0.014592482480585756, 148.0, 0.014691018305464376, 149.0, 0.014789544277253097, 150.0, 0.014888060396937353, 151.0, 0.014986566665502132, 152.0, 0.015085063083932537, 153.0, 0.015183549653213668, 154.0, 0.015282026374330182, 155.0, 0.015380493248267069, 156.0, 0.015478950276008763, 157.0, 0.015577397458540032, 158.0, 0.0156758347968452, 159.0, 0.015774262291908703, 160.0, 0.015872679944714863, 161.0, 0.01597108775624778, 162.0, 0.016069485727491672, 163.0, 0.016167873859430304, 164.0, 0.016266252153047667, 165.0, 0.01636462060932764, 166.0, 0.01646297922925366, 167.0, 0.016561328013809606, 168.0, 0.016659666963978803, 169.0, 0.016757996080744575, 170.0, 0.016856315365090357, 171.0, 0.016954624817999253, 172.0, 0.017052924440454476, 173.0, 0.017151214233438794, 174.0, 0.017249494197935422, 175.0, 0.017347764334926796, 176.0, 0.017446024645395908, 177.0, 0.017544275130325304, 178.0, 0.01764251579069731, 179.0, 0.017740746627494586, 180.0, 0.017838967641699233, 181.0, 0.017937178834293688, 182.0, 0.018035380206259832, 183.0, 0.01813357175857966, 184.0, 0.01823175349223538, 185.0, 0.018329925408208547, 186.0, 0.018428087507480928, 187.0, 0.018526239791034183, 188.0, 0.01862438225984986, 189.0, 0.018722514914909394, 190.0, 0.018820637757194003, 191.0, 0.018918750787685013, 192.0, 0.019016854007363526, 193.0, 0.019114947417210537, 194.0, 0.01921303101820704, 195.0, 0.0193111048113338, 196.0, 0.019409168797571597, 197.0, 0.019507222977901195, 198.0, 0.019605267353302924, 199.0, 0.019703301924757333, 200.0, 0.019801326693244747, 201.0, 0.019899341659745384, 202.0, 0.01999734682523946, 203.0, 0.020095342190706966, 204.0, 0.0201933277571279, 205.0, 0.02029130352548214, 206.0, 0.020389269496749463, 207.0, 0.020487225671909304, 208.0, 0.020585172051941547, 209.0, 0.02068310863782541, 210.0, 0.02078103543054044, 211.0, 0.020878952431065745, 212.0, 0.02097685964038054, 213.0, 0.021074757059464044, 214.0, 0.021172644689295028, 215.0, 0.021270522530852376, 216.0, 0.021368390585115082, 217.0, 0.021466248853061587, 218.0, 0.021564097335670662, 219.0, 0.021661936033920637, 220.0, 0.02175976494878995, 221.0, 0.02185758408125693, 222.0, 0.021955393432299797, 223.0, 0.022053193002896543, 224.0, 0.022150982794025165, 225.0, 0.022248762806663658, 226.0, 0.022346533041789796, 227.0, 0.02244429350038113, 228.0, 0.022542044183415544, 229.0, 0.022639785091870257, 230.0, 0.02273751622672293, 231.0, 0.022835237588950674, 232.0, 0.022932949179530815, 233.0, 0.02303065099944046, 234.0, 0.023128343049656608, 235.0, 0.02322602533115614, 236.0, 0.023323697844915947, 237.0, 0.0234213605919128, 238.0, 0.023519013573123138, 239.0, 0.023616656789523627, 240.0, 0.023714290242090708, 241.0, 0.0238119139318006, 242.0, 0.023909527859629742, 243.0, 0.024007132026554023, 244.0, 0.024104726433549772, 245.0, 0.024202311081592653, 246.0, 0.024299885971658663, 247.0, 0.024397451104723578, 248.0, 0.02449500648176295, 249.0, 0.02459255210375244, 250.0, 0.024690087971667385, 251.0, 0.024787614086483112, 252.0, 0.024885130449175064, 253.0, 0.02498263706071835, 254.0, 0.025080133922087966, 255.0, 0.025177621034258912, 256.0, 0.025275098398206075, 257.0, 0.02537256601490423, 258.0, 0.02547002388532793, 259.0, 0.025567472010451953, 260.0, 0.025664910391250628, 261.0, 0.02576233902869851, 262.0, 0.02585975792376971, 263.0, 0.025957167077438448, 264.0, 0.026054566490678832, 265.0, 0.026151956164464973, 266.0, 0.026249336099770648, 267.0, 0.026346706297569633, 268.0, 0.026444066758835594, 269.0, 0.026541417484542307, 270.0, 0.026638758475663216, 271.0, 0.026736089733171653, 272.0, 0.02683341125804095, 273.0, 0.026930723051244443, 274.0, 0.027028025113755128, 275.0, 0.027125317446546005, 276.0, 0.027222600050590073, 277.0, 0.02731987292686011, 278.0, 0.027417136076328896, 279.0, 0.027514389499969094, 280.0, 0.02761163319875315, 281.0, 0.027708867173653506, 282.0, 0.0278060914256425, 283.0, 0.027903305955692348, 284.0, 0.028000510764775388, 285.0, 0.028097705853863397, 286.0, 0.028194891223928598, 287.0, 0.028292066875942545, 288.0, 0.02838923281087724, 289.0, 0.02848638902970424, 290.0, 0.02858353553339521, 291.0, 0.028680672322921374, 292.0, 0.0287777993992544, 293.0, 0.028874916763365288, 294.0, 0.028972024416225373, 295.0, 0.029069122358805766, 296.0, 0.029166210592077246, 297.0, 0.029263289117010927, 298.0, 0.029360357934577475, 299.0, 0.029457417045747558, 300.0, 0.029554466451491845, 301.0, 0.029651506152780782, 302.0, 0.029748536150584703, 303.0, 0.029845556445874055, 304.0, 0.02994256703961895, 305.0, 0.0300395679327895, 306.0, 0.03013655912635571, 307.0, 0.03023354062128747, 308.0, 0.030330512418554667, 309.0, 0.030427474519126974, 310.0, 0.030524426923974057, 311.0, 0.030621369634065365, 312.0, 0.030718302650370344, 313.0, 0.03081522597385833, 314.0, 0.030912139605498656, 315.0, 0.03100904354626033, 316.0, 0.03110593779711235, 317.0, 0.03120282235902383, 318.0, 0.03129969723296355, 319.0, 0.03139656241990019, 320.0, 0.0314934179208024, 321.0, 0.03159026373663887, 322.0, 0.03168709986837792, 323.0, 0.0317839263169879, 324.0, 0.031880743083437246, 325.0, 0.03197755016869397, 326.0, 0.03207434757372618, 327.0, 0.032171135299501885, 328.0, 0.032267913346988863, 329.0, 0.03236468171715501, 330.0, 0.03246144041096799, 331.0, 0.03255818942939537, 332.0, 0.03265492877340459, 333.0, 0.032751658443963105, 334.0, 0.03284837844203825, 335.0, 0.03294508876859714, 336.0, 0.03304178942460689, 337.0, 0.03313848041103451, 338.0, 0.033235161728846885, 339.0, 0.03333183337901102, 340.0, 0.03342849536249337, 341.0, 0.033525147680260714, 342.0, 0.0336217903332795, 343.0, 0.03371842332251618, 344.0, 0.033815046648937086, 345.0, 0.03391166031350845, 346.0, 0.03400826431719639, 347.0, 0.03410485866096702, 348.0, 0.03420144334578612, 349.0, 0.0342980183726197, 350.0, 0.03439458374243354, 351.0, 0.03449113945619309, 352.0, 0.03458768551486413, 353.0, 0.034684221919412006, 354.0, 0.03478074867080205, 355.0, 0.0348772657699995, 356.0, 0.034973773217969684, 357.0, 0.03507027101567761, 358.0, 0.03516675916408818, 359.0, 0.03526323766416639, 360.0, 0.03535970651687692, 361.0, 0.03545616572318455, 362.0, 0.035552615284053846, 363.0, 0.03564905520044925, 364.0, 0.035745485473335226, 365.0, 0.03584190610367599, 366.0, 0.03593831709243589, 367.0, 0.03603471844057893, 368.0, 0.03613111014906911, 369.0, 0.03622749221887034, 370.0, 0.0363238646509465, 371.0, 0.03642022744626139, 372.0, 0.03651658060577845, 373.0, 0.036612924130461355, 374.0, 0.03670925802127356, 375.0, 0.036805582279178184, 376.0, 0.03690189690513879, 377.0, 0.036998201900118266, 378.0, 0.03709449726507974, 379.0, 0.037190783000986216, 380.0, 0.03728705910880048, 381.0, 0.03738332558948532, 382.0, 0.0374795824440034, 383.0, 0.03757582967331741, 384.0, 0.037672067278389565, 385.0, 0.03776829526018244, 386.0, 0.03786451361965826, 387.0, 0.03796072235777925, 388.0, 0.03805692147550743, 389.0, 0.038153110973804805, 390.0, 0.038249290853633267, 391.0, 0.038345461115954604, 392.0, 0.038441621761730604, 393.0, 0.03853777279192283, 394.0, 0.03863391420749274, 395.0, 0.038730046009401775, 396.0, 0.03882616819861129, 397.0, 0.03892228077608251, 398.0, 0.03901838374277644, 399.0, 0.03911447709965421, 400.0, 0.03921056084767682, 401.0, 0.039306634987804956, 402.0, 0.03940269952099951, 403.0, 0.03949875444822093, 404.0, 0.03959479977043001, 405.0, 0.039690835488586984, 406.0, 0.03978686160365241, 407.0, 0.03988287811658631, 408.0, 0.03997888502834912, 409.0, 0.04007488233990064, 410.0, 0.0401708700522011, 411.0, 0.04026684816621018, 412.0, 0.04036281668288777, 413.0, 0.04045877560319344, 414.0, 0.04055472492808698, 415.0, 0.040650664658527735, 416.0, 0.040746594795475044, 417.0, 0.04084251533988836, 418.0, 0.040938426292726815, 419.0, 0.04103432765494952, 420.0, 0.04113021942751549, 421.0, 0.041226101611383625, 422.0, 0.04132197420751271, 423.0, 0.04141783721686165, 424.0, 0.0415136906403889, 425.0, 0.04160953447905302, 426.0, 0.04170536873381259, 427.0, 0.041801193405625714, 428.0, 0.04189700849545086, 429.0, 0.04199281400424604, 430.0, 0.04208860993296937, 431.0, 0.04218439628257875, 432.0, 0.04228017305403209, 433.0, 0.04237594024828717, 434.0, 0.04247169786630167, 435.0, 0.04256744590903305, 436.0, 0.04266318437743899, 437.0, 0.04275891327247672, 438.0, 0.04285463259510358, 439.0, 0.042950342346276704, 440.0, 0.04304604252695332, 441.0, 0.04314173313809033, 442.0, 0.04323741418064464, 443.0, 0.043333085655573145, 444.0, 0.043428747563832415, 445.0, 0.04352439990637924, 446.0, 0.04362004268416997, 447.0, 0.043715675898161166, 448.0, 0.04381129954930907, 449.0, 0.04390691363857002, 450.0, 0.04400251816690015, 451.0, 0.04409811313525536, 452.0, 0.04419369854459165, 453.0, 0.04428927439586505, 454.0, 0.044384840690031124, 455.0, 0.04448039742804555, 456.0, 0.044575944610864005, 457.0, 0.04467148223944184, 458.0, 0.04476701031473451, 459.0, 0.04486252883769726, 460.0, 0.04495803780928531, 461.0, 0.0450535372304538, 462.0, 0.045149027102157624, 463.0, 0.04524450742535169, 464.0, 0.04533997820099078, 465.0, 0.0454354394300297, 466.0, 0.0455308911134229, 467.0, 0.04562633325212517, 468.0, 0.045721765847090645, 469.0, 0.045817188899273775, 470.0, 0.04591260240962891, 471.0, 0.046008006379109956, 472.0, 0.046103400808671036, 473.0, 0.046198785699266165, 474.0, 0.046294161051849136, 475.0, 0.04638952686737363, 476.0, 0.046484883146793554, 477.0, 0.04658022989106214, 478.0, 0.046675567101133075, 479.0, 0.046770894777959704, 480.0, 0.046866212922495265, 481.0, 0.046961521535692885, 482.0, 0.0470568206185058, 483.0, 0.04715211017188692, 484.0, 0.04724739019678903, 485.0, 0.04734266069416515, 486.0, 0.04743792166496774, 487.0, 0.047533173110149596, 488.0, 0.047628415030663174, 489.0, 0.047723647427460936, 490.0, 0.04781887030149512, 491.0, 0.047914083653718076, 492.0, 0.04800928748508171, 493.0, 0.04810448179653837, 494.0, 0.048199666589039736, 495.0, 0.04829484186353783, 496.0, 0.04839000762098433, 497.0, 0.048485163862330816, 498.0, 0.04858031058852896, 499.0, 0.048675447800530236, 500.0, 0.048770575499285984, 501.0, 0.04886569368574745, 502.0, 0.04896080236086586, 503.0, 0.04905590152559236, 504.0, 0.049150991180877734, 505.0, 0.04924607132767311, 506.0, 0.04934114196692918, 507.0, 0.04943620309959662, 508.0, 0.04953125472662612, 509.0, 0.04962629684896813, 510.0, 0.04972132946757313, 511.0, 0.04981635258339134, 512.0, 0.04991136619737313, 513.0, 0.050006370310468506, 514.0, 0.05010136492362771, 515.0, 0.05019635003780043, 516.0, 0.05029132565393668, 517.0, 0.05038629177298626, 518.0, 0.050481248395898626, 519.0, 0.05057619552362358, 520.0, 0.05067113315711047, 521.0, 0.05076606129730854, 522.0, 0.05086097994516736, 523.0, 0.050955889101635954, 524.0, 0.051050788767663446, 525.0, 0.05114567894419875, 526.0, 0.051240559632190874, 527.0, 0.05133543083258851, 528.0, 0.05143029254634057, 529.0, 0.051525144774395404, 530.0, 0.051619987517701804, 531.0, 0.051714820777208015, 532.0, 0.0518096445538625, 533.0, 0.05190445884861328, 534.0, 0.05199926366240881, 535.0, 0.0520940589961969, 536.0, 0.052188844850925564, 537.0, 0.0522836212275426, 538.0, 0.05237838812699591, 539.0, 0.05247314555023308, 540.0, 0.05256789349820168, 541.0, 0.05266263197184928, 542.0, 0.052757360972123135, 543.0, 0.05285208049997059, 544.0, 0.052946790556338885, 545.0, 0.053041491142175046, 546.0, 0.05313618225842609, 547.0, 0.05323086390603893, 548.0, 0.05332553608596047, 549.0, 0.053420198799137286, 550.0, 0.05351485204651618, 551.0, 0.05360949582904351, 552.0, 0.05370413014766584, 553.0, 0.053798755003329424, 554.0, 0.0538933703969805, 555.0, 0.05398797632956531, 556.0, 0.05408257280202999, 557.0, 0.05417715981532023, 558.0, 0.054271737370382156, 559.0, 0.05436630546816146, 560.0, 0.05446086410960371, 561.0, 0.05455541329565472, 562.0, 0.05464995302725972, 563.0, 0.0547444833053643, 564.0, 0.054839004130913804, 565.0, 0.05493351550485326, 566.0, 0.055028017428127796, 567.0, 0.05512250990168255, 568.0, 0.05521699292646243, 569.0, 0.05531146650341223, 570.0, 0.05540593063347665, 571.0, 0.055500385317600376, 572.0, 0.05559483055672798, 573.0, 0.05568926635180382, 574.0, 0.05578369270377237, 575.0, 0.055878109613577864, 576.0, 0.05597251708216433, 577.0, 0.05606691511047601, 578.0, 0.05616130369945693, 579.0, 0.05625568285005078, 580.0, 0.05635005256320147, 581.0, 0.05644441283985269, 582.0, 0.05653876368094801, 583.0, 0.056633105087431024, 584.0, 0.05672743706024497, 585.0, 0.05682175960033342, 586.0, 0.0569160727086393, 587.0, 0.057010376386106065, 588.0, 0.05710467063367641, 589.0, 0.05719895545229359, 590.0, 0.05729323084290028, 591.0, 0.057387496806439176, 592.0, 0.05748175334385319, 593.0, 0.057576000456084575, 594.0, 0.057670238144076125, 595.0, 0.05776446640876998, 596.0, 0.05785868525110838, 597.0, 0.057952894672033795, 598.0, 0.05804709467248803, 599.0, 0.05814128525341322, 600.0, 0.05823546641575128, 601.0, 0.05832963816044401, 602.0, 0.0584238004884331, 603.0, 0.05851795340066013, 604.0, 0.05861209689806679, 605.0, 0.05870623098159433, 606.0, 0.05880035565218422, 607.0, 0.05889447091077771, 608.0, 0.058988576758315814, 609.0, 0.05908267319573968, 610.0, 0.05917676022399032, 611.0, 0.05927083784400844, 612.0, 0.059364906056735056, 613.0, 0.05945896486311064, 614.0, 0.05955301426407589, 615.0, 0.059647054260571375, 616.0, 0.05974108485353724, 617.0, 0.059835106043914066, 618.0, 0.059929117832641876, 619.0, 0.06002312022066092, 620.0, 0.06011711320891111, 621.0, 0.060211096798332364, 622.0, 0.060305070989864706, 623.0, 0.06039903578444761, 624.0, 0.06049299118302098, 625.0, 0.06058693718652419, 626.0, 0.06068087379589682, 627.0, 0.060774801012078106, 628.0, 0.06086871883600753, 629.0, 0.060962627268624, 630.0, 0.06105652631086678, 631.0, 0.061150415963674765, 632.0, 0.061244296227986994, 633.0, 0.06133816710474216, 634.0, 0.06143202859487895, 635.0, 0.061525880699335955, 636.0, 0.061619723419051864, 637.0, 0.06171355675496493, 638.0, 0.061807380708013615, 639.0, 0.06190119527913607, 640.0, 0.061995000469270534, 641.0, 0.06208879627935493, 642.0, 0.06218258271032728, 643.0, 0.06227635976312551, 644.0, 0.062370127438687195, 645.0, 0.06246388573795025, 646.0, 0.06255763466185216, 647.0, 0.06265137421133038, 648.0, 0.06274510438732239, 649.0, 0.06283882519076534, 650.0, 0.06293253662259657, 651.0, 0.06302623868375312, 652.0, 0.06311993137517213, 653.0, 0.06321361469779041, 654.0, 0.06330728865254487, 655.0, 0.0634009532403721, 656.0, 0.063494608462209, 657.0, 0.06358825431899184, 658.0, 0.06368189081165732, 659.0, 0.06377551794114167, 660.0, 0.06386913570838115, 661.0, 0.06396274411431202, 662.0, 0.0640563431598703, 663.0, 0.06414993284599202, 664.0, 0.0642435131736131, 665.0, 0.06433708414366923, 666.0, 0.06443064575709623, 667.0, 0.06452419801482967, 668.0, 0.06461774091780503, 669.0, 0.0647112744669579, 670.0, 0.06480479866322342, 671.0, 0.06489831350753694, 672.0, 0.06499181900083362, 673.0, 0.06508531514404847, 674.0, 0.06517880193811643, 675.0, 0.06527227938397251, 676.0, 0.0653657474825513, 677.0, 0.06545920623478751, 678.0, 0.06555265564161583, 679.0, 0.06564609570397062, 680.0, 0.06573952642278647, 681.0, 0.06583294779899751, 682.0, 0.065926359833538, 683.0, 0.06601976252734221, 684.0, 0.06611315588134392, 685.0, 0.06620653989647718, 686.0, 0.0662999145736759, 687.0, 0.06639327991387367, 688.0, 0.0664866359180043, 689.0, 0.06657998258700126, 690.0, 0.06667331992179804, 691.0, 0.06676664792332798, 692.0, 0.06685996659252447, 693.0, 0.06695327593032052, 694.0, 0.0670465759376494, 695.0, 0.06713986661544402, 696.0, 0.06723314796463731, 697.0, 0.06732641998616196, 698.0, 0.06741968268095089, 699.0, 0.06751293604993669, 700.0, 0.06760618009405173, 701.0, 0.0676994148142287, 702.0, 0.06779264021139975, 703.0, 0.06788585628649713, 704.0, 0.06797906304045309, 705.0, 0.06807226047419968, 706.0, 0.06816544858866891, 707.0, 0.0682586273847926, 708.0, 0.06835179686350257, 709.0, 0.06844495702573039, 710.0, 0.06853810787240788, 711.0, 0.06863124940446641, 712.0, 0.06872438162283745, 713.0, 0.06881750452845226, 714.0, 0.0689106181222422, 715.0, 0.06900372240513819, 716.0, 0.0690968173780715, 717.0, 0.06918990304197292, 718.0, 0.06928297939777339, 719.0, 0.0693760464464036, 719.9999999999999, 0.06946910418879426, 720.0, 0.06946910418879426, 720.0000000000001, 0.06946910418879348, 721.0, 0.06295162934434473, 722.0, 0.057063880678397405, 723.0, 0.051745930871278434, 724.0, 0.046943555441880114, 725.0, 0.04260769005081677, 726.0, 0.03869393944801691, 727.0, 0.035162133150127395, 728.0, 0.03197592340080446, 729.0, 0.029102421390141964, 730.0, 0.026511868092397473, 731.0, 0.02417733642764941, 732.0, 0.02207446176652128, 733.0, 0.0201811980807719, 734.0, 0.01847759729922427, 735.0, 0.01694560966075498, 736.0, 0.01556890306620784, 737.0, 0.014332699621246059, 738.0, 0.01322362773420882, 739.0, 0.012229588288718118, 740.0, 0.011339633551644024, 741.0, 0.010543857604503604, 742.0, 0.009833297201687796, 743.0, 0.009199842063277841, 744.0, 0.008636153704626781, 745.0, 0.008135591990329871, 746.0, 0.007692148677506339, 747.0, 0.007300387283276311, 748.0, 0.006955388674601992, 749.0, 0.006652701835941577, 750.0, 0.006388299321979263, 751.0, 0.006158536949589233, 752.0, 0.005960117325615633, 753.0, 0.0057900568454438694, 754.0, 0.00564565583207266, 755.0, 0.0055244715168299985, 756.0, 0.005424293591311802, 757.0, 0.0053431220858639605, 758.0, 0.005279147353203006, 759.0, 0.0052307319568482, 760.0, 0.005196394283096817, 761.0, 0.005174793712526271, 762.0, 0.005164717202614133, 763.0, 0.005165067147191449, 764.0, 0.005174850391220787, 765.0, 0.005193168290957395, 766.0, 0.005219207720009278, 767.0, 0.005252232931287071, 768.0, 0.005291578193388213, 769.0, 0.005336641127723918, 770.0, 0.005386876679701946, 771.0, 0.005441791663626905, 772.0, 0.005500939826722284, 773.0, 0.005563917382872541, 774.0, 0.005630358971386085, 775.0, 0.005699934000332307, 776.0, 0.005772343337857477, 777.0, 0.00584731631836144, 778.0, 0.005924608033575973, 779.0, 0.00600399688143094, 780.0, 0.006085282348175514, 781.0, 0.0061682830015598045, 782.0, 0.006252834674989605, 783.0, 0.006338788824482466, 784.0, 0.00642601104197893, 785.0, 0.0065143797101325784, 786.0, 0.006603784785111366, 787.0, 0.006694126695233726, 788.0, 0.006785315344410292, 789.0, 0.006877269210422643, 790.0, 0.006969914529011967, 791.0, 0.007063184555610835, 792.0, 0.007157018897331668, 793.0, 0.007251362908524683, 794.0, 0.0073461671438550535, 795.0, 0.007441386863428656, 796.0, 0.00753698158500915, 797.0, 0.007632914678848857, 798.0, 0.007729153001075906, 799.0, 0.007825666561969147, 800.0, 0.007922428225800915, 801.0, 0.008019413439244172, 802.0, 0.008116599985623418, 803.0, 0.008213967762554564, 804.0, 0.008311498580741983, 805.0, 0.008409175981924921, 806.0, 0.008506985074147377, 807.0, 0.008604912382704888, 808.0, 0.008702945715274524, 809.0, 0.00880107403988073, 810.0, 0.00889928737447343, 811.0, 0.008997576687014508, 812.0, 0.00909593380507201, 813.0, 0.009194351334018247, 814.0, 0.009292822583011007, 815.0, 0.009391341498020678, 816.0, 0.009489902601228506, 817.0, 0.009588500936193567, 818.0, 0.009687132018236677, 819.0, 0.009785791789546416, 820.0, 0.009884476578557622, 821.0, 0.009983183063194567, 822.0, 0.010081908237613013, 823.0, 0.010180649382106721, 824.0, 0.010279404035877904, 825.0, 0.01037816997239871, 826.0, 0.010476945177117947, 827.0, 0.010575727827287329, 828.0, 0.010674516273711188, 829.0, 0.010773309024229127, 830.0, 0.010872104728772425, 831.0, 0.010970902165843177, 832.0, 0.011069700230277424, 833.0, 0.011168497922176335, 834.0, 0.011267294336887446, 835.0, 0.011366088655941686, 836.0, 0.01146488013885183, 837.0, 0.011563668115690762, 838.0, 0.01166245198037763, 839.0, 0.011761231184601706, 840.0, 0.011860005232325, 841.0, 0.011958773674807688, 842.0, 0.012057536106107047, 843.0, 0.012156292159004822, 844.0, 0.012255041501322395, 845.0, 0.012353783832585452, 846.0, 0.012452518881008179, 847.0, 0.012551246400761995, 848.0, 0.0126499661695062, 849.0, 0.012748677986152424, 850.0, 0.012847381668841806, 851.0, 0.012946077053116123, 852.0, 0.013044763990260999, 853.0, 0.013143442345807999, 854.0, 0.013242111998178707, 855.0, 0.013340772837458492, 856.0, 0.013439424764286168, 857.0, 0.013538067688849686, 858.0, 0.013636701529977646, 859.0, 0.013735326214317167, 860.0, 0.013833941675589045, 861.0, 0.013932547853915622, 862.0, 0.014031144695210829, 863.0, 0.014129732150629404, 864.0, 0.014228310176068182, 865.0, 0.014326878731714454, 866.0, 0.014425437781637851, 867.0, 0.014523987293421303, 868.0, 0.01462252723782631, 869.0, 0.01472105758848996, 870.0, 0.014819578321652371, 871.0, 0.014918089415907776, 872.0, 0.015016590851981815, 873.0, 0.015115082612527364, 874.0, 0.015213564681942016, 875.0, 0.015312037046201765, 876.0, 0.015410499692710689, 877.0, 0.015508952610165161, 878.0, 0.015607395788430733, 879.0, 0.015705829218431444, 880.0, 0.01580425289204801, 881.0, 0.015902666802027676, 882.0, 0.016001070941901507, 883.0, 0.016099465305909444, 884.0, 0.016197849888933358, 885.0, 0.016296224686435545, 886.0, 0.01639458969440377, 887.0, 0.01649294490930131, 888.0, 0.01659129032802109, 889.0, 0.01668962594784551, 890.0, 0.016787951766408793, 891.0, 0.016886267781664244, 892.0, 0.016984573991853047, 893.0, 0.01708287039547718, 894.0, 0.017181156991275093, 895.0, 0.01727943377819796, 896.0, 0.0173777007553908, 897.0, 0.0174759579221736, 898.0, 0.017574205278023447, 899.0, 0.017672442822561862, 900.0, 0.017770670555539048, 901.0, 0.017868888476822553, 902.0, 0.017967096586385622, 903.0, 0.018065294884297645, 904.0, 0.018163483370715383, 905.0, 0.01826166204587265, 906.0, 0.018359830910075647, 907.0, 0.018457989963693966, 908.0, 0.01855613920715593, 909.0, 0.018654278640941935, 910.0, 0.01875240826558011, 911.0, 0.018850528081641782, 912.0, 0.018948638089736902, 913.0, 0.019046738290510956, 914.0, 0.01914482868464107, 915.0, 0.01924290927283323, 916.0, 0.019340980055819523, 917.0, 0.019439041034355897, 918.0, 0.019537092209218843, 919.0, 0.019635133581204833, 920.0, 0.01973316515112744, 921.0, 0.019831186919816224, 922.0, 0.01992919888811484, 923.0, 0.02002720105687983, 924.0, 0.020125193426979604, 925.0, 0.02022317599929291, 926.0, 0.02032114877470803, 927.0, 0.0204191117541217, 928.0, 0.02051706493843919, 929.0, 0.02061500832857155, 930.0, 0.020712941925437378, 931.0, 0.02081086572996027, 932.0, 0.02090877974306926, 933.0, 0.02100668396569827, 934.0, 0.02110457839878499, 935.0, 0.021202463043271114, 936.0, 0.021300337900101995, 937.0, 0.021398202970225877, 938.0, 0.021496058254593886, 939.0, 0.021593903754159594, 940.0, 0.02169173946987879, 941.0, 0.0217895654027096, 942.0, 0.021887381553611696, 943.0, 0.021985187923546534, 944.0, 0.02208298451347701, 945.0, 0.022180771324367576, 946.0, 0.02227854835718346, 947.0, 0.02237631561289144, 948.0, 0.022474073092458968, 949.0, 0.02257182079685438, 950.0, 0.022669558727047012, 951.0, 0.022767286884006643, 952.0, 0.02286500526870372, 953.0, 0.022962713882109242, 954.0, 0.02306041272519499, 955.0, 0.02315810179893263, 956.0, 0.023255781104294604, 957.0, 0.02335345064225358, 958.0, 0.02345111041378256, 959.0, 0.023548760419854653, 960.0, 0.023646400661443412, 961.0, 0.023744031139522392, 962.0, 0.023841651855065593, 963.0, 0.02393926280904657, 964.0, 0.024036864002439873, 965.0, 0.024134455436219282, 966.0, 0.02423203711135924, 967.0, 0.024329609028833854, 968.0, 0.02442717118961779, 969.0, 0.02452472359468527, 970.0, 0.024622266245010405, 971.0, 0.024719799141567855, 972.0, 0.02481732228533229, 973.0, 0.024914835677277813, 974.0, 0.02501233931837865, 975.0, 0.025109833209609467, 976.0, 0.02520731735194459, 977.0, 0.025304791746358024, 978.0, 0.025402256393824096, 979.0, 0.02549971129531725, 980.0, 0.025597156451811376, 981.0, 0.02569459186428058, 982.0, 0.025792017533698863, 983.0, 0.025889433461040334, 984.0, 0.02598683964727866, 985.0, 0.026084236093387836, 986.0, 0.026181622800341642, 987.0, 0.02627899976911352, 988.0, 0.026376367000676915, 989.0, 0.026473724496005824, 990.0, 0.026571072256073358, 991.0, 0.02666841028185296, 992.0, 0.026765738574317743, 993.0, 0.026863057134441037, 994.0, 0.026960365963195954, 995.0, 0.02705766506155527, 996.0, 0.027154954430491984, 997.0, 0.027252234070978987, 998.0, 0.027349503983989054, 999.0, 0.027446764170494742, 1000.0, 0.027544014631468605, 1001.0, 0.02764125536788309, 1002.0, 0.027738486380710414, 1003.0, 0.027835707670923027, 1004.0, 0.027932919239493148, 1005.0, 0.02803012108739278, 1006.0, 0.02812731321559392, 1007.0, 0.028224495625068236, 1008.0, 0.02832166831678795, 1009.0, 0.02841883129172451, 1010.0, 0.028515984550849582, 1011.0, 0.02861312809513461, 1012.0, 0.02871026192555115, 1013.0, 0.028807386043070315, 1014.0, 0.02890450044866355, 1015.0, 0.02900160514330208, 1016.0, 0.029098700127956456, 1017.0, 0.02919578540359813, 1018.0, 0.029292860971197654, 1019.0, 0.02938992683172581, 1020.0, 0.029486982986153376, 1021.0, 0.029584029435450798, 1022.0, 0.029681066180588522, 1023.0, 0.029778093222536994, 1024.0, 0.029875110562266438, 1025.0, 0.029972118200747078, 1026.0, 0.030069116138948915, 1027.0, 0.03016610437784184, 1028.0, 0.030263082918395856, 1029.0, 0.030360051761580853, 1030.0, 0.030457010908366278, 1031.0, 0.03055396035972191, 1032.0, 0.030650900116616975, 1033.0, 0.03074783018002125, 1034.0, 0.030844750550903743, 1035.0, 0.030941661230233897, 1036.0, 0.031038562218980492, 1037.0, 0.031135453518112755, 1038.0, 0.031232335128599575, 1039.0, 0.031329207051409846, 1040.0, 0.031426069287511904, 1041.0, 0.03152292183787497, 1042.0, 0.03161976470346706, 1043.0, 0.031716597885256936, 1044.0, 0.031813421384212726, 1045.0, 0.03191023520130265, 1046.0, 0.03200703933749505, 1047.0, 0.0321038337937577, 1048.0, 0.032200618571058826, 1049.0, 0.03229739367036599, 1050.0, 0.0323941590926472, 1051.0, 0.03249091483887001, 1052.0, 0.03258766091000187, 1053.0, 0.03268439730701034, 1054.0, 0.03278112403086286, 1055.0, 0.03287784108252667, 1056.0, 0.03297454846296877, 1057.0, 0.03307124617315638, 1058.0, 0.033167934214056394, 1059.0, 0.03326461258663571, 1060.0, 0.03336128129186133, 1061.0, 0.0334579403306996, 1062.0, 0.03355458970411729, 1063.0, 0.03365122941308096, 1064.0, 0.03374785945855685, 1065.0, 0.03384447984151129, 1066.0, 0.0339410905629105, 1067.0, 0.03403769162372072, 1068.0, 0.03413428302490773, 1069.0, 0.03423086476743753, 1070.0, 0.03432743685227613, 1071.0, 0.03442399928038897, 1072.0, 0.03452055205274185, 1073.0, 0.034617095170300316, 1074.0, 0.034713628634029714, 1075.0, 0.03481015244489516, 1076.0, 0.034906666603862324, 1077.0, 0.0350031711118961, 1078.0, 0.03509966596996161, 1079.0, 0.03519615117902375, 1080.0, 0.03529262674004752, 1081.0, 0.035389092653997256, 1082.0, 0.035485548921838195, 1083.0, 0.03558199554453445, 1084.0, 0.03567843252305081, 1085.0, 0.03577485985835127, 1086.0, 0.035871277551400516, 1087.0, 0.035967685603162436, 1088.0, 0.03606408401460126, 1089.0, 0.036160472786680886, 1090.0, 0.03625685192036521, 1091.0, 0.03635322141661801, 1092.0, 0.036449581276402965, 1093.0, 0.03654593150068386, 1094.0, 0.03664227209042403, 1095.0, 0.036738603046586826, 1096.0, 0.0368349243701358, 1097.0, 0.03693123606203397, 1098.0, 0.03702753812324444, 1099.0, 0.03712383055473034, 1100.0, 0.037220113357454454, 1101.0, 0.037316386532379675, 1102.0, 0.03741265008046879, 1103.0, 0.037508904002684584, 1104.0, 0.037605148299989066, 1105.0, 0.03770138297334524, 1106.0, 0.037797608023715235, 1107.0, 0.03789382345206127, 1108.0, 0.03799002925934558, 1109.0, 0.038086225446530064, 1110.0, 0.03818241201457684, 1111.0, 0.03827858896444769, 1112.0, 0.03837475629710452, 1113.0, 0.03847091401350888, 1114.0, 0.03856706211462235, 1115.0, 0.03866320060140638, 1116.0, 0.038759329474822524, 1117.0, 0.03885544873583191, 1118.0, 0.03895155838539577, 1119.0, 0.03904765842447511, 1120.0, 0.03914374885403127, 1121.0, 0.03923982967502471, 1122.0, 0.03933590088841654, 1123.0, 0.03943196249516723, 1124.0, 0.03952801449623766, 1125.0, 0.03962405689258808, 1126.0, 0.03972008968517915, 1127.0, 0.03981611287497122, 1128.0, 0.03991212646292419, 1129.0, 0.040008130449998514, 1130.0, 0.04010412483715431, 1131.0, 0.040200109625351144, 1132.0, 0.04029608481554914, 1133.0, 0.04039205040870786, 1134.0, 0.0404880064057872, 1135.0, 0.040583952807746626, 1136.0, 0.04067988961554547, 1137.0, 0.04077581683014331, 1138.0, 0.04087173445249925, 1139.0, 0.04096764248357254, 1140.0, 0.041063540924322184, 1141.0, 0.04115942977570719, 1142.0, 0.04125530903868668, 1143.0, 0.04135117871421912, 1144.0, 0.04144703880326328, 1145.0, 0.041542889306777964, 1146.0, 0.04163873022572151, 1147.0, 0.041734561561052264, 1148.0, 0.04183038331372868, 1149.0, 0.041926195484708884, 1150.0, 0.042021998074951106, 1151.0, 0.04211779108541325, 1152.0, 0.04221357451705332, 1153.0, 0.042309348370829114, 1154.0, 0.04240511264769842, 1155.0, 0.04250086734861869, 1156.0, 0.042596612474547824, 1157.0, 0.04269234802644306, 1158.0, 0.042788074005261634, 1159.0, 0.042883790411961, 1160.0, 0.04297949724749828, 1161.0, 0.043075194512830484, 1162.0, 0.04317088220891474, 1163.0, 0.043266560336707616, 1164.0, 0.04336222889716623, 1165.0, 0.04345788789124727, 1166.0, 0.043553537319906854, 1167.0, 0.043649177184101884, 1168.0, 0.04374480748478882, 1169.0, 0.04384042822292378, 1170.0, 0.043936039399463, 1171.0, 0.0440316410153625, 1172.0, 0.04412723307157851, 1173.0, 0.04422281556906693, 1174.0, 0.044318388508783335, 1175.0, 0.044413951891683734, 1176.0, 0.044509505718723474, 1177.0, 0.04460504999085846, 1178.0, 0.04470058470904381, 1179.0, 0.04479610987423499, 1180.0, 0.04489162548738734, 1181.0, 0.04498713154945588, 1182.0, 0.045082628061395846, 1183.0, 0.045178115024162024, 1184.0, 0.04527359243870921, 1185.0, 0.045369060305992415, 1186.0, 0.04546451862696621, 1187.0, 0.04555996740258528, 1188.0, 0.04565540663380385, 1189.0, 0.045750836321576616, 1190.0, 0.045846256466857804, 1191.0, 0.04594166707060132, 1192.0, 0.04603706813376163, 1193.0, 0.04613245965729251, 1194.0, 0.046227841642148104, 1195.0, 0.04632321408928197, 1196.0, 0.04641857699964813, 1197.0, 0.04651393037419993, 1198.0, 0.04660927421389105, 1199.0, 0.04670460851967495, 1200.0, 0.04679993329250498, 1201.0, 0.046895248533334155, 1202.0, 0.046990554243115934, 1203.0, 0.04708585042280333, 1204.0, 0.04718113707334903, 1205.0, 0.04727641419570616, 1206.0, 0.0473716817908274, 1207.0, 0.04746693985966555, 1208.0, 0.047562188403172945, 1209.0, 0.04765742742230239, 1210.0, 0.0477526569180059, 1211.0, 0.04784787689123626, 1212.0, 0.04794308734294506, 1213.0, 0.04803828827408496, 1214.0, 0.04813347968560766, 1215.0, 0.04822866157846517, 1216.0, 0.048323833953609285, 1217.0, 0.04841899681199169, 1218.0, 0.04851415015456395, 1219.0, 0.04860929398227787, 1220.0, 0.04870442829608468, 1221.0, 0.04879955309693573, 1222.0, 0.04889466838578238, 1223.0, 0.04898977416357564, 1224.0, 0.04908487043126675, 1225.0, 0.04917995718980639, 1226.0, 0.04927503444014569, 1227.0, 0.04937010218323534, 1228.0, 0.04946516042002591, 1229.0, 0.04956020915146819, 1230.0, 0.04965524837851243, 1231.0, 0.04975027810210919, 1232.0, 0.04984529832320872, 1233.0, 0.049940309042761144, 1234.0, 0.050035310261716925, 1235.0, 0.05013030198102553, 1236.0, 0.05022528420163719, 1237.0, 0.050320256924501816, 1238.0, 0.050415220150568874, 1239.0, 0.05051017388078827, 1240.0, 0.05060511811610935, 1241.0, 0.05070005285748147, 1242.0, 0.050794978105854205, 1243.0, 0.050889893862176794, 1244.0, 0.050984800127398255, 1245.0, 0.05107969690246761, 1246.0, 0.05117458418833398, 1247.0, 0.051269461985946174, 1248.0, 0.05136433029625309, 1249.0, 0.051459189120203086, 1250.0, 0.051554038458745066, 1251.0, 0.051648878312827495, 1252.0, 0.051743708683398726, 1253.0, 0.05183852957140689, 1254.0, 0.05193334097780056, 1255.0, 0.05202814290352742, 1256.0, 0.052122935349535826, 1257.0, 0.052217718316773465, 1258.0, 0.052312491806188355, 1259.0, 0.05240725581872807, 1260.0, 0.05250201035534041, 1261.0, 0.05259675541697284, 1262.0, 0.05269149100457282, 1263.0, 0.05278621711908782, 1264.0, 0.052880933761464854, 1265.0, 0.05297564093265117, 1266.0, 0.053070338633594005, 1267.0, 0.05316502686524005, 1268.0, 0.05325970562853655, 1269.0, 0.05335437492442996, 1270.0, 0.0534490347538672, 1271.0, 0.053543685117794726, 1272.0, 0.05363832601715912, 1273.0, 0.05373295745290674, 1274.0, 0.05382757942598393, 1275.0, 0.05392219193733683, 1276.0, 0.0540167949879119, 1277.0, 0.05411138857865461, 1278.0, 0.05420597271051142, 1279.0, 0.0543005473844278, 1280.0, 0.05439511260134966, 1281.0, 0.0544896683622228, 1282.0, 0.05458421466799246, 1283.0, 0.05467875151960422, 1284.0, 0.054773278918003654, 1285.0, 0.05486779686413579, 1286.0, 0.05496230535894586, 1287.0, 0.0550568044033789, 1288.0, 0.055151293998380146, 1289.0, 0.05524577414489429, 1290.0, 0.055340244843866127, 1291.0, 0.05543470609624035, 1292.0, 0.055529157902961646, 1293.0, 0.05562360026497459, 1294.0, 0.05571803318322344, 1295.0, 0.055812456658652754, 1296.0, 0.055906870692206456, 1297.0, 0.05600127528482901, 1298.0, 0.05609567043746422, 1299.0, 0.0561900561510561, 1300.0, 0.05628443242654857, 1301.0, 0.056378799264885315, 1302.0, 0.05647315666701014, 1303.0, 0.056567504633866506, 1304.0, 0.056661843166397774, 1305.0, 0.056756172265547744, 1306.0, 0.056850491932259106, 1307.0, 0.05694480216747566, 1308.0, 0.05703910297213999, 1309.0, 0.05713339434719544, 1310.0, 0.05722767629358494, 1311.0, 0.057321948812250945, 1312.0, 0.057416211904136705, 1313.0, 0.057510465570184355, 1314.0, 0.05760470981133681, 1315.0, 0.05769894462853631, 1316.0, 0.057793170022725104, 1317.0, 0.057887385994845886, 1318.0, 0.05798159254584023, 1319.0, 0.05807578967665061, 1320.0, 0.05816997738821883, 1321.0, 0.05826415568148691, 1322.0, 0.058358324557396535, 1323.0, 0.058452484016889295, 1324.0, 0.05854663406090699, 1325.0, 0.05864077469039086, 1326.0, 0.05873490590628272, 1327.0, 0.058829027709523474, 1328.0, 0.05892314010105448, 1329.0, 0.059017243081816884, 1330.0, 0.05911133665275181, 1331.0, 0.05920542081479996, 1332.0, 0.05929949556890235, 1333.0, 0.05939356091599979, 1334.0, 0.05948761685703263, 1335.0, 0.05958166339294202, 1336.0, 0.05967570052466764, 1337.0, 0.05976972825315041, 1338.0, 0.05986374657933036, 1339.0, 0.05995775550414795, 1340.0, 0.060051755028542986, 1341.0, 0.0601457451534555, 1342.0, 0.06023972587982551, 1343.0, 0.06033369720859272, 1344.0, 0.06042765914069703, 1345.0, 0.06052161167707781, 1346.0, 0.060615554818674755, 1347.0, 0.06070948856642722, 1348.0, 0.06080341292127467, 1349.0, 0.06089732788415614, 1350.0, 0.06099123345601076, 1351.0, 0.0610851296377779, 1352.0, 0.06117901643039625, 1353.0, 0.06127289383480472, 1354.0, 0.06136676185194223, 1355.0, 0.06146062048274714, 1356.0, 0.06155446972815848, 1357.0, 0.06164830958911438, 1358.0, 0.06174214006655343, 1359.0, 0.06183596116141388, 1360.0, 0.06192977287463386, 1361.0, 0.06202357520715163, 1362.0, 0.062117368159905095, 1363.0, 0.062211151733832404, 1364.0, 0.062304925929870913, 1365.0, 0.062398690748958874, 1366.0, 0.062492446192033646, 1367.0, 0.06258619226003292, 1368.0, 0.06267992895389418, 1369.0, 0.06277365627455456, 1370.0, 0.06286737422295163, 1371.0, 0.06296108280002244, 1372.0, 0.06305478200670389, 1373.0, 0.06314847184393335, 1374.0, 0.0632421523126474, 1375.0, 0.06333582341378297, 1376.0, 0.06342948514827695, 1377.0, 0.06352313751706562, 1378.0, 0.06361678052108566, 1379.0, 0.06371041416127354, 1380.0, 0.06380403843856552, 1381.0, 0.06389765335389785, 1382.0, 0.06399125890820678, 1383.0, 0.06408485510242823, 1384.0, 0.06417844193749833, 1385.0, 0.06427201941435268, 1386.0, 0.0643655875339273, 1387.0, 0.06445914629715777, 1388.0, 0.06455269570497968, 1389.0, 0.06464623575832851, 1390.0, 0.06473976645813972, 1391.0, 0.0648332878053487, 1392.0, 0.06492679980089056, 1393.0, 0.06502030244570023, 1394.0, 0.06511379574071297, 1395.0, 0.06520727968686368, 1396.0, 0.06530075428508719, 1397.0, 0.0653942195363183, 1398.0, 0.06548767544149148, 1399.0, 0.06558112200154143, 1400.0, 0.06567455921740262, 1401.0, 0.06576798709000942, 1402.0, 0.06586140562029597, 1403.0, 0.06595481480919685, 1404.0, 0.06604821465764554, 1405.0, 0.06614160516657652, 1406.0, 0.0662349863369236, 1407.0, 0.06632835816962035, 1408.0, 0.06642172066560081, 1409.0, 0.06651507382579847, 1410.0, 0.06660841765114689, 1411.0, 0.06670175214257934, 1412.0, 0.06679507730102952, 1413.0, 0.06688839312743022, 1414.0, 0.06698169962271505, 1415.0, 0.0670749967878167, 1416.0, 0.06716828462366842, 1417.0, 0.0672615631312029, 1418.0, 0.06735483231135297, 1419.0, 0.06744809216505154, 1420.0, 0.06754134269323087, 1421.0, 0.06763458389682375, 1422.0, 0.06772781577676235, 1423.0, 0.06782103833397912, 1424.0, 0.06791425156940623, 1425.0, 0.0680074554839758, 1426.0, 0.0681006500786201, 1427.0, 0.06819383535427082, 1428.0, 0.06828701131185988, 1429.0, 0.06838017795231899, 1430.0, 0.06847333527657995, 1431.0, 0.06856648328557413, 1432.0, 0.06865962198023334, 1433.0, 0.06875275136148862, 1434.0, 0.06884587143027154, 1435.0, 0.06893898218751293, 1436.0, 0.06903208363414426, 1437.0, 0.06912517577109656, 1438.0, 0.06921825859930042, 1439.0, 0.06931133211968687, 1439.9999999999998, 0.06940439633318674, 1440.0, 0.06940439633318674, 1440.0000000000002, 0.06940439633318518, 1441.0, 0.0628930854128038, 1442.0, 0.05701091409537806, 1443.0, 0.051698010881279455, 1444.0, 0.04690020179746357, 1445.0, 0.04256846820613169, 1446.0, 0.038658456209717085};
        BooleanExpression expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.PT4, BooleanExpression.createParameterFloat(1.0E-4), BooleanExpression.createParameterFloat(0.1), BooleanExpression.createParameterFloat(720.0), BooleanExpression.createParameterFloat(0.0));
        this.assertCompute(expr, 1.0E-10, result);
        expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.PT4, BooleanExpression.createParameterFloat(1.0E-4), BooleanExpression.createParameterFloat(0.1), BooleanExpression.createParameterFloat(720.0), BooleanExpression.createParameterFloat(720.0));
        this.assertCompute(expr, 1.0E-10, result);
    }

    /*
     * Opcode count of 16345 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    @Test
    public void testTPEc() {
        double[] result = new double[]{0.0, 0.0, Double.MIN_VALUE, 0.0, 1.0, 0.009950166250831893, 2.0, 0.019801326693244747, 3.0, 0.029554466451491845, 4.0, 0.03921056084767682, 5.0, 0.048770575499285984, 6.0, 0.05823546641575128, 7.0, 0.06760618009405173, 8.0, 0.07688365361336424, 9.0, 0.08606881472877181, 10.0, 0.09516258196404048, 11.0, 0.10416586470347178, 12.0, 0.11307956328284252, 13.0, 0.1219045690794387, 14.0, 0.13064176460119414, 15.0, 0.1392920235749422, 16.0, 0.14785621103378865, 17.0, 0.1563351834036163, 18.0, 0.164729788588728, 19.0, 0.1730408660566377, 20.0, 0.18126924692201818, 21.0, 0.18941575402981292, 22.0, 0.1974812020375215, 23.0, 0.20546639749666595, 24.0, 0.21337213893344664, 25.0, 0.22119921692859512, 26.0, 0.22894841419643375, 27.0, 0.23662050566314685, 28.0, 0.24421625854427453, 29.0, 0.25173643242143484, 30.0, 0.2591817793182821, 31.0, 0.26655304377571076, 32.0, 0.27385096292630906, 33.0, 0.28107626656807383, 34.0, 0.28822967723739024, 35.0, 0.29531191028128656, 36.0, 0.302323673928969, 37.0, 0.3092656693626453, 38.0, 0.31613859078764417, 39.0, 0.32294312550183535, 40.0, 0.3296799539643607, 41.0, 0.3363497498636807, 42.0, 0.34295318018494325, 43.0, 0.3494909052766835, 44.0, 0.3559635789168587, 45.0, 0.3623718483782268, 46.0, 0.36871635449307405, 47.0, 0.3749977317172992, 48.0, 0.38121660819385916, 49.0, 0.3873736058155839, 50.0, 0.3934693402873666, 51.0, 0.3995044211877341, 52.0, 0.40547945202980573, 53.0, 0.4113950303216448, 54.0, 0.41725174762601036, 55.0, 0.42305018961951335, 56.0, 0.42879093615118513, 57.0, 0.4344745613004629, 58.0, 0.44010163343459796, 59.0, 0.4456727152654929, 60.0, 0.4511883639059735, 61.0, 0.4566491309255002, 62.0, 0.4620555624053255, 63.0, 0.4674081989931028, 64.0, 0.47270757595695145, 65.0, 0.47795422323898396, 66.0, 0.4831486655083008, 67.0, 0.48829142221345756, 68.0, 0.49338300763441045, 69.0, 0.49842393093394455, 70.0, 0.5034146962085906, 71.0, 0.5083558025390349, 72.0, 0.5132477440400283, 73.0, 0.5180910099097975, 74.0, 0.5228860844789656, 75.0, 0.5276334472589853, 76.0, 0.5323335729900908, 77.0, 0.5369869316887719, 78.0, 0.5415939886947765, 79.0, 0.5461552047176441, 80.0, 0.5506710358827784, 81.0, 0.5551419337770589, 82.0, 0.5595683454940008, 83.0, 0.5639507136784645, 84.0, 0.5682894765709203, 85.0, 0.5725850680512733, 86.0, 0.5768379176822511, 87.0, 0.581048450752361, 88.0, 0.5852170883184187, 89.0, 0.5893442472476546, 90.0, 0.5934303402594009, 91.0, 0.597475775966364, 92.0, 0.6014809589154858, 93.0, 0.6054462896283989, 94.0, 0.6093721646414789, 95.0, 0.6132589765454988, 96.0, 0.6171071140248879, 97.0, 0.6209169618966012, 98.0, 0.6246889011486004, 99.0, 0.6284233089779543, 100.0, 0.6321205588285577, 101.0, 0.6357810204284766, 102.0, 0.6394050598269216, 103.0, 0.6429930394308526, 104.0, 0.6465453180412198, 105.0, 0.6500622508888447, 106.0, 0.6535441896699425, 107.0, 0.6569914825812934, 108.0, 0.6604044743550609, 109.0, 0.6637835062932667, 110.0, 0.6671289163019205, 111.0, 0.670441038924811, 112.0, 0.6737202053769605, 113.0, 0.6769667435777471, 114.0, 0.6801809781836962, 115.0, 0.6833632306209468, 116.0, 0.6865138191173947, 117.0, 0.689633058734515, 118.0, 0.6927212613988687, 119.0, 0.6957787359332959, 120.0, 0.6988057880877979, 121.0, 0.7018027205701126, 122.0, 0.7047698330759857, 123.0, 0.7077074223191406, 124.0, 0.7106157820609493, 125.0, 0.7134952031398099, 126.0, 0.7163459735002295, 127.0, 0.7191683782216203, 128.0, 0.7219626995468058, 129.0, 0.7247292169102477, 130.0, 0.7274682069659875, 131.0, 0.7301799436153131, 132.0, 0.7328646980341497, 133.0, 0.735522738700176, 134.0, 0.738154331419674, 135.0, 0.7407597393541085, 136.0, 0.7433392230464442, 137.0, 0.7458930404471997, 138.0, 0.7484214469402435, 139.0, 0.7509246953683318, 140.0, 0.7534030360583935, 141.0, 0.7558567168465629, 142.0, 0.7582859831029636, 143.0, 0.7606910777562454, 144.0, 0.7630722413178782, 145.0, 0.7654297119062023, 146.0, 0.7677637252702412, 147.0, 0.7700745148132762, 148.0, 0.7723623116161873, 149.0, 0.7746273444605613, 150.0, 0.7768698398515702, 151.0, 0.7790900220406218, 152.0, 0.7812881130477852, 153.0, 0.783464332683993, 154.0, 0.785618898573022, 155.0, 0.7877520261732569, 156.0, 0.7898639287992353, 157.0, 0.7919548176429796, 158.0, 0.7940249017951165, 159.0, 0.7960743882657866, 160.0, 0.7981034820053446, 161.0, 0.8001123859248556, 162.0, 0.8021013009163853, 163.0, 0.8040704258730906, 164.0, 0.8060199577091081, 165.0, 0.8079500913792459, 166.0, 0.8098610198984795, 167.0, 0.8117529343612533, 168.0, 0.81362602396059, 169.0, 0.8154804760070107, 170.0, 0.8173164759472653, 171.0, 0.8191342073828779, 172.0, 0.8209338520885068, 173.0, 0.8227155900301222, 174.0, 0.8244795993830032, 175.0, 0.8262260565495549, 176.0, 0.8279551361769495, 177.0, 0.8296670111745905, 178.0, 0.8313618527314045, 179.0, 0.8330398303329594, 180.0, 0.8347011117784134, 181.0, 0.836345863197296, 182.0, 0.8379742490661193, 183.0, 0.8395864322248272, 184.0, 0.8411825738930794, 185.0, 0.8427628336863724, 186.0, 0.8443273696320027, 187.0, 0.8458763381848686, 188.0, 0.8474098942431161, 189.0, 0.8489281911636292, 190.0, 0.8504313807773649, 191.0, 0.8519196134045376, 192.0, 0.8533930378696498, 193.0, 0.8548518015163763, 194.0, 0.856296050222297, 195.0, 0.8577259284134864, 196.0, 0.8591415790789549, 197.0, 0.8605431437849491, 198.0, 0.8619307626891072, 199.0, 0.8633045745544762, 200.0, 0.8646647167633873, 201.0, 0.8660113253311951, 202.0, 0.8673445349198783, 203.0, 0.868664478851507, 204.0, 0.8699712891215741, 205.0, 0.8712650964121957, 206.0, 0.8725460301051793, 207.0, 0.8738142182949612, 208.0, 0.8750697878014175, 209.0, 0.8763128641825452, 210.0, 0.8775435717470181, 211.0, 0.8787620335666183, 212.0, 0.8799683714885432, 213.0, 0.8811627061475904, 214.0, 0.8823451569782208, 215.0, 0.883515842226503, 216.0, 0.8846748789619375, 217.0, 0.8858223830891635, 218.0, 0.8869584693595501, 219.0, 0.8880832513826711, 220.0, 0.8891968416376661, 221.0, 0.8902993514844886, 222.0, 0.891390891175042, 223.0, 0.8924715698642051, 224.0, 0.8935414956207473, 225.0, 0.8946007754381357, 226.0, 0.8956495152452351, 227.0, 0.8966878199168998, 228.0, 0.8977157932844626, 229.0, 0.8987335381461166, 230.0, 0.8997411562771963, 231.0, 0.9007387484403544, 232.0, 0.9017264143956385, 233.0, 0.9027042529104672, 234.0, 0.9036723617695069, 235.0, 0.9046308377844504, 236.0, 0.9055797768036976, 237.0, 0.9065192737219415, 238.0, 0.9074494224896568, 239.0, 0.9083703161224952, 240.0, 0.9092820467105875, 241.0, 0.9101847054277523, 242.0, 0.9110783825406137, 243.0, 0.9119631674176274, 244.0, 0.9128391485380187, 245.0, 0.9137064135006295, 246.0, 0.9145650490326788, 247.0, 0.9154151409984354, 248.0, 0.9162567744078041, 249.0, 0.9170900334248273, 250.0, 0.9179150013761012, 251.0, 0.9187317607591083, 252.0, 0.9195403932504675, 253.0, 0.920340979714102, 254.0, 0.9211336002093251, 255.0, 0.9219183339988468, 256.0, 0.9226952595567003, 257.0, 0.9234644545760885, 258.0, 0.9242259959771545, 259.0, 0.9249799599146731, 260.0, 0.9257264217856661, 261.0, 0.9264654562369429, 262.0, 0.9271971371725645, 263.0, 0.9279215377612339, 264.0, 0.9286387304436139, 265.0, 0.9293487869395705, 266.0, 0.9300517782553447, 267.0, 0.9307477746906541, 268.0, 0.9314368458457221, 269.0, 0.9321190606282386, 270.0, 0.9327944872602503, 271.0, 0.9334631932849832, 272.0, 0.9341252455735971, 273.0, 0.9347807103318725, 274.0, 0.9354296531068316, 275.0, 0.9360721387932924, 276.0, 0.9367082316403593, 277.0, 0.9373379952578469, 278.0, 0.9379614926226417, 279.0, 0.9385787860849999, 280.0, 0.9391899373747821, 281.0, 0.9397950076076265, 282.0, 0.9403940572910606, 283.0, 0.9409871463305521, 284.0, 0.9415743340354992, 285.0, 0.9421556791251615, 286.0, 0.9427312397345327, 287.0, 0.9433010734201531, 288.0, 0.9438652371658662, 289.0, 0.944423787388517, 290.0, 0.9449767799435927, 291.0, 0.9455242701308102, 292.0, 0.946066312699644, 293.0, 0.9466029618548029, 294.0, 0.9471342712616496, 295.0, 0.9476602940515676, 296.0, 0.9481810828272742, 297.0, 0.9486966896680809, 298.0, 0.9492071661351015, 299.0, 0.9497125632764082, 300.0, 0.950212931632136, 301.0, 0.9507083212395379, 302.0, 0.951198781637987, 303.0, 0.9516843618739322, 304.0, 0.9521651105058017, 305.0, 0.9526410756088591, 306.0, 0.9531123047800115, 307.0, 0.9535788451425687, 308.0, 0.9540407433509558, 309.0, 0.9544980455953784, 310.0, 0.9549507976064422, 311.0, 0.9553990446597255, 312.0, 0.9558428315803071, 313.0, 0.9562822027472491, 314.0, 0.9567172020980341, 315.0, 0.9571478731329598, 316.0, 0.9575742589194887, 317.0, 0.9579964020965545, 318.0, 0.9584143448788268, 319.0, 0.9588281290609323, 320.0, 0.9592377960216338, 321.0, 0.9596433867279689, 322.0, 0.9600449417393461, 323.0, 0.9604425012116012, 324.0, 0.9608361049010129, 325.0, 0.961225792168278, 326.0, 0.961611601982448, 327.0, 0.9619935729248257, 328.0, 0.9623717431928238, 329.0, 0.9627461506037842, 330.0, 0.96311683259876, 331.0, 0.9634838262462596, 332.0, 0.9638471682459536, 333.0, 0.9642068949323447, 334.0, 0.9645630422784014, 335.0, 0.964915645899155, 336.0, 0.9652647410552614, 337.0, 0.9656103626565273, 338.0, 0.9659525452654006, 339.0, 0.9662913231004276, 340.0, 0.9666267300396739, 341.0, 0.966958799624113, 342.0, 0.9672875650609802, 343.0, 0.967613059227093, 344.0, 0.9679353146721392, 345.0, 0.9682543636219321, 346.0, 0.9685702379816323, 347.0, 0.9688829693389391, 348.0, 0.9691925889672489, 349.0, 0.9694991278287826, 350.0, 0.9698026165776815, 351.0, 0.9701030855630737, 352.0, 0.970400564832108, 353.0, 0.9706950841329592, 354.0, 0.9709866729178029, 355.0, 0.9712753603457606, 356.0, 0.9715611752858155, 357.0, 0.9718441463197, 358.0, 0.972124301744753, 359.0, 0.9724016695767507, 360.0, 0.9726762775527075, 361.0, 0.9729481531336496, 362.0, 0.9732173235073618, 363.0, 0.9734838155911059, 364.0, 0.973747656034312, 365.0, 0.9740088712212447, 366.0, 0.9742674872736401, 367.0, 0.9745235300533189, 368.0, 0.9747770251647728, 369.0, 0.9750279979577239, 370.0, 0.9752764735296606, 371.0, 0.9755224767283474, 372.0, 0.9757660321543089, 373.0, 0.9760071641632908, 374.0, 0.976245896868695, 375.0, 0.9764822541439909, 376.0, 0.976716259625103, 377.0, 0.9769479367127745, 378.0, 0.977177308574907, 379.0, 0.9774043981488781, 380.0, 0.9776292281438345, 381.0, 0.9778518210429626, 382.0, 0.9780721991057384, 383.0, 0.9782903843701515, 384.0, 0.9785063986549101, 385.0, 0.9787202635616228, 386.0, 0.9789320004769586, 387.0, 0.9791416305747853, 388.0, 0.9793491748182874, 389.0, 0.9795546539620623, 390.0, 0.9797580885541957, 391.0, 0.979959498938316, 392.0, 0.9801589052556298, 393.0, 0.9803563274469347, 394.0, 0.9805517852546146, 395.0, 0.9807452982246131, 396.0, 0.9809368857083883, 397.0, 0.9811265668648486, 398.0, 0.9813143606622672, 399.0, 0.9815002858801808, 400.0, 0.9816843611112658, 401.0, 0.981866604763199, 402.0, 0.9820470350604972, 403.0, 0.9822256700463405, 404.0, 0.9824025275843766, 405.0, 0.9825776253605065, 406.0, 0.9827509808846537, 407.0, 0.9829226114925153, 408.0, 0.9830925343472947, 409.0, 0.9832607664414194, 410.0, 0.9834273245982388, 411.0, 0.9835922254737074, 412.0, 0.9837554855580501, 413.0, 0.9839171211774116, 414.0, 0.9840771484954883, 415.0, 0.9842355835151455, 416.0, 0.9843924420800172, 417.0, 0.9845477398760905, 418.0, 0.9847014924332744, 419.0, 0.984853715126953, 420.0, 0.9850044231795223, 421.0, 0.9851536316619132, 422.0, 0.9853013554950982, 423.0, 0.9854476094515838, 424.0, 0.9855924081568876, 425.0, 0.9857357660910008, 426.0, 0.985877697589836, 427.0, 0.9860182168466617, 428.0, 0.9861573379135204, 429.0, 0.9862950747026351, 430.0, 0.9864314409877991, 431.0, 0.9865664504057547, 432.0, 0.9867001164575563, 433.0, 0.9868324525099202, 434.0, 0.9869634717965623, 435.0, 0.9870931874195201, 436.0, 0.9872216123504642, 437.0, 0.9873487594319947, 438.0, 0.9874746413789256, 439.0, 0.9875992707795566, 440.0, 0.9877226600969315, 441.0, 0.987844821670085, 442.0, 0.9879657677152762, 443.0, 0.9880855103272104, 444.0, 0.9882040614802484, 445.0, 0.9883214330296045, 446.0, 0.9884376367125315, 447.0, 0.9885526841494943, 448.0, 0.9886665868453326, 449.0, 0.9887793561904109, 450.0, 0.9888910034617577, 451.0, 0.9890015398241931, 452.0, 0.9891109763314455, 453.0, 0.9892193239272569, 454.0, 0.9893265934464771, 455.0, 0.9894327956161474, 456.0, 0.9895379410565732, 457.0, 0.9896420402823863, 458.0, 0.989745103703596, 459.0, 0.9898471416266302, 460.0, 0.9899481642553665, 461.0, 0.9900481816921516, 462.0, 0.9901472039388127, 463.0, 0.9902452408976571, 464.0, 0.9903423023724622, 465.0, 0.9904383980694565, 466.0, 0.9905335375982897, 467.0, 0.9906277304729939, 468.0, 0.9907209861129352, 469.0, 0.9908133138437554, 470.0, 0.9909047228983042, 471.0, 0.9909952224175634, 472.0, 0.9910848214515604, 473.0, 0.9911735289602733, 474.0, 0.9912613538145267, 475.0, 0.9913483047968794, 476.0, 0.9914343906025019, 477.0, 0.9915196198400468, 478.0, 0.9916040010325086, 479.0, 0.9916875426180769, 480.0, 0.99177025295098, 481.0, 0.99185214030232, 482.0, 0.9919332128609004, 483.0, 0.9920134787340446, 484.0, 0.9920929459484066, 485.0, 0.9921716224507743, 486.0, 0.9922495161088634, 487.0, 0.9923266347121045, 488.0, 0.9924029859724224, 489.0, 0.9924785775250067, 490.0, 0.9925534169290756, 491.0, 0.992627511668632, 492.0, 0.9927008691532114, 493.0, 0.9927734967186236, 494.0, 0.9928454016276854, 495.0, 0.9929165910709479, 496.0, 0.9929870721674146, 497.0, 0.9930568519652538, 498.0, 0.9931259374425038, 499.0, 0.9931943355077695, 500.0, 0.9932620530009145, 501.0, 0.9933290966937447, 502.0, 0.9933954732906852, 503.0, 0.9934611894294509, 504.0, 0.9935262516817106, 505.0, 0.9935906665537436, 506.0, 0.9936544404870908, 507.0, 0.9937175798591988, 508.0, 0.9937800909840574, 509.0, 0.9938419801128311, 510.0, 0.9939032534344844, 511.0, 0.9939639170764004, 512.0, 0.994023977104994, 513.0, 0.9940834395263182, 514.0, 0.9941423102866643, 515.0, 0.9942005952731578, 516.0, 0.9942583003143458, 517.0, 0.9943154311807804, 518.0, 0.9943719935855959, 519.0, 0.99442799318508, 520.0, 0.9944834355792392, 521.0, 0.9945383263123593, 522.0, 0.9945926708735591, 523.0, 0.9946464746973401, 524.0, 0.9946997431641296, 525.0, 0.9947524816008186, 526.0, 0.9948046952812948, 527.0, 0.9948563894269696, 528.0, 0.9949075692073008, 529.0, 0.9949582397403091, 530.0, 0.9950084060930898, 531.0, 0.9950580732823202, 532.0, 0.9951072462747605, 533.0, 0.995155929987751, 534.0, 0.9952041292897036, 535.0, 0.9952518490005885, 536.0, 0.9952990938924168, 537.0, 0.9953458686897168, 538.0, 0.9953921780700072, 539.0, 0.995438026664265, 540.0, 0.9954834190573874, 541.0, 0.9955283597886516, 542.0, 0.9955728533521685, 543.0, 0.9956169041973312, 544.0, 0.9956605167292611, 545.0, 0.9957036953092476, 546.0, 0.9957464442551849, 547.0, 0.995788767842003, 548.0, 0.9958306703020959, 549.0, 0.9958721558257445, 550.0, 0.995913228561536, 551.0, 0.9959538926167778, 552.0, 0.9959941520579095, 553.0, 0.9960340109109089, 554.0, 0.9960734731616944, 555.0, 0.9961125427565238, 556.0, 0.9961512236023895, 557.0, 0.996189519567408, 558.0, 0.9962274344812078, 559.0, 0.996264972135312, 560.0, 0.996302136283517, 561.0, 0.996338930642269, 562.0, 0.9963753588910342, 563.0, 0.9964114246726681, 564.0, 0.9964471315937786, 565.0, 0.9964824832250879, 566.0, 0.9965174831017883, 567.0, 0.9965521347238969, 568.0, 0.9965864415566046, 569.0, 0.9966204070306233, 570.0, 0.9966540345425288, 571.0, 0.9966873274551001, 572.0, 0.9967202890976564, 573.0, 0.9967529227663894, 574.0, 0.9967852317246931, 575.0, 0.9968172192034903, 576.0, 0.9968488884015556, 577.0, 0.996880242485835, 578.0, 0.9969112845917633, 579.0, 0.9969420178235767, 580.0, 0.9969724452546241, 581.0, 0.9970025699276742, 582.0, 0.9970323948552191, 583.0, 0.9970619230197765, 584.0, 0.9970911573741874, 585.0, 0.9971201008419117, 586.0, 0.9971487563173204, 587.0, 0.9971771266659847, 588.0, 0.9972052147249632, 589.0, 0.9972330233030852, 590.0, 0.9972605551812316, 591.0, 0.9972878131126134, 592.0, 0.9973147998230462, 593.0, 0.9973415180112236, 594.0, 0.9973679703489868, 595.0, 0.9973941594815915, 596.0, 0.9974200880279728, 597.0, 0.997445758581007, 598.0, 0.9974711737077707, 599.0, 0.9974963359497979, 600.0, 0.9975212478233336, 601.0, 0.9975459118195861, 602.0, 0.9975703304049754, 603.0, 0.9975945060213804, 604.0, 0.9976184410863831, 605.0, 0.9976421379935098, 606.0, 0.9976655991124709, 607.0, 0.9976888267893979, 608.0, 0.9977118233470779, 609.0, 0.9977345910851857, 610.0, 0.9977571322805142, 611.0, 0.9977794491872017, 612.0, 0.9978015440369574, 613.0, 0.9978234190392848, 614.0, 0.9978450763817024, 615.0, 0.9978665182299623, 616.0, 0.9978877467282673, 617.0, 0.9979087639994849, 618.0, 0.9979295721453597, 619.0, 0.9979501732467237, 620.0, 0.9979705693637043, 621.0, 0.9979907625359299, 622.0, 0.9980107547827348, 623.0, 0.9980305481033603, 624.0, 0.9980501444771549, 625.0, 0.9980695458637723, 626.0, 0.9980887542033674, 627.0, 0.9981077714167901, 628.0, 0.9981265994057775, 629.0, 0.9981452400531445, 630.0, 0.9981636952229711, 631.0, 0.9981819667607897, 632.0, 0.9982000564937694, 633.0, 0.9982179662308985, 634.0, 0.9982356977631657, 635.0, 0.9982532528637389, 636.0, 0.9982706332881428, 637.0, 0.9982878407744344, 638.0, 0.9983048770433768, 639.0, 0.9983217437986107, 640.0, 0.998338442726826, 641.0, 0.9983549754979294, 642.0, 0.9983713437652117, 643.0, 0.9983875491655133, 644.0, 0.9984035933193878, 645.0, 0.9984194778312638, 646.0, 0.9984352042896059, 647.0, 0.9984507742670728, 648.0, 0.9984661893206755, 649.0, 0.9984814509919321, 650.0, 0.9984965608070224, 651.0, 0.9985115202769406, 652.0, 0.998526330897646, 653.0, 0.9985409941502131, 654.0, 0.9985555115009794, 655.0, 0.9985698844016921, 656.0, 0.9985841142896532, 657.0, 0.9985982025878634, 658.0, 0.9986121507051641, 659.0, 0.9986259600363788, 660.0, 0.9986396319624521, 661.0, 0.998653167850588, 662.0, 0.9986665690543867, 663.0, 0.9986798369139795, 664.0, 0.9986929727561636, 665.0, 0.9987059778945342, 666.0, 0.9987188536296158, 667.0, 0.9987316012489927, 668.0, 0.9987442220274376, 669.0, 0.9987567172270387, 670.0, 0.9987690880973266, 671.0, 0.9987813358753983, 672.0, 0.998793461786042, 673.0, 0.9988054670418588, 674.0, 0.9988173528433845, 675.0, 0.9988291203792088, 676.0, 0.9988407708260955, 677.0, 0.9988523053490985, 678.0, 0.9988637251016802, 679.0, 0.9988750312258252, 680.0, 0.9988862248521552, 681.0, 0.9988973071000423, 682.0, 0.9989082790777205, 683.0, 0.9989191418823967, 684.0, 0.9989298966003604, 685.0, 0.9989405443070923, 686.0, 0.9989510860673723, 687.0, 0.9989615229353846, 688.0, 0.9989718559548253, 689.0, 0.9989820861590045, 690.0, 0.9989922145709514, 691.0, 0.9990022422035156, 692.0, 0.9990121700594687, 693.0, 0.9990219991316046, 694.0, 0.9990317304028385, 695.0, 0.999041364846306, 696.0, 0.9990509034254591, 697.0, 0.9990603470941639, 698.0, 0.999069696796795, 699.0, 0.9990789534683306, 700.0, 0.9990881180344455, 701.0, 0.9990971914116039, 702.0, 0.9991061745071511, 703.0, 0.9991150682194042, 704.0, 0.9991238734377418, 705.0, 0.999132591042693, 706.0, 0.9991412219060256, 707.0, 0.9991497668908332, 708.0, 0.9991582268516215, 709.0, 0.9991666026343933, 710.0, 0.9991748950767341, 711.0, 0.999183105007895, 712.0, 0.9991912332488759, 713.0, 0.9991992806125077, 714.0, 0.9992072479035335, 715.0, 0.999215135918689, 716.0, 0.9992229454467825, 717.0, 0.9992306772687729, 718.0, 0.9992383321578492, 719.0, 0.9992459108795064, 720.0, 0.9992534141916233, 721.0, 0.9992608428445372, 722.0, 0.9992681975811195, 723.0, 0.9992754791368501, 724.0, 0.9992826882398906, 725.0, 0.9992898256111574, 726.0, 0.9992968919643935, 727.0, 0.9993038880062401, 728.0, 0.9993108144363072, 729.0, 0.9993176719472436, 730.0, 0.9993244612248061, 731.0, 0.9993311829479282, 732.0, 0.9993378377887877, 733.0, 0.9993444264128744, 734.0, 0.9993509494790559, 735.0, 0.9993574076396444, 736.0, 0.9993638015404614, 737.0, 0.9993701318209024, 738.0, 0.9993763991140006, 739.0, 0.9993826040464904, 740.0, 0.9993887472388704, 741.0, 0.999394829305465, 742.0, 0.9994008508544857, 743.0, 0.9994068124880926, 744.0, 0.999412714802454, 745.0, 0.9994185583878062, 746.0, 0.9994243438285128, 747.0, 0.9994300717031224, 748.0, 0.9994357425844274, 749.0, 0.9994413570395205, 750.0, 0.9994469156298522, 751.0, 0.9994524189112859, 752.0, 0.9994578674341544, 753.0, 0.9994632617433146, 754.0, 0.9994686023782018, 755.0, 0.999473889872884, 756.0, 0.999479124756115, 757.0, 0.9994843075513876, 758.0, 0.9994894387769856, 759.0, 0.9994945189460358, 760.0, 0.9994995485665594, 761.0, 0.9995045281415226, 762.0, 0.999509458168887, 763.0, 0.9995143391416597, 764.0, 0.9995191715479416, 765.0, 0.9995239558709778, 766.0, 0.9995286925892042, 767.0, 0.999533382176297, 768.0, 0.9995380251012184, 769.0, 0.9995426218282649, 770.0, 0.9995471728171132, 771.0, 0.9995516785228659, 772.0, 0.9995561393960971, 773.0, 0.9995605558828982, 774.0, 0.9995649284249213, 775.0, 0.9995692574594243, 776.0, 0.9995735434193144, 777.0, 0.999577786733191, 778.0, 0.999581987825389, 779.0, 0.9995861471160212, 780.0, 0.9995902650210202, 781.0, 0.9995943419521799, 782.0, 0.9995983783171967, 783.0, 0.9996023745197105, 784.0, 0.9996063309593449, 785.0, 0.9996102480317473, 786.0, 0.999614126128628, 787.0, 0.9996179656377999, 788.0, 0.9996217669432174, 789.0, 0.9996255304250139, 790.0, 0.9996292564595409, 791.0, 0.999632945419405, 792.0, 0.999636597673505, 793.0, 0.9996402135870696, 794.0, 0.999643793521693, 795.0, 0.9996473378353717, 796.0, 0.9996508468825401, 797.0, 0.9996543210141059, 798.0, 0.999657760577485, 799.0, 0.9996611659166366, 800.0, 0.9996645373720975, 801.0, 0.9996678752810161, 802.0, 0.9996711799771859, 803.0, 0.9996744517910796, 804.0, 0.999677691049881, 805.0, 0.9996808980775188, 806.0, 0.9996840731946984, 807.0, 0.9996872167189342, 808.0, 0.9996903289645813, 809.0, 0.9996934102428668, 810.0, 0.9996964608619211, 811.0, 0.9996994811268086, 812.0, 0.9997024713395585, 813.0, 0.9997054317991942, 814.0, 0.9997083628017644, 815.0, 0.9997112646403717, 816.0, 0.9997141376052026, 817.0, 0.9997169819835557, 818.0, 0.9997197980598713, 819.0, 0.9997225861157594, 820.0, 0.9997253464300279, 821.0, 0.9997280792787104, 822.0, 0.9997307849350944, 823.0, 0.9997334636697474, 824.0, 0.9997361157505453, 825.0, 0.9997387414426984, 826.0, 0.999741341008778, 827.0, 0.9997439147087429, 828.0, 0.9997464627999653, 829.0, 0.9997489855372564, 830.0, 0.9997514831728921, 831.0, 0.9997539559566379, 832.0, 0.9997564041357744, 833.0, 0.9997588279551214, 834.0, 0.999761227657063, 835.0, 0.9997636034815713, 836.0, 0.9997659556662308, 837.0, 0.9997682844462619, 838.0, 0.9997705900545445, 839.0, 0.9997728727216414, 840.0, 0.9997751326758212, 841.0, 0.9997773701430811, 842.0, 0.9997795853471698, 843.0, 0.9997817785096096, 844.0, 0.9997839498497185, 845.0, 0.9997860995846324, 846.0, 0.9997882279293264, 847.0, 0.9997903350966368, 848.0, 0.9997924212972823, 849.0, 0.9997944867398845, 850.0, 0.9997965316309894, 851.0, 0.9997985561750878, 852.0, 0.9998005605746358, 853.0, 0.9998025450300753, 854.0, 0.999804509739853, 855.0, 0.999806454900442, 856.0, 0.9998083807063596, 857.0, 0.9998102873501882, 858.0, 0.9998121750225937, 859.0, 0.9998140439123449, 860.0, 0.9998158942063324, 861.0, 0.9998177260895872, 862.0, 0.9998195397452989, 863.0, 0.9998213353548349, 864.0, 0.9998231130977574, 865.0, 0.9998248731518423, 866.0, 0.9998266156930965, 867.0, 0.9998283408957754, 868.0, 0.999830048932401, 869.0, 0.999831739973778, 870.0, 0.9998334141890124, 871.0, 0.9998350717455268, 872.0, 0.9998367128090782, 873.0, 0.9998383375437745, 874.0, 0.9998399461120905, 875.0, 0.9998415386748842, 876.0, 0.9998431153914135, 877.0, 0.9998446764193512, 878.0, 0.9998462219148012, 879.0, 0.9998477520323147, 880.0, 0.9998492669249045, 881.0, 0.9998507667440613, 882.0, 0.999852251639768, 883.0, 0.9998537217605156, 884.0, 0.9998551772533173, 885.0, 0.9998566182637237, 886.0, 0.999858044935837, 887.0, 0.9998594574123255, 888.0, 0.9998608558344383, 889.0, 0.9998622403420184, 890.0, 0.999863611073518, 891.0, 0.9998649681660112, 892.0, 0.9998663117552086, 893.0, 0.9998676419754701, 894.0, 0.9998689589598188, 895.0, 0.9998702628399543, 896.0, 0.9998715537462656, 897.0, 0.9998728318078446, 898.0, 0.9998740971524983, 899.0, 0.9998753499067624, 900.0, 0.9998765901959134, 901.0, 0.9998778181439809, 902.0, 0.9998790338737612, 903.0, 0.999880237506828, 904.0, 0.9998814291635456, 905.0, 0.9998826089630809, 906.0, 0.9998837770234146, 907.0, 0.9998849334613538, 908.0, 0.9998860783925432, 909.0, 0.999887211931477, 910.0, 0.9998883341915099, 911.0, 0.9998894452848689, 912.0, 0.9998905453226643, 913.0, 0.9998916344149007, 914.0, 0.9998927126704883, 915.0, 0.9998937801972535, 916.0, 0.99989483710195, 917.0, 0.999895883490269, 918.0, 0.9998969194668503, 919.0, 0.9998979451352924, 920.0, 0.9998989605981629, 921.0, 0.999899965957009, 922.0, 0.9999009613123676, 923.0, 0.9999019467637748, 924.0, 0.9999029224097766, 925.0, 0.9999038883479386, 926.0, 0.9999048446748553, 927.0, 0.9999057914861601, 928.0, 0.9999067288765351, 929.0, 0.99990765693972, 930.0, 0.9999085757685219, 931.0, 0.9999094854548244, 932.0, 0.999910386089597, 933.0, 0.9999112777629039, 934.0, 0.9999121605639132, 935.0, 0.9999130345809056, 936.0, 0.9999138999012837, 937.0, 0.9999147566115801, 938.0, 0.9999156047974667, 939.0, 0.9999164445437626, 940.0, 0.9999172759344434, 941.0, 0.9999180990526486, 942.0, 0.9999189139806909, 943.0, 0.9999197208000636, 944.0, 0.9999205195914495, 945.0, 0.9999213104347282, 946.0, 0.9999220934089849, 947.0, 0.9999228685925176, 948.0, 0.9999236360628451, 949.0, 0.9999243958967153, 950.0, 0.9999251481701124, 951.0, 0.9999258929582638, 952.0, 0.9999266303356495, 953.0, 0.9999273603760076, 954.0, 0.9999280831523427, 955.0, 0.9999287987369331, 956.0, 0.9999295072013379, 957.0, 0.999930208616404, 958.0, 0.9999309030522737, 959.0, 0.999931590578391, 960.0, 0.9999322712635091, 961.0, 0.9999329451756972, 962.0, 0.9999336123823469, 963.0, 0.9999342729501796, 964.0, 0.9999349269452524, 965.0, 0.9999355744329657, 966.0, 0.9999362154780684, 967.0, 0.9999368501446659, 968.0, 0.9999374784962252, 969.0, 0.999938100595582, 970.0, 0.9999387165049468, 971.0, 0.999939326285911, 972.0, 0.9999399299994532, 973.0, 0.9999405277059453, 974.0, 0.9999411194651585, 975.0, 0.9999417053362691, 976.0, 0.9999422853778648, 977.0, 0.9999428596479502, 978.0, 0.9999434282039527, 979.0, 0.9999439911027285, 980.0, 0.9999445484005678, 981.0, 0.999945100153201, 982.0, 0.9999456464158039, 983.0, 0.9999461872430029, 984.0, 0.9999467226888814, 985.0, 0.9999472528069845, 986.0, 0.9999477776503243, 987.0, 0.9999482972713856, 988.0, 0.9999488117221309, 989.0, 0.9999493210540058, 990.0, 0.9999498253179439, 991.0, 0.9999503245643718, 992.0, 0.9999508188432149, 993.0, 0.9999513082039013, 994.0, 0.9999517926953676, 995.0, 0.9999522723660632, 996.0, 0.9999527472639557, 997.0, 0.9999532174365351, 998.0, 0.9999536829308192, 999.0, 0.9999541437933578, 999.9999999999999, 0.9999546000702375, 1000.0, 0.9999546000702375, 1000.0000000000001, 0.9999546000702262, 1001.0, 0.9052788883898416, 1002.0, 0.8205548439418162, 1003.0, 0.7448260665043667, 1004.0, 0.6772272626417924, 1005.0, 0.6169755748194174, 1006.0, 0.5633627356715711, 1007.0, 0.5157479688988239, 1008.0, 0.4735515657432262, 1009.0, 0.4362490727517079, 1010.0, 0.40336603265579474, 1011.0, 0.3744732257315706, 1012.0, 0.34918236401281344, 1013.0, 0.3271421952625315, 1014.0, 0.3080349777091562, 1015.0, 0.29157329026437884, 1016.0, 0.27749714629724953, 1017.0, 0.2655713820772577, 1018.0, 0.25558329374810296, 1019.0, 0.24734049918125012, 1020.0, 0.24066900330905117, 1021.0, 0.23541144757370736, 1022.0, 0.23142552597106059, 1023.0, 0.2285825518355349, 1024.0, 0.2267661610212398, 1025.0, 0.22587113849934115, 1026.0, 0.22580235662701942, 1027.0, 0.22647381446097914, 1028.0, 0.2278077684997759, 1029.0, 0.2297339461542861, 1030.0, 0.2321888340736198, 1031.0, 0.23511503420297097, 1032.0, 0.2384606811277843, 1033.0, 0.24217891487200527, 1034.0, 0.2462274038731892, 1035.0, 0.2505679133594406, 1036.0, 0.25516591480755746, 1037.0, 0.2599902325729212, 1038.0, 0.2650127241537038, 1039.0, 0.27020799088859615, 1040.0, 0.27555311619186307, 1041.0, 0.2810274287051302, 1042.0, 0.28661228799470406, 1043.0, 0.29229089064886593, 1044.0, 0.2980480948337624, 1045.0, 0.3038702615512626, 1046.0, 0.30974511100931956, 1047.0, 0.3156615926666241, 1048.0, 0.32160976765021543, 1049.0, 0.32758070236854075, 1050.0, 0.33356637225451846, 1051.0, 0.339559574674549, 1052.0, 0.345553850131157, 1053.0, 0.3515434109699671, 1054.0, 0.35752307687682017, 1055.0, 0.3634882165188089, 1056.0, 0.3694346947445033, 1057.0, 0.3753588248142856, 1058.0, 0.38125732518205857, 1059.0, 0.38712728039515365, 1060.0, 0.39296610572048707, 1061.0, 0.39877151514230935, 1062.0, 0.40454149241064585, 1063.0, 0.41027426485006635, 1064.0, 0.4159682796660483, 1065.0, 0.4216221825112084, 1066.0, 0.42723479809629317, 1067.0, 0.43280511265129573, 1068.0, 0.4383322580605876, 1069.0, 0.44381549751270677, 1070.0, 0.44925421252062137, 1071.0, 0.45464789118199844, 1072.0, 0.4599961175614278, 1073.0, 0.4652985620877874, 1074.0, 0.47055497287009795, 1075.0, 0.4757651678444148, 1076.0, 0.48092902767262813, 1077.0, 0.4860464893215717, 1078.0, 0.491117540257654, 1079.0, 0.49614221319839513, 1080.0, 0.5011205813678249, 1081.0, 0.5060527542077538, 1082.0, 0.5109388735014868, 1083.0, 0.5157791098706924, 1084.0, 0.5205736596098697, 1085.0, 0.5253227418262482, 1086.0, 0.5300265958560113, 1087.0, 0.5346854789305061, 1088.0, 0.5392996640686099, 1089.0, 0.5438694381736913, 1090.0, 0.5483951003156564, 1091.0, 0.5528769601804269, 1092.0, 0.5573153366708763, 1093.0, 0.5617105566447747, 1094.0, 0.5660629537766642, 1095.0, 0.570372867531832, 1096.0, 0.5746406422416799, 1097.0, 0.5788666262707983, 1098.0, 0.5830511712669851, 1099.0, 0.5871946314862787, 1100.0, 0.5912973631858285, 1101.0, 0.5953597240781136, 1102.0, 0.5993820728406352, 1103.0, 0.6033647686757686, 1104.0, 0.6073081709159658, 1105.0, 0.6112126386699608, 1106.0, 0.6150785305060382, 1107.0, 0.6189062041688087, 1108.0, 0.6226960163262636, 1109.0, 0.6264483223441999, 1110.0, 0.6301634760853743, 1111.0, 0.6338418297310011, 1112.0, 0.6374837336224384, 1113.0, 0.6410895361211048, 1114.0, 0.6446595834848636, 1115.0, 0.6481942197592767, 1116.0, 0.6516937866822784, 1117.0, 0.655158623600967, 1118.0, 0.658589067399325, 1119.0, 0.6619854524358018, 1120.0, 0.66534811048979, 1121.0, 0.6686773707161189, 1122.0, 0.6719735596067721, 1123.0, 0.6752370009591162, 1124.0, 0.678468015849989, 1125.0, 0.681666922615064, 1126.0, 0.6848340368329584, 1127.0, 0.6879696713136088, 1128.0, 0.6910741360904781, 1129.0, 0.6941477384162045, 1130.0, 0.6971907827613354, 1131.0, 0.7002035708158281, 1132.0, 0.7031864014930275, 1133.0, 0.7061395709358581, 1134.0, 0.7090633725249944, 1135.0, 0.7119580968887955, 1136.0, 0.7148240319148116, 1137.0, 0.7176614627626863, 1138.0, 0.7204706718782987, 1139.0, 0.7232519390090019, 1140.0, 0.7260055412198285, 1141.0, 0.7287317529105489, 1142.0, 0.7314308458334764, 1143.0, 0.7341030891119232, 1144.0, 0.7367487492592248, 1145.0, 0.7393680901982533, 1146.0, 0.7419613732813508, 1147.0, 0.744528857310621, 1148.0, 0.747070798558521, 1149.0, 0.7495874507887048, 1150.0, 0.7520790652770696, 1151.0, 0.7545458908329663, 1152.0, 0.7569881738205362, 1153.0, 0.75940615818014, 1154.0, 0.76180008544985, 1155.0, 0.764170194786978, 1156.0, 0.7665167229896153, 1157.0, 0.7688399045181626, 1158.0, 0.7711399715168313, 1159.0, 0.7734171538350972, 1160.0, 0.7756716790490932, 1161.0, 0.7779037724829261, 1162.0, 0.7801136572299051, 1163.0, 0.7823015541736712, 1164.0, 0.7844676820092182, 1165.0, 0.7866122572637968, 1166.0, 0.7887354943176924, 1167.0, 0.7908376054248732, 1168.0, 0.7929188007335001, 1169.0, 0.7949792883062935, 1170.0, 0.7970192741407546, 1171.0, 0.7990389621892344, 1172.0, 0.8010385543788501, 1173.0, 0.8030182506312431, 1174.0, 0.8049782488821796, 1175.0, 0.806918745100988, 1176.0, 0.8088399333098347, 1177.0, 0.810742005602836, 1178.0, 0.8126251521650038, 1179.0, 0.8144895612910261, 1180.0, 0.8163354194038814, 1181.0, 0.8181629110732861, 1182.0, 0.8199722190339747, 1183.0, 0.8217635242038139, 1184.0, 0.8235370057017507, 1185.0, 0.8252928408655926, 1186.0, 0.8270312052696243, 1187.0, 0.8287522727420572, 1188.0, 0.8304562153823165, 1189.0, 0.8321432035781631, 1190.0, 0.8338134060226531, 1191.0, 0.8354669897309359, 1192.0, 0.8371041200568907, 1193.0, 0.8387249607096035, 1194.0, 0.8403296737696845, 1195.0, 0.8419184197054286, 1196.0, 0.8434913573888188, 1197.0, 0.8450486441113743, 1198.0, 0.8465904355998436, 1199.0, 0.8481168860317457, 1200.0, 0.8496281480507586, 1201.0, 0.8511243727819569, 1202.0, 0.8526057098469014, 1203.0, 0.8540723073785793, 1204.0, 0.8555243120361978, 1205.0, 0.8569618690198333, 1206.0, 0.8583851220849346, 1207.0, 0.8597942135566845, 1208.0, 0.8611892843442195, 1209.0, 0.8625704739547084, 1210.0, 0.8639379205072932, 1211.0, 0.8652917607468907, 1212.0, 0.866632130057859, 1213.0, 0.8679591624775269, 1214.0, 0.8692729907095922, 1215.0, 0.8705737461373844, 1216.0, 0.8718615588369976, 1217.0, 0.8731365575902934, 1218.0, 0.8743988698977736, 1219.0, 0.8756486219913263, 1220.0, 0.8768859388468455, 1221.0, 0.8781109441967249, 1222.0, 0.879323760542228, 1223.0, 0.8805245091657357, 1224.0, 0.8817133101428717, 1225.0, 0.8828902823545077, 1226.0, 0.8840555434986502, 1227.0, 0.8852092101022071, 1228.0, 0.8863513975326398, 1229.0, 0.8874822200094982, 1230.0, 0.8886017906158409, 1231.0, 0.8897102213095426, 1232.0, 0.8908076229344891, 1233.0, 0.8918941052316601, 1234.0, 0.8929697768501026, 1235.0, 0.8940347453577951, 1236.0, 0.895089117252404, 1237.0, 0.8961329979719321, 1238.0, 0.8971664919052623, 1239.0, 0.8981897024025958, 1240.0, 0.8992027317857866, 1241.0, 0.9002056813585735, 1242.0, 0.9011986514167102, 1243.0, 0.902181741257994, 1244.0, 0.9031550491921961, 1245.0, 0.9041186725508916, 1246.0, 0.9050727076971928, 1247.0, 0.9060172500353856, 1248.0, 0.9069523940204689, 1249.0, 0.9078782331676012, 1250.0, 0.9087948600614508, 1251.0, 0.909702366365455, 1252.0, 0.9106008428309856, 1253.0, 0.9114903793064251, 1254.0, 0.9123710647461502, 1255.0, 0.913242987219428, 1256.0, 0.9141062339192227, 1257.0, 0.9149608911709148, 1258.0, 0.915807044440934, 1259.0, 0.9166447783453047, 1260.0, 0.9174741766581094, 1261.0, 0.9182953223198642, 1262.0, 0.9191082974458146, 1263.0, 0.9199131833341455, 1264.0, 0.9207100604741123, 1265.0, 0.9214990085540891, 1266.0, 0.9222801064695376, 1267.0, 0.9230534323308972, 1268.0, 0.9238190634713955, 1269.0, 0.9245770764547818, 1270.0, 0.9253275470829839, 1271.0, 0.9260705504036877, 1272.0, 0.9268061607178425, 1273.0, 0.9275344515870909, 1274.0, 0.9282554958411252, 1275.0, 0.9289693655849702, 1276.0, 0.9296761322061939, 1277.0, 0.9303758663820462, 1278.0, 0.9310686380865266, 1279.0, 0.931754516597382, 1280.0, 0.9324335705030341, 1281.0, 0.9331058677094385, 1282.0, 0.9337714754468756, 1283.0, 0.9344304602766729, 1284.0, 0.9350828880978619, 1285.0, 0.9357288241537682, 1286.0, 0.936368333038535, 1287.0, 0.9370014787035832, 1288.0, 0.9376283244640066, 1289.0, 0.9382489330049033, 1290.0, 0.9388633663876441, 1291.0, 0.9394716860560792, 1292.0, 0.9400739528426819, 1293.0, 0.9406702269746328, 1294.0, 0.9412605680798415, 1295.0, 0.9418450351929103, 1296.0, 0.9424236867610375, 1297.0, 0.9429965806498619, 1298.0, 0.9435637741492497, 1299.0, 0.9441253239790234, 1300.0, 0.9446812862946337, 1301.0, 0.9452317166927754, 1302.0, 0.945776670216947, 1303.0, 0.9463162013629548, 1304.0, 0.946850364084363, 1305.0, 0.9473792117978889, 1306.0, 0.9479027973887443, 1307.0, 0.9484211732159247, 1308.0, 0.9489343911174447, 1309.0, 0.9494425024155221, 1310.0, 0.9499455579217101, 1311.0, 0.9504436079419785, 1312.0, 0.9509367022817442, 1313.0, 0.9514248902508523, 1314.0, 0.9519082206685063, 1315.0, 0.9523867418681508, 1316.0, 0.9528605017023045, 1317.0, 0.9533295475473456, 1318.0, 0.9537939263082494, 1319.0, 0.9542536844232791, 1320.0, 0.9547088678686292, 1321.0, 0.9551595221630235, 1322.0, 0.955605692372267, 1323.0, 0.9560474231137526, 1324.0, 0.9564847585609223, 1325.0, 0.9569177424476855, 1326.0, 0.9573464180727914, 1327.0, 0.9577708283041599, 1328.0, 0.9581910155831679, 1329.0, 0.9586070219288932, 1330.0, 0.9590188889423173, 1331.0, 0.9594266578104846, 1332.0, 0.9598303693106218, 1333.0, 0.9602300638142153, 1334.0, 0.9606257812910485, 1335.0, 0.9610175613131989, 1336.0, 0.9614054430589951, 1337.0, 0.9617894653169351, 1338.0, 0.9621696664895646, 1339.0, 0.9625460845973176, 1340.0, 0.9629187572823187, 1341.0, 0.963287721812147, 1342.0, 0.9636530150835627, 1343.0, 0.9640146736261976, 1344.0, 0.9643727336062073, 1345.0, 0.9647272308298881, 1346.0, 0.9650782007472578, 1347.0, 0.9654256784556007, 1348.0, 0.9657696987029771, 1349.0, 0.9661102958916985, 1350.0, 0.9664475040817675, 1351.0, 0.9667813569942842, 1352.0, 0.9671118880148181, 1353.0, 0.9674391301967465, 1354.0, 0.9677631162645606, 1355.0, 0.968083878617137, 1356.0, 0.9684014493309782, 1357.0, 0.9687158601634202, 1358.0, 0.9690271425558084, 1359.0, 0.9693353276366414, 1360.0, 0.969640446224684, 1361.0, 0.9699425288320496, 1362.0, 0.9702416056672502, 1363.0, 0.9705377066382188, 1364.0, 0.9708308613552994, 1365.0, 0.9711210991342076, 1366.0, 0.9714084489989636, 1367.0, 0.971692939684793, 1368.0, 0.9719745996410016, 1369.0, 0.9722534570338198, 1370.0, 0.9725295397492192, 1371.0, 0.9728028753957013, 1372.0, 0.9730734913070587, 1373.0, 0.9733414145451078, 1374.0, 0.973606671902396, 1375.0, 0.97386928990488, 1376.0, 0.9741292948145787, 1377.0, 0.9743867126321999, 1378.0, 0.9746415690997399, 1379.0, 0.9748938897030577, 1380.0, 0.9751436996744239, 1381.0, 0.9753910239950441, 1382.0, 0.975635887397556, 1383.0, 0.9758783143685044, 1384.0, 0.976118329150788, 1385.0, 0.9763559557460854, 1386.0, 0.9765912179172538, 1387.0, 0.9768241391907067, 1388.0, 0.9770547428587653, 1389.0, 0.9772830519819886, 1390.0, 0.9775090893914794, 1391.0, 0.9777328776911667, 1392.0, 0.9779544392600672, 1393.0, 0.9781737962545224, 1394.0, 0.9783909706104144, 1395.0, 0.9786059840453599, 1396.0, 0.9788188580608815, 1397.0, 0.9790296139445582, 1398.0, 0.979238272772154, 1399.0, 0.9794448554097255, 1400.0, 0.9796493825157085, 1401.0, 0.9798518745429844, 1402.0, 0.9800523517409243, 1403.0, 0.9802508341574152, 1404.0, 0.9804473416408642, 1405.0, 0.9806418938421834, 1406.0, 0.9808345102167548, 1407.0, 0.9810252100263768, 1408.0, 0.9812140123411889, 1409.0, 0.9814009360415802, 1410.0, 0.9815859998200763, 1411.0, 0.9817692221832094, 1412.0, 0.9819506214533684, 1413.0, 0.9821302157706316, 1414.0, 0.9823080230945803, 1415.0, 0.9824840612060951, 1416.0, 0.9826583477091339, 1417.0, 0.9828309000324922, 1418.0, 0.983001735431546, 1419.0, 0.9831708709899777, 1420.0, 0.9833383236214841, 1421.0, 0.983504110071468, 1422.0, 0.9836682469187122, 1423.0, 0.9838307505770386, 1424.0, 0.9839916372969483, 1425.0, 0.9841509231672473, 1426.0, 0.9843086241166553, 1427.0, 0.984464755915399, 1428.0, 0.9846193341767879, 1429.0, 0.9847723743587774, 1430.0, 0.984923891765513, 1431.0, 0.9850739015488617, 1432.0, 0.9852224187099268, 1433.0, 0.9853694581005482, 1434.0, 0.9855150344247875, 1435.0, 0.9856591622403984, 1436.0, 0.9858018559602827, 1437.0, 0.9859431298539312, 1438.0, 0.9860829980488509, 1439.0, 0.986221474531978, 1440.0, 0.9863585731510761, 1441.0, 0.9864943076161214, 1442.0, 0.9866286915006737, 1443.0, 0.9867617382432331, 1444.0, 0.986893461148585, 1445.0, 0.9870238733891296, 1446.0, 0.9871529880061995, 1447.0, 0.9872808179113642, 1448.0, 0.9874073758877208, 1449.0, 0.9875326745911722, 1450.0, 0.9876567265516932, 1451.0, 0.9877795441745834, 1452.0, 0.9879011397417072, 1453.0, 0.9880215254127228, 1454.0, 0.9881407132262976, 1455.0, 0.9882587151013122, 1456.0, 0.9883755428380526, 1457.0, 0.9884912081193896, 1458.0, 0.9886057225119479, 1459.0, 0.9887190974672622, 1460.0, 0.9888313443229223, 1461.0, 0.9889424743037075, 1462.0, 0.9890524985227085, 1463.0, 0.9891614279824388, 1464.0, 0.9892692735759351, 1465.0, 0.9893760460878468, 1466.0, 0.9894817561955139, 1467.0, 0.9895864144700353, 1468.0, 0.9896900313773257, 1469.0, 0.9897926172791622, 1470.0, 0.9898941824342203, 1471.0, 0.9899947369991005, 1472.0, 0.9900942910293427, 1473.0, 0.9901928544804331, 1474.0, 0.990290437208799, 1475.0, 0.9903870489727943, 1476.0, 0.9904826994336761, 1477.0, 0.9905773981565701, 1478.0, 0.9906711546114276, 1479.0, 0.9907639781739722, 1480.0, 0.9908558781266376, 1481.0, 0.9909468636594954, 1482.0, 0.9910369438711748, 1483.0, 0.9911261277697722, 1484.0, 0.9912144242737516, 1485.0, 0.991301842212837, 1486.0, 0.9913883903288953, 1487.0, 0.99147407727681, 1488.0, 0.9915589116253475, 1489.0, 0.9916429018580133, 1490.0, 0.9917260563739005, 1491.0, 0.9918083834885303, 1492.0, 0.9918898914346824, 1493.0, 0.9919705883632196, 1494.0, 0.992050482343902, 1495.0, 0.9921295813661941, 1496.0, 0.9922078933400641, 1497.0, 0.9922854260967746, 1498.0, 0.9923621873896661, 1499.0, 0.9924381848949316, 1500.0, 0.9925134262123851, 1501.0, 0.992587918866221, 1502.0, 0.9926616703057668, 1503.0, 0.9927346879062278, 1504.0, 0.9928069789694249, 1505.0, 0.9928785507245249, 1506.0, 0.9929494103287628, 1507.0, 0.993019564868158, 1508.0, 0.993089021358223, 1509.0, 0.9931577867446646, 1510.0, 0.9932258679040789, 1511.0, 0.9932932716446383, 1512.0, 0.9933600047067733, 1513.0, 0.9934260737638457, 1514.0, 0.9934914854228162, 1515.0, 0.9935562462249051, 1516.0, 0.9936203626462468, 1517.0, 0.9936838410985366, 1518.0, 0.9937466879296728, 1519.0, 0.9938089094243909, 1520.0, 0.9938705118048922, 1521.0, 0.993931501231466, 1522.0, 0.9939918838031059, 1523.0, 0.9940516655581193, 1524.0, 0.9941108524747315, 1525.0, 0.9941694504716837, 1526.0, 0.9942274654088241, 1527.0, 0.994284903087695, 1528.0, 0.994341769252112, 1529.0, 0.9943980695887391, 1530.0, 0.9944538097276567, 1531.0, 0.9945089952429254, 1532.0, 0.9945636316531423, 1533.0, 0.9946177244219943, 1534.0, 0.9946712789588033, 1535.0, 0.9947243006190675, 1536.0, 0.9947767947049971, 1537.0, 0.9948287664660447, 1538.0, 0.9948802210994294, 1539.0, 0.9949311637506576, 1540.0, 0.9949815995140368, 1541.0, 0.9950315334331854, 1542.0, 0.9950809705015369, 1543.0, 0.9951299156628393, 1544.0, 0.9951783738116496, 1545.0, 0.9952263497938231, 1546.0, 0.9952738484069978, 1547.0, 0.9953208744010749, 1548.0, 0.9953674324786927, 1549.0, 0.9954135272956979, 1550.0, 0.9954591634616107, 1551.0, 0.9955043455400855, 1552.0, 0.9955490780493679, 1553.0, 0.9955933654627461, 1554.0, 0.9956372122089985, 1555.0, 0.9956806226728361, 1556.0, 0.9957236011953414, 1557.0, 0.9957661520744027, 1558.0, 0.9958082795651431, 1559.0, 0.9958499878803468, 1560.0, 0.9958912811908804, 1561.0, 0.995932163626109, 1562.0, 0.9959726392743105, 1563.0, 0.9960127121830832, 1564.0, 0.9960523863597514, 1565.0, 0.9960916657717659, 1566.0, 0.9961305543471006, 1567.0, 0.9961690559746456, 1568.0, 0.9962071745045955, 1569.0, 0.9962449137488352, 1570.0, 0.9962822774813205, 1571.0, 0.9963192694384557, 1572.0, 0.9963558933194676, 1573.0, 0.9963921527867747, 1574.0, 0.9964280514663539, 1575.0, 0.9964635929481032, 1576.0, 0.9964987807862001, 1577.0, 0.996533618499458, 1578.0, 0.9965681095716772, 1579.0, 0.9966022574519937, 1580.0, 0.9966360655552239, 1581.0, 0.9966695372622063, 1582.0, 0.9967026759201395, 1583.0, 0.996735484842917, 1584.0, 0.9967679673114583, 1585.0, 0.9968001265740375, 1586.0, 0.9968319658466074, 1587.0, 0.996863488313122, 1588.0, 0.9968946971258541, 1589.0, 0.996925595405711, 1590.0, 0.9969561862425466, 1591.0, 0.9969864726954698, 1592.0, 0.9970164577931513, 1593.0, 0.9970461445341258, 1594.0, 0.9970755358870922, 1595.0, 0.9971046347912101, 1596.0, 0.9971334441563945, 1597.0, 0.9971619668636057, 1598.0, 0.9971902057651382, 1599.0, 0.9972181636849057, 1600.0, 0.9972458434187235, 1601.0, 0.997273247734588, 1602.0, 0.9973003793729537, 1603.0, 0.997327241047007, 1604.0, 0.9973538354429377, 1605.0, 0.9973801652202074, 1606.0, 0.9974062330118161, 1607.0, 0.9974320414245644, 1608.0, 0.9974575930393152, 1609.0, 0.9974828904112514, 1610.0, 0.997507936070131, 1611.0, 0.9975327325205409, 1612.0, 0.9975572822421468, 1613.0, 0.9975815876899413, 1614.0, 0.9976056512944894, 1615.0, 0.9976294754621717, 1616.0, 0.9976530625754247, 1617.0, 0.9976764149929797, 1618.0, 0.9976995350500975, 1619.0, 0.9977224250588032, 1620.0, 0.9977450873081167, 1621.0, 0.9977675240642822, 1622.0, 0.9977897375709935, 1623.0, 0.9978117300496201, 1624.0, 0.997833503699428, 1625.0, 0.9978550606978006, 1626.0, 0.9978764032004553, 1627.0, 0.9978975333416606, 1628.0, 0.9979184532344479, 1629.0, 0.997939164970824, 1630.0, 0.9979596706219799, 1631.0, 0.9979799722384977, 1632.0, 0.9980000718505558, 1633.0, 0.9980199714681326, 1634.0, 0.998039673081206, 1635.0, 0.998059178659954, 1636.0, 0.9980784901549506, 1637.0, 0.9980976094973615, 1638.0, 0.9981165385991367, 1639.0, 0.9981352793532023, 1640.0, 0.9981538336336494, 1641.0, 0.9981722032959213, 1642.0, 0.9981903901769995, 1643.0, 0.9982083960955875, 1644.0, 0.9982262228522921, 1645.0, 0.9982438722298037, 1646.0, 0.9982613459930748, 1647.0, 0.9982786458894964, 1648.0, 0.9982957736490725, 1649.0, 0.9983127309845933, 1650.0, 0.9983295195918065, 1651.0, 0.9983461411495868, 1652.0, 0.9983625973201038, 1653.0, 0.9983788897489883, 1654.0, 0.9983950200654967, 1655.0, 0.9984109898826743, 1656.0, 0.998426800797516, 1657.0, 0.9984424543911263, 1658.0, 0.9984579522288779, 1659.0, 0.9984732958605673, 1660.0, 0.9984884868205705, 1661.0, 0.9985035266279961, 1662.0, 0.9985184167868375, 1663.0, 0.9985331587861229, 1664.0, 0.9985477541000646, 1665.0, 0.9985622041882061, 1666.0, 0.9985765104955682, 1667.0, 0.9985906744527935, 1668.0, 0.9986046974762898, 1669.0, 0.9986185809683709, 1670.0, 0.9986323263173977, 1671.0, 0.9986459348979164, 1672.0, 0.9986594080707967, 1673.0, 0.9986727471833667, 1674.0, 0.9986859535695491, 1675.0, 0.9986990285499934, 1676.0, 0.9987119734322085, 1677.0, 0.9987247895106935, 1678.0, 0.998737478067067, 1679.0, 0.998750040370195, 1680.0, 0.9987624776763184, 1681.0, 0.9987747912291781, 1682.0, 0.9987869822601397, 1683.0, 0.9987990519883166, 1684.0, 0.9988110016206915, 1685.0, 0.9988228323522376, 1686.0, 0.9988345453660379, 1687.0, 0.9988461418334036, 1688.0, 0.9988576229139912, 1689.0, 0.9988689897559181, 1690.0, 0.9988802434958781, 1691.0, 0.9988913852592546, 1692.0, 0.9989024161602331, 1693.0, 0.998913337301913, 1694.0, 0.9989241497764175, 1695.0, 0.9989348546650032, 1696.0, 0.9989454530381677, 1697.0, 0.9989559459557572, 1698.0, 0.9989663344670723, 1699.0, 0.9989766196109727, 1700.0, 0.9989868024159814, 1701.0, 0.9989968839003872, 1702.0, 0.9990068650723473, 1703.0, 0.999016746929987, 1704.0, 0.9990265304615003, 1705.0, 0.9990362166452484, 1706.0, 0.999045806449858, 1707.0, 0.9990553008343174, 1708.0, 0.999064700748073, 1709.0, 0.9990740071311239, 1710.0, 0.9990832209141163, 1711.0, 0.9990923430184361, 1712.0, 0.9991013743563014, 1713.0, 0.9991103158308534, 1714.0, 0.9991191683362473, 1715.0, 0.9991279327577406, 1716.0, 0.9991366099717829, 1717.0, 0.999145200846103, 1718.0, 0.9991537062397954, 1719.0, 0.9991621270034065, 1720.0, 0.9991704639790197, 1721.0, 0.9991787180003394, 1722.0, 0.9991868898927748, 1723.0, 0.999194980473522, 1724.0, 0.9992029905516456, 1725.0, 0.9992109209281602, 1726.0, 0.9992187723961101, 1727.0, 0.9992265457406485, 1728.0, 0.9992342417391165, 1729.0, 0.9992418611611202, 1730.0, 0.9992494047686082, 1731.0, 0.9992568733159477, 1732.0, 0.9992642675499994, 1733.0, 0.9992715882101931, 1734.0, 0.9992788360286008, 1735.0, 0.9992860117300103, 1736.0, 0.9992931160319978, 1737.0, 0.9993001496449995, 1738.0, 0.9993071132723824, 1739.0, 0.9993140076105153, 1740.0, 0.9993208333488374, 1741.0, 0.9993275911699285, 1742.0, 0.9993342817495763, 1743.0, 0.9993409057568442, 1744.0, 0.9993474638541385, 1745.0, 0.9993539566972746, 1746.0, 0.9993603849355419, 1747.0, 0.9993667492117698, 1748.0, 0.9993730501623912, 1749.0, 0.9993792884175063, 1750.0, 0.9993854646009459, 1751.0, 0.9993915793303335, 1752.0, 0.9993976332171471, 1753.0, 0.9994036268667805, 1754.0, 0.9994095608786036, 1755.0, 0.9994154358460224, 1756.0, 0.9994212523565388, 1757.0, 0.9994270109918085, 1758.0, 0.9994327123276999, 1759.0, 0.9994383569343513, 1760.0, 0.9994439453762282, 1761.0, 0.9994494782121792, 1762.0, 0.9994549559954928, 1763.0, 0.9994603792739517, 1764.0, 0.9994657485898882, 1765.0, 0.9994710644802386, 1766.0, 0.9994763274765962, 1767.0, 0.9994815381052651, 1768.0, 0.9994866968873124, 1769.0, 0.9994918043386207, 1770.0, 0.9994968609699394, 1771.0, 0.9995018672869358, 1772.0, 0.9995068237902457, 1773.0, 0.9995117309755237, 1774.0, 0.9995165893334924, 1775.0, 0.9995213993499916, 1776.0, 0.9995261615060269, 1777.0, 0.999530876277818, 1778.0, 0.9995355441368459, 1779.0, 0.9995401655499004, 1780.0, 0.9995447409791268, 1781.0, 0.9995492708820717, 1782.0, 0.9995537557117292, 1783.0, 0.999558195916586, 1784.0, 0.9995625919406662, 1785.0, 0.9995669442235761, 1786.0, 0.9995712532005474, 1787.0, 0.9995755193024815, 1788.0, 0.999579742955992, 1789.0, 0.9995839245834479, 1790.0, 0.9995880646030155, 1791.0, 0.9995921634287002, 1792.0, 0.9995962214703877, 1793.0, 0.9996002391338858, 1794.0, 0.9996042168209643, 1795.0, 0.999608154929395, 1796.0, 0.9996120538529921, 1797.0, 0.9996159139816512, 1798.0, 0.9996197357013884, 1799.0, 0.9996235193943788, 1800.0, 0.9996272654389949, 1801.0, 0.9996309742098444, 1802.0, 0.9996346460778073, 1803.0, 0.9996382814100735, 1804.0, 0.9996418805701793, 1805.0, 0.9996454439180437, 1806.0, 0.9996489718100043, 1807.0, 0.9996524645988536, 1808.0, 0.999655922633873, 1809.0, 0.9996593462608692, 1810.0, 0.9996627358222074, 1811.0, 0.999666091656847, 1812.0, 0.9996694141003738, 1813.0, 0.9996727034850353, 1814.0, 0.9996759601397726, 1815.0, 0.9996791843902537, 1816.0, 0.9996823765589065, 1817.0, 0.9996855369649505, 1818.0, 0.9996886659244291, 1819.0, 0.9996917637502405, 1820.0, 0.9996948307521701, 1821.0, 0.9996978672369207, 1822.0, 0.9997008735081432, 1823.0, 0.9997038498664672, 1824.0, 0.999706796609531, 1825.0, 0.9997097140320115, 1826.0, 0.9997126024256533, 1827.0, 0.9997154620792981, 1828.0, 0.9997182932789137, 1829.0, 0.9997210963076225, 1830.0, 0.9997238714457297, 1831.0, 0.9997266189707512, 1832.0, 0.9997293391574421, 1833.0, 0.9997320322778231, 1834.0, 0.9997346986012087, 1835.0, 0.9997373383942332, 1836.0, 0.9997399519208783, 1837.0, 0.9997425394424988, 1838.0, 0.999745101217849, 1839.0, 0.9997476375031085, 1840.0, 0.999750148551908, 1841.0, 0.9997526346153546, 1842.0, 0.9997550959420565, 1843.0, 0.9997575327781485, 1844.0, 0.9997599453673163, 1845.0, 0.9997623339508208, 1846.0, 0.9997646987675223, 1847.0, 0.9997670400539045, 1848.0, 0.9997693580440979, 1849.0, 0.9997716529699036, 1850.0, 0.9997739250608159, 1851.0, 0.999776174544046, 1852.0, 0.9997784016445439, 1853.0, 0.9997806065850215, 1854.0, 0.9997827895859749, 1855.0, 0.9997849508657058, 1856.0, 0.9997870906403442, 1857.0, 0.9997892091238691, 1858.0, 0.9997913065281308, 1859.0, 0.9997933830628714, 1860.0, 0.9997954389357461, 1861.0, 0.9997974743523438, 1862.0, 0.999799489516208, 1863.0, 0.9998014846288568, 1864.0, 0.999803459889803, 1865.0, 0.9998054154965744, 1866.0, 0.9998073516447333, 1867.0, 0.9998092685278962, 1868.0, 0.9998111663377529, 1869.0, 0.999813045264086, 1870.0, 0.9998149054947898, 1871.0, 0.9998167472158888, 1872.0, 0.9998185706115565, 1873.0, 0.9998203758641343, 1874.0, 0.9998221631541488, 1875.0, 0.9998239326603306, 1876.0, 0.9998256845596316, 1877.0, 0.9998274190272434, 1878.0, 0.9998291362366141, 1879.0, 0.999830836359466, 1880.0, 0.9998325195658129, 1881.0, 0.9998341860239769, 1882.0, 0.999835835900605, 1883.0, 0.9998374693606864, 1884.0, 0.9998390865675684, 1885.0, 0.9998406876829731, 1886.0, 0.9998422728670133, 1887.0, 0.9998438422782088, 1888.0, 0.999845396073502, 1889.0, 0.9998469344082737, 1890.0, 0.9998484574363586, 1891.0, 0.9998499653100609, 1892.0, 0.9998514581801692, 1893.0, 0.9998529361959717, 1894.0, 0.9998543995052713, 1895.0, 0.9998558482544, 1896.0, 0.9998572825882341, 1897.0, 0.999858702650208, 1898.0, 0.9998601085823293, 1899.0, 0.9998615005251922, 1900.0, 0.9998628786179922, 1901.0, 0.9998642429985397, 1902.0, 0.999865593803274, 1903.0, 0.9998669311672765, 1904.0, 0.9998682552242849, 1905.0, 0.999869566106706, 1906.0, 0.999870863945629, 1907.0, 0.999872148870839, 1908.0, 0.9998734210108294, 1909.0, 0.9998746804928156, 1910.0, 0.9998759274427466, 1911.0, 0.9998771619853184, 1912.0, 0.9998783842439863, 1913.0, 0.9998795943409774, 1914.0, 0.9998807923973022, 1915.0, 0.9998819785327674, 1916.0, 0.9998831528659876, 1917.0, 0.9998843155143969, 1918.0, 0.9998854665942614, 1919.0, 0.9998866062206897, 1920.0, 0.9998877345076457, 1921.0, 0.9998888515679588, 1922.0, 0.9998899575133361, 1923.0, 0.999891052454373, 1924.0, 0.9998921365005647, 1925.0, 0.9998932097603165, 1926.0, 0.9998942723409553, 1927.0, 0.9998953243487401, 1928.0, 0.9998963658888725, 1929.0, 0.9998973970655075, 1930.0, 0.9998984179817636, 1931.0, 0.9998994287397331, 1932.0, 0.9999004294404928, 1933.0, 0.9999014201841135, 1934.0, 0.9999024010696707, 1935.0, 0.9999033721952533, 1936.0, 0.999904333657975, 1937.0, 0.9999052855539827, 1938.0, 0.999906227978467, 1939.0, 0.9999071610256709, 1940.0, 0.9999080847889, 1941.0, 0.9999089993605315, 1942.0, 0.9999099048320231, 1943.0, 0.9999108012939228, 1944.0, 0.9999116888358777, 1945.0, 0.9999125675466425, 1946.0, 0.9999134375140891, 1947.0, 0.9999142988252151, 1948.0, 0.9999151515661521, 1949.0, 0.9999159958221749, 1950.0, 0.9999168316777101, 1951.0, 0.9999176592163437, 1952.0, 0.9999184785208303, 1953.0, 0.9999192896731011, 1954.0, 0.9999200927542718, 1955.0, 0.9999208878446515, 1956.0, 0.9999216750237496, 1957.0, 0.9999224543702849, 1958.0, 0.9999232259621926, 1959.0, 0.9999239898766326, 1960.0, 0.9999247461899968, 1961.0, 0.9999254949779174, 1962.0, 0.9999262363152736, 1963.0, 0.9999269702761999, 1964.0, 0.999927696934093, 1965.0, 0.9999284163616192, 1966.0, 0.9999291286307219, 1967.0, 0.9999298338126287, 1968.0, 0.9999305319778582, 1969.0, 0.9999312231962276, 1970.0, 0.9999319075368593, 1971.0, 0.999932585068188, 1972.0, 0.9999332558579673, 1973.0, 0.9999339199732769, 1974.0, 0.9999345774805286, 1975.0, 0.9999352284454739, 1976.0, 0.9999358729332097, 1977.0, 0.9999365110081855, 1978.0, 0.9999371427342091, 1979.0, 0.9999377681744538, 1980.0, 0.9999383873914641, 1981.0, 0.9999390004471622, 1982.0, 0.9999396074028541, 1983.0, 0.999940208319236, 1984.0, 0.9999408032564001, 1985.0, 0.9999413922738404, 1986.0, 0.9999419754304593, 1987.0, 0.9999425527845729, 1988.0, 0.999943124393917, 1989.0, 0.9999436903156531, 1990.0, 0.9999442506063739, 1991.0, 0.9999448053221088, 1992.0, 0.9999453545183301, 1993.0, 0.9999458982499575, 1994.0, 0.999946436571365, 1995.0, 0.9999469695363848, 1996.0, 0.9999474971983141, 1997.0, 0.9999480196099195, 1998.0, 0.9999485368234426, 1999.0, 0.9999490488906052, 1999.9999999999998, 0.9999495558626144, 2000.0, 0.9999495558626144, 2000.0000000000002, 0.9999495558625915, 2001.0, 0.9052743719608306, 2002.0, 0.820550804591434, 2003.0, 0.7448224583620997, 2004.0, 0.6772240442069648, 2005.0, 0.6169727085452996, 2006.0, 0.5633601875890661, 2007.0, 0.5157457082759643, 2008.0, 0.4735495647770762, 2009.0, 0.43624730628958364, 2010.0, 0.40336447794301533, 2011.0, 0.3744718621832145, 2012.0, 0.34918117300719453, 2013.0, 0.32714115995433, 2014.0, 0.3080340828603323, 2015.0, 0.29157252209117757, 2016.0, 0.27749649233176543, 2017.0, 0.2655708310421746, 2018.0, 0.2555828354433527, 2019.0, 0.24734012438145847, 2020.0, 0.24066870367074356, 2021.0, 0.23541121555134548, 2022.0, 0.23142535474106907, 2023.0, 0.22858243522755894, 2024.0, 0.226766093455944, 2025.0, 0.22587111493212886, 2026.0, 0.22580237249710744, 2027.0, 0.2264738656453199, 2028.0, 0.22780785127136416, 2029.0, 0.22973405714443396};
        this.assertCompute(BooleanExpression.createLaw(BooleanExpression.TypeLaw.PT4, BooleanExpression.createParameterFloat(0.01), BooleanExpression.createParameterFloat(0.1), BooleanExpression.createParameterFloat(1000.0), BooleanExpression.createParameterFloat(0.0)), 1.0E-10, result);
        BooleanExpression expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.PT4, BooleanExpression.createParameterFloat(0.01), BooleanExpression.createParameterFloat(0.1), BooleanExpression.createParameterFloat(1000.0), BooleanExpression.createParameterFloat(1000.0));
        this.assertCompute(expr, 1.0E-10, result);
    }

    @Test
    public void testTPF_Pi10() {
        double[] result = new double[]{0.0, 0.0, 10.0, 0.009950166250831893, 20.0, 0.019801326693244747, 30.0, 0.029554466451491845, 40.0, 0.03921056084767682, 50.0, 0.048770575499285984, 60.0, 0.05823546641575128, 70.0, 0.06760618009405173, 80.0, 0.07688365361336424, 90.0, 0.08606881472877181, 99.99999999999999, 0.09516258196404037, 100.0, 0.09516258196404048, 100.00000000000001, 0.09516258196404048, 110.0, 0.09517163029297915, 119.99999999999999, 0.09518067853143497, 120.0, 0.09518067853143497, 120.00000000000001, 0.09518067853143497, 130.0, 0.09517203059936108, 140.0, 0.09602105017148932, 150.0, 0.09763759364798241, 160.0, 0.09994018055929832, 170.0, 0.10285516831624486, 180.0, 0.10631600550134845, 190.0, 0.11026255622726133, 200.0, 0.11464048879919764, 210.0, 0.11940072256198242, 220.0, 0.12449892739463342, 230.0, 0.12989507084231933, 240.0, 0.1355530083523211, 250.0, 0.14144011251202615, 260.0, 0.14752693757734858, 270.0, 0.15378691593316418, 280.0, 0.16019608344695557, 290.0, 0.1667328309660372, 299.99999999999994, 0.17337767947039506, 300.0, 0.17337767947039517, 300.00000000000006, 0.17337767947039517, 310.0, 0.1718963132958946, 319.99999999999994, 0.17057152638954098, 320.0, 0.17057152638954098, 320.00000000000006, 0.17057152638954098, 330.0, 0.16267745807053458, 340.0, 0.15639852911268315, 350.0, 0.15157244254211422, 360.0, 0.14805243151707725, 370.0, 0.1457057805894033, 380.0, 0.14441248769501258, 390.0, 0.14406405348124252, 400.0, 0.14456238585321612, 410.0, 0.14581880877462083, 420.0, 0.1477531654017039, 430.0, 0.15029300657340638, 440.0, 0.15337285653484656, 450.0, 0.1569335485443476, 460.0, 0.16092162371363472, 470.0, 0.165288787063689, 480.0, 0.16999141535139417, 490.0, 0.17499011174025614, 499.99999999999994, 0.18024930285731788, 500.0, 0.180249302857318, 500.00000000000006, 0.180249302857318, 510.0, 0.17758841594779273, 519.9999999999999, 0.17520808375022034, 520.0, 0.17520808375022034, 520.0000000000001, 0.17520808375022023, 530.0, 0.16683108382967116, 540.0, 0.16011559525840013, 550.0, 0.15489490405539408, 560.0, 0.15101824674664965, 570.0, 0.14834929162226507, 580.0, 0.14676476452950238, 590.0, 0.14615320544731647, 600.0, 0.14641384339676788, 610.0, 0.1474555784260877, 620.0, 0.14919606048081147, 630.0, 0.1515608559390692, 640.0, 0.15448269346950894, 650.0, 0.15790078166322497, 660.0, 0.16176019160941635, 670.0, 0.16601129823448224, 680.0, 0.17060927481239752, 690.0, 0.17551363558637678, 699.9999999999999, 0.18068782192335453, 700.0, 0.18068782192335453, 700.0000000000001, 0.18068782192335453, 710.0, 0.17795472855613614, 719.9999999999999, 0.17550977925918432, 720.0, 0.17550977925918432, 720.0000000000001, 0.1755097792591842, 730.0, 0.167101347076126, 740.0, 0.1603574445033381, 750.0, 0.1551110700647904, 760.0, 0.151211200152913, 770.0, 0.1485212676818739, 780.0, 0.14691778552461499, 790.0, 0.14628910095555936, 800.0, 0.14653426863207342, 810.0, 0.14756203083414376, 820.0, 0.14928989475522092, 830.0, 0.15164329760850725, 840.0, 0.15455485119186618, 850.0, 0.157963658349784};
        BooleanExpression expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.PT10, BooleanExpression.createParameterFloat(0.001), BooleanExpression.createParameterFloat(1.0E-6), BooleanExpression.createParameterFloat(0.01), BooleanExpression.createParameterFloat(200.0), BooleanExpression.createParameterFloat(100.0), BooleanExpression.createParameterFloat(0.0), BooleanExpression.createParameterFloat(20.0), BooleanExpression.createParameterFloat(1.0), BooleanExpression.createParameterFloat(1.0), BooleanExpression.createParameterFloat(0.0));
        this.assertCompute(expr, 1.0E-10, result);
    }

    @Test
    public void testTPF_Pi10Gamma() {
        double[] result = new double[]{0.0, 0.0, 10.0, 0.009950166250831893, 20.0, 0.019801326693244747, 30.0, 0.029554466451491845, 40.0, 0.03921056084767682, 50.0, 0.048770575499285984, 60.0, 0.05823546641575128, 70.0, 0.06760618009405173, 80.0, 0.07688365361336424, 90.0, 0.08606881472877181, 99.99999999999999, 0.09516258196404037, 100.0, 0.3213719364730303, 100.00000000000001, 0.3213719364730303, 110.0, 0.32137872271973433, 119.99999999999999, 0.3213855088985761, 120.0, 0.3213855088985761, 120.00000000000001, 0.3213855088985761, 130.0, 0.29770890747362944, 140.0, 0.27716358756506865, 150.0, 0.2594428305507671, 160.0, 0.2442691928870615, 170.0, 0.23139171935160552, 180.0, 0.22058342148983834, 190.0, 0.21163899602751846, 200.0, 0.20437276041344976, 210.0, 0.19861678482964518, 220.0, 0.19421920197249798, 230.0, 0.19104267768772587, 240.0, 0.18896302715175306, 250.0, 0.18786796274886708, 260.0, 0.18765596111156702, 270.0, 0.188235237984143, 280.0, 0.1895228206486732, 290.0, 0.19144370862906968, 299.99999999999994, 0.1939301142723281, 300.0, 0.3954475857042461, 300.00000000000006, 0.3954475857042461, 310.0, 0.390423763158639, 319.99999999999994, 0.3859286438053695, 320.0, 0.3859286438053695, 320.00000000000006, 0.3859286438053694, 330.0, 0.3555082114333048, 340.0, 0.32886680835175675, 350.0, 0.30563601501223725, 360.0, 0.28548255915697174, 370.0, 0.26810497024097557, 380.0, 0.2532305522366306, 390.0, 0.2406126445225738, 400.0, 0.23002814344196842, 410.0, 0.22127525972409612, 420.0, 0.21417148932383212, 430.0, 0.20855177736951414, 440.0, 0.2042668568424384, 450.0, 0.201181745359982, 460.0, 0.19917438501672668, 470.0, 0.198134411669733, 480.0, 0.1979620413496469, 490.0, 0.19856706265156543, 499.99999999999994, 0.19986792502027395, 500.0, 0.39990094376520546, 500.00000000000006, 0.39990094376520546, 510.0, 0.39386848634104443, 519.9999999999999, 0.3884707478126732, 520.0, 0.3884707478126732, 520.0000000000001, 0.3884707478126729, 530.0, 0.3577862099300374, 540.0, 0.3309060551175843, 550.0, 0.3074594488985206, 560.0, 0.28711093391944187, 570.0, 0.26955706250071976, 580.0, 0.2545233496507596, 590.0, 0.241761516047869, 600.0, 0.2310469933955891, 610.0, 0.22217666718326445, 620.0, 0.21496683425967544, 630.0, 0.2092513547774817, 640.0, 0.20487998001156915, 650.0, 0.20171683931460238, 660.0, 0.19963907106579581, 670.0, 0.19853558391005666, 680.0, 0.19830593588865408, 690.0, 0.1988593202424731, 699.9999999999999, 0.20011364773653795, 700.0, 0.4000852358024034, 700.0000000000001, 0.4000852358024033, 710.0, 0.39401330131723367, 719.9999999999999, 0.3885802350765326, 720.0, 0.3885802350765326, 720.0000000000001, 0.3885802350765323, 730.0, 0.3578843149142422, 740.0, 0.3309938705731452, 750.0, 0.3075379634920792, 760.0, 0.28718104213915707, 770.0, 0.26961957361947475, 780.0, 0.25457899583639754, 790.0, 0.24181095970162836, 800.0, 0.23109083379218598, 810.0, 0.22221544647907776, 820.0, 0.21500104292916877, 830.0, 0.2092814365322727, 840.0, 0.204906336251379, 850.0, 0.2017398331546314};
        BooleanExpression expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.PT10, BooleanExpression.createParameterFloat(0.001), BooleanExpression.createParameterFloat(1.0E-6), BooleanExpression.createParameterFloat(0.01), BooleanExpression.createParameterFloat(200.0), BooleanExpression.createParameterFloat(100.0), BooleanExpression.createParameterFloat(0.25), BooleanExpression.createParameterFloat(20.0), BooleanExpression.createParameterFloat(1.0), BooleanExpression.createParameterFloat(1.0), BooleanExpression.createParameterFloat(0.0));
        this.assertCompute(expr, 1.0E-10, result);
    }

    @Test
    public void testTPF_Pi10Indispo() {
        double[] result = new double[]{0.0, 0.0, 10.0, 0.009950166250831893, 20.0, 0.019801326693244747, 30.0, 0.029554466451491845, 40.0, 0.03921056084767682, 50.0, 0.048770575499285984, 60.0, 0.05823546641575128, 70.0, 0.06760618009405173, 80.0, 0.07688365361336424, 90.0, 0.08606881472877181, 99.99999999999999, 0.09516258196404037, 100.0, 1.0, 100.00000000000001, 1.0, 110.0, 1.0, 119.99999999999999, 1.0, 120.0, 0.09518067853143497, 120.00000000000001, 0.09518067853143497, 130.0, 0.09517203059936108, 140.0, 0.09602105017148932, 150.0, 0.09763759364798241, 160.0, 0.09994018055929832, 170.0, 0.10285516831624486, 180.0, 0.10631600550134845, 190.0, 0.11026255622726133, 200.0, 0.11464048879919764, 210.0, 0.11940072256198242, 220.0, 0.12449892739463342, 230.0, 0.12989507084231933, 240.0, 0.1355530083523211, 250.0, 0.14144011251202615, 260.0, 0.14752693757734858, 270.0, 0.15378691593316418, 280.0, 0.16019608344695557, 290.0, 0.1667328309660372, 299.99999999999994, 0.17337767947039506, 300.0, 1.0, 300.00000000000006, 1.0, 310.0, 0.9985103676436251, 319.99999999999994, 0.9971773146380586, 320.0, 0.17057152638954098, 320.00000000000006, 0.17057152638954098, 330.0, 0.16267745807053458, 340.0, 0.15639852911268315, 350.0, 0.15157244254211422, 360.0, 0.14805243151707725, 370.0, 0.1457057805894033, 380.0, 0.14441248769501258, 390.0, 0.14406405348124252, 400.0, 0.14456238585321612, 410.0, 0.14581880877462083, 420.0, 0.1477531654017039, 430.0, 0.15029300657340638, 440.0, 0.15337285653484656, 450.0, 0.1569335485443476, 460.0, 0.16092162371363472, 470.0, 0.165288787063689, 480.0, 0.16999141535139417, 490.0, 0.17499011174025614, 499.99999999999994, 0.18024930285731788, 500.0, 1.0, 500.00000000000006, 1.0, 510.0, 0.9973309156244907, 519.9999999999999, 0.9949423860429085, 520.0, 0.17520808375022034, 520.0000000000001, 0.17520808375022023, 530.0, 0.16683108382967116, 540.0, 0.16011559525840013, 550.0, 0.15489490405539408, 560.0, 0.15101824674664965, 570.0, 0.14834929162226507, 580.0, 0.14676476452950238, 590.0, 0.14615320544731647, 600.0, 0.14641384339676788, 610.0, 0.1474555784260877, 620.0, 0.14919606048081147, 630.0, 0.1515608559390692, 640.0, 0.15448269346950894, 650.0, 0.15790078166322497, 660.0, 0.16176019160941635, 670.0, 0.16601129823448224, 680.0, 0.17060927481239752, 690.0, 0.17551363558637678, 699.9999999999999, 0.18068782192335453, 700.0, 1.0, 700.0000000000001, 1.0, 710.0, 0.9972587135519663, 719.9999999999999, 0.9948055712561296, 720.0, 0.17550977925918432, 720.0000000000001, 0.1755097792591842, 730.0, 0.167101347076126, 740.0, 0.1603574445033381, 750.0, 0.1551110700647904, 760.0, 0.151211200152913, 770.0, 0.1485212676818739, 780.0, 0.14691778552461499, 790.0, 0.14628910095555936, 800.0, 0.14653426863207342, 810.0, 0.14756203083414376, 820.0, 0.14928989475522092, 830.0, 0.15164329760850725, 840.0, 0.15455485119186618, 850.0, 0.157963658349784};
        BooleanExpression expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.PT10, BooleanExpression.createParameterFloat(0.001), BooleanExpression.createParameterFloat(1.0E-6), BooleanExpression.createParameterFloat(0.01), BooleanExpression.createParameterFloat(200.0), BooleanExpression.createParameterFloat(100.0), BooleanExpression.createParameterFloat(0.0), BooleanExpression.createParameterFloat(20.0), BooleanExpression.createParameterFloat(0.0), BooleanExpression.createParameterFloat(1.0), BooleanExpression.createParameterFloat(0.0));
        this.assertCompute(expr, 1.0E-10, result);
    }

    @Test
    public void testTPF_Pi10Sigma() {
        double[] result = new double[]{0.0, 0.0, 10.0, 0.009950166250831893, 20.0, 0.019801326693244747, 30.0, 0.029554466451491845, 40.0, 0.03921056084767682, 50.0, 0.048770575499285984, 60.0, 0.05823546641575128, 70.0, 0.06760618009405173, 80.0, 0.07688365361336424, 90.0, 0.08606881472877181, 99.99999999999999, 0.09516258196404037, 100.0, 0.09516258196404048, 100.00000000000001, 0.09516258196404048, 110.0, 0.09517163029297915, 119.99999999999999, 0.09518067853143497, 120.0, 0.09518067853143497, 120.00000000000001, 0.09518067853143497, 130.0, 0.09742496825127389, 140.0, 0.1002901130071655, 150.0, 0.10370872793909669, 160.0, 0.10761992331748171, 170.0, 0.11196868562776618, 180.0, 0.1167053175607965, 190.0, 0.12178493130325008, 200.0, 0.12716699005587406, 210.0, 0.1328148931899683, 220.0, 0.13869560088930877, 230.0, 0.1447792945198937, 240.0, 0.15103906932748534, 250.0, 0.15745065638647227, 260.0, 0.16399217101634733, 270.0, 0.17064388514699758, 280.0, 0.1773880213537018, 290.0, 0.1842085664996176, 299.99999999999994, 0.19109110311978328, 300.0, 0.1910911031197834, 300.00000000000006, 0.1910911031197834, 310.0, 0.18998196790102562, 319.99999999999994, 0.1889902671144842, 320.0, 0.1889902671144842, 320.00000000000006, 0.1889902671144842, 330.0, 0.18341256688417662, 340.0, 0.1791890857974503, 350.0, 0.17618275959081753, 360.0, 0.17426964891443053, 370.0, 0.17333768952022854, 380.0, 0.17328556139348195, 390.0, 0.17402166550868658, 400.0, 0.1754631979679232, 410.0, 0.1775353122544323, 420.0, 0.18017036121605845, 430.0, 0.18330721119118276, 440.0, 0.18689062141180612, 450.0, 0.1908706824717613, 460.0, 0.19520230823919194, 470.0, 0.1998447761273281, 480.0, 0.20476131112158447, 490.0, 0.20991870939894608, 499.99999999999994, 0.21528699777186222, 500.0, 0.21528699777186233, 500.00000000000006, 0.21528699777186233, 510.0, 0.21303894780685495, 519.9999999999999, 0.21102802130260156, 520.0, 0.21102802130260156, 520.0000000000001, 0.21102802130260145, 530.0, 0.20343465541752537, 540.0, 0.19738651364641646, 550.0, 0.192728363269, 560.0, 0.1893198253556081, 570.0, 0.18703396043172926, 580.0, 0.1857559887424376, 590.0, 0.18538213230774392, 600.0, 0.18581856717885537, 610.0, 0.18698047540825746, 620.0, 0.1887911872445206, 630.0, 0.19118140496573155, 640.0, 0.19408850058253524, 650.0, 0.1974558803810853, 660.0, 0.2012324099451731, 670.0, 0.20537189390210375, 680.0, 0.20983260518459412, 690.0, 0.21457685909654833, 699.9999999999999, 0.21957062791898507, 700.0, 0.21957062791898507, 700.0000000000001, 0.21957062791898507, 710.0, 0.2170255944536007, 719.9999999999999, 0.2147488966986788, 720.0, 0.2147488966986788, 720.0000000000001, 0.2147488966986787, 730.0, 0.20679392255220208, 740.0, 0.20041865892226507, 750.0, 0.19546459052894294, 760.0, 0.1917883682671776, 770.0, 0.18926036514396116, 780.0, 0.18776336964433182, 790.0, 0.18719140344801777, 800.0, 0.18744865166312397, 810.0, 0.18844849486936655, 820.0, 0.19011263328232364, 830.0, 0.19237029427214536, 840.0, 0.19515751530442604, 850.0, 0.1984164951257925};
        BooleanExpression expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.PT10, BooleanExpression.createParameterFloat(0.001), BooleanExpression.createParameterFloat(1.0E-6), BooleanExpression.createParameterFloat(0.01), BooleanExpression.createParameterFloat(200.0), BooleanExpression.createParameterFloat(100.0), BooleanExpression.createParameterFloat(0.0), BooleanExpression.createParameterFloat(20.0), BooleanExpression.createParameterFloat(1.0), BooleanExpression.createParameterFloat(0.75), BooleanExpression.createParameterFloat(0.0));
        this.assertCompute(expr, 1.0E-10, result);
    }

    @Test
    public void testTPF_Pi0Gamma() {
        double[] result = new double[]{0.0, 0.0, 10.0, 0.009950166250831893, 20.0, 0.019801326693244747, 30.0, 0.029554466451491845, 40.0, 0.03921056084767682, 50.0, 0.048770575499285984, 60.0, 0.05823546641575128, 70.0, 0.06760618009405173, 80.0, 0.07688365361336424, 90.0, 0.08606881472877181, 99.99999999999999, 0.09516258196404037, 100.0, 0.3213719364730303, 100.00000000000001, 0.3213719364730303, 110.0, 0.2976967551394941, 120.0, 0.27715271890413884, 130.0, 0.25943312213946923, 140.0, 0.24426053305972384, 150.0, 0.23138400708142104, 160.0, 0.2205765653763183, 170.0, 0.21163291338030432, 180.0, 0.20436737642331326, 190.0, 0.19861203181837928, 200.0, 0.1942150187141909, 210.0, 0.19103900879462643, 220.0, 0.1889598225185789, 230.0, 0.18786517704999617, 240.0, 0.18765355334607747, 250.0, 0.18823317106415094, 260.0, 0.18952106102684507, 270.0, 0.19144222596158333, 280.0, 0.1939288811139085, 290.0, 0.19691976713356185, 299.99999999999994, 0.20035952835558146, 300.0, 0.40026964626668604, 300.00000000000006, 0.40026964626668593, 310.0, 0.36833934799749624, 320.0, 0.34033320591393845, 330.0, 0.31586897544786097, 340.0, 0.2946008750893737, 350.0, 0.2762161155956627, 360.0, 0.2604317594979395, 370.0, 0.24699187947441004, 380.0, 0.23566498714831896, 390.0, 0.22624170657663378, 400.0, 0.2185326691438937, 410.0, 0.21236660879165226, 420.0, 0.20758863851897946, 430.0, 0.2040586909037202, 440.0, 0.201650107035788, 450.0, 0.20024835973914634, 460.0, 0.1997498983031336, 470.0, 0.20006110315991787, 480.0, 0.20109734004524116, 490.0, 0.2027821041752924, 499.99999999999994, 0.20504624587346543, 500.0, 0.40378468440509907, 500.00000000000006, 0.40378468440509896, 510.0, 0.37148660548750057, 520.0, 0.3431480128585731, 530.0, 0.3183832965513721, 540.0, 0.29684362995003777, 550.0, 0.27821346851839235, 560.0, 0.26220738172725067, 570.0, 0.24856718647230258, 580.0, 0.23705935329186512, 590.0, 0.22747265942407657, 600.0, 0.21961606521357102, 610.0, 0.2133167926130386, 620.0, 0.20841858654771372, 630.0, 0.20478014174100845, 640.0, 0.2022736792554931, 650.0, 0.20078365850185187, 660.0, 0.200205611824246, 670.0, 0.20044508999732646, 680.0, 0.20141670808017131, 690.0, 0.20304328207685396, 699.9999999999999, 0.2052550477621694, 700.0, 0.403941285821627, 700.0000000000001, 0.4039412858216267, 710.0, 0.37162682159944727, 720.0, 0.34327341768703434, 730.0, 0.31849531418273525, 740.0, 0.29694354880561624, 750.0, 0.2783024542661109, 760.0, 0.26228648896460605, 770.0, 0.24863736929753, 780.0, 0.23712147486911106, 790.0, 0.2275275006383104, 800.0, 0.21966433250185968, 810.0, 0.2133591250505631, 820.0, 0.20845556225944906, 830.0, 0.20481228370323634, 840.0, 0.20230146054521692, 850.0, 0.20080750704664818};
        BooleanExpression expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.PT10, BooleanExpression.createParameterFloat(0.001), BooleanExpression.createParameterFloat(1.0E-6), BooleanExpression.createParameterFloat(0.01), BooleanExpression.createParameterFloat(200.0), BooleanExpression.createParameterFloat(100.0), BooleanExpression.createParameterFloat(0.25), BooleanExpression.createParameterFloat(0.0), BooleanExpression.createParameterFloat(1.0), BooleanExpression.createParameterFloat(1.0), BooleanExpression.createParameterFloat(0.0));
        this.assertCompute(expr, 1.0E-10, result);
    }

    @Test
    public void testTPF_Pi0Indispo() {
        double[] result = new double[]{0.0, 0.0, 10.0, 0.009950166250831893, 20.0, 0.019801326693244747, 30.0, 0.029554466451491845, 40.0, 0.03921056084767682, 50.0, 0.048770575499285984, 60.0, 0.05823546641575128, 70.0, 0.06760618009405173, 80.0, 0.07688365361336424, 90.0, 0.08606881472877181, 99.99999999999999, 0.09516258196404037, 100.0, 0.09516258196404048, 100.00000000000001, 0.09516258196404048, 110.0, 0.09515582748718054, 120.0, 0.09600655862358287, 130.0, 0.09762464909958501, 140.0, 0.09992863412284814, 150.0, 0.10284488528933189, 160.0, 0.10630686401665479, 170.0, 0.11025444603097556, 180.0, 0.11463331014568223, 190.0, 0.11939438521362755, 200.0, 0.12449334971689052, 210.0, 0.12989017898485322, 220.0, 0.13554873550808877, 230.0, 0.14143639824686471, 240.0, 0.14752372722336238, 250.0, 0.1537841600398413, 260.0, 0.1601937372845178, 270.0, 0.16673085407605526, 280.0, 0.173376035259169, 290.0, 0.18011173200057395, 299.99999999999994, 0.1869221377486896, 300.0, 0.1869221377486897, 300.00000000000006, 0.1869221377486897, 310.0, 0.17731452331091346, 320.0, 0.16948668165173164, 330.0, 0.16326063325488271, 340.0, 0.1584754212826881, 350.0, 0.15498549080139212, 360.0, 0.15265922225208994, 370.0, 0.15137760448874515, 380.0, 0.15103303410165358, 390.0, 0.1515282290086174, 400.0, 0.1527752454397412, 410.0, 0.15469458847656126, 420.0, 0.15721440724255753, 430.0, 0.1602697666893257, 440.0, 0.16380198868928775, 450.0, 0.16775805583947545, 460.0, 0.1720900720085604, 470.0, 0.17675477422722308, 480.0, 0.18171309103581812, 490.0, 0.18692974286826536, 499.99999999999994, 0.192372880471817, 500.0, 0.192372880471817, 500.00000000000006, 0.192372880471817, 510.0, 0.18219495139901198, 520.0, 0.17385158122502686, 530.0, 0.1671595717354637, 540.0, 0.16195324407013623, 550.0, 0.15808277068297005, 560.0, 0.15541266604539417, 570.0, 0.15382042098669946, 580.0, 0.15319526700241526, 590.0, 0.15343705816252828, 600.0, 0.15445525942835914, 610.0, 0.15616803125189138, 620.0, 0.1585014012949859, 630.0, 0.1613885149778489, 640.0, 0.16476895735507768, 650.0, 0.16858813953149276, 660.0, 0.17279674347590201, 670.0, 0.17735021967542708, 680.0, 0.18220833260186853, 690.0, 0.1873347494401203, 699.9999999999999, 0.19269666796162843, 700.0, 0.19269666796162843, 700.0000000000001, 0.19269666796162832, 710.0, 0.18248486080037596, 720.0, 0.17411086696788902, 730.0, 0.16739117824629757, 740.0, 0.16215983527569422, 750.0, 0.1582667567063507, 760.0, 0.15557622736161403, 770.0, 0.15396553027952786, 780.0, 0.1533237089412276, 790.0, 0.15355044729711376, 800.0, 0.15455505638078448, 810.0, 0.15625555736747565, 820.0, 0.15857785189902374, 830.0, 0.16145497137076104, 840.0, 0.16482639766604557, 850.0, 0.16863744853920504};
        BooleanExpression expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.PT10, BooleanExpression.createParameterFloat(0.001), BooleanExpression.createParameterFloat(1.0E-6), BooleanExpression.createParameterFloat(0.01), BooleanExpression.createParameterFloat(200.0), BooleanExpression.createParameterFloat(100.0), BooleanExpression.createParameterFloat(0.0), BooleanExpression.createParameterFloat(0.0), BooleanExpression.createParameterFloat(0.0), BooleanExpression.createParameterFloat(1.0), BooleanExpression.createParameterFloat(0.0));
        this.assertCompute(expr, 1.0E-10, result);
    }

    public void canevaTPF_() {
        double[] result = new double[]{};
        BooleanExpression expr = BooleanExpression.createLaw(BooleanExpression.TypeLaw.PT10, BooleanExpression.createParameterFloat(0.001), BooleanExpression.createParameterFloat(1.0E-6), BooleanExpression.createParameterFloat(0.01), BooleanExpression.createParameterFloat(200.0), BooleanExpression.createParameterFloat(100.0), BooleanExpression.createParameterFloat(0.0), BooleanExpression.createParameterFloat(20.0), BooleanExpression.createParameterFloat(1.0), BooleanExpression.createParameterFloat(1.0), BooleanExpression.createParameterFloat(0.0));
        this.assertCompute(expr, 1.0E-10, result);
    }
}

