/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.plugin.faulttree.compute.BooleanMCS;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BooleanMEL {
    BooleanStore _store;
    DefaultItem _nominalItem;
    List<DefaultItem> _listItems;
    Map<String, DefaultItem> _mapItems;
    boolean _simplified = false;

    public BooleanStore getStore() {
        return this._store;
    }

    public BooleanMEL(BooleanStore store) {
        this._store = store;
        this._listItems = new ArrayList<DefaultItem>();
        this._mapItems = new LinkedHashMap<String, DefaultItem>();
        this._nominalItem = null;
    }

    public ModifiableItem createItem(BooleanNode leaf, int orderMax) {
        if (leaf == null) {
            this._nominalItem = new DefaultItem(leaf, orderMax);
            return this._nominalItem;
        }
        DefaultItem item = this._mapItems.get(leaf.getEngineName());
        if (item != null) {
            for (int i = this._listItems.size() - 1; i >= 0; --i) {
                if (item != this._listItems.get(i)) continue;
                this._listItems.remove(i);
                break;
            }
            this._mapItems.remove(leaf.getEngineName());
        }
        item = new DefaultItem(leaf, orderMax);
        this._listItems.add(item);
        this._mapItems.put(leaf.getEngineName(), item);
        return item;
    }

    public void addItem(BooleanNode leaf, BooleanMCS mcs, double rootProba, String warning) {
        if (leaf == null) {
            this._nominalItem = new DefaultItem(leaf, mcs, rootProba, warning);
        } else {
            DefaultItem item = this._mapItems.get(leaf.getEngineName());
            if (item != null) {
                for (int i = this._listItems.size() - 1; i >= 0; --i) {
                    if (item != this._listItems.get(i)) continue;
                    this._listItems.remove(i);
                    break;
                }
                this._mapItems.remove(leaf.getEngineName());
            }
            item = new DefaultItem(leaf, mcs, rootProba, warning);
            this._listItems.add(item);
            this._mapItems.put(leaf.getEngineName(), item);
        }
    }

    public void addItem(BooleanNode leaf, BooleanResult result) {
        this.addItem(leaf, result.getMCS(), result.getRootProbability(), result.getWarning());
    }

    public void sortItems() {
        Collections.sort(this._listItems);
    }

    public Item getNominalItem() {
        return this._nominalItem;
    }

    public int getNbrItems() {
        return this._listItems.size();
    }

    public Item getItemAt(int idx) {
        return this._listItems.get(idx);
    }

    public boolean isSimplified() {
        return this._simplified;
    }

    public void setSimplified(boolean value) {
        this._simplified = value;
    }

    public int getMaxOrder() {
        int maxOrder = this._nominalItem._orders.length;
        for (DefaultItem item : this._listItems) {
            int curOrder = item._orders.length;
            if (curOrder <= maxOrder) continue;
            maxOrder = curOrder;
        }
        return maxOrder - 1;
    }

    public boolean withAlwaysTrue() {
        if (this._nominalItem.isAlwaysTrue()) {
            return true;
        }
        for (DefaultItem item : this._listItems) {
            if (!item.isAlwaysTrue()) continue;
            return true;
        }
        return false;
    }

    public String getResultsString() {
        int i;
        int maxOrder = this.getMaxOrder();
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append("Evt;Prb");
        for (i = 0; i < maxOrder; ++i) {
            sb.append(";").append(i);
        }
        sb.append("\n");
        sb.append(" - ");
        sb.append(";").append(this._nominalItem.getProbability());
        for (i = 0; i < maxOrder; ++i) {
            sb.append(";").append(this._nominalItem.getOrderNumber(i));
        }
        sb.append("\n");
        for (DefaultItem item : this._listItems) {
            sb.append(item._leaf._name);
            sb.append(";").append(item.getProbability());
            for (int i2 = 0; i2 < maxOrder; ++i2) {
                sb.append(";").append(item.getOrderNumber(i2));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static class DefaultItem
    implements ModifiableItem,
    Comparable<DefaultItem> {
        BooleanNode _leaf;
        double _probability;
        long[] _orders;
        double[] _probabilities;
        boolean _alwaysTrue;
        boolean _alwaysFalse;
        String _warning;

        DefaultItem(BooleanNode leaf, int orderMax) {
            this._leaf = leaf;
            this._probability = Double.NaN;
            this._orders = new long[orderMax];
            this._probabilities = new double[orderMax];
        }

        DefaultItem(BooleanNode leaf, BooleanMCS mcs, double rootProba, String warning) {
            this(leaf, mcs.getOrderMax());
            this._probability = rootProba;
            for (int idx = 0; idx < this._orders.length; ++idx) {
                this._orders[idx] = mcs.getOrderNumber(idx);
                this._probabilities[idx] = mcs.getOrderProbability(idx);
            }
            this._alwaysFalse = false;
            this._alwaysTrue = false;
            if (this._orders.length == 0) {
                this._alwaysFalse = true;
            } else if (this._orders.length == 1 && this._orders[0] > 0L) {
                this._alwaysTrue = true;
            }
            this._warning = warning;
        }

        @Override
        public int compareTo(DefaultItem o) {
            int result = Double.compare(this._probability, o._probability);
            if (result != 0) {
                return -1 * result;
            }
            if (this._leaf != null) {
                return this._leaf.getName().compareTo(o._leaf.getName());
            }
            return 0;
        }

        @Override
        public BooleanNode getNode() {
            return this._leaf;
        }

        @Override
        public double getProbability() {
            return this._probability;
        }

        @Override
        public boolean isAlwaysTrue() {
            return this._alwaysTrue;
        }

        @Override
        public boolean isAlwaysFalse() {
            return this._alwaysFalse;
        }

        @Override
        public String getWarning() {
            return this._warning;
        }

        @Override
        public long getOrderNumber(int idx) {
            if (idx < 0 || idx >= this._orders.length) {
                return 0L;
            }
            return this._orders[idx];
        }

        @Override
        public double getOrderProbability(int idx) {
            if (this._probabilities == null) {
                return Double.NaN;
            }
            if (idx < 0) {
                return Double.NaN;
            }
            if (idx >= this._probabilities.length) {
                return 0.0;
            }
            return this._probabilities[idx];
        }

        @Override
        public void setNode(BooleanNode node) {
            this._leaf = node;
        }

        @Override
        public void setProbability(double value) {
            this._probability = value;
        }

        @Override
        public void setAlwaysTrue(boolean value) {
            this._alwaysTrue = value;
        }

        @Override
        public void setAlwaysFalse(boolean value) {
            this._alwaysFalse = value;
        }

        @Override
        public void setWarning(String value) {
            this._warning = value;
        }

        @Override
        public void setOrderNumber(int idx, long value) {
            this._orders[idx] = value;
        }

        @Override
        public void setOrderProbability(int idx, double value) {
            this._probabilities[idx] = value;
        }
    }

    public static interface ModifiableItem
    extends Item {
        public void setNode(BooleanNode var1);

        public void setProbability(double var1);

        public void setAlwaysTrue(boolean var1);

        public void setAlwaysFalse(boolean var1);

        public void setOrderNumber(int var1, long var2);

        public void setOrderProbability(int var1, double var2);

        public void setWarning(String var1);
    }

    public static interface Item {
        public BooleanNode getNode();

        public double getProbability();

        public boolean isAlwaysTrue();

        public boolean isAlwaysFalse();

        public long getOrderNumber(int var1);

        public double getOrderProbability(int var1);

        public String getWarning();
    }
}

