/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMEL;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ComputeType;
import com.dassault.cecilia.plugin.faulttree.compute.PluginCmdEngine;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResIcoCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ComputeMEL;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDConfig;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDMEL;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMCS;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMEL;
import com.dassault.cecilia.plugin.faulttree.compute.pref.DisplayDefaultMCS;
import com.dassault.cecilia.plugin.faulttree.compute.pref.PrintExportMCS;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainerWithMsg;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIStoreLoad;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskItem;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class PluginCmdMEL
extends AbstractPluginModel
implements PluginMAction {
    private static Logger _LOG = Logger.getLogger(PluginCmdMEL.class.getPackage().getName());
    private static final String LOG_NAME = PluginCmdMEL.class.getSimpleName();
    protected static final String KEY_DATUM = ComputeType.MEL.toString();

    public PlugPanel displayOption(Plugable launcher) {
        return null;
    }

    public void refreshOptions(Plugable launcher) {
    }

    public boolean withParameters() {
        return false;
    }

    public Object getDefaultParameters(PluginManager plugable) {
        return null;
    }

    public Object changeParameters(PluginManager parent, Object parameters) {
        return null;
    }

    public IOParameters getIOParameters() {
        return null;
    }

    public boolean withOption(Plugable plugable) {
        if (plugable != null) {
            if (plugable.getPreferencies(DisplayDefaultMCS.PREF_KEY) == null) {
                plugable.putPreferencies((PluginWithOptions)new DisplayDefaultMCS());
            }
            if (plugable.getPreferencies(PrintExportMCS.PREF_KEY) == null) {
                plugable.putPreferencies((PluginWithOptions)new PrintExportMCS());
            }
        }
        return false;
    }

    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResCompute.getString("PLUG_CMD_MEL_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResCompute.getString("PLUG_CMD_MEL_DESC");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        if (key.equals("plugin.shortcut")) {
            return "ctrl alt M";
        }
        return ResMsgVoc.getString((String)"VOC_ERROR");
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoCompute.getImageIcon("PLUGIN_MEL");
        }
        return super.getIcon(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSession(Plugable launcher, Object sessionParams) {
        _LOG.finer("Entering : " + LOG_NAME + ".createSession");
        PluginModel pluginEngine = launcher.getPlugin(PluginCmdEngine.class.getName());
        if (pluginEngine == null || !(pluginEngine instanceof EngineBDDConfig)) {
            _LOG.logp(Level.SEVERE, LOG_NAME, "createSession", "No EngineBDDConfig");
            return;
        }
        EngineBDDConfig engineBDDCfg = (EngineBDDConfig)pluginEngine;
        InfoDatum idatum = launcher.getDatum("Tree.Compute." + KEY_DATUM);
        if (idatum == null) {
            return;
        }
        String msgError = (String)idatum.getParameters().get("tree.error");
        if (msgError != null && !msgError.isEmpty()) {
            JOptionCecilia.showMessageDialog((Component)launcher.getWindow(), (String)msgError, (String)this.getInfo("plugin.name"), (int)0);
            return;
        }
        _LOG.finer("Tracing : " + LOG_NAME + ".createSession - getDatum");
        File dagFile = (File)idatum.getInputFiles().get("ceciliabdd.file.dag");
        if (dagFile == null || !dagFile.exists() || dagFile.length() == 0L) {
            _LOG.logp(Level.SEVERE, LOG_NAME, "createSession", "No inputFile('ceciliabdd.file.dag')");
            return;
        }
        File xmlFile = (File)idatum.getInputFiles().get("ceciliabdd.file.xml");
        if (xmlFile == null || !xmlFile.exists() || xmlFile.length() == 0L) {
            _LOG.logp(Level.SEVERE, LOG_NAME, "createSession", "No inputFile('ceciliabdd.file.res')");
            return;
        }
        boolean bSuccess = false;
        StringBuffer pathTree = new StringBuffer();
        try {
            ParamComputeMEL iparameters;
            EngineBDDMEL engineBDD;
            BooleanMEL results;
            ParamComputeMEL parameters;
            BooleanStore store;
            block58: {
                store = new BooleanStore();
                parameters = new ParamComputeMEL();
                results = new BooleanMEL(store);
                engineBDD = new EngineBDDMEL(engineBDDCfg);
                TaskContainerWithMsg task = new TaskContainerWithMsg(launcher, this.getInfo("plugin.name"));
                TaskIStoreLoad bTask = new TaskIStoreLoad(task, store, xmlFile);
                bTask.run();
                if (!((TaskItem)bTask).continueWhenFinnished()) {
                    return;
                }
                _LOG.finer("Tracing : " + LOG_NAME + ".createSession - TaskIStoreLoad.run");
                pathTree.append(store.getInfo(BooleanStore.INFO_PROJECT)).append("/");
                pathTree.append(store.getInfo(BooleanStore.INFO_SYSTEM)).append("/");
                pathTree.append(store.getInfo(BooleanStore.INFO_TREE)).append("(");
                pathTree.append(store.getInfo(BooleanStore.INFO_VERSION)).append(")");
                if (!store.getInfo(BooleanStore.INFO_TREE).equals(store.getRoot().getName())) {
                    pathTree.append(" : ").append(store.getRoot().getName());
                }
                task.setTitle(ResCompute.getString("PLUG_CMD_MEL_HEADER") + pathTree.toString());
                try {
                    engineBDD.defineComputeType(store);
                }
                catch (Throwable th) {
                    _LOG.log(Level.SEVERE, "Exception during initialise compute", th);
                    if (!bSuccess) {
                        if (dagFile.exists() && (Boolean.getBoolean("cecilia.ft.compute.KeepFile") || !dagFile.delete())) {
                            dagFile.deleteOnExit();
                        }
                        if (xmlFile.exists() && (Boolean.getBoolean("cecilia.ft.compute.KeepFile") || !xmlFile.delete())) {
                            xmlFile.deleteOnExit();
                        }
                    }
                    _LOG.finer("Exiting : " + LOG_NAME + ".createSession");
                    return;
                }
                iparameters = null;
                File paramFile = (File)idatum.getInputFiles().get("result.parameters");
                if (paramFile != null && paramFile.exists() && paramFile.length() != 0L) {
                    iparameters = new ParamComputeMEL();
                    try {
                        iparameters.loadFromXML(new FileInputStream(paramFile));
                    }
                    catch (IOException e) {
                        _LOG.log(Level.WARNING, "Error during read 'result.parameters'", e);
                        iparameters = null;
                        break block58;
                    }
                    parameters.copy(iparameters);
                }
            }
            if (store.oneOrMoreLeavesWithoutProbability()) {
                parameters.setDefaultTypeProbability(TypeProbability.NONE);
            } else {
                String latentProbability;
                if (iparameters == null) {
                    double missionTime = store.getAverageFlightDuration();
                    if (!Double.isNaN(missionTime)) {
                        parameters.setMissionTimeSec(missionTime);
                    } else {
                        missionTime = store.getDefaultMissionTime();
                        if (!Double.isNaN(missionTime)) {
                            parameters.setMissionTimeSec(missionTime);
                        }
                    }
                }
                if ((latentProbability = store.getInfo(BooleanStore.INFO_LATENT_PROBABILITY)) != null && latentProbability.length() > 0) {
                    try {
                        parameters.setDefaultTypeProbability(TypeProbability.valueOf((String)latentProbability.toUpperCase()));
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
                if (parameters.getTypeProbability() == null) {
                    parameters.setTypeProbability(TypeProbability.BDD);
                }
            }
            String readOnly = store.getInfo(BooleanStore.INFO_READONLY);
            if (readOnly != null && readOnly.equals("true")) {
                parameters.setReferenceCompute(false, false);
            } else if (iparameters != null) {
                parameters.setReferenceCompute(false, true);
            } else {
                parameters.setReferenceCompute(true, true);
            }
            parameters.setReferenceIgnore(iparameters == null, iparameters != null);
            _LOG.finer("Tracing : " + LOG_NAME + ".createSession - Display parameters dialog - started");
            if (!parameters.displayDialog(store, launcher)) {
                return;
            }
            _LOG.finer("Tracing : " + LOG_NAME + ".createSession - Display parameters dialog - finalized");
            boolean bLaunchCompute = true;
            if (iparameters != null && !parameters.isPreviousReferenceComputeIgnore()) {
                boolean bSameCRCXml = false;
                String keyCRCXmlEquals = (String)idatum.getParameters().get("CRC.Xml.equals");
                if (keyCRCXmlEquals != null) {
                    bSameCRCXml = keyCRCXmlEquals.equals("true");
                }
                if (iparameters.equals(parameters) && bSameCRCXml) {
                    bLaunchCompute = false;
                }
                if (_LOG.isLoggable(Level.FINER)) {
                    _LOG.finer(LOG_NAME + ".Action : Db[" + iparameters.getShortAbstract() + "]User[" + parameters.getShortAbstract() + "]Crc[" + (bSameCRCXml ? "1" : "0") + "] => " + (bLaunchCompute ? "C" : "D"));
                }
            } else if (_LOG.isLoggable(Level.FINER)) {
                _LOG.finer(LOG_NAME + ".Action : Db[null] User[" + parameters.getShortAbstract() + "]Crc[?] => C");
            }
            if (bLaunchCompute) {
                if (parameters.isSimplifiedMode()) {
                    ParamComputeMCS iparametersMCS;
                    InfoDatum iDatumMCS = this.getMCSDatum(idatum, launcher);
                    ParamComputeMCS paramComputeMCS = iparametersMCS = iDatumMCS != null ? this.getMCSParameters(iDatumMCS) : null;
                    if (iparametersMCS != null) {
                        int limitOrder = iparametersMCS.getLimitOrder();
                        if (limitOrder > 0) {
                            parameters.setLimitOrder(limitOrder - 1);
                            parameters.setPessimistCompute(true);
                        } else {
                            parameters.setLimitOrder(-1);
                        }
                    } else {
                        _LOG.log(Level.WARNING, "Error during load real MCS of " + pathTree.toString());
                        JOptionCecilia.showMessageDialog((Component)launcher.getWindow(), (String)ResCompute.getString("PLUG_CMD_MEL2_ERROR1"), (String)ResCompute.getString("PLUG_CMD_MEL2_NAME"), (int)0);
                        return;
                    }
                    ComputeMEL compute = new ComputeMEL(parameters, results);
                    compute.defineFiles(dagFile, xmlFile);
                    compute.launchCompute(iDatumMCS, launcher, engineBDD, pathTree.toString());
                } else {
                    ComputeMEL compute = null;
                    if (parameters.getLimitOrder() > 0 && parameters.withPessimistCompute()) {
                        ParamComputeMCS iparametersMCS;
                        InfoDatum iDatumMCS = this.getMCSDatum(idatum, launcher);
                        ParamComputeMCS paramComputeMCS = iparametersMCS = iDatumMCS != null ? this.getMCSParameters(iDatumMCS) : null;
                        if (iparametersMCS != null) {
                            int orderCmd = parameters.getLimitOrder();
                            if (iparametersMCS.getLimitOrder() == -1 || iparametersMCS.getLimitOrder() >= orderCmd + 1) {
                                compute = new ComputeMEL(parameters, results);
                                parameters.setUseMCSResult(true);
                                compute.defineFiles(dagFile, xmlFile);
                                compute.launchCompute(iDatumMCS, launcher, engineBDD, pathTree.toString());
                            }
                        }
                    }
                    if (compute == null) {
                        compute = new ComputeMEL(parameters, results);
                        compute.defineFiles(dagFile, xmlFile);
                        compute.launchCompute(idatum, launcher, engineBDD, pathTree.toString());
                    }
                }
            } else {
                ComputeMEL compute = new ComputeMEL(parameters, results);
                compute.defineFiles(dagFile, xmlFile);
                compute.launchDisplay(idatum, launcher, false, pathTree.toString());
            }
            bSuccess = true;
        }
        finally {
            if (!bSuccess) {
                if (dagFile.exists() && (Boolean.getBoolean("cecilia.ft.compute.KeepFile") || !dagFile.delete())) {
                    dagFile.deleteOnExit();
                }
                if (xmlFile.exists() && (Boolean.getBoolean("cecilia.ft.compute.KeepFile") || !xmlFile.delete())) {
                    xmlFile.deleteOnExit();
                }
            }
            _LOG.finer("Exiting : " + LOG_NAME + ".createSession");
        }
    }

    private InfoDatum getMCSDatum(InfoDatum idatum, Plugable launcher) {
        String config = (String)idatum.getParameters().get("Config");
        String key = "Tree.Compute." + "MCS@" + config;
        return launcher.getDatum(key);
    }

    private ParamComputeMCS getMCSParameters(InfoDatum iDatumMCS) {
        File paramFile = (File)iDatumMCS.getInputFiles().get("result.abstract");
        ParamComputeMCS iparametersMCS = null;
        if (paramFile != null && paramFile.exists() && paramFile.length() > 0L) {
            iparametersMCS = new ParamComputeMCS();
            try {
                iparametersMCS.loadFromXML(new FileInputStream(paramFile));
                return iparametersMCS;
            }
            catch (IOException e) {
                _LOG.log(Level.WARNING, "Error during read 'result.abstract'", e);
            }
        }
        return null;
    }
}

