/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.batch;

import com.dassault.cecilia.core.cecilia.CeciliaRuntimeException;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableAppl;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.pluginmanager.ExtendedPlugable;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.CeciliaFactory;
import com.dassault.cecilia.dbobj.faulttree.TreeInfoCompute;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfig;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.dbobj.faulttree.ft.export.XPortCfgTree;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.dbobj.general.attrib.AttrCriterion;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.plugin.export.wordxml.PluginWordXml;
import com.dassault.cecilia.plugin.faulttree.compute.ActionControl;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMCS;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMEL;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ComputeType;
import com.dassault.cecilia.plugin.faulttree.compute.MCSReaderHelper;
import com.dassault.cecilia.plugin.faulttree.compute.ProbabilityVerify;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.batch.BatchCompute;
import com.dassault.cecilia.plugin.faulttree.compute.batch.ExportItem;
import com.dassault.cecilia.plugin.faulttree.compute.batch.OptionsWordView;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDConfig;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDMCS;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDMEL;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDMELSimple;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineControlLog;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineExecute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineMELHelperAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMCS;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMEL;
import com.dassault.cecilia.plugin.faulttree.compute.export.ExportAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.export.ExportCAA;
import com.dassault.cecilia.plugin.faulttree.compute.export.ExportMCS;
import com.dassault.cecilia.plugin.faulttree.compute.export.ExportMEL;
import com.dassault.cecilia.plugin.faulttree.compute.pref.PrintExportMCS;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborForOneHourRenderer;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborPreferenciesRenderer;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilter;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilterLatent;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilterNone;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilterStandard;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilterWeight;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorter;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultCriticity;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultLoadMCS;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultLoadMEL;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultSaveAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultSaveMCS;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultSaveMEL;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BatchItem
implements Cloneable {
    private static Logger _LOG = Logger.getLogger(BatchItem.class.getPackage().getName());
    protected FTEquation _ftEqu;
    protected String _treePath;
    protected String _treeConfig;
    protected String _treeRoot;
    protected ComputeType _cmdType;
    private CmdParamsMCS _cmdMCS = null;
    private CmdParamsMEL _cmdMEL = null;
    protected List<ExportItem> _exports = null;
    private static final FTEquation ERROR_FTEQUATION = new FTEquation(null);
    String _errorDBPath = null;
    String _errorDBConfig = null;
    StringBuffer _errorCfgCompute = null;
    boolean _errorExportDuplicateFile = false;

    public BatchItem(CeciliaFactory cecFactory, FTEquation ftEqu) {
        String criticity;
        this._treePath = ftEqu.getRefPath();
        String config = "Default";
        if (!ftEqu.getConfigs().isEmpty() && ftEqu.getConfig(config) == null) {
            config = ((FTConfig)ftEqu.getConfigs().get(0)).getName();
        }
        this._ftEqu = ftEqu;
        this._treeConfig = config;
        this._treeRoot = "";
        this._cmdType = ComputeType.MCS;
        this._cmdMCS = new CmdParamsMCS();
        this._cmdMCS._paramCompute = new ParamComputeMCS();
        boolean loaded = this.loadFromResult(config, ComputeType.MCS, (DAOFactory)cecFactory);
        if (!loaded) {
            TypeProbability defaultProbability = ftEqu.getComputeParameters().getType();
            if (defaultProbability != null) {
                this._cmdMCS._paramCompute.setDefaultTypeProbability(defaultProbability);
            }
            if (this._cmdMCS._paramCompute.getTypeProbability() == null) {
                this._cmdMCS._paramCompute.setTypeProbability(TypeProbability.BDD);
            }
            double missionTime = ftEqu.getComputeParameters().getTime();
            this._cmdMCS._paramCompute.setMissionTimeSec(missionTime);
        }
        if ((criticity = ftEqu.getCriticityLevel()) != null && !criticity.isEmpty()) {
            this._cmdMCS._paramCompute.setCriticity(criticity);
        }
        this._cmdMCS._filter = new MCSFilterNone();
        this._cmdMCS._sorter = MCSSorter.Type.ORDER_LEXIC;
        this._cmdMCS._rankLimit = -1;
        this._exports = new ArrayList<ExportItem>();
        this._cmdMEL = new CmdParamsMEL();
        this._cmdMEL._paramCompute = new ParamComputeMEL();
        this._cmdMEL._engineBDDMEL = null;
        loaded = this.loadFromResult(config, ComputeType.MEL, (DAOFactory)cecFactory);
        if (!loaded) {
            TypeProbability defaultProbability = ftEqu.getComputeParameters().getType();
            if (defaultProbability != null) {
                this._cmdMEL._paramCompute.setDefaultTypeProbability(defaultProbability);
            }
            if (this._cmdMEL._paramCompute.getTypeProbability() == null) {
                this._cmdMEL._paramCompute.setTypeProbability(TypeProbability.BDD);
            }
            double missionTime = ftEqu.getComputeParameters().getTime();
            this._cmdMEL._paramCompute.setMissionTimeSec(missionTime);
        }
    }

    public BatchItem(Element xmlItem) throws SAXException, IOException {
        this._exports = new ArrayList<ExportItem>();
        this.load(xmlItem);
    }

    public BatchItem(BatchItem src) {
        this._ftEqu = src._ftEqu;
        this._treePath = src._treePath;
        this._treeConfig = src._treeConfig;
        this._treeRoot = src._treeRoot;
        this._cmdType = src.getComputeType();
        if (src._cmdMCS != null) {
            this.configCompute(src._cmdMCS);
        }
        if (src._cmdMEL != null) {
            this.configCompute(src._cmdMEL._paramCompute);
        }
        this._exports = new ArrayList<ExportItem>(src._exports.size());
        for (ExportItem export : src._exports) {
            this._exports.add(export.getCopy());
        }
        this._errorCfgCompute = src._errorCfgCompute == null ? null : new StringBuffer().append(src._errorCfgCompute);
        this._errorDBConfig = src._errorDBConfig;
        this._errorDBPath = src._errorDBPath;
        this._errorExportDuplicateFile = src._errorExportDuplicateFile;
    }

    public BatchItem getCopy() {
        return new BatchItem(this);
    }

    public void save(Appendable output) throws IOException {
        output.append("  <cecilia.compute");
        output.append(" path=\"").append(this._treePath).append("\"");
        if (this._treeConfig != null && this._treeConfig.length() > 0) {
            output.append(" config=\"").append(this._treeConfig).append("\"");
        }
        if (this._treeRoot != null && this._treeRoot.length() > 0) {
            output.append(" root=\"").append(this._treeRoot).append("\"");
        }
        output.append(" type=\"").append(this._cmdType.toString()).append("\"");
        output.append(">\n");
        if (this._cmdType.equals((Object)ComputeType.MCS)) {
            this._cmdMCS._paramCompute.saveToXML(output, "    ", null);
            output.append("    <compute-filter");
            output.append(" type='").append(this._cmdMCS._filter.getClass().getSimpleName()).append("'");
            output.append(" sorter='").append(this._cmdMCS._sorter.toString()).append("'");
            output.append(" rank='").append(Integer.toString(this._cmdMCS._rankLimit)).append("'");
            output.append(">\n");
            this._cmdMCS._filter.saveToXML(output, "      ");
            output.append("    </compute-filter>\n");
        }
        if (this._cmdType.equals((Object)ComputeType.MEL)) {
            this._cmdMEL._paramCompute.saveToXML(output, "    ", null);
        }
        for (ExportItem export : this._exports) {
            export.saveToXML(output, "    ");
        }
        output.append("  </cecilia.compute>\n");
    }

    public void load(Element xmlElt) throws SAXException, IOException {
        this._treePath = xmlElt.getAttribute("path");
        this._treeConfig = xmlElt.getAttribute("config");
        this._treeRoot = xmlElt.getAttribute("root");
        String type = xmlElt.getAttribute("type");
        if (type == null || type.length() == 0) {
            throw new SAXException("No good 'type' attribute");
        }
        this._cmdType = ComputeType.valueOf(type);
        if (this._cmdType == null) {
            throw new SAXException("Unknown attribute 'type=" + type + "' ");
        }
        NodeList childs = xmlElt.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            ExportItem exportItem;
            Node xmlChild = childs.item(i);
            String xmlChildName = xmlChild.getNodeName();
            if (xmlChildName.equals("ftc.parameters")) {
                String cmptType = ((Element)xmlChild).getAttribute("type");
                if (cmptType != null && cmptType.equals(ComputeType.MCS.name())) {
                    this._cmdMCS = new CmdParamsMCS();
                    this._cmdMCS._paramCompute = new ParamComputeMCS();
                    this._cmdMCS._paramCompute.loadFromXML((Element)xmlChild);
                    this._cmdMEL = new CmdParamsMEL();
                    this._cmdMEL._paramCompute = new ParamComputeMEL();
                    this._cmdMEL._paramCompute.copy(this._cmdMCS._paramCompute);
                    continue;
                }
                if (cmptType == null || !cmptType.equals(ComputeType.MEL.name())) continue;
                this._cmdMEL = new CmdParamsMEL();
                this._cmdMEL._paramCompute = new ParamComputeMEL();
                this._cmdMEL._paramCompute.loadFromXML((Element)xmlChild);
                this._cmdMCS = new CmdParamsMCS();
                this._cmdMCS._paramCompute = new ParamComputeMCS();
                this._cmdMCS._paramCompute.copy(this._cmdMEL._paramCompute);
                this._cmdMCS._filter = new MCSFilterNone();
                this._cmdMCS._sorter = MCSSorter.Type.ORDER_LEXIC;
                this._cmdMCS._rankLimit = -1;
                continue;
            }
            if (xmlChildName.equals("compute-filter")) {
                if (this._cmdType != ComputeType.MCS) {
                    throw new SAXException();
                }
                String typeFilter = ((Element)xmlChild).getAttribute("type");
                if (typeFilter.equals(MCSFilterNone.class.getSimpleName())) {
                    this._cmdMCS._filter = new MCSFilterNone();
                } else if (typeFilter.equals(MCSFilterStandard.class.getSimpleName())) {
                    this._cmdMCS._filter = new MCSFilterStandard(null);
                } else if (typeFilter.equals(MCSFilterWeight.class.getSimpleName())) {
                    this._cmdMCS._filter = new MCSFilterWeight(0.0);
                } else if (typeFilter.equals(MCSFilterLatent.class.getSimpleName())) {
                    this._cmdMCS._filter = new MCSFilterLatent();
                }
                if (this._cmdMCS._filter == null) {
                    throw new SAXException("Unknown filter - " + type);
                }
                this._cmdMCS._filter.loadFromXML((Element)xmlChild);
                String sorter = ((Element)xmlChild).getAttribute("sorter");
                if (sorter != null && sorter.length() > 0) {
                    this._cmdMCS._sorter = MCSSorter.Type.valueOf(sorter);
                }
                String rank = ((Element)xmlChild).getAttribute("rank");
                try {
                    this._cmdMCS._rankLimit = Integer.parseInt(rank);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new SAXException(nfe);
                }
            }
            if (!xmlChildName.equals("export") || (exportItem = new ExportItem((Element)xmlChild)) == null) continue;
            this._exports.add(exportItem);
        }
    }

    public FTEquation getFTEquation() {
        if (this._ftEqu == null) {
            DBWrap dbWrap;
            CeciliaAppl appl = (CeciliaAppl)CeciliaAppl.getInstance();
            DBFolder dbFolder = appl.getDAOFactory().createFolderDAO().findFolder("PROJECTS", this._treePath);
            this._ftEqu = dbFolder == null ? ERROR_FTEQUATION : ((dbWrap = appl.getDAOFactory().findOrCreateWrap(dbFolder)) == null || !(dbWrap instanceof FTEquation) ? ERROR_FTEQUATION : (FTEquation)dbWrap);
        }
        if (this._ftEqu == ERROR_FTEQUATION) {
            return null;
        }
        return this._ftEqu;
    }

    void setFTEquation(FTEquation ftEqu) {
        if (this._ftEqu == null) {
            this._ftEqu = ftEqu;
        }
    }

    public String getTreePath() {
        return this._treePath;
    }

    public String getTreePathForFiles() {
        return this._treePath.replace(';', '(') + ')';
    }

    public String getTreeConfig() {
        return this._treeConfig;
    }

    public String getRootConfig() {
        return this._treeRoot;
    }

    public String getTreeConfiguration() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this._treeConfig);
        if (this._treeRoot != null && this._treeRoot.length() > 0) {
            buffer.append(" / ").append(this._treeRoot);
        }
        return buffer.toString();
    }

    public String getComputeConfiguration(ArborRenderer renderer) {
        StringBuffer buffer = new StringBuffer();
        buffer.append((Object)this._cmdType).append(" ");
        if (this._cmdType == ComputeType.MEL) {
            if (this._cmdMEL._paramCompute.isSimplifiedMode()) {
                buffer.append("# ");
            } else if (this._cmdMEL._paramCompute.getLimitOrder() > 0) {
                if (this._cmdMEL._paramCompute.withPessimistCompute()) {
                    buffer.append("~");
                }
                buffer.append("!").append(this._cmdMEL._paramCompute.getLimitOrder()).append(" ");
            }
        } else if (this._cmdMCS._paramCompute.getLimitOrder() > 0) {
            buffer.append("!").append(this._cmdMCS._paramCompute.getLimitOrder()).append(" ");
        }
        ParamComputeAbstract params = this._cmdType == ComputeType.MCS ? this._cmdMCS._paramCompute : this._cmdMEL._paramCompute;
        TypeProbability typeProba = params.getTypeProbability();
        buffer.append(typeProba);
        if (typeProba != TypeProbability.NONE) {
            buffer.append(" ").append(renderer.formatMissionTime(params.getMissionTime()));
        }
        return buffer.toString();
    }

    public ComputeType getComputeType() {
        return this._cmdType;
    }

    public ParamComputeMCS getParametersMCSCompute() {
        return this._cmdMCS._paramCompute;
    }

    public MCSFilter getParametersMCSFilter() {
        return this._cmdMCS._filter;
    }

    public MCSSorter.Type getParametersMCSSorter() {
        return this._cmdMCS._sorter;
    }

    public int getParametersMCSLimit() {
        return this._cmdMCS._rankLimit;
    }

    public ParamComputeMEL getParametersMELCompute() {
        return this._cmdMEL._paramCompute;
    }

    public List<ExportItem> getExports() {
        return this._exports;
    }

    public void configCompute(CmdParamsMCS cmdParamMCS) {
        this._cmdMCS = new CmdParamsMCS();
        this._cmdMCS._paramCompute = new ParamComputeMCS();
        this._cmdMCS._paramCompute.copy(cmdParamMCS._paramCompute);
        this._cmdMCS._filter = cmdParamMCS._filter != null ? cmdParamMCS._filter.getCopy() : this.getParametersMCSFilter();
        this._cmdMCS._sorter = cmdParamMCS._sorter;
        if (cmdParamMCS._rankLimit != null) {
            this._cmdMCS._rankLimit = cmdParamMCS._rankLimit;
        }
    }

    public void configCompute(ParamComputeMEL params) {
        this._cmdMEL = new CmdParamsMEL();
        this._cmdMEL._paramCompute = new ParamComputeMEL();
        this._cmdMEL._paramCompute.copy(params);
    }

    public void setCmdType(ComputeType cmdType) {
        this._cmdType = cmdType;
    }

    public void setExports(List<ExportItem> exports) {
        this._exports = new ArrayList<ExportItem>();
        for (int i = 0; i < exports.size(); ++i) {
            this._exports.add(exports.get(i).getCopy());
        }
    }

    public float getProgress() {
        if (this._cmdType == ComputeType.MEL && this._cmdMEL._engineBDDMEL != null) {
            float progress = this._cmdMEL._engineBDDMEL.getCurStep();
            return progress /= (float)this._cmdMEL._engineBDDMEL.getMaxStep();
        }
        return 0.0f;
    }

    public String getInfoProgress() {
        StringBuilder buffer = new StringBuilder();
        buffer.append((Object)this._cmdType).append(" - ");
        if (this._cmdType == ComputeType.MEL && this._cmdMEL._engineBDDMEL != null) {
            buffer.append(this._cmdMEL._engineBDDMEL.getCurStep()).append("/").append(this._cmdMEL._engineBDDMEL.getMaxStep()).append(" - ");
        }
        buffer.append(this.getTreePath());
        return buffer.toString();
    }

    public boolean withError(int c) {
        switch (c) {
            case 0: {
                return this._errorDBPath != null;
            }
            case 1: {
                return this._errorDBConfig != null;
            }
            case 2: {
                return this._errorCfgCompute != null;
            }
            case 10: {
                return this._errorExportDuplicateFile;
            }
        }
        return false;
    }

    public boolean withError() {
        return this._errorDBPath != null || this._errorDBConfig != null || this._errorCfgCompute != null;
    }

    public String getError(int c) {
        switch (c) {
            case 0: {
                return this._errorDBPath;
            }
            case 1: {
                return this._errorDBConfig;
            }
            case 2: {
                return this._errorCfgCompute != null ? this._errorCfgCompute.toString() : null;
            }
        }
        return null;
    }

    public void clearError() {
        this._errorDBPath = null;
        this._errorDBConfig = null;
        this._errorCfgCompute = null;
        this._errorExportDuplicateFile = false;
    }

    public void setError(int c, String error) {
        switch (c) {
            case 0: {
                this._errorDBPath = error;
                break;
            }
            case 1: {
                this._errorDBConfig = error;
                break;
            }
            case 2: {
                if (error == null) {
                    this._errorCfgCompute = null;
                    this._errorExportDuplicateFile = false;
                    break;
                }
                if (this._errorCfgCompute == null) {
                    this._errorCfgCompute = new StringBuffer();
                }
                if (this._errorCfgCompute.length() > 0) {
                    this._errorCfgCompute.append("\n");
                }
                this._errorCfgCompute.append(error);
            }
        }
    }

    public void checkError(Map<Attr.Key, Set<String>> attrs, Map<String, BatchItem> allExportPaths) {
        switch (this._cmdType) {
            case MCS: {
                String attrName = this._cmdMCS._filter.checkAttributes(attrs);
                if (attrName == null) break;
                this.setError(2, ResCompute.msgFormat("BATCH_ERROR_ATTRIBUTE", attrName));
                break;
            }
            case MEL: {
                AttrCriterion crit;
                if (this._cmdMEL._paramCompute.withListMEL()) {
                    File melListFile = this._cmdMEL._paramCompute.getListFileMEL();
                    if (!melListFile.exists() || !melListFile.isFile()) {
                        this.setError(2, ResCompute.msgFormat("BATCH_ERROR_MEL_LIST", melListFile));
                    } else {
                        try {
                            this._cmdMEL._paramCompute.getEvents(null, null);
                        }
                        catch (IOException e) {
                            this.setError(2, ResCompute.msgFormat("BATCH_ERROR_MEL_LIST", melListFile));
                        }
                    }
                }
                if (!this._cmdMEL._paramCompute.withLSR() || Attr.Key.containsAttribut(attrs, (Attr.Key)(crit = this._cmdMEL._paramCompute.getCriteriumLSR()).getKey())) break;
                this.setError(2, ResCompute.msgFormat("BATCH_ERROR_ATTRIBUTE", crit.getName()));
            }
        }
        this.checkExportPaths(allExportPaths, attrs);
    }

    public void checkExportPaths(Map<String, BatchItem> allExportPaths, Map<Attr.Key, Set<String>> attrs) {
        int treeExport = 0;
        for (ExportItem exportItem : this._exports) {
            block1 : switch (exportItem.getFormat()) {
                case TREE_WORD: {
                    switch (treeExport) {
                        case 0: {
                            treeExport = 1;
                            break block1;
                        }
                        case 1: {
                            this.setError(2, ResCompute.getString("BATCH_ERROR_EXPORT_TREE"));
                            treeExport = 2;
                            break block1;
                        }
                    }
                    break;
                }
                case CAA_DOCBOOK: 
                case CAA_WORD: {
                    if (exportItem.getCAAOptions().checkAttributes(attrs)) break;
                    this.setError(2, ResCompute.getString("BATCH_ERROR_CAA_CONFIG"));
                }
            }
            File exportFile = exportItem.getFile();
            boolean exportError = true;
            if (!exportFile.exists() || exportFile.isFile()) {
                exportError = false;
            }
            if (exportError) {
                this.setError(2, ResCompute.msgFormat("BATCH_ERROR_FILE", exportFile));
                continue;
            }
            String exportPath = null;
            try {
                exportPath = exportFile.getCanonicalPath();
            }
            catch (IOException e) {
                _LOG.log(Level.FINE, "IOException during verify duplicate export file : " + exportFile, e);
                exportPath = exportFile.getAbsolutePath();
            }
            BatchItem otherItem = allExportPaths.get(exportPath);
            if (otherItem != null) {
                if (!this._errorExportDuplicateFile) {
                    this.setError(2, ResCompute.msgFormat("BATCH_ERROR_FILE_DUP", exportFile));
                    this._errorExportDuplicateFile = true;
                }
                if (otherItem._errorExportDuplicateFile) continue;
                otherItem.setError(2, ResCompute.msgFormat("BATCH_ERROR_FILE_DUP", exportFile));
                otherItem._errorExportDuplicateFile = true;
                continue;
            }
            allExportPaths.put(exportPath, this);
        }
    }

    private String createXMLDatum(String type, boolean unlock, boolean saveTree) {
        StringBuffer out = new StringBuffer(512);
        out.append("<?xml version='1.0'?>\n");
        out.append("<").append("cecilia.datum").append(">\n");
        out.append("  <").append("tree");
        out.append(" ").append("path").append("='").append(this._ftEqu.getRefPath()).append("'");
        out.append(" ").append("config").append("='").append(this._treeConfig).append("'");
        if (unlock) {
            out.append(" ").append("unlock").append("='true'");
            if (saveTree) {
                out.append(" ").append("save").append("='true'");
            }
        } else {
            if (this._treeRoot != null && this._treeRoot.length() > 0) {
                out.append(" ").append("root").append("='").append(this._treeRoot).append("'");
            }
            out.append(" ").append("closeIfOpen").append("='true'");
        }
        out.append(">\n");
        if (!unlock) {
            out.append("    <").append("compute");
            out.append(" ").append("type").append("='").append(type).append("'");
            out.append(">\n");
            out.append("    </").append("compute").append(">\n");
        }
        out.append("  </").append("tree").append(">\n");
        out.append("</").append("cecilia.datum").append(">\n");
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(Plugable plugable, EngineBDDConfig engineBDDCfg, BatchItemCtrl msgs, BatchCompute.SaveResults saveCompute, boolean ignoreReference) {
        ExecuteHelper xHelper = new ExecuteHelper();
        xHelper._plugable = plugable;
        xHelper._engineBDDCfg = engineBDDCfg;
        xHelper._msgs = msgs;
        xHelper._saveCompute = saveCompute;
        xHelper._bIgnoreReference = ignoreReference;
        _LOG.finer("Tracing : BatchItem.execute - getDatum");
        try {
            xHelper._inputDatum = plugable.getDatum(this.createXMLDatum(this._cmdType.toString(), false, false));
            if (xHelper._inputDatum == null) {
                msgs.addError(ResCompute.getString("BATCH_ITEM_MSG_ERR_DATUM"));
                return;
            }
        }
        catch (CeciliaRuntimeException rte) {
            msgs.addError(rte.getMessage());
            return;
        }
        boolean error = false;
        String msgError = (String)xHelper._inputDatum.getParameters().get("tree.error");
        if (msgError != null && !msgError.isEmpty()) {
            msgs.addError(msgError);
            error = true;
        }
        boolean unlockAtFinalize = false;
        String lock = (String)xHelper._inputDatum.getParameters().get("tree.lock");
        if (lock != null && lock.equals("true")) {
            unlockAtFinalize = true;
        }
        ArrayList deleteTmpFilesAtFinalize = null;
        String open = (String)xHelper._inputDatum.getParameters().get("tree.open");
        if (open != null && open.equals("true")) {
            deleteTmpFilesAtFinalize = new ArrayList(xHelper._inputDatum.getInputFiles().values());
        }
        boolean bSave = false;
        try {
            if (error) {
                return;
            }
            xHelper._dagFile = (File)xHelper._inputDatum.getInputFiles().get("ceciliabdd.file.dag");
            if (xHelper._dagFile == null || !xHelper._dagFile.exists() || xHelper._dagFile.length() == 0L) {
                _LOG.logp(Level.SEVERE, "BatchItem", "createSession", "No inputFile('ceciliabdd.file.dag')");
                return;
            }
            xHelper._xmlFile = (File)xHelper._inputDatum.getInputFiles().get("ceciliabdd.file.xml");
            if (xHelper._xmlFile == null || !xHelper._xmlFile.exists() || xHelper._xmlFile.length() == 0L) {
                _LOG.logp(Level.SEVERE, "BatchItem", "createSession", "No inputFile('ceciliabdd.file.res')");
                return;
            }
            if (xHelper.isCanceled()) {
                return;
            }
            try {
                xHelper._store = new BooleanStore();
                _LOG.finer("Tracing : BatchItem.execute - loadStore");
                FileInputStream xmlStream = null;
                try {
                    xmlStream = new FileInputStream(xHelper._xmlFile);
                    xHelper._store.loadXML(xmlStream);
                }
                catch (IOException ioe) {
                    _LOG.log(Level.SEVERE, "Error during read store", ioe);
                    msgs.addError(ResCompute.getString("MSG_STORE_ERR_LOAD"));
                    if (!xHelper._dagFile.delete()) {
                        xHelper._dagFile.deleteOnExit();
                    }
                    if (!xHelper._xmlFile.delete()) {
                        xHelper._xmlFile.deleteOnExit();
                    }
                    if (unlockAtFinalize) {
                        xHelper._inputDatum.setKey(this.createXMLDatum(this._cmdType.toString(), true, bSave));
                        xHelper._plugable.setDatum(xHelper._inputDatum, xHelper._plugable);
                    }
                    if (deleteTmpFilesAtFinalize == null) return;
                    Iterator iterator = deleteTmpFilesAtFinalize.iterator();
                    while (iterator.hasNext()) {
                        File tmpFile = (File)iterator.next();
                        if (!tmpFile.exists() || tmpFile.delete()) continue;
                        tmpFile.deleteOnExit();
                    }
                    return;
                }
                finally {
                    if (xmlStream != null) {
                        try {
                            xmlStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                BooleanNode root = xHelper._store.getRoot();
                if (root == null) {
                    _LOG.log(Level.SEVERE, "No root for current store !!");
                    msgs.addError(ResCompute.getString("BATCH_ITEM_MSG_ERR_NOROOT"));
                    return;
                }
                switch (this._cmdType) {
                    case MCS: {
                        bSave = this.executeMCS(xHelper);
                        return;
                    }
                    case MEL: {
                        bSave = this.executeMEL(xHelper);
                        return;
                    }
                }
                return;
            }
            finally {
                if (!xHelper._dagFile.delete()) {
                    xHelper._dagFile.deleteOnExit();
                }
                if (!xHelper._xmlFile.delete()) {
                    xHelper._xmlFile.deleteOnExit();
                }
            }
        }
        finally {
            if (unlockAtFinalize) {
                xHelper._inputDatum.setKey(this.createXMLDatum(this._cmdType.toString(), true, bSave));
                xHelper._plugable.setDatum(xHelper._inputDatum, xHelper._plugable);
            }
            if (deleteTmpFilesAtFinalize != null) {
                for (File tmpFile : deleteTmpFilesAtFinalize) {
                    if (!tmpFile.exists() || tmpFile.delete()) continue;
                    tmpFile.deleteOnExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean executeMCS(final ExecuteHelper xHelper) {
        block100: {
            bLaunchCompute = true;
            bComputeProbability = true;
            if (xHelper.isCanceled()) {
                return false;
            }
            iparameters = null;
            if (!xHelper._bIgnoreReference) {
                paramFile = (File)xHelper._inputDatum.getInputFiles().get("result.abstract");
                if (paramFile != null && paramFile.exists() && paramFile.length() != 0L) {
                    BatchItem._LOG.finer("Tracing : BatchItem.executeMCS - readParameters");
                    iparameters = new ParamComputeMCS();
                    try {
                        iparameters.loadFromXML(new FileInputStream(paramFile));
                    }
                    catch (IOException e) {
                        BatchItem._LOG.log(Level.WARNING, "Error during read 'result.abstract'", e);
                        iparameters = null;
                        break block100;
                    }
                    if (this._cmdMCS._paramCompute.getComputePrForGate().booleanValue() && (bigTree = xHelper._store.getInfo(BooleanStore.INFO_BIGTREE)) != null && bigTree.equals("true")) {
                        xHelper.addWarning(ResCompute.getString("BATCH_ITEM_MSG_ERR_BIGTREE_GATE"));
                        this._cmdMCS._paramCompute.setComputePrForGate(false);
                    }
                    bSameCRCXml = false;
                    keyCRCXmlEquals = (String)xHelper._inputDatum.getParameters().get("CRC.Xml.equals");
                    if (keyCRCXmlEquals != null) {
                        bSameCRCXml = keyCRCXmlEquals.equals("true");
                    }
                    if (iparameters.isCompatible(this._cmdMCS._paramCompute, bSameCRCXml)) {
                        bLaunchCompute = false;
                        if (iparameters.equals(this._cmdMCS._paramCompute)) {
                            bComputeProbability = false;
                        }
                    }
                    if (BatchItem._LOG.isLoggable(Level.FINER)) {
                        BatchItem._LOG.finer("BatchItem.executeMCS.Action: Db[" + iparameters.getShortAbstract() + "] User[" + this._cmdMCS._paramCompute.getShortAbstract() + "] Crc[" + (bSameCRCXml != false ? "1" : "0") + "] => " + (bLaunchCompute != false ? "C" : (bComputeProbability != false ? "P" : "D")));
                    }
                }
            } else {
                BatchItem._LOG.finer("BatchItem.executeMCS.Action: IgnoreRef => C");
            }
        }
        resultMCS = new BooleanResult(xHelper._store, this._cmdMCS._paramCompute);
        if (xHelper.isCanceled()) {
            return false;
        }
        if (bLaunchCompute) {
            BatchItem._LOG.finer("Tracing : BatchItem.executeMCS - prepareStore");
            if (!this.prepareStore(xHelper, this._cmdMCS._paramCompute)) {
                return false;
            }
            try {
                resFile = File.createTempFile("EngineBDD", ".res");
            }
            catch (IOException e) {
                BatchItem._LOG.log(Level.SEVERE, "Error during create tmpFile", e);
                return false;
            }
            if (xHelper.isCanceled()) {
                return false;
            }
            BatchItem._LOG.finer("Tracing : BatchItem.executeMCS - prepareEngine");
            engineBDDMCS = new EngineBDDMCS(xHelper._engineBDDCfg);
            engineBDDMCS.defineComputeType(xHelper._store);
            engineBDDMCS.addInputFile(xHelper._dagFile);
            if (!this.prepareEngine(xHelper, engineBDDMCS, this._cmdMCS._paramCompute)) {
                return false;
            }
            if (xHelper.isCanceled()) {
                return false;
            }
            try {
                engineType = engineBDDMCS.getEngineType();
                resFileID = resFile.getAbsolutePath();
                resFileID = engineBDDMCS.createResultID(resFileID);
                try {
                    this._cmdMCS._paramCompute.generateComputeScript(engineBDDMCS.getCmdsAppendable(), xHelper._store.getRoot(), engineType == EngineBDDConfig.EngineType.Aralia4, resFileID, xHelper._store.iterate());
                }
                catch (IOException e) {
                    xHelper.addError(ResCompute.getString("MSG_ENGINE_ERR_PREPARE"));
                    BatchItem._LOG.log(Level.WARNING, "IOException during generate script : " + e.getMessage(), e);
                    var11_25 = false;
                    if (!resFile.delete()) {
                        resFile.deleteOnExit();
                    }
                    return var11_25;
                }
                if (xHelper.isCanceled()) {
                    e = false;
                    return e;
                }
                BatchItem._LOG.finer("Tracing : BatchItem.executeMCS - launchEngine");
                if (!this.launchEngine(xHelper, engineBDDMCS)) {
                    e = false;
                    return e;
                }
                if (xHelper.isCanceled()) {
                    e = false;
                    return e;
                }
                BatchItem._LOG.finer("Tracing : BatchItem.executeMCS - readResult");
                root = xHelper._store.getRoot();
                resReader = null;
                resReader = new BufferedReader(new FileReader(resFile));
                helper = new MCSReaderHelper(){

                    @Override
                    public boolean isCanceled() {
                        return xHelper.isCanceled();
                    }
                };
                resultMCS.parse(root, resReader, helper);
                if (BatchItem._LOG.isLoggable(Level.FINER)) {
                    BatchItem._LOG.finer("Abstract MCS resultat (juste after read): " + resultMCS.getResultAbstract());
                }
                if (helper.hasLimited() && !resultMCS.getMCS().isAlwaysTrue() && !resultMCS.getMCS().isAlwaysFalse()) {
                    xHelper.addWarning(helper.getWarningMsg());
                }
                if (resReader == null) ** GOTO lbl145
                try {
                    resReader.close();
                }
                catch (IOException e) {
                    BatchItem._LOG.log(Level.FINEST, "IOException during close stream result", e);
                }
                catch (IOException e) {
                    block101: {
                        try {
                            xHelper.addError(ResCompute.getString("MSG_RESULT_ERR_READ"));
                            BatchItem._LOG.log(Level.WARNING, "IOException during read result" + e.getMessage(), e);
                            var13_30 = false;
                            if (resReader == null) break block101;
                        }
                        catch (Throwable var15_34) {
                            if (resReader != null) {
                                try {
                                    resReader.close();
                                }
                                catch (IOException e) {
                                    BatchItem._LOG.log(Level.FINEST, "IOException during close stream result", e);
                                }
                            }
                            throw var15_34;
                        }
                        try {
                            resReader.close();
                        }
                        catch (IOException e) {
                            BatchItem._LOG.log(Level.FINEST, "IOException during close stream result", e);
                        }
                    }
                    if (!resFile.delete()) {
                        resFile.deleteOnExit();
                    }
                    return var13_30;
                }
            }
            finally {
                if (!resFile.delete()) {
                    resFile.deleteOnExit();
                }
            }
        } else {
            BatchItem._LOG.finer("Tracing : BatchItem.executeMCS - loadReferencies");
            file = (File)xHelper._inputDatum.getInputFiles().get("result.abstract");
            if (!TaskIResultLoadMCS.loadProbabilities(file, xHelper._store, resultMCS)) {
                xHelper.addError(ResCompute.getString("MSG_RESULT_ERR_LOAD"));
                return false;
            }
            if (xHelper.isCanceled()) {
                return false;
            }
            file = (File)xHelper._inputDatum.getInputFiles().get("result.cuts");
            if (!TaskIResultLoadMCS.loadCuts(file, xHelper._store, resultMCS.getMCS())) {
                xHelper.addError(ResCompute.getString("MSG_RESULT_ERR_LOAD"));
                return false;
            }
            if (xHelper.isCanceled()) {
                return false;
            }
            if (!this.prepareStore(xHelper, this._cmdMCS._paramCompute)) {
                return false;
            }
        }
lbl145:
        // 5 sources

        if (xHelper.isCanceled()) {
            return false;
        }
        BatchItem._LOG.finer("Tracing : BatchItem.executeMCS - postTreatment");
        bWithPostTreatment = false;
        if (this._cmdMCS._paramCompute.getPostTreatmentDormant().booleanValue() || this._cmdMCS._paramCompute.getPostTreatmentAtRisk().booleanValue()) {
            type = this._cmdMCS._paramCompute.getTypeProbability();
            if (type != TypeProbability.ARP1 && type != TypeProbability.ARP3 && type != TypeProbability.MCS) {
                xHelper.addError(ResCompute.getString("PTD_ERROR_COMPUTE_TYPE"));
            } else {
                currentMCS = originMCS = resultMCS.getMCS();
                if (this._cmdMCS._paramCompute.getPostTreatmentDormant().booleanValue()) {
                    currentMCS = currentMCS.postTreatmentHide(this._cmdMCS._paramCompute.getMissionTimeH());
                }
                if (this._cmdMCS._paramCompute.getPostTreatmentAtRisk().booleanValue()) {
                    endOfFlyMCS = currentMCS.postTreatmentRisk(this._cmdMCS._paramCompute.getSpecificTimeH());
                    if (endOfFlyMCS == null) {
                        xHelper.addError(ResCompute.getString("PTF_DORMANT_ERROR"));
                    } else {
                        currentMCS = endOfFlyMCS;
                    }
                }
                if (originMCS != currentMCS) {
                    resultMCS = new BooleanResult(currentMCS, new ParamComputeMCS(this._cmdMCS._paramCompute));
                }
                bWithPostTreatment = true;
            }
        }
        BatchItem._LOG.finer("Tracing : BatchItem.executeMCS - computeProbabilities");
        try {
            resultMCS.computeProbabilities(this._cmdMCS._paramCompute.getTypeProbability(), this._cmdMCS._paramCompute.getMissionTimeH(), xHelper);
        }
        catch (Throwable e) {
            xHelper.addError(ResCompute.getString("MSG_RESULT_ERR_COMPUTE_PROBA"));
            BatchItem._LOG.log(Level.WARNING, "IOException during compute probability" + e.getMessage(), e);
            return false;
        }
        critResult = TaskIResultCriticity.getCriticityInfo(resultMCS, this._cmdMCS._paramCompute.getCriteriumLSR());
        if (critResult != null) {
            resultMCS.setCriticityResult(critResult);
        }
        if (xHelper.isCanceled()) {
            return false;
        }
        bSaveCuts = false;
        if (this._treeRoot == null || this._treeRoot.length() <= 0) {
            switch (5.$SwitchMap$com$dassault$cecilia$plugin$faulttree$compute$batch$BatchCompute$SaveResults[xHelper._saveCompute.ordinal()]) {
                case 1: {
                    bSaveCuts = true;
                    break;
                }
                case 2: {
                    v0 = bSaveCuts = iparameters == null;
                }
            }
            if (bSaveCuts && iparameters != null && iparameters.getTypeProbability() == TypeProbability.ARP3) {
                bSaveCuts = false;
            }
            if (bSaveCuts && (frozen = xHelper._store.getInfo(BooleanStore.INFO_FROZEN)) != null && frozen.equals("true")) {
                xHelper.addWarning(ResCompute.getString("BATCH_ITEM_MSG_ERR_FREEZE"));
                bSaveCuts = false;
            }
            if (bSaveCuts && (accessWrite = xHelper._store.getInfo(BooleanStore.INFO_ACCESS_WRITE)) != null && accessWrite.equals("false")) {
                xHelper.addWarning(ResCompute.getString("BATCH_ITEM_MSG_ERR_NOWRITE"));
                bSaveCuts = false;
            }
            if (bSaveCuts && bWithPostTreatment) {
                xHelper.addWarning(ResCompute.getString("BATCH_ITEM_MSG_ERR_SAVE_MCS_POSTTREAT"));
                bSaveCuts = false;
            }
            if ((readOnly = xHelper._store.getInfo(BooleanStore.INFO_READONLY)) != null && readOnly.equals("true")) {
                bSaveCuts = false;
            }
        }
        good = false;
        BatchItem._LOG.finer("Tracing : BatchItem.executeMCS - saveReferencies");
        cutsFile = null;
        if (!(bSaveCuts && (cutsFile = TaskIResultSaveMCS.saveCuts(xHelper._store, resultMCS)) == null || (abstractFile = TaskIResultSaveMCS.saveAbstract(xHelper._store, resultMCS, this._cmdMCS._paramCompute)) == null)) {
            xHelper._inputDatum.getInputFiles().put("result.abstract", abstractFile);
            xHelper._inputDatum.getParameters().put("result.save", bSaveCuts != false ? "true" : "false");
            xHelper._inputDatum.setKey(this.createXMLDatum(this._cmdType.toString() + ".Abstract", false, false));
            xHelper._plugable.setDatum(xHelper._inputDatum, xHelper._plugable);
            if (bSaveCuts) {
                xHelper._inputDatum.getInputFiles().put("result.cuts", cutsFile);
                xHelper._inputDatum.setKey(this.createXMLDatum(this._cmdType.toString(), false, false));
                xHelper._plugable.setDatum(xHelper._inputDatum, xHelper._plugable);
            }
            good = true;
        }
        if (!good) {
            xHelper.addError(ResCompute.getString("BATCH_ITEM_MSG_ERR_SAVE"));
            return false;
        }
        if (xHelper.isCanceled()) {
            return false;
        }
        BatchItem._LOG.finer("Tracing : BatchItem.executeMCS - filterMCS");
        filterMCS = resultMCS.getMCS();
        try {
            this._cmdMCS._filter.setTypeSorter(this._cmdMCS._sorter);
            this._cmdMCS._filter.setRankLimit(this._cmdMCS._rankLimit);
            filterMCS = this._cmdMCS._filter.filterMCS(filterMCS);
        }
        catch (Exception e) {
            xHelper.addError(ResCompute.getString("BATCH_ITEM_MSG_ERR_FILTER"));
            BatchItem._LOG.log(Level.WARNING, "Exception during filter MCS" + e.getMessage(), e);
            return false;
        }
        if (xHelper.isCanceled()) {
            return false;
        }
        nominal = resultMCS.getMCS();
        if (nominal.isAlwaysTrue() || nominal.isAlwaysFalse()) {
            xHelper.addError(resultMCS.getWarning());
        }
        if (!this._exports.isEmpty() && this.withStandardExport()) {
            BatchItem._LOG.finer("Tracing : BatchItem.executeMCS - exportMCS");
            if (filterMCS.getCutCount() == 0) {
                xHelper.addWarning(ResCompute.getString("KEY_1308"));
            }
            export = new ExportMCS(xHelper._store, this._cmdMCS._paramCompute, resultMCS, resultMCS.getMCS(), (PrintExportMCS)xHelper._plugable.getPreferencies(PrintExportMCS.PREF_KEY));
            export.setMCSFilter(filterMCS, this._cmdMCS._filter);
            this.exportItems(xHelper, export, this._cmdMCS._paramCompute.getMissionTime());
        }
        if (!this._exports.isEmpty() && this.withCAAExport()) {
            BatchItem._LOG.finer("Tracing : BatchItem.executeMCS - exportCAA");
            renderer = new ArborPreferenciesRenderer(xHelper._plugable);
            for (ExportItem item : this._exports) {
                if (xHelper.isCanceled()) break;
                if (item.getFormat() != ExportItem.Format.CAA_DOCBOOK && item.getFormat() != ExportItem.Format.CAA_WORD) continue;
                caaSelector = item.getCAAOptions();
                warning = caaSelector.verifyAttributes(xHelper._store.getAttributes());
                if (warning != null) {
                    xHelper.addWarning(warning);
                }
                if ((rootItem = caaSelector.playMCS(resultMCS.getMCS())).getMCS().getCutCount() == 0) {
                    xHelper.addWarning(ResCompute.getString("KEY_1308"));
                }
                export = new ExportCAA(xHelper._store, this._cmdMCS._paramCompute, resultMCS, rootItem, caaSelector, (PrintExportMCS)xHelper._plugable.getPreferencies(PrintExportMCS.PREF_KEY), this._cmdMCS._filter);
                export.setRenderer(renderer, false);
                try {
                    writer = new DBKOutput(item.getFile().getAbsolutePath());
                    export.exportFormatDocBook(writer);
                    if (item.getFormat() != ExportItem.Format.CAA_WORD || this.processWord(item, xHelper)) continue;
                    xHelper.addError(ResCompute.msgFormat("BATCH_ITEM_MSG_ERR_EXPORT", new Object[]{item.getFormat().getLabel(), item.getFile()}));
                }
                catch (IOException e) {
                    xHelper.addError(ResCompute.msgFormat("BATCH_ITEM_MSG_ERR_EXPORT", new Object[]{item.getFormat().getLabel(), item.getFile()}));
                    BatchItem._LOG.log(Level.WARNING, "IOException during export results " + e.getMessage(), e);
                }
            }
        }
        if (!this._exports.isEmpty()) {
            for (ExportItem item : this._exports) {
                switch (5.$SwitchMap$com$dassault$cecilia$plugin$faulttree$compute$batch$ExportItem$Format[item.getFormat().ordinal()]) {
                    case 1: {
                        bigTree = xHelper._store.getInfo(BooleanStore.INFO_BIGTREE);
                        if (bigTree != null && bigTree.equals("true")) {
                            xHelper.addWarning(ResCompute.getString("BATCH_ITEM_MSG_ERR_BIGTREE_EXPORT"));
                            break;
                        }
                        if (resultMCS.getMCS().isAlwaysTrue() || resultMCS.getMCS().isAlwaysFalse()) break;
                        BatchItem._LOG.finer("Tracing : BatchItem.executeMCS - exportTreeView");
                        this.exportTree(xHelper, item, XPortCfgTree.TypeExport.ONLY_TREE_VIEW);
                        break;
                    }
                    case 4: {
                        BatchItem._LOG.finer("Tracing : BatchItem.executeMCS - exportEventsView");
                        this.exportTree(xHelper, item, XPortCfgTree.TypeExport.ONLY_LIST_EVENTS);
                    }
                }
            }
        }
        return bSaveCuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeMEL(ExecuteHelper xHelper) {
        BooleanMEL resultMEL;
        ParamComputeMEL iparameters;
        block64: {
            boolean bLaunchCompute;
            block63: {
                bLaunchCompute = true;
                if (xHelper.isCanceled()) {
                    return false;
                }
                iparameters = null;
                if (!xHelper._bIgnoreReference && !this._cmdMEL._paramCompute.isSimplifiedMode()) {
                    File paramFile = (File)xHelper._inputDatum.getInputFiles().get("result.parameters");
                    if (paramFile != null && paramFile.exists() && paramFile.length() != 0L) {
                        _LOG.finer("Tracing : BatchItem.executeMEL - readParameters");
                        iparameters = new ParamComputeMEL();
                        try {
                            iparameters.loadFromXML(new FileInputStream(paramFile));
                        }
                        catch (IOException e) {
                            _LOG.log(Level.WARNING, "Error during read 'result.parameters'", e);
                            iparameters = null;
                            break block63;
                        }
                        boolean bSameCRCXml = false;
                        String keyCRCXmlEquals = (String)xHelper._inputDatum.getParameters().get("CRC.Xml.equals");
                        if (keyCRCXmlEquals != null) {
                            bSameCRCXml = keyCRCXmlEquals.equals("true");
                        }
                        if (iparameters.equals(this._cmdMEL._paramCompute) && bSameCRCXml) {
                            bLaunchCompute = false;
                        }
                        if (_LOG.isLoggable(Level.FINER)) {
                            _LOG.finer("BatchItem.executeMEL.Action: Db[" + iparameters.getShortAbstract() + "] User[" + this._cmdMEL._paramCompute.getShortAbstract() + "] Crc[" + (bSameCRCXml ? "1" : "0") + "] => " + (bLaunchCompute ? "C" : "D"));
                        }
                    }
                } else {
                    _LOG.finer("BatchItem.executeMEL.Action: IgnoreRef => C");
                }
            }
            if (xHelper.isCanceled()) {
                return false;
            }
            _LOG.finer("Tracing : BatchItem.executeMEL - prepareStore");
            if (!this.prepareStore(xHelper, this._cmdMEL._paramCompute)) {
                return false;
            }
            if (xHelper.isCanceled()) {
                return false;
            }
            resultMEL = new BooleanMEL(xHelper._store);
            if (bLaunchCompute) {
                EngineMELHelperBatch melHelper;
                Collection<String> events = null;
                try {
                    ArrayList<String> missingEvents = new ArrayList<String>();
                    events = this._cmdMEL._paramCompute.getEvents(xHelper._store, missingEvents);
                    if (missingEvents.size() > 0) {
                        int size = missingEvents.size();
                        if (size > 20) {
                            size = 20;
                        }
                        StringBuffer buffer = new StringBuffer(size * 32);
                        Iterator iMissingEvents = missingEvents.iterator();
                        for (int i = 0; i < size && iMissingEvents.hasNext(); ++i) {
                            if (i > 0) {
                                buffer.append(", ");
                            }
                            if (i % 3 == 0) {
                                buffer.append("\n");
                            }
                            buffer.append((String)iMissingEvents.next());
                        }
                        xHelper.addWarning(ResCompute.msgFormat("DLG_PARAM_ERR_MEL_UNKNOWN_EVENTS", buffer.toString()));
                    }
                    if (events.size() == 0) {
                        xHelper.addError(ResCompute.getString("DLG_PARAM_ERR_MEL_NOEVENT"));
                        return false;
                    }
                }
                catch (IOException e) {
                    xHelper.addError(ResCompute.getString("MSG_ENGINE_ERR_PREPARE"));
                    _LOG.log(Level.WARNING, "IOException during get events MEL : " + e.getMessage(), e);
                    return false;
                }
                if (xHelper.isCanceled()) {
                    return false;
                }
                if (this._cmdMEL._paramCompute.isSimplifiedMode()) {
                    BooleanMCS mcs = this.readMCSforMEL(xHelper, -1);
                    if (mcs == null) {
                        return false;
                    }
                    melHelper = new EngineMELHelperBatch(xHelper, resultMEL, events);
                    EngineBDDMELSimple computeMEL = new EngineBDDMELSimple();
                    computeMEL.prepareCompute(melHelper, resultMEL, mcs, this._cmdMEL._paramCompute);
                    try {
                        this._cmdMEL._engineBDDMEL = computeMEL;
                        if (!this.launchEngine(xHelper, computeMEL)) {
                            boolean bl = false;
                            return bl;
                        }
                        break block64;
                    }
                    finally {
                        this._cmdMEL._engineBDDMEL = null;
                    }
                }
                _LOG.finer("Tracing : BatchItem.executeMEL - prepareEngine");
                EngineBDDMEL engineBDDMEL = new EngineBDDMEL(xHelper._engineBDDCfg);
                try {
                    BooleanMCS mcs2;
                    engineBDDMEL.defineComputeType(xHelper._store);
                    engineBDDMEL.addInputFile(xHelper._dagFile);
                    if (this._cmdMEL._paramCompute.getLimitOrder() > 0 && this._cmdMEL._paramCompute.withPessimistCompute() && (mcs2 = this.readMCSforMEL(xHelper, this._cmdMEL._paramCompute.getLimitOrder())) != null) {
                        engineBDDMEL.setMCSForPessimistCompute(mcs2);
                    }
                    if (!this.prepareEngine(xHelper, engineBDDMEL, this._cmdMEL._paramCompute)) {
                        boolean mcs2 = false;
                        return mcs2;
                    }
                    if (xHelper.isCanceled()) {
                        boolean mcs2 = false;
                        return mcs2;
                    }
                    melHelper = new EngineMELHelperBatch(xHelper, resultMEL, events);
                    melHelper.prepare();
                    try {
                        engineBDDMEL.prepareCompute(melHelper, melHelper);
                        _LOG.finer("Tracing : BatchItem.executeMEL - launchEngine");
                        this._cmdMEL._engineBDDMEL = engineBDDMEL;
                        if (!this.launchEngine(xHelper, engineBDDMEL)) {
                            boolean computeMEL = false;
                            return computeMEL;
                        }
                        break block64;
                    }
                    finally {
                        melHelper.run();
                    }
                }
                finally {
                    this._cmdMEL._engineBDDMEL = null;
                }
            }
            _LOG.finer("Tracing : BatchItem.executeMEL - loadReferencies");
            File file = (File)xHelper._inputDatum.getInputFiles().get("result.mel");
            if (!TaskIResultLoadMEL.loadMEL(file, xHelper._store, resultMEL)) {
                xHelper.addError(ResCompute.getString("MSG_RESULT_ERR_LOAD"));
                return false;
            }
        }
        if (xHelper.isCanceled()) {
            return false;
        }
        boolean bSaveMEL = false;
        if (this._treeRoot == null || this._treeRoot.length() <= 0) {
            String readOnly;
            switch (xHelper._saveCompute) {
                case ALWAYS: {
                    bSaveMEL = true;
                    break;
                }
                case SOMETIMES: {
                    boolean bl = bSaveMEL = iparameters == null;
                }
            }
            if (bSaveMEL && iparameters != null && iparameters.getTypeProbability() == TypeProbability.ARP3) {
                bSaveMEL = false;
            }
            if (bSaveMEL) {
                String accessWrite;
                String frozen = xHelper._store.getInfo(BooleanStore.INFO_FROZEN);
                if (frozen != null && frozen.equals("true")) {
                    xHelper.addWarning(ResCompute.getString("BATCH_ITEM_MSG_ERR_FREEZE"));
                }
                if ((accessWrite = xHelper._store.getInfo(BooleanStore.INFO_ACCESS_WRITE)) != null && accessWrite.equals("false")) {
                    xHelper.addWarning(ResCompute.getString("BATCH_ITEM_MSG_ERR_NOWRITE"));
                }
            }
            if ((readOnly = xHelper._store.getInfo(BooleanStore.INFO_READONLY)) != null && readOnly.equals("true")) {
                bSaveMEL = false;
            }
        }
        if (bSaveMEL) {
            boolean good = false;
            _LOG.finer("Tracing : BatchItem.executeMEL - saveReferencies");
            File melFile = TaskIResultSaveMEL.saveMEL(resultMEL, this._cmdMEL._paramCompute);
            if (melFile != null) {
                this._cmdMEL._paramCompute.setSimplifiedMode(false);
                File paramsFile = TaskIResultSaveAbstract.saveParameters(xHelper._store, this._cmdMEL._paramCompute);
                if (paramsFile != null) {
                    xHelper._inputDatum.getInputFiles().put("result.mel", melFile);
                    xHelper._inputDatum.getInputFiles().put("result.parameters", paramsFile);
                    xHelper._inputDatum.getParameters().put("result.save", "true");
                    xHelper._inputDatum.setKey(this.createXMLDatum(this._cmdType.toString(), false, false));
                    xHelper._plugable.setDatum(xHelper._inputDatum, xHelper._plugable);
                    good = true;
                }
            }
            if (!good) {
                xHelper.addError(ResCompute.getString("BATCH_ITEM_MSG_ERR_SAVE"));
                return false;
            }
        }
        if (xHelper.isCanceled()) {
            return false;
        }
        BooleanMEL.Item nominal = resultMEL.getNominalItem();
        if (nominal.isAlwaysTrue() || nominal.isAlwaysFalse()) {
            xHelper.addError(nominal.getWarning());
        }
        if (xHelper.isCanceled()) {
            return false;
        }
        if (!this._exports.isEmpty() && this.withStandardExport()) {
            _LOG.finer("Tracing : BatchItem.executeMEL - sortMEL");
            resultMEL.sortItems();
        }
        if (xHelper.isCanceled()) {
            return false;
        }
        if (!this._exports.isEmpty() && this.withStandardExport()) {
            _LOG.finer("Tracing : BatchItem.executeMEL - exportMEL");
            ExportMEL export = new ExportMEL(xHelper._store, this._cmdMEL._paramCompute, resultMEL, (PrintExportMCS)xHelper._plugable.getPreferencies(PrintExportMCS.PREF_KEY));
            this.exportItems(xHelper, export, this._cmdMEL._paramCompute.getMissionTime());
        }
        return bSaveMEL;
    }

    private BooleanMCS readMCSforMEL(ExecuteHelper xHelper, int verifyOrder) {
        InfoDatum iDatumMCS = null;
        String key = this.createXMLDatum("MCS", false, false);
        iDatumMCS = xHelper._plugable.getDatum(key);
        if (iDatumMCS != null) {
            File paramFile = (File)iDatumMCS.getInputFiles().get("result.abstract");
            ParamComputeAbstract iparametersMCS = null;
            if (paramFile != null && paramFile.exists() && paramFile.length() > 0L) {
                iparametersMCS = new ParamComputeMCS();
                try {
                    iparametersMCS.loadFromXML(new FileInputStream(paramFile));
                }
                catch (IOException e) {
                    xHelper.addError(ResCompute.getString("MSG_RESULT_ERR_GETDATUM"));
                    _LOG.log(Level.WARNING, "Error during read 'result.abstract'", e);
                    return null;
                }
            }
            if (iparametersMCS != null) {
                int limitOrder = iparametersMCS.getLimitOrder();
                if (verifyOrder > 0) {
                    if (limitOrder >= 0 && limitOrder < verifyOrder + 1) {
                        return null;
                    }
                } else if (limitOrder > 0) {
                    this._cmdMEL._paramCompute.setLimitOrder(limitOrder - 1);
                    this._cmdMEL._paramCompute.setPessimistCompute(true);
                } else {
                    this._cmdMEL._paramCompute.setLimitOrder(-1);
                }
            }
        } else {
            if (verifyOrder > 0) {
                return null;
            }
            xHelper.addError(ResCompute.getString("MSG_RESULT_ERR_GETDATUM"));
            _LOG.log(Level.WARNING, "Error during getDatum of real MCS of " + this._treePath);
            return null;
        }
        BooleanMCS mcs = new BooleanMCS(xHelper._store);
        File file = (File)iDatumMCS.getInputFiles().get("result.cuts");
        if (file == null) {
            xHelper.addError(ResCompute.getString("MSG_RESULT_ERR_GETDATUM"));
            _LOG.warning("No input file for key = 'result.cuts'");
            return null;
        }
        if (!TaskIResultLoadMCS.loadCuts(file, xHelper._store, mcs)) {
            xHelper.addError(ResCompute.getString("MSG_RESULT_ERR_READ"));
            _LOG.warning("No read MCS '" + this._treePath + "'");
            return null;
        }
        return mcs;
    }

    private boolean withStandardExport() {
        for (ExportItem item : this._exports) {
            switch (item.getFormat()) {
                case RESULT_XML: 
                case RESULT_DOCBOOK: 
                case RESULT_WORD: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean withCAAExport() {
        for (ExportItem item : this._exports) {
            switch (item.getFormat()) {
                case CAA_DOCBOOK: 
                case CAA_WORD: {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exportItems(ExecuteHelper xHelper, ExportAbstract export, double missionTimeSec) {
        double missionTimeH = missionTimeSec / 3600.0;
        double averageFlight = xHelper._store.getAverageFlightDuration();
        if (!Double.isNaN(averageFlight)) {
            missionTimeH = averageFlight / 3600.0;
        }
        ArborForOneHourRenderer renderer = new ArborForOneHourRenderer(new ArborPreferenciesRenderer(xHelper._plugable), missionTimeH);
        boolean result = true;
        block9: for (ExportItem item : this._exports) {
            renderer.setForOneHour(item.isForOneHour());
            export.setRenderer(renderer, renderer.isForOneHour());
            if (xHelper.isCanceled()) {
                return false;
            }
            try {
                switch (item.getFormat()) {
                    case RESULT_XML: {
                        Object writer = null;
                        try {
                            writer = new BufferedWriter(new FileWriter(item.getFile()));
                            export.exportFormatXML((Appendable)writer);
                            continue block9;
                        }
                        finally {
                            if (writer == null) continue block9;
                            ((Writer)writer).close();
                            continue block9;
                        }
                    }
                    case RESULT_DOCBOOK: 
                    case RESULT_WORD: {
                        Object writer = new DBKOutput(item.getFile().getAbsolutePath());
                        export.exportFormatDocBook((DBKOutput)writer);
                        if (item.getFormat() != ExportItem.Format.RESULT_WORD || this.processWord(item, xHelper)) break;
                        xHelper.addError(ResCompute.msgFormat("BATCH_ITEM_MSG_ERR_EXPORT", item.getFormat().getLabel(), item.getFile()));
                        result = false;
                    }
                }
            }
            catch (IOException e) {
                xHelper.addError(ResCompute.msgFormat("BATCH_ITEM_MSG_ERR_EXPORT", item.getFormat().getLabel(), item.getFile()));
                _LOG.log(Level.WARNING, "IOException during export results " + e.getMessage(), e);
                result = false;
            }
        }
        return result;
    }

    private final void exportTree(ExecuteHelper xHelper, final ExportItem item, final XPortCfgTree.TypeExport exportType) {
        PluginModel plug = xHelper._plugable.getPlugin("com.dassault.cecilia.plugin.export.wordxml.PluginWordXml");
        if (plug instanceof PluginWordXml) {
            final CeciliaAppl appl = (CeciliaAppl)xHelper._plugable.getAppl();
            final PageFormat pageFormat = item.getWordOptions().createPageFormat();
            int readlevelGSR = -1;
            if (exportType == XPortCfgTree.TypeExport.ONLY_TREE_VIEW && ((OptionsWordView.OptionsTreeView)item.getWordOptions())._gsrAuto) {
                readlevelGSR = ((OptionsWordView.OptionsTreeView)item.getWordOptions())._gsrLevel;
            }
            final int levelGSR = readlevelGSR;
            ProcessExtendedPlugable processPlugable = new ProcessExtendedPlugable((ExtendedPlugable)xHelper._plugable){

                @Override
                public IModel getModel(String key) {
                    if (key.equals("word.file")) {
                        return BatchItem.this._ftEqu.exportDocbookModel(key, appl, exportType, item.getFile(), pageFormat, levelGSR);
                    }
                    return super.getModel(key);
                }

                @Override
                public PageFormat getPageFormat(String key) {
                    return pageFormat;
                }
            };
            ((PluginWordXml)plug).createSession((Plugable)processPlugable, null);
        }
    }

    private boolean processWord(final ExportItem item, final ExecuteHelper xHelper) {
        if (!(xHelper._plugable instanceof ExtendedPlugable)) {
            _LOG.warning("Plugable is not instance of ExtendedPlugable");
            return false;
        }
        PluginModel plugin = xHelper._plugable.getPlugin("com.dassault.cecilia.plugin.export.wordxml.PluginWordXml");
        if (plugin instanceof PluginMAction) {
            ProcessExtendedPlugable processPlugable = new ProcessExtendedPlugable((ExtendedPlugable)xHelper._plugable){

                @Override
                public IModel getModel(String key) {
                    if (key.equals("word.file")) {
                        return new IModel.DefaultModel(key, item.getFile(), xHelper._inputDatum.getModel().getName(), xHelper._inputDatum.getModel().getUID());
                    }
                    return super.getModel(key);
                }

                @Override
                public PageFormat getPageFormat(String key) {
                    if (item.getWordOptions() != null) {
                        return item.getWordOptions().createPageFormat();
                    }
                    return super.getPageFormat(key);
                }
            };
            ((PluginMAction)plugin).createSession((Plugable)processPlugable, (Object)false);
            return true;
        }
        return false;
    }

    private boolean prepareStore(ExecuteHelper xHelper, ParamComputeAbstract params) {
        double missionTime;
        if (params.getTypeProbability() != TypeProbability.NONE && (missionTime = params.getMissionTimeH()) >= 0.0) {
            String msg;
            ProbabilityVerify ctrl = new ProbabilityVerify();
            xHelper._store.computeLeavesProbability(missionTime, ctrl);
            if (!ctrl.withError()) {
                xHelper._store.prepareComputeAverageRisk(params.getTypeProbability(), missionTime, ctrl);
            }
            if ((msg = ctrl.getMessage()) != null) {
                if (ctrl.withError()) {
                    xHelper.addError(msg);
                    return false;
                }
                xHelper.addWarning(msg);
                xHelper._store.addWarning(msg);
            }
        }
        return true;
    }

    private boolean prepareEngine(ExecuteHelper xHelper, EngineBDDAbstract engineBDD, ParamComputeAbstract parameters) {
        engineBDD.prepareComputeType();
        Appendable cmds = engineBDD.getCmdsAppendable();
        double missionTime = parameters.getMissionTimeH();
        if (missionTime >= 0.0 && parameters.getTypeProbability() != TypeProbability.NONE) {
            try {
                xHelper._store.writeProbabilities(cmds);
            }
            catch (IOException e) {
                xHelper.addError(ResCompute.getString("MSG_ENGINE_ERR_PREPARE"));
                _LOG.log(Level.WARNING, "IOException during write probabilities : " + e.getMessage(), e);
                return false;
            }
        }
        return true;
    }

    private boolean launchEngine(final ExecuteHelper xHelper, EngineExecute engineBDD) {
        final StringBuffer userBuffer = new StringBuffer();
        EngineControlLog ctrl = new EngineControlLog(){

            @Override
            public boolean isCanceled() {
                return xHelper.isCanceled();
            }

            @Override
            public void appendUserMsg(String msg) {
                userBuffer.append(msg);
            }
        };
        if (engineBDD.execute(ctrl) == EngineBDDConfig.ResultType.NoError) {
            _LOG.log(Level.FINE, "EngineBDD : Compute ok");
            return true;
        }
        if (ctrl.isCanceled()) {
            _LOG.log(Level.FINE, "EngineBDD : Compute cancel");
        } else {
            xHelper.addError(ResCompute.getString("MSG_ENGINE_ERR_HEADER") + userBuffer.toString());
            _LOG.log(Level.INFO, "EngineBDD : Compute ko");
        }
        return false;
    }

    public void setParamCompute(ComputeType type, ParamComputeAbstract paramCompute) {
        if (type == ComputeType.MCS && this._cmdMCS != null) {
            this._cmdMCS._paramCompute = (ParamComputeMCS)paramCompute;
        } else if (type == ComputeType.MEL && this._cmdMEL != null) {
            this._cmdMEL._paramCompute = (ParamComputeMEL)paramCompute;
        }
    }

    public boolean loadFromResult(String config, ComputeType type, DAOFactory factory) {
        FTEquation ftEquation = this.getFTEquation();
        if (ftEquation == null) {
            return false;
        }
        try {
            switch (type) {
                case MCS: {
                    TreeInfoCompute infoCompute = ftEquation.findInfoCompute(factory.createObjModelDAO(), "MCS.Abstract", config, null);
                    if (infoCompute == null) {
                        return false;
                    }
                    File paramFile = (File)infoCompute.getInputFiles().get("result.abstract");
                    if (paramFile == null) {
                        return false;
                    }
                    this._cmdMCS._paramCompute.loadFromXML(new FileInputStream(paramFile));
                    break;
                }
                case MEL: {
                    TreeInfoCompute infoCompute = ftEquation.findInfoCompute(factory.createObjModelDAO(), "MEL", config, null);
                    if (infoCompute == null) {
                        return false;
                    }
                    File paramFile = (File)infoCompute.getInputFiles().get("result.parameters");
                    if (paramFile == null) {
                        return false;
                    }
                    this._cmdMEL._paramCompute.loadFromXML(new FileInputStream(paramFile));
                }
            }
        }
        catch (IOException err) {
            _LOG.info("Can not load InfoCompute from the tree " + this.getTreePath());
            return false;
        }
        return true;
    }

    static class ProcessExtendedPlugable
    implements ExtendedPlugable {
        ExtendedPlugable _delegate;

        ProcessExtendedPlugable(ExtendedPlugable plug) {
            this._delegate = plug;
        }

        public IModel getModel(String key) {
            return this._delegate.getModel(key);
        }

        public InfoDatum getDatum(String key) {
            return this._delegate.getDatum(key);
        }

        public void setDatum(InfoDatum istepper, Plugable srcPlugable) {
            this._delegate.setDatum(istepper, srcPlugable);
        }

        public Window getWindow() {
            return this._delegate.getWindow();
        }

        public List getToolbars() {
            return this._delegate.getToolbars();
        }

        public JToolBar getToolbar(String name) {
            return this._delegate.getToolbar(name);
        }

        public List getPlugins(String typeKey) {
            return this._delegate.getPlugins(typeKey);
        }

        public JMenuBar getJMenuBar() {
            return this._delegate.getJMenuBar();
        }

        public void refreshMenubarAndToolbars() {
            this._delegate.refreshMenubarAndToolbars();
        }

        public void pluginChange() {
            this._delegate.pluginChange();
        }

        public PageFormat getPageFormat(String key) {
            return this._delegate.getPageFormat(key);
        }

        public PluginModel getPlugin(String pluginKey) {
            return this._delegate.getPlugin(pluginKey);
        }

        public String getInfo(String key) {
            return this._delegate.getInfo(key);
        }

        public String getOption(String key) {
            return this._delegate.getOption(key);
        }

        public void setOption(String key, String value) {
            this._delegate.setOption(key, value);
        }

        public boolean addPanel(PlugPanel panel, long uid) {
            return this._delegate.addPanel(panel, uid);
        }

        public boolean addTask(PlugTask task, long uid) {
            return this._delegate.addTask(task, uid);
        }

        public PluginWithOptions getPreferencies(String key) {
            return this._delegate.getPreferencies(key);
        }

        public void putPreferencies(PluginWithOptions prefs) {
            this._delegate.putPreferencies(prefs);
        }

        public PlugableAppl getAppl() {
            return this._delegate.getAppl();
        }
    }

    class EngineMELHelperBatch
    extends EngineMELHelperAbstract
    implements EngineBDDMEL.TargetsAccessor {
        ExecuteHelper _xHelper;
        BooleanMEL _result;
        Collection<String> _events;

        public EngineMELHelperBatch(ExecuteHelper helper, BooleanMEL result, Collection<String> evts) {
            this._xHelper = helper;
            this._result = result;
            this._events = evts;
        }

        @Override
        public void addError(String msg) {
            this._xHelper.addError(new StringBuffer(msg.length() + 128).append(this._currentTarget).append(" : ").append(msg).toString());
        }

        @Override
        public void addWarning(String msg) {
            this._xHelper.addWarning(new StringBuffer(msg.length() + 128).append(this._currentTarget).append(" : ").append(msg).toString());
        }

        @Override
        public ParamComputeMEL getParameters() {
            return ((BatchItem)BatchItem.this)._cmdMEL._paramCompute;
        }

        @Override
        protected BooleanStore getStore() {
            return this._xHelper._store;
        }

        @Override
        protected BooleanMEL getResult() {
            return this._result;
        }

        @Override
        public int size() {
            return this._events.size();
        }

        @Override
        public Iterator<String> iterate() {
            return this._events.iterator();
        }
    }

    class ExecuteHelper
    implements BatchItemCtrl {
        Plugable _plugable;
        EngineBDDConfig _engineBDDCfg;
        BatchItemCtrl _msgs;
        InfoDatum _inputDatum;
        File _dagFile;
        File _xmlFile;
        BooleanStore _store;
        BatchCompute.SaveResults _saveCompute;
        boolean _bIgnoreReference;

        ExecuteHelper() {
        }

        @Override
        public void addError(String msg) {
            this._msgs.addError(msg);
        }

        @Override
        public void addWarning(String msg) {
            this._msgs.addWarning(msg);
        }

        @Override
        public boolean isCanceled() {
            return this._msgs.isCanceled();
        }
    }

    public static interface BatchItemCtrl
    extends ActionControl {
        public void addError(String var1);

        public void addWarning(String var1);
    }

    static class CmdParamsMEL {
        ParamComputeMEL _paramCompute;
        EngineExecute _engineBDDMEL;

        CmdParamsMEL() {
        }
    }

    static class CmdParamsMCS {
        ParamComputeMCS _paramCompute;
        MCSFilter _filter;
        MCSSorter.Type _sorter;
        Integer _rankLimit = -1;

        CmdParamsMCS() {
        }
    }
}

