/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.batch;

import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.plugin.faulttree.compute.CAASelector;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.batch.BatchItem;
import com.dassault.cecilia.plugin.faulttree.compute.batch.OptionsWordView;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExportItem
implements Cloneable {
    private static Logger _LOG = Logger.getLogger(ExportItem.class.getPackage().getName());
    private Format _format;
    private File _file;
    private boolean _forOneHour;
    public static final String BALISE_PATH = "%path%";
    public static final String BALISE_PROJ = "%proj%";
    public static final String BALISE_SYST = "%syst%";
    public static final String BALISE_TREE = "%tree%";
    public static final String BALISE_VERS = "%vers%";
    public static final List<String> BALISES = new ArrayList<String>();
    protected OptionsWordView _wordOptions;
    protected CAASelector _caaOptions;

    public ExportItem(String defaultPath, String treePath, String compute) {
        this._format = Format.RESULT_WORD;
        this._wordOptions = new OptionsWordView();
        StringBuffer buffer = new StringBuffer(512);
        if (defaultPath != null) {
            buffer.append(defaultPath);
            if (!defaultPath.endsWith("/") && !defaultPath.endsWith("\\")) {
                buffer.append("/");
            }
        } else {
            buffer.append("./");
        }
        if (treePath.isEmpty()) {
            buffer.append(BALISE_PATH);
        } else {
            buffer.append(ExportItem.getAcceptableTreePathFromOriginal(treePath, true));
        }
        if (this._format.withComputeExt()) {
            buffer.append(".").append(compute.toLowerCase());
        }
        buffer.append(this._format.getExtention());
        this._file = new File(new File(buffer.toString()).getAbsolutePath());
        this._forOneHour = false;
    }

    public ExportItem(Element xmlItem) {
        this.load(xmlItem);
    }

    public ExportItem(ExportItem src) {
        this._format = src._format;
        this._file = new File(src._file.getPath());
        this._forOneHour = src._forOneHour;
        switch (src._format) {
            case TREE_WORD: {
                this._wordOptions = new OptionsWordView.OptionsTreeView((OptionsWordView.OptionsTreeView)src._wordOptions);
                break;
            }
            case RESULT_WORD: 
            case EVENTS_WORD: {
                this._wordOptions = new OptionsWordView(src._wordOptions);
                break;
            }
            case CAA_WORD: {
                this._wordOptions = new OptionsWordView(src._wordOptions);
                this._caaOptions = src._caaOptions.getCopy();
                break;
            }
            case CAA_DOCBOOK: {
                this._caaOptions = src._caaOptions.getCopy();
                break;
            }
        }
    }

    public ExportItem getCopy() {
        return new ExportItem(this);
    }

    public boolean withError() {
        return false;
    }

    public void saveProperties(Appendable output) throws IOException {
        output.append(" format=\"").append(this._format.toString().toLowerCase()).append("\"");
        output.append(" path=\"").append(this._file.getAbsolutePath()).append("\"");
        output.append(" forOneHour=\"").append(this._forOneHour ? "true" : "false").append("\"");
    }

    public void saveToXML(Appendable output, String indent) throws IOException {
        output.append(indent).append("<export");
        this.saveProperties(output);
        switch (this._format) {
            case CAA_WORD: {
                output.append(" merge=\"").append(this._caaOptions.getMerge() ? "true" : "false").append("\"");
                output.append(">\n");
                this.saveWord(output, indent);
                this.saveCAA(output, indent);
                output.append(indent).append("</export>\n");
                break;
            }
            case CAA_DOCBOOK: {
                output.append(" merge=\"").append(this._caaOptions.getMerge() ? "true" : "false").append("\"");
                output.append(">\n");
                this.saveCAA(output, indent);
                output.append(indent).append("</export>\n");
                break;
            }
            case RESULT_WORD: 
            case TREE_WORD: 
            case EVENTS_WORD: {
                output.append(">\n");
                this.saveWord(output, indent);
                output.append(indent).append("</export>\n");
                break;
            }
            default: {
                output.append("/>\n");
            }
        }
    }

    private void saveWord(Appendable output, String indent) throws IOException {
        output.append(indent).append("  <page");
        output.append(" width='").append(Integer.toString(this._wordOptions._pageWidth)).append("'");
        output.append(" height='").append(Integer.toString(this._wordOptions._pageHeight)).append("'");
        output.append(" orientation='").append(Integer.toString(this._wordOptions._pageOrientation)).append("'");
        output.append("/>\n");
        if (this._wordOptions instanceof OptionsWordView.OptionsTreeView) {
            OptionsWordView.OptionsTreeView treeView = (OptionsWordView.OptionsTreeView)this._wordOptions;
            output.append(indent).append("  <gsr");
            output.append(" auto='").append(treeView._gsrAuto ? "true" : "false").append("'");
            output.append(" level='").append(Integer.toString(treeView._gsrLevel)).append("'");
            output.append("/>\n");
        }
    }

    private void saveCAA(Appendable output, String indent) throws IOException {
        List<Attr.Key> attrs = this._caaOptions.getAttributes();
        if (attrs != null && attrs.size() > 0) {
            for (Attr.Key attr : attrs) {
                output.append(indent).append("  <attribute");
                Attr.DefaultKey.saveToXML((Attr.Key)attr, (Appendable)output);
                output.append("/>\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Element xmlElt) {
        this._format = Format.valueOf(xmlElt.getAttribute("format").toUpperCase());
        this._file = new File(xmlElt.getAttribute("path"));
        this._forOneHour = xmlElt.getAttribute("forOneHour").equals("true");
        if (this._format.isWordExport()) {
            OptionsWordView options = this._format == Format.TREE_WORD ? new OptionsWordView.OptionsTreeView() : new OptionsWordView();
            try {
                NodeList nodes = xmlElt.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node xmlChild = nodes.item(i);
                    String xmlName = xmlChild.getNodeName();
                    if (xmlName.equals("page")) {
                        options._pageWidth = Integer.parseInt(((Element)xmlChild).getAttribute("width"));
                        options._pageHeight = Integer.parseInt(((Element)xmlChild).getAttribute("height"));
                        options._pageOrientation = Integer.parseInt(((Element)xmlChild).getAttribute("orientation"));
                        continue;
                    }
                    if (!xmlName.equals("gsr")) continue;
                    options._gsrAuto = Boolean.parseBoolean(((Element)xmlChild).getAttribute("auto"));
                    options._gsrLevel = Integer.parseInt(((Element)xmlChild).getAttribute("level"));
                }
                this._wordOptions = options;
            }
            catch (Exception exc) {
                _LOG.log(Level.WARNING, "Error during read ExportItemTree options", exc);
            }
        } else {
            this._wordOptions = null;
        }
        if (this._format == Format.CAA_DOCBOOK || this._format == Format.CAA_WORD) {
            boolean merge = xmlElt.getAttribute("merge").equals("true");
            ArrayList<Attr.Key> attrs = new ArrayList<Attr.Key>();
            try {
                NodeList nodes = xmlElt.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node xmlChild = nodes.item(i);
                    String xmlName = xmlChild.getNodeName();
                    if (!xmlName.equals("attribute")) continue;
                    attrs.add(Attr.DefaultKey.loadFromXML((Element)((Element)xmlChild)));
                }
            }
            catch (Exception e) {
                _LOG.log(Level.WARNING, "Error during read ExportItemCAA options", e);
            }
            finally {
                this._caaOptions = new CAASelector(attrs, merge);
            }
        } else {
            this._caaOptions = null;
        }
    }

    public String getAbstractOptions() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("<html>");
        switch (this._format) {
            case TREE_WORD: {
                this._wordOptions.appendAbstract(buffer);
                break;
            }
            case CAA_DOCBOOK: {
                this._caaOptions.appendAbstract(buffer);
                break;
            }
            case CAA_WORD: {
                this._wordOptions.appendAbstract(buffer);
                this._caaOptions.appendAbstract(buffer);
                break;
            }
            case EVENTS_WORD: {
                this._wordOptions.appendAbstract(buffer);
                break;
            }
            case RESULT_WORD: {
                this._wordOptions.appendAbstract(buffer);
            }
        }
        if (this._forOneHour) {
            buffer.append(ResCompute.getString("KEY_0050"));
        }
        if (buffer.length() == 6) {
            buffer.append(ResCompute.getString("BATCH_EXPORT_MSG_NO_OPTION"));
        }
        buffer.append("</html>");
        return buffer.toString();
    }

    public Format getFormat() {
        return this._format;
    }

    public void setFormat(Format value) {
        assert (value != null);
        if (value == null) {
            return;
        }
        if (this._format == value) {
            return;
        }
        this._format = value;
        switch (this._format) {
            case RESULT_WORD: 
            case EVENTS_WORD: {
                this._wordOptions = new OptionsWordView();
                this._caaOptions = null;
                break;
            }
            case CAA_DOCBOOK: {
                this._wordOptions = null;
                this._caaOptions = new CAASelector(new ArrayList<Attr.Key>(), false);
                break;
            }
            case TREE_WORD: {
                this._wordOptions = new OptionsWordView.OptionsTreeView();
                this._caaOptions = null;
                break;
            }
            case CAA_WORD: {
                this._wordOptions = new OptionsWordView();
                this._caaOptions = new CAASelector(new ArrayList<Attr.Key>(), false);
                break;
            }
            default: {
                this._wordOptions = null;
                this._caaOptions = null;
            }
        }
    }

    public File getFile() {
        return this._file;
    }

    public void setFile(File value) {
        this._file = value;
    }

    public boolean isForOneHour() {
        return this._forOneHour;
    }

    public void setForOneHour(boolean value) {
        this._forOneHour = value;
    }

    public OptionsWordView getWordOptions() {
        return this._wordOptions;
    }

    public CAASelector getCAAOptions() {
        return this._caaOptions;
    }

    public static String formatToString(int w, int h, int o) {
        int tp = w;
        String orientation = "P";
        if (o == 0) {
            tp = h;
            orientation = "L";
            h = w;
        }
        if (Math.abs(2380 - tp) < 10) {
            return "A0" + orientation;
        }
        if (Math.abs(1684 - tp) < 2) {
            return "A1" + orientation;
        }
        if (Math.abs(1190 - tp) < 2) {
            return "A2" + orientation;
        }
        if (Math.abs(842 - tp) < 2) {
            return "A3" + orientation;
        }
        if (Math.abs(728 - tp) < 2) {
            return "B4" + orientation;
        }
        if (Math.abs(612 - tp) < 2 && Math.abs(792 - h) < 2) {
            return "L" + orientation;
        }
        if (Math.abs(595 - tp) < 2) {
            return "A4" + orientation;
        }
        if (Math.abs(515 - tp) < 2) {
            return "B5" + orientation;
        }
        return "";
    }

    public boolean sameDestination(ExportItem item) {
        if (item == null) {
            return false;
        }
        if (item == this) {
            return true;
        }
        if (!(item instanceof ExportItem)) {
            return false;
        }
        if (item.getFile() == null ^ this.getFile() == null) {
            return false;
        }
        return item.getFile() == null || item.getFormat().equals((Object)this.getFormat());
    }

    public static final String getAcceptableTreePathFromOriginal(String original, boolean forDisplayUse) {
        if (forDisplayUse && System.getProperty("os.name").contains("Windows")) {
            return original.replace('/', '\\');
        }
        return original;
    }

    public static final String getOriginalFromAcceptableTreePath(String treePath) {
        return treePath.replace('(', ';').replace(")", "");
    }

    public static final File createDirectory(BatchItem item, File file) {
        String absolutPath = file.getAbsolutePath();
        if (absolutPath.contains(BALISE_PATH)) {
            absolutPath = absolutPath.replace(BALISE_PATH, ExportItem.getAcceptableTreePathFromOriginal(item.getTreePathForFiles(), false));
        }
        String path = item.getTreePath();
        String[] splitedPath = path.split("/");
        if (absolutPath.contains(BALISE_PROJ)) {
            absolutPath = absolutPath.replace(BALISE_PROJ, splitedPath[0]);
        }
        if (absolutPath.contains(BALISE_SYST)) {
            absolutPath = absolutPath.replace(BALISE_SYST, splitedPath[1]);
        }
        splitedPath = splitedPath[2].split(";");
        if (absolutPath.contains(BALISE_TREE)) {
            absolutPath = absolutPath.replace(BALISE_TREE, splitedPath[0]);
        }
        if (absolutPath.contains(BALISE_VERS)) {
            absolutPath = absolutPath.replace(BALISE_VERS, '(' + splitedPath[1] + ')');
        }
        return new File(absolutPath);
    }

    public static final String getPathWithBalises(BatchItem item, String absolutePath) {
        String refPath = item.getTreePath();
        if (refPath.startsWith("/")) {
            refPath = refPath.substring(1);
        }
        String[] splitedPath = refPath.split("/");
        String result = absolutePath;
        String acceptableTreePath = ExportItem.getAcceptableTreePathFromOriginal(item.getTreePathForFiles(), true);
        if (result.contains(acceptableTreePath)) {
            result = result.replace(acceptableTreePath, BALISE_PATH);
        }
        if (result.contains(splitedPath[0])) {
            result = result.replace(splitedPath[0], BALISE_PROJ);
        }
        if (result.contains(splitedPath[1])) {
            result = result.replace(splitedPath[1], BALISE_SYST);
        }
        if (splitedPath[2].contains(";")) {
            if (result.contains((splitedPath = splitedPath[2].split(";"))[0])) {
                result = result.replace(splitedPath[0], BALISE_TREE);
            }
            if (result.contains('(' + splitedPath[1] + ')')) {
                result = result.replace('(' + splitedPath[1] + ')', BALISE_VERS);
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExportItem)) {
            return false;
        }
        ExportItem expItem = (ExportItem)obj;
        if (expItem.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (expItem.getFormat() != null && !expItem.getFormat().equals((Object)this.getFormat())) {
            return false;
        }
        if (expItem.getFile() == null ^ this.getFile() == null) {
            return false;
        }
        if (expItem.getFile() != null && !expItem.getFile().equals(this.getFile())) {
            return false;
        }
        if (expItem.isForOneHour() != this._forOneHour) {
            return false;
        }
        if (expItem._caaOptions == null ^ this._caaOptions == null) {
            return false;
        }
        if (expItem._caaOptions != null && !expItem._caaOptions.equals(this._caaOptions)) {
            return false;
        }
        if (expItem._wordOptions == null ^ this._wordOptions == null) {
            return false;
        }
        return expItem._wordOptions == null || expItem._wordOptions.equals(this._wordOptions);
    }

    public int hashCode() {
        int hashCode = this.getFormat() != null ? this.getFormat().hashCode() : 0;
        hashCode = hashCode * 2 + (this.getFile() != null ? this.getFile().hashCode() : 0);
        hashCode = hashCode * 3 + (this.isForOneHour() ? 1 : 0);
        hashCode = hashCode * 5 + (this._caaOptions != null ? this._caaOptions.hashCode() : 0);
        hashCode = hashCode * 7 + (this._wordOptions != null ? this._wordOptions.hashCode() : 0);
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Format: ").append((Object)this._format).append(" | ");
        sb.append("File").append(this._file.getAbsolutePath()).append(" | ");
        return sb.toString();
    }

    static {
        BALISES.add(BALISE_PATH);
        BALISES.add(BALISE_PROJ);
        BALISES.add(BALISE_SYST);
        BALISES.add(BALISE_TREE);
        BALISES.add(BALISE_VERS);
    }

    public static enum Format {
        RESULT_WORD(".word.xml", ResCompute.getString("EXPORT_FORMAT_RESULT_WORD")),
        RESULT_XML(".xml", ResCompute.getString("EXPORT_FORMAT_RESULT_XML")),
        RESULT_DOCBOOK(".docbook.xml", ResCompute.getString("EXPORT_FORMAT_RESULT_DOCBOOK")),
        CAA_DOCBOOK(".caa.docbook.xml", ResCompute.getString("EXPORT_FORMAT_CAA_DOCBOOK")),
        CAA_WORD(".caa.word.xml", ResCompute.getString("EXPORT_FORMAT_CAA_WORD")),
        TREE_WORD(".tree.word.xml", ResCompute.getString("EXPORT_FORMAT_RESULT_TREE_WORD")),
        EVENTS_WORD(".list.word.xml", ResCompute.getString("EXPORT_FORMAT_RESULT_EVENT_WORD"));

        String _ext;
        String _keyLbl;

        private Format(String ext, String keyLbl) {
            this._ext = ext;
            this._keyLbl = keyLbl;
        }

        public String getLabel() {
            return this._keyLbl;
        }

        public String getExtention() {
            return this._ext;
        }

        public boolean withComputeExt() {
            switch (this) {
                case RESULT_WORD: 
                case RESULT_DOCBOOK: 
                case RESULT_XML: {
                    return true;
                }
            }
            return false;
        }

        public boolean isWordExport() {
            switch (this) {
                case RESULT_WORD: 
                case CAA_WORD: 
                case TREE_WORD: 
                case EVENTS_WORD: {
                    return true;
                }
            }
            return false;
        }

        public static final Format[] getValues(String computeKey) {
            if (computeKey.equals("MCS")) {
                return Format.values();
            }
            Format[] formatValues = new Format[]{RESULT_XML, RESULT_DOCBOOK, RESULT_WORD};
            return formatValues;
        }
    }
}

