/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.bddmemory;

import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.bddmemory.OptionsAralia;
import com.dassault.cecilia.plugin.faulttree.compute.bddmemory.OptionsAraliaTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OptionsAralia2Panel
extends JPanel {
    private JLabel _configLabel = new JLabel(ResCompute.getString("DLG_ARALIA_CONFIGURATION"));
    private JComboBox _configChoice = new JComboBox();
    private int _nbTextField = 11;
    private int _nbTextFieldInt = 9;
    private int _nbTextFieldDouble = 2;
    private OptionsAraliaTextField[] _textFieldsInt = new OptionsAraliaTextField[this._nbTextFieldInt];
    private OptionsAraliaTextField[] _textFieldsDouble = new OptionsAraliaTextField[this._nbTextFieldDouble];
    private JLabel[] _labelTextFields = new JLabel[this._nbTextField];
    private OptionsAralia _configurator;
    private Map<OptionsAralia.Type, Map<String, String>> _configs = new HashMap<OptionsAralia.Type, Map<String, String>>();

    public OptionsAralia2Panel() {
        this.createPanel();
    }

    public void configurate(OptionsAralia config) {
        this._configurator = config;
        OptionsAralia.Type typeConfig = this._configurator.getConfig();
        this._configChoice.setSelectedItem((Object)typeConfig);
        this.selectConfig(typeConfig);
    }

    public OptionsAralia.Type getTypeConfig() {
        return (OptionsAralia.Type)((Object)this._configChoice.getSelectedItem());
    }

    public Map<String, String> getUserConfig() {
        OptionsAralia.Type typeConfig = this.getTypeConfig();
        Map<String, String> config = this._configs.get((Object)typeConfig);
        if (typeConfig == OptionsAralia.Type.CFGUser) {
            this.copyFromCtrl(config);
        }
        return config;
    }

    private void createPanel() {
        int i;
        for (i = 0; i < this._nbTextFieldInt; ++i) {
            this._textFieldsInt[i] = new OptionsAraliaTextField(10, false);
        }
        for (i = 0; i < this._nbTextFieldDouble; ++i) {
            this._textFieldsDouble[i] = new OptionsAraliaTextField(10, true);
        }
        this._labelTextFields[0] = new JLabel(ResCompute.getString("DLG_ARALIA_INITIALE"));
        this._labelTextFields[1] = new JLabel(ResCompute.getString("DLG_ARALIA_MINIMUM"));
        this._labelTextFields[2] = new JLabel(ResCompute.getString("DLG_ARALIA_MAXIMUM"));
        this._labelTextFields[3] = new JLabel(ResCompute.getString("DLG_ARALIA_INITIAL"));
        this._labelTextFields[4] = new JLabel(ResCompute.getString("DLG_ARALIA_MINIMUM"));
        this._labelTextFields[5] = new JLabel(ResCompute.getString("DLG_ARALIA_MAXIMUM"));
        this._labelTextFields[6] = new JLabel(ResCompute.getString("DLG_ARALIA_RATIO_AUGMENTATION"));
        this._labelTextFields[7] = new JLabel(ResCompute.getString("DLG_ARALIA_RATIO_DIMINUTION"));
        this._labelTextFields[8] = new JLabel(ResCompute.getString("DLG_ARALIA_TABLE_BDD"));
        this._labelTextFields[9] = new JLabel(ResCompute.getString("DLG_ARALIA_NOMBRE_PAGES"));
        this._labelTextFields[10] = new JLabel(ResCompute.getString("DLG_ARALIA_PERIODE_GARBAGE"));
        this._configChoice.addItem(OptionsAralia.Type.CFG1);
        this._configChoice.addItem(OptionsAralia.Type.CFG2);
        this._configChoice.addItem(OptionsAralia.Type.CFG3);
        this._configChoice.addItem(OptionsAralia.Type.CFGUser);
        this._configChoice.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText(((OptionsAralia.Type)((Object)value)).getLabel());
                return this;
            }
        });
        this._configChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsAralia2Panel.this.selectConfig((OptionsAralia.Type)((Object)OptionsAralia2Panel.this._configChoice.getSelectedItem()));
            }
        });
        JPanel tableBDDPanel = new JPanel();
        tableBDDPanel.setLayout(new GridBagLayout());
        tableBDDPanel.setBorder(BorderFactory.createTitledBorder(ResCompute.getString("DLG_ARALIA_TABLE_BDD")));
        tableBDDPanel.add((Component)this._labelTextFields[0], new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 5, 5), 0, 0));
        tableBDDPanel.add((Component)this._textFieldsInt[0], new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(1, 1, 5, 5), 0, 0));
        tableBDDPanel.add((Component)this._labelTextFields[1], new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 5, 5), 0, 0));
        tableBDDPanel.add((Component)this._textFieldsInt[1], new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(1, 1, 5, 5), 0, 0));
        tableBDDPanel.add((Component)this._labelTextFields[2], new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 5, 5), 0, 0));
        tableBDDPanel.add((Component)this._textFieldsInt[2], new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(1, 1, 5, 5), 0, 0));
        JPanel tableOperationPanel = new JPanel();
        tableOperationPanel.setBorder(BorderFactory.createTitledBorder(ResCompute.getString("DLG_ARALIA_TABLE_OPERATION")));
        tableOperationPanel.setLayout(new GridBagLayout());
        tableOperationPanel.add((Component)this._labelTextFields[3], new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 5, 5), 0, 0));
        tableOperationPanel.add((Component)this._textFieldsInt[3], new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 5, 5), 0, 0));
        tableOperationPanel.add((Component)this._labelTextFields[4], new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 5, 5), 0, 0));
        tableOperationPanel.add((Component)this._textFieldsInt[4], new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 5, 5), 0, 0));
        tableOperationPanel.add((Component)this._labelTextFields[5], new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 5, 5), 0, 0));
        tableOperationPanel.add((Component)this._textFieldsInt[5], new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 5, 5), 0, 0));
        JPanel tableDiversPanel = new JPanel();
        tableDiversPanel.setLayout(new GridBagLayout());
        tableDiversPanel.add((Component)this._labelTextFields[6], new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 5, 5), 0, 0));
        tableDiversPanel.add((Component)this._textFieldsDouble[0], new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 5, 5), 0, 0));
        tableDiversPanel.add((Component)this._labelTextFields[7], new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 5, 5), 0, 0));
        tableDiversPanel.add((Component)this._textFieldsDouble[1], new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 5, 5), 0, 0));
        tableDiversPanel.add((Component)this._labelTextFields[8], new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 5, 5), 0, 0));
        tableDiversPanel.add((Component)this._textFieldsInt[6], new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 5, 5), 0, 0));
        tableDiversPanel.add((Component)this._labelTextFields[9], new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 5, 5), 0, 0));
        tableDiversPanel.add((Component)this._textFieldsInt[7], new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 5, 5), 0, 0));
        tableDiversPanel.add((Component)this._labelTextFields[10], new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 5, 5), 0, 0));
        tableDiversPanel.add((Component)this._textFieldsInt[8], new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this._configLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 1, 1), 0, 0));
        this.add((Component)this._configChoice, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 17, 1, new Insets(10, 1, 1, 10), 0, 0));
        this.add((Component)tableBDDPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 10, 1), 0, 0));
        this.add((Component)tableOperationPanel, new GridBagConstraints(1, 2, 0, 1, 1.0, 0.0, 17, 1, new Insets(10, 1, 10, 10), 0, 0));
        this.add((Component)tableDiversPanel, new GridBagConstraints(0, 3, 0, 1, 1.0, 1.0, 17, 1, new Insets(1, 10, 10, 10), 0, 0));
    }

    private void selectConfig(OptionsAralia.Type typeConfig) {
        Map<String, String> config = this._configs.get((Object)typeConfig);
        if (config == null) {
            config = this._configurator.getConfigOptions(typeConfig);
            if (typeConfig == OptionsAralia.Type.CFGUser) {
                config = new LinkedHashMap<String, String>(config);
            }
            this._configs.put(typeConfig, config);
        }
        if (typeConfig == OptionsAralia.Type.CFGUser) {
            this.editTextField(this._textFieldsInt, true);
            this.editTextField(this._textFieldsDouble, true);
        } else {
            this.editTextField(this._textFieldsInt, false);
            this.editTextField(this._textFieldsDouble, false);
        }
        this.copyToCtrl(config);
    }

    public boolean validateData() {
        int i;
        if (this.getTypeConfig() != OptionsAralia.Type.CFGUser) {
            return true;
        }
        for (i = 0; i < this._textFieldsInt.length; ++i) {
            if (this._textFieldsInt[i].getText().length() != 0) continue;
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResCompute.getString("DLG_ARALIA_ERREUR_CHAMP_VIDE"), ResCompute.getString("DLG_ARALIA_ERREUR_PARAMETRES"), 0);
            return false;
        }
        for (i = 0; i < this._textFieldsDouble.length; ++i) {
            if (this._textFieldsDouble[i].getText().length() != 0) continue;
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResCompute.getString("DLG_ARALIA_ERREUR_CHAMP_VIDE"), ResCompute.getString("DLG_ARALIA_ERREUR_PARAMETRES"), 0);
            return false;
        }
        int min = Integer.parseInt(this._textFieldsInt[1].getText());
        int max = Integer.parseInt(this._textFieldsInt[2].getText());
        int size = Integer.parseInt(this._textFieldsInt[0].getText());
        if (min > max) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResCompute.getString("DLG_ARALIA_ERREUR_BDD"), ResCompute.getString("DLG_ARALIA_ERREUR_PARAMETRES"), 0);
            this._textFieldsInt[1].setText(this._textFieldsInt[1].getPreviousValue());
            this._textFieldsInt[2].setText(this._textFieldsInt[2].getPreviousValue());
            return false;
        }
        if (min > size || max < size) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResCompute.msgFormat("DLG_ARALIA_ERREUR_BDD_SIZE", min, max), ResCompute.getString("DLG_ARALIA_ERREUR_PARAMETRES"), 0);
            this._textFieldsInt[1].setText(this._textFieldsInt[1].getPreviousValue());
            this._textFieldsInt[2].setText(this._textFieldsInt[2].getPreviousValue());
            this._textFieldsInt[0].setText(this._textFieldsInt[0].getPreviousValue());
            return false;
        }
        min = Integer.parseInt(this._textFieldsInt[4].getText());
        max = Integer.parseInt(this._textFieldsInt[5].getText());
        size = Integer.parseInt(this._textFieldsInt[3].getText());
        if (min > max) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResCompute.getString("DLG_ARALIA_ERREUR_OPERATION"), ResCompute.getString("DLG_ARALIA_ERREUR_PARAMETRES"), 0);
            this._textFieldsInt[3].setText(this._textFieldsInt[3].getPreviousValue());
            this._textFieldsInt[4].setText(this._textFieldsInt[4].getPreviousValue());
            return false;
        }
        if (min > size || max < size) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResCompute.msgFormat("DLG_ARALIA_ERREUR_OPERATION_SIZE", min, max), ResCompute.getString("DLG_ARALIA_ERREUR_PARAMETRES"), 0);
            this._textFieldsInt[3].setText(this._textFieldsInt[3].getPreviousValue());
            this._textFieldsInt[4].setText(this._textFieldsInt[4].getPreviousValue());
            this._textFieldsInt[5].setText(this._textFieldsInt[5].getPreviousValue());
            return false;
        }
        return true;
    }

    private void editTextField(JTextField[] textfield, boolean active) {
        int size = textfield.length;
        for (int i = 0; i < size; ++i) {
            textfield[i].setEditable(active);
        }
    }

    private void copyFromCtrl(Map<String, String> map) {
        map.put("BDD-table maximum", this._textFieldsInt[2].getText());
        map.put("BDD-table minimum", this._textFieldsInt[1].getText());
        map.put("BDD-table size", this._textFieldsInt[0].getText());
        map.put("operation-table maximum", this._textFieldsInt[5].getText());
        map.put("operation-table minimum", this._textFieldsInt[4].getText());
        map.put("operation-table size", this._textFieldsInt[3].getText());
        map.put("page-size", this._textFieldsInt[6].getText());
        map.put("maximum-page-number", this._textFieldsInt[7].getText());
        map.put("enlargement-ratio", this._textFieldsDouble[0].getText());
        map.put("reduction-ratio", this._textFieldsDouble[1].getText());
        map.put("garbage-collector-period", this._textFieldsInt[8].getText());
    }

    private void copyToCtrl(Map<String, String> map) {
        this._textFieldsInt[0].setText(map.get("BDD-table size"));
        this._textFieldsInt[1].setText(map.get("BDD-table minimum"));
        this._textFieldsInt[2].setText(map.get("BDD-table maximum"));
        this._textFieldsInt[3].setText(map.get("operation-table size"));
        this._textFieldsInt[4].setText(map.get("operation-table minimum"));
        this._textFieldsInt[5].setText(map.get("operation-table maximum"));
        this._textFieldsDouble[0].setText(map.get("enlargement-ratio"));
        this._textFieldsDouble[1].setText(map.get("reduction-ratio"));
        this._textFieldsInt[6].setText(map.get("page-size"));
        this._textFieldsInt[7].setText(map.get("maximum-page-number"));
        this._textFieldsInt[8].setText(map.get("garbage-collector-period"));
    }
}

