/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDConfig;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDConfigProxy;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineControl;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineExecute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineProcess;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class EngineBDDAbstract
implements EngineExecute {
    private static Logger _LOG = Logger.getLogger(EngineBDDAbstract.class.getPackage().getName());
    boolean _distrib = false;
    EngineBDDConfig _config;
    File _optionsFile;
    List<File> _inputFiles;
    StringBuffer _command;

    public EngineBDDAbstract(EngineBDDConfig config) {
        this._config = new EngineBDDConfigProxy(config);
        this._inputFiles = new ArrayList<File>();
        this._command = new StringBuffer(1024);
    }

    protected void finalize() throws Throwable {
        if (this._optionsFile != null && !this._optionsFile.delete()) {
            _LOG.info("Can not delete the configuration file : " + this._optionsFile);
        }
    }

    public void addInputFile(File inputFile) {
        this._inputFiles.add(inputFile);
    }

    public EngineBDDConfig.EngineType getEngineType() {
        return this._config.getEngineType(this._distrib);
    }

    public Appendable getCmdsAppendable() {
        return this._command;
    }

    public void defineComputeType(BooleanStore store) {
        switch (this._config.getComputeType()) {
            case LOCAL: {
                this._distrib = false;
                break;
            }
            case DISTRIB: {
                this._distrib = true;
                break;
            }
            case AUTOMATIC: {
                String bigTree = store.getInfo(BooleanStore.INFO_BIGTREE);
                if (bigTree != null && bigTree.equals("true")) {
                    _LOG.info("EngineBDD - Automatic compute type : BigTree => type distrib");
                    this._distrib = true;
                    break;
                }
                double note = store.getNbrLeaves() * Integer.getInteger("cecilia.ft.engine.type.AutomaticWeightLeaf", 100) / 100 + store.getNbrGates() * Integer.getInteger("cecilia.ft.engine.type.AutomaticWeightGate", 50) / 100;
                if (note > (double)Integer.getInteger("cecilia.ft.engine.type.AutomaticLimit", 150).intValue()) {
                    this._distrib = true;
                }
                if (!_LOG.isLoggable(Level.INFO)) break;
                StringBuffer buffer = new StringBuffer();
                buffer.append("EngineBDD - Automatic compute type (NbrLeaves=").append(store.getNbrLeaves());
                buffer.append(",NbrGates=").append(store.getNbrGates()).append(")");
                buffer.append(">[Note=").append(note).append("]");
                buffer.append(">[Distrib=").append(this._distrib).append("]");
                _LOG.info(buffer.toString());
            }
        }
        if (!this._distrib) {
            this._optionsFile = this._config.getOptionsLocalFile();
        }
    }

    public abstract void prepareComputeType();

    protected Request createRequest() {
        CECILIAClient client = this._config.getDistribClient();
        Request request = client.getNewRequest();
        switch (this._config.getEngineType(true)) {
            case Aralia4: {
                request.setEngine("ARALIA4");
                break;
            }
            case CeciliaBDD: {
                request.setEngine("CECILIABDD");
            }
        }
        return request;
    }

    public String createResultID(String file, Request request) {
        if (request != null) {
            CECILIAClient client = this._config.getDistribClient();
            String UID = client.makeUniqueFileID(file, false);
            request.addResultFile(UID);
            return UID;
        }
        return file;
    }

    @Override
    public EngineBDDConfig.ResultType execute(EngineControl ctrl) {
        if (this._distrib) {
            _LOG.log(Level.INFO, "EngineBDD - execute in distrib mode with " + (Object)((Object)this._config.getEngineType(true)));
            return this.executeDistrib(ctrl);
        }
        _LOG.log(Level.INFO, "EngineBDD - execute in local mode with " + (Object)((Object)this._config.getEngineType(false)));
        return this.executeLocal(ctrl);
    }

    protected abstract EngineBDDConfig.ResultType executeDistrib(EngineControl var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EngineBDDConfig.ResultType executeRequest(EngineControl ctrl, Request request, String additionalCmd) {
        CECILIAClient client = this._config.getDistribClient();
        if (this._inputFiles.size() > 0) {
            for (File file : this._inputFiles) {
                String inputUniqueName = client.makeUniqueFileID(file.getAbsolutePath(), false);
                request.addNeededFile(inputUniqueName);
            }
        }
        File commandFile = null;
        try {
            commandFile = File.createTempFile("EngineBDD", ".txt");
            try (FileWriter writer = null;){
                writer = new FileWriter(commandFile);
                writer.write(this._command.toString());
                writer.write(additionalCmd);
            }
        }
        catch (IOException ioe) {
            _LOG.log(Level.WARNING, "Error during create file command", ioe);
            return EngineBDDConfig.ResultType.ErrPrepareEngine;
        }
        String commandUID = client.makeUniqueFileID(commandFile.getAbsolutePath(), false);
        request.setCmdFileName(commandUID);
        request.setParsed(true);
        client.addRequestToStock(request);
        try {
            boolean cancelRequest = false;
            while (!request.isFinished()) {
                Thread.sleep(100L);
                if (!ctrl.isCanceled() || cancelRequest) continue;
                client.cancelRequest(request, true);
                cancelRequest = true;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (_LOG.isLoggable(Level.FINER)) {
            _LOG.finer("Distrib Request Historic" + request.getHistoString(client.getPeerJXTA()));
        }
        if (request.getState() == ReqState.FINISHED_SUCCESFULY) {
            return EngineBDDConfig.ResultType.NoError;
        }
        ctrl.appendUserMsg(ResCompute.msgFormat("MSG_ENGINE_DISTRIB_ERROR", request.getState().getDesc()));
        return EngineBDDConfig.ResultType.ErrCompute;
    }

    protected abstract EngineBDDConfig.ResultType executeLocal(EngineControl var1);

    protected EngineBDDConfig.ResultType executeCompute(EngineControl ctrl, String additionalCmd) {
        Thread thread = null;
        EngineVerify verifyCtrl = new EngineVerify(ctrl);
        EngineBDDConfig.EngineType type = this._config.getEngineType(false);
        if (type != null) {
            switch (type) {
                case Aralia4: {
                    thread = this.createThreadAralia4(this._command.toString(), additionalCmd, verifyCtrl);
                    break;
                }
                case CeciliaBDD: {
                    thread = this.createThreadCeciliaBDD(this._command.toString(), additionalCmd, verifyCtrl);
                }
            }
        }
        if (thread == null) {
            return EngineBDDConfig.ResultType.ErrNoEngine;
        }
        thread.start();
        try {
            while (thread.isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!ctrl.isCanceled() || ((EngineProcess)thread).getProcess() == null) continue;
                thread.interrupt();
                Process process = ((EngineProcess)thread).getProcess();
                process.destroy();
                process.getInputStream().close();
                process.getOutputStream().close();
                process.getErrorStream().close();
                break;
            }
            if (verifyCtrl._bufferError.length() > 0) {
                _LOG.log(Level.INFO, "Error msgs during compute : \n" + verifyCtrl._bufferError.toString());
                if (verifyCtrl._bMemoryError) {
                    return EngineBDDConfig.ResultType.ErrMemoryExhaustid;
                }
                return EngineBDDConfig.ResultType.ErrCompute;
            }
        }
        catch (IOException e) {
            _LOG.log(Level.WARNING, "Compute local BDDEngine error.", e);
            verifyCtrl.appendUserMsg(ResCompute.msgFormat("MSG_ENGINE_EXCEPTION_ERROR", e.getMessage()));
            return EngineBDDConfig.ResultType.ErrCompute;
        }
        return EngineBDDConfig.ResultType.NoError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EngineProcess createThreadAralia4(String cmd, String additionalCmd, EngineControl ctrl) {
        List<String> execArray = this._config.createExecLine();
        if (execArray == null) {
            return null;
        }
        execArray = new ArrayList<String>(execArray);
        File commandFile = null;
        try {
            commandFile = File.createTempFile("BDDEngine", ".cdag");
            try (FileWriter writer = null;){
                writer = new FileWriter(commandFile);
                writer.write(cmd);
                if (additionalCmd.length() > 0) {
                    writer.write(additionalCmd);
                }
            }
        }
        catch (IOException ioe) {
            _LOG.log(Level.WARNING, "Error during create Aralia4 command file", ioe);
            return null;
        }
        if (this._optionsFile != null) {
            execArray.add(this._optionsFile.getAbsolutePath());
        }
        if (this._inputFiles.size() > 0) {
            for (File file : this._inputFiles) {
                execArray.add(file.getAbsolutePath());
            }
        }
        execArray.add(commandFile.getAbsolutePath());
        String[] args = new String[execArray.size()];
        EngineProcess thread = new EngineProcess(execArray.toArray(args), commandFile, "exit;\n", ctrl);
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EngineProcess createThreadCeciliaBDD(String cmd, String additionalCmd, EngineControl ctrl) {
        List<String> execArray = this._config.createExecLine();
        if (execArray == null) {
            return null;
        }
        execArray = new ArrayList<String>(execArray);
        File commandFile = null;
        try {
            commandFile = File.createTempFile("BDDEngineCmd", ".cdag");
            try (FileWriter writer = null;){
                writer = new FileWriter(commandFile);
                writer.write(cmd);
                if (additionalCmd.length() > 0) {
                    writer.write(additionalCmd);
                }
            }
        }
        catch (IOException ioe) {
            _LOG.log(Level.WARNING, "Error during create CeciliaBDD command file", ioe);
            return null;
        }
        execArray.add("--verify");
        if (this._optionsFile != null) {
            execArray.add("-c");
            execArray.add(this._optionsFile.getAbsolutePath());
        }
        if (this._inputFiles.size() > 0) {
            execArray.add("-f");
            for (File file : this._inputFiles) {
                execArray.add(file.getAbsolutePath());
            }
        }
        execArray.add("-e");
        execArray.add(commandFile.getAbsolutePath());
        String[] args = new String[execArray.size()];
        EngineProcess thread = new EngineProcess(execArray.toArray(args), commandFile, "", ctrl);
        return thread;
    }

    class EngineVerify
    implements EngineControl {
        EngineControl _delegate;
        boolean _bMemoryError;
        boolean _bOtherError;
        StringBuffer _bufferError;

        EngineVerify(EngineControl delegate) {
            this._delegate = delegate;
            this._bMemoryError = false;
            this._bOtherError = false;
            this._bufferError = new StringBuffer(1024);
        }

        @Override
        public void appendErr(String msg) {
            if (msg.contains("Memory exhausted")) {
                this._bufferError.append(msg);
                this._bMemoryError = true;
                this.appendUserMsg(ResCompute.getString("MSG_ENGINE_MEMORY_ERROR"));
            } else {
                if (this._bufferError.length() < 1024) {
                    this._bufferError.append(msg);
                }
                if (!this._bOtherError) {
                    this._bOtherError = true;
                    this.appendUserMsg(ResCompute.msgFormat("MSG_ENGINE_OTHER_ERROR", msg));
                }
            }
            this._delegate.appendErr(msg);
        }

        @Override
        public void appendOut(String msg) {
            this._delegate.appendOut(msg);
        }

        @Override
        public boolean isCanceled() {
            return this._delegate.isCanceled();
        }

        @Override
        public void appendUserMsg(String msg) {
            this._delegate.appendUserMsg(msg);
        }
    }
}

