/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.lib.distrib.jxtautility.JXTARuntimeException;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonClient;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMCS;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDConfig;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineControl;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineMELHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EngineBDDMEL
extends EngineBDDAbstract {
    private static Logger _LOG = Logger.getLogger(EngineBDDMEL.class.getPackage().getName());
    Boolean _stopEngine = false;
    int _nbrTreated = 0;
    TargetsAccessor _targets;
    EngineMELHelper _melHelperCompute;
    Request _requestNominal = null;
    BooleanMCS _mcsForPessimistCompute;

    public EngineBDDMEL(EngineBDDConfig config) {
        super(config);
    }

    public void prepareCompute(TargetsAccessor targets, EngineMELHelper melHelperCompute) {
        this._targets = targets;
        this._melHelperCompute = melHelperCompute;
    }

    @Override
    public void prepareComputeType() {
        if (this._distrib) {
            this._requestNominal = this.createRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected EngineBDDConfig.ResultType executeDistrib(EngineControl ctrl) {
        CECILIAClient client = this._config.getDistribClient();
        int nbrServer = client.numberServer();
        if (nbrServer == 0) {
            client.refreshNetwork();
            nbrServer = client.numberServer();
            if (nbrServer == 0) {
                int nbrRefusedServeur = client.getConnexionRefusedPeer().size();
                if (nbrRefusedServeur > 0) {
                    ctrl.appendUserMsg(ResCompute.getString("MSG_ENGINE_DISTRIB_SERVER_NO_COMPATIBLE"));
                } else {
                    ctrl.appendUserMsg(ResCompute.getString("MSG_ENGINE_DISTRIB_SERVER_NO_AVAILABLE"));
                }
                return EngineBDDConfig.ResultType.ErrCompute;
            }
        }
        if (ctrl.isCanceled()) {
            return EngineBDDConfig.ResultType.ErrCompute;
        }
        boolean computeNominal = true;
        boolean forAralia4 = this.getEngineType() == EngineBDDConfig.EngineType.Aralia4;
        File dagFile = null;
        if (this._inputFiles.size() == 1) {
            dagFile = (File)this._inputFiles.get(0);
        }
        EngineBDDConfig.ResultType execResult = EngineBDDConfig.ResultType.NoError;
        if (this._melHelperCompute.withPessimistCompute()) {
            if (this._mcsForPessimistCompute != null) {
                execResult = this.transformMCSResultIfExist();
                if (execResult != EngineBDDConfig.ResultType.NoError) {
                    return execResult;
                }
                dagFile = (File)this._inputFiles.get(0);
            }
            try {
                File fileResult = this._melHelperCompute.createTmpFile();
                String pathResult = this.createResultID(fileResult.getAbsolutePath(), this._requestNominal);
                StringBuffer nominalCmd = new StringBuffer(1024);
                this._melHelperCompute.setCurrentTarget(ResCompute.getString("MEL_TARGET_NOMINAL"));
                this._melHelperCompute.generate(nominalCmd, forAralia4, pathResult, true);
                execResult = this.executeRequest(ctrl, this._requestNominal, nominalCmd.toString());
                if (execResult != EngineBDDConfig.ResultType.NoError) {
                    return execResult;
                }
                if (ctrl.isCanceled()) {
                    return EngineBDDConfig.ResultType.ErrCompute;
                }
                this._melHelperCompute.setCurrentTarget(ResCompute.getString("MEL_TARGET_NOMINAL"));
                BooleanResult result = this._melHelperCompute.readResult(fileResult.getAbsolutePath(), ctrl);
                if (ctrl.isCanceled()) {
                    return EngineBDDConfig.ResultType.ErrCompute;
                }
                if (result.getMCS().isAlwaysTrue() || result.getMCS().isAlwaysFalse()) {
                    this._melHelperCompute.computeProbabilities(result, ctrl);
                    this._melHelperCompute.addResult(null, result);
                    return EngineBDDConfig.ResultType.NoError;
                }
                if (this._mcsForPessimistCompute == null) {
                    dagFile = this._melHelperCompute.defineEquationFromMCS(result.getMCS());
                }
                result.getMCS().limitAt(this._melHelperCompute.getParameters().getLimitOrder());
                result = this._melHelperCompute.postTreatResult(result, ctrl);
                this._melHelperCompute.computeProbabilities(result, ctrl);
                this._melHelperCompute.addResult(null, result);
                computeNominal = false;
                ++this._nbrTreated;
            }
            catch (IOException ioe) {
                _LOG.log(Level.SEVERE, "IOException during MEL.Compute.Nominal", ioe);
                this._melHelperCompute.addError(ResCompute.msgFormat("MSG_ENGINE_ERROR_COMPUTE_TARGET", ResCompute.getString("MEL_TARGET_NOMINAL")));
                execResult = EngineBDDConfig.ResultType.ErrCompute;
            }
            if (execResult != EngineBDDConfig.ResultType.NoError) {
                return execResult;
            }
        }
        if (ctrl.isCanceled()) {
            return EngineBDDConfig.ResultType.ErrCompute;
        }
        DistribMEL distribMEL = new DistribMEL(ctrl, nbrServer, computeNominal, forAralia4, dagFile);
        execResult = EngineBDDConfig.ResultType.ErrCompute;
        try {
            try {
                distribMEL.prepareRequests();
            }
            catch (IOException ioe) {
                _LOG.log(Level.SEVERE, "IOException during prepareRequest", ioe);
                this._melHelperCompute.addError(ResCompute.getString("MSG_ENGINE_DISTRIB_COMPUTE_PREPARE"));
                EngineBDDConfig.ResultType resultType = EngineBDDConfig.ResultType.ErrCompute;
                this._stopEngine = true;
                distribMEL.clearRequests();
                return resultType;
            }
            distribMEL.launchThreads();
            distribMEL.launchRequests();
            execResult = EngineBDDConfig.ResultType.NoError;
        }
        catch (Exception e) {
            distribMEL.cancelRequests(ReqAutomatonClient.EvtClient.CANCEL_BY_SOFTWARE);
            if (e instanceof NoCutsFromNominalComputeException) {
                execResult = EngineBDDConfig.ResultType.NoError;
            } else {
                ctrl.appendUserMsg(e.getMessage());
                _LOG.log(Level.SEVERE, "Exception during DistribMEL", e);
            }
        }
        finally {
            this._stopEngine = true;
            distribMEL.clearRequests();
        }
        return execResult;
    }

    @Override
    protected EngineBDDConfig.ResultType executeLocal(EngineControl ctrl) {
        EngineBDDConfig.ResultType execResult = EngineBDDConfig.ResultType.NoError;
        execResult = this.transformMCSResultIfExist();
        if (execResult != EngineBDDConfig.ResultType.NoError) {
            return execResult;
        }
        try {
            File fileResult = this._melHelperCompute.createTmpFile();
            StringBuffer nominalCmd = new StringBuffer(1024);
            this._melHelperCompute.setCurrentTarget(ResCompute.getString("MEL_TARGET_NOMINAL"));
            this._melHelperCompute.generate(nominalCmd, this.getEngineType() == EngineBDDConfig.EngineType.Aralia4, fileResult.getAbsolutePath(), true);
            execResult = this.executeCompute(ctrl, nominalCmd.toString());
            if (execResult != EngineBDDConfig.ResultType.NoError) {
                return execResult;
            }
            BooleanResult result = this._melHelperCompute.readResult(fileResult.getAbsolutePath(), ctrl);
            if (result.getMCS().isAlwaysTrue() || result.getMCS().isAlwaysFalse()) {
                this._melHelperCompute.computeProbabilities(result, ctrl);
                this._melHelperCompute.addResult(null, result);
                return EngineBDDConfig.ResultType.NoError;
            }
            if (this._melHelperCompute.withPessimistCompute()) {
                if (this._mcsForPessimistCompute == null) {
                    File dagFile = this._melHelperCompute.defineEquationFromMCS(result.getMCS());
                    this._inputFiles.clear();
                    this.addInputFile(dagFile);
                }
                result.getMCS().limitAt(this._melHelperCompute.getParameters().getLimitOrder());
            }
            result = this._melHelperCompute.postTreatResult(result, ctrl);
            this._melHelperCompute.computeProbabilities(result, ctrl);
            this._melHelperCompute.addResult(null, result);
            ++this._nbrTreated;
        }
        catch (IOException ioe) {
            _LOG.log(Level.SEVERE, "IOException during MEL.Compute.Nominal", ioe);
            this._melHelperCompute.addError(ResCompute.msgFormat("MSG_ENGINE_ERROR_COMPUTE_TARGET", ResCompute.getString("MEL_TARGET_NOMINAL")));
            execResult = EngineBDDConfig.ResultType.ErrCompute;
        }
        if (execResult != EngineBDDConfig.ResultType.NoError) {
            return execResult;
        }
        Iterator<String> iTgt = this._targets.iterate();
        while (!ctrl.isCanceled() && iTgt.hasNext() && execResult == EngineBDDConfig.ResultType.NoError) {
            String tgt = iTgt.next();
            try {
                File tgtResult = this._melHelperCompute.createTmpFile();
                StringBuffer tgtCmd = new StringBuffer(1024);
                tgtCmd.append(tgt).append(" := 1;\n");
                this._melHelperCompute.setCurrentTarget(tgt);
                this._melHelperCompute.generate(tgtCmd, this.getEngineType() == EngineBDDConfig.EngineType.Aralia4, tgtResult.getAbsolutePath(), false);
                execResult = this.executeCompute(ctrl, tgtCmd.toString());
                if (execResult != EngineBDDConfig.ResultType.NoError) {
                    return execResult;
                }
                BooleanResult result = this._melHelperCompute.readResult(tgtResult.getAbsolutePath(), ctrl);
                result = this._melHelperCompute.postTreatResult(result, ctrl);
                this._melHelperCompute.computeProbabilities(result, ctrl);
                this._melHelperCompute.addResult(tgt, result);
                ++this._nbrTreated;
            }
            catch (IOException ioe) {
                _LOG.log(Level.SEVERE, "IOException during MEL.Compute." + tgt, ioe);
                this._melHelperCompute.addError(ResCompute.msgFormat("MSG_ENGINE_ERROR_COMPUTE_TARGET", tgt));
                execResult = EngineBDDConfig.ResultType.ErrCompute;
            }
        }
        return execResult;
    }

    @Override
    public int getMaxStep() {
        return this._targets.size() + 1;
    }

    @Override
    public int getCurStep() {
        return this._nbrTreated;
    }

    public void setMCSForPessimistCompute(BooleanMCS mcs) {
        this._mcsForPessimistCompute = mcs;
    }

    private EngineBDDConfig.ResultType transformMCSResultIfExist() {
        if (this._mcsForPessimistCompute != null) {
            this._mcsForPessimistCompute.prepare();
            _LOG.finest("MEL - From MCS result: " + this._mcsForPessimistCompute.getOrderAbstract());
            this._mcsForPessimistCompute.limitAt(this._melHelperCompute.getParameters().getLimitOrder() + 1);
            try {
                File dagFile = this._melHelperCompute.defineEquationFromMCS(this._mcsForPessimistCompute);
                _LOG.fine("MEL - Transforme MCS result (orderLimit=" + this._melHelperCompute.getParameters().getLimitOrder() + ") [" + this._mcsForPessimistCompute.getOrderAbstract() + "]: \nDagFile " + this._inputFiles + " => " + dagFile.toString());
                this._inputFiles.clear();
                this.addInputFile(dagFile);
                return EngineBDDConfig.ResultType.NoError;
            }
            catch (IOException ioe) {
                _LOG.log(Level.SEVERE, "IOException during MEL.Compute.Transform MCS", ioe);
                this._melHelperCompute.addError(ResCompute.msgFormat("MSG_ENGINE_ERROR_COMPUTE_TARGET", ResCompute.getString("MEL_TARGET_NOMINAL")));
                return EngineBDDConfig.ResultType.ErrCompute;
            }
        }
        return EngineBDDConfig.ResultType.NoError;
    }

    class DistribMEL {
        CECILIAClient _client;
        EngineControl _ctrl;
        boolean _computeNominal;
        boolean _forAralia4;
        File _dagFile;
        String _dagUniqueName;
        int _nbrRequests;
        Request[] _requests;
        File[] _fileResults;
        String[] _reqTargets;
        char[] _states;
        int _nbrReaded;
        int _nbrFinished;
        int _nbrServer;
        Exception _distribException;

        DistribMEL(EngineControl ctrl, int nbrServer, boolean computeNominal, boolean forAralia4, File dagFile) {
            this._client = EngineBDDMEL.this._config.getDistribClient();
            this._ctrl = ctrl;
            this._nbrServer = nbrServer;
            this._computeNominal = computeNominal;
            this._forAralia4 = forAralia4;
            this._dagFile = dagFile;
            this._nbrRequests = EngineBDDMEL.this._targets.size() + (computeNominal ? 1 : 0);
            this._requests = new Request[this._nbrRequests];
            this._fileResults = new File[this._nbrRequests];
            this._reqTargets = new String[this._nbrRequests];
            this._states = new char[this._requests.length];
            for (int i = 0; i < this._states.length; ++i) {
                this._states[i] = '\u0000';
            }
            this._nbrFinished = 0;
            this._nbrReaded = 0;
        }

        private void prepareRequests() throws IOException {
            this._dagUniqueName = this._client.makeUniqueFileID(this._dagFile.getAbsolutePath(), true);
            this._client.diffuseFile(this._dagFile, this._dagUniqueName);
            int prioMEL = Integer.getInteger("cecilia.jxta.prio", 0) + Integer.getInteger("cecilia.jxta.prio_delta_mel", 0);
            int idxReq = 0;
            if (this._computeNominal) {
                this._requests[idxReq] = EngineBDDMEL.this._requestNominal;
                this._requests[idxReq].setPriority(prioMEL);
                this._fileResults[idxReq] = EngineBDDMEL.this._melHelperCompute.createTmpFile();
                this._reqTargets[idxReq] = null;
                ++idxReq;
            }
            Iterator<String> iTgt = EngineBDDMEL.this._targets.iterate();
            while (iTgt.hasNext()) {
                String tgt = iTgt.next();
                this._requests[idxReq] = EngineBDDMEL.this.createRequest();
                this._requests[idxReq].setPriority(prioMEL);
                this._fileResults[idxReq] = EngineBDDMEL.this._melHelperCompute.createTmpFile();
                this._reqTargets[idxReq] = tgt;
                ++idxReq;
            }
            for (int idx = 0; idx < idxReq; ++idx) {
                this.prepareRequest(this._requests[idx], this._fileResults[idx], this._reqTargets[idx], EngineBDDMEL.this._melHelperCompute.createTmpFile());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prepareRequest(Request request, File resFile, String target, File cmdFile) throws IOException {
            String pathResult = EngineBDDMEL.this.createResultID(resFile.getAbsolutePath(), request);
            request.addNeededFile(this._dagUniqueName);
            StringBuffer melCmd = new StringBuffer(1024);
            if (target != null) {
                melCmd.append(target).append(" := 1;\n");
                EngineBDDMEL.this._melHelperCompute.setCurrentTarget(target);
            }
            EngineBDDMEL.this._melHelperCompute.generate(melCmd, this._forAralia4, pathResult, false);
            try (FileWriter writer = null;){
                writer = new FileWriter(cmdFile);
                writer.write(EngineBDDMEL.this._command.toString());
                writer.write(melCmd.toString());
            }
            String commandUID = EngineBDDMEL.this._config.getDistribClient().makeUniqueFileID(cmdFile.getAbsolutePath(), false);
            request.setCmdFileName(commandUID);
            request.setParsed(true);
        }

        private void launchThreads() {
            Thread finishThread = new Thread("DistribMEL-Finish"){

                @Override
                public void run() {
                    try {
                        while (DistribMEL.this._nbrFinished != DistribMEL.this._states.length && DistribMEL.this._distribException == null) {
                            for (int i = 0; i < DistribMEL.this._states.length; ++i) {
                                if (DistribMEL.this._states[i] != '\u0001' || !DistribMEL.this._requests[i].isFinished()) continue;
                                ++DistribMEL.this._nbrFinished;
                                int n = i;
                                DistribMEL.this._states[n] = (char)(DistribMEL.this._states[n] + '\u0001');
                                if (!DistribMEL.this._ctrl.isCanceled() && !EngineBDDMEL.this._stopEngine.booleanValue()) continue;
                                return;
                            }
                            1.sleep(100L);
                            if (!DistribMEL.this._ctrl.isCanceled() && !EngineBDDMEL.this._stopEngine.booleanValue()) continue;
                            return;
                        }
                    }
                    catch (Exception e) {
                        DistribMEL.this._distribException = new Exception(e);
                    }
                }
            };
            finishThread.setPriority(1);
            finishThread.start();
            Thread mergeThread = new Thread("DistribMEL-Read"){

                @Override
                public void run() {
                    try {
                        while (DistribMEL.this._nbrReaded != DistribMEL.this._states.length && DistribMEL.this._distribException == null) {
                            for (int i = 0; i < DistribMEL.this._requests.length; ++i) {
                                if (DistribMEL.this._states[i] != '\u0002' || !DistribMEL.this._requests[i].isFinished()) continue;
                                if (DistribMEL.this._requests[i].getState() != ReqState.FINISHED_SUCCESFULY) {
                                    throw new JXTARuntimeException("Request [" + i + "] don't finnish with success : " + DistribMEL.this._requests[i].getState());
                                }
                                File tgtFile = DistribMEL.this._fileResults[i];
                                if (!tgtFile.canRead()) {
                                    throw new IOException("MCS result file not be loadable for distrib resquest " + i);
                                }
                                String reqTarget = DistribMEL.this._reqTargets[i];
                                EngineBDDMEL.this._melHelperCompute.setCurrentTarget(reqTarget == null ? ResCompute.getString("MEL_TARGET_NOMINAL") : reqTarget);
                                BooleanResult mcsResult = EngineBDDMEL.this._melHelperCompute.readResult(tgtFile.getAbsolutePath(), DistribMEL.this._ctrl);
                                if (!Boolean.getBoolean("cecilia.ft.compute.KeepFile.MEL")) {
                                    tgtFile.delete();
                                }
                                mcsResult = EngineBDDMEL.this._melHelperCompute.postTreatResult(mcsResult, DistribMEL.this._ctrl);
                                EngineBDDMEL.this._melHelperCompute.computeProbabilities(mcsResult, DistribMEL.this._ctrl);
                                EngineBDDMEL.this._melHelperCompute.addResult(DistribMEL.this._reqTargets[i], mcsResult);
                                if (reqTarget == null && (mcsResult.getMCS().isAlwaysTrue() || mcsResult.getMCS().isAlwaysFalse())) {
                                    throw new NoCutsFromNominalComputeException();
                                }
                                int n = i;
                                DistribMEL.this._states[n] = (char)(DistribMEL.this._states[n] + '\u0001');
                                ++DistribMEL.this._nbrReaded;
                                ++EngineBDDMEL.this._nbrTreated;
                                if (!DistribMEL.this._ctrl.isCanceled() && !EngineBDDMEL.this._stopEngine.booleanValue()) continue;
                                return;
                            }
                            2.sleep(100L);
                            if (!DistribMEL.this._ctrl.isCanceled() && !EngineBDDMEL.this._stopEngine.booleanValue()) continue;
                            return;
                        }
                    }
                    catch (Exception e) {
                        DistribMEL.this._distribException = e;
                    }
                }
            };
            mergeThread.setPriority(1);
            mergeThread.start();
        }

        private void launchRequests() throws Exception {
            int curIdxDistribReq = 0;
            int maxDistribReq = this._nbrServer * 10;
            while (this._nbrReaded != this._states.length) {
                if (this._distribException != null) {
                    throw this._distribException;
                }
                while (curIdxDistribReq >= 0 && curIdxDistribReq - this._nbrFinished < maxDistribReq) {
                    this._client.addRequestToStock(this._requests[curIdxDistribReq]);
                    int n = curIdxDistribReq++;
                    this._states[n] = (char)(this._states[n] + '\u0001');
                    if (curIdxDistribReq < this._requests.length) continue;
                    curIdxDistribReq = -1;
                }
                if (this._ctrl.isCanceled()) {
                    this.cancelRequests(ReqAutomatonClient.EvtClient.CANCEL_BY_USER);
                    return;
                }
                Thread.sleep(100L);
            }
        }

        private void cancelRequests(ReqAutomatonClient.EvtClient evt) {
            Request reqTmp = null;
            for (int i = 0; i < this._requests.length; ++i) {
                reqTmp = this._requests[i];
                if (reqTmp.isFinished() || reqTmp.getServerID().isEmpty()) continue;
                ReqAutomatonClient.fireEvent((Request)reqTmp, (ReqAutomatonClient.EvtClient)evt);
            }
            this._client.remoteStopRequests();
        }

        private void clearRequests() {
            this._client.removeDiffusedFiles(this._dagUniqueName);
        }
    }

    static class NoCutsFromNominalComputeException
    extends Exception {
    }

    public static interface TargetsAccessor {
        public int size();

        default public int getNbrEvents() {
            return this.size();
        }

        public Iterator<String> iterate();
    }
}

