/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.lib.util.TestUtility;
import com.dassault.cecilia.plugin.faulttree.compute.compute.MCSInputStream;
import com.dassault.cecilia.plugin.faulttree.compute.compute.MCSOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class MCSStreamTest
extends TestUtility {
    @Test
    public void test083Index() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(128);
        MCSOutputStream mcsOutput = new MCSOutputStream(output, 83);
        mcsOutput.writeIndex(56);
        mcsOutput.writeIndex(24);
        mcsOutput.writeIndex(30);
        mcsOutput.writeIndex(12);
        mcsOutput.writeIndex(1);
        mcsOutput.writeIndex(0);
        mcsOutput.writeIndex(82);
        mcsOutput.writeIndex(81);
        mcsOutput.writeIndex(63);
        mcsOutput.flush();
        mcsOutput.close();
        byte[] result = output.toByteArray();
        ByteArrayInputStream input = new ByteArrayInputStream(result);
        MCSInputStream mcsInput = new MCSInputStream(input, 83);
        Assert.assertEquals((long)56L, (long)mcsInput.readIndex());
        Assert.assertEquals((long)24L, (long)mcsInput.readIndex());
        Assert.assertEquals((long)30L, (long)mcsInput.readIndex());
        Assert.assertEquals((long)12L, (long)mcsInput.readIndex());
        Assert.assertEquals((long)1L, (long)mcsInput.readIndex());
        Assert.assertEquals((long)0L, (long)mcsInput.readIndex());
        Assert.assertEquals((long)82L, (long)mcsInput.readIndex());
        Assert.assertEquals((long)81L, (long)mcsInput.readIndex());
        Assert.assertEquals((long)63L, (long)mcsInput.readIndex());
        mcsInput.close();
    }

    @Test
    public void test064Index() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(128);
        MCSOutputStream mcsOutput = new MCSOutputStream(output, 64);
        mcsOutput.writeIndex(56);
        mcsOutput.writeIndex(31);
        mcsOutput.writeIndex(30);
        mcsOutput.writeIndex(12);
        mcsOutput.writeIndex(1);
        mcsOutput.writeIndex(0);
        mcsOutput.writeIndex(63);
        mcsOutput.flush();
        mcsOutput.close();
        byte[] result = output.toByteArray();
        ByteArrayInputStream input = new ByteArrayInputStream(result);
        MCSInputStream mcsInput = new MCSInputStream(input, 64);
        Assert.assertEquals((long)56L, (long)mcsInput.readIndex());
        Assert.assertEquals((long)31L, (long)mcsInput.readIndex());
        Assert.assertEquals((long)30L, (long)mcsInput.readIndex());
        Assert.assertEquals((long)12L, (long)mcsInput.readIndex());
        Assert.assertEquals((long)1L, (long)mcsInput.readIndex());
        Assert.assertEquals((long)0L, (long)mcsInput.readIndex());
        Assert.assertEquals((long)63L, (long)mcsInput.readIndex());
        mcsInput.close();
    }

    protected void verifyAllValue(int maxIndex) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(128);
        MCSOutputStream mcsOutput = new MCSOutputStream(output, maxIndex);
        for (int i = 0; i < maxIndex; ++i) {
            mcsOutput.writeIndex(i);
        }
        mcsOutput.flush();
        mcsOutput.close();
        byte[] result = output.toByteArray();
        ByteArrayInputStream input = new ByteArrayInputStream(result);
        MCSInputStream mcsInput = new MCSInputStream(input, maxIndex);
        for (int i = 0; i < maxIndex; ++i) {
            Assert.assertEquals((long)i, (long)mcsInput.readIndex());
        }
        mcsInput.close();
    }

    @Test
    public void testAllValue() throws IOException {
        for (int i = 4096; i >= 0; --i) {
            this.verifyAllValue(i);
        }
    }

    @Test
    public void testMixed() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(128);
        MCSOutputStream mcsOutput = new MCSOutputStream(output, 3);
        mcsOutput.write(1);
        new DataOutputStream(mcsOutput).writeInt(1);
        mcsOutput.writeIndex(1);
        mcsOutput.writeIndex(1);
        mcsOutput.flush();
        mcsOutput.close();
        byte[] result = output.toByteArray();
        ByteArrayInputStream input = new ByteArrayInputStream(result);
        MCSInputStream mcsInput = new MCSInputStream(input, 3);
        Assert.assertEquals((long)1L, (long)mcsInput.read());
        Assert.assertEquals((long)1L, (long)new DataInputStream(mcsInput).readInt());
        Assert.assertEquals((long)1L, (long)mcsInput.readIndex());
        Assert.assertEquals((long)1L, (long)mcsInput.readIndex());
        mcsInput.close();
    }
}

