/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.pref;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResIcoCompute;
import com.dassault.cecilia.plugin.faulttree.compute.pref.PrintExportMCSAbstract;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class PrintExportMCS
extends PrintExportMCSAbstract {
    public static final String PROP_EXPORT_FILTER_CAA_EDITABLE = "cecilia.ft.compute.FilterCAAEditable";
    public static String PREF_KEY = PrintExportMCS.class.getName();
    public static final String PREF_CONT_REMINDER = "Content.Reminder";
    public static final String PREF_FIELDS_NUMBER = "Fields.Number";
    public static final String PREF_FIELDS_OCCURENCE = "Fields.Occurence";
    public static final String PREF_FIELDS_LAW = "Fields.Law";
    public static final String PREF_FIELDS_COMMENT = "Fields.Comment";
    public static final String PREF_FIELDS_INSPECTED = "Fields.Inspected";
    public static final String PREF_FIELDS_INFLIGHTTESTED = "Fields.InflightTested";
    public static final String PREF_FIELDS_PROPERTIES = "Fields.Properties";
    public static final String PREF_FIELDS_ATTRIBUTES = "Fields.Attributes";
    public static final String PREF_FIELDS_BTP = "Fields.BTP";
    public static final String PREF_FIELDS_FMEA = "Fields.FMEA";
    public static final int PREF_FIELDS_IF_NBR = 8;
    public static final String PREF_FIELDS_IF_PREFIX = "Fields.IF.";
    public static final String PREF_CONT_CAA = "Content.MCSInCAA";
    public static final String PREF_CONT_CAA_ORDER = PREF_KEY + "#CAA.Order";
    protected JComboBox _ctrlDefaultLevel;
    protected int _valueDefaultLevel = 3;
    JPanel _perfsPanel;

    public static String getIFKeyName(int idx) {
        switch (idx) {
            case 0: {
                return "COMPUTE_IP_CP";
            }
            case 1: {
                return "COMPUTE_IP_MIF";
            }
            case 2: {
                return "COMPUTE_IP_CIF";
            }
            case 3: {
                return "COMPUTE_IP_DIF";
            }
            case 4: {
                return "COMPUTE_IP_RAW";
            }
            case 5: {
                return "COMPUTE_IP_RRW";
            }
            case 6: {
                return "COMPUTE_IP_CC";
            }
            case 7: {
                return "COMPUTE_IP_PC";
            }
        }
        throw new UnsupportedOperationException();
    }

    public PrintExportMCS() {
        super(ResCompute.getString("KEY_0156"));
    }

    protected void load(Plugable launcher) {
        super.load(launcher);
        this._valueDefaultLevel = PlugableUtility.getIntOpt((Plugable)launcher, (String)PREF_CONT_CAA_ORDER, (int)0);
        if (this._valueDefaultLevel < 0) {
            this._valueDefaultLevel = 0;
        }
        if (this._ctrlDefaultLevel != null) {
            this._ctrlDefaultLevel.setSelectedItem(Integer.toString(this._valueDefaultLevel));
        }
    }

    protected void save(Plugable launcher) {
        launcher.setOption(PREF_CONT_CAA_ORDER, Integer.toString(this._valueDefaultLevel));
        super.save(launcher);
    }

    public int getPrefLevel() {
        return this._valueDefaultLevel;
    }

    @Override
    protected List<PrefFieldBoolean> createFields() {
        List<PrefFieldBoolean> prefs = super.createFields();
        prefs.add(new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_REMINDER"), PREF_CONT_REMINDER));
        prefs.add(new PrefFieldBoolean(ResCompute.getString("EXPORT_CAA_MCS"), PREF_CONT_CAA).setSelected(true));
        prefs.add(new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_NUMBER"), PREF_FIELDS_NUMBER));
        prefs.add(new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_OCCURRENCE"), PREF_FIELDS_OCCURENCE));
        prefs.add(new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_LAW"), PREF_FIELDS_LAW));
        prefs.add(new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_COMMENT"), PREF_FIELDS_COMMENT));
        prefs.add(new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_PERIODICITY"), PREF_FIELDS_INSPECTED));
        prefs.add(new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_EXPOSURE"), PREF_FIELDS_INFLIGHTTESTED));
        prefs.add(new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_PROPERTIES"), PREF_FIELDS_PROPERTIES));
        prefs.add(new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_ATTRIBUTES"), PREF_FIELDS_ATTRIBUTES));
        prefs.add(new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_FRB"), PREF_FIELDS_BTP));
        prefs.add(new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_FMEA"), PREF_FIELDS_FMEA));
        return prefs;
    }

    protected JPanel makeContent() {
        if (this._perfsPanel == null) {
            this._ctrlDefaultLevel = new JComboBox<Object>(new Object[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"});
            this._ctrlDefaultLevel.setEditable(Boolean.getBoolean(PROP_EXPORT_FILTER_CAA_EDITABLE));
            this._ctrlDefaultLevel.setSelectedItem(Integer.toString(this._valueDefaultLevel));
            this._ctrlDefaultLevel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String strLevel = PrintExportMCS.this._ctrlDefaultLevel.getSelectedItem().toString();
                        PrintExportMCS.this._valueDefaultLevel = Integer.parseInt(strLevel);
                    }
                    catch (Exception ex) {
                        PrintExportMCS.this._valueDefaultLevel = -1;
                    }
                }
            });
            this._ctrlDefaultLevel.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    try {
                        int order = Integer.parseInt(value.toString());
                        if (order > 0) {
                            this.setText(Integer.toString(order));
                        } else {
                            this.setText(ResCompute.getString("EXPORT_CAA_FILTER_NONE"));
                        }
                    }
                    catch (Exception ex) {
                        this.setText(ResCompute.getString("EXPORT_CAA_FILTER_NONE"));
                    }
                    return this;
                }
            });
            this._perfsPanel = new JPanel(new GridBagLayout());
            int idxPanel = 0;
            JPanel analysisPanel = new JPanel();
            analysisPanel.setLayout(new GridBagLayout());
            analysisPanel.setBorder(BorderFactory.createTitledBorder(ResMsgVoc.getString((String)"VOC_CONTENTS")));
            analysisPanel.add((Component)this.createIHM("Content.QAnalysis"), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(2, 5, 2, 10), 0, 0));
            analysisPanel.add((Component)this.createIHM("Content.TableOfContents"), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 13, 2, new Insets(2, 10, 2, 5), 0, 0));
            analysisPanel.add((Component)this.createIHM(PREF_CONT_REMINDER), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 13, 2, new Insets(2, 10, 2, 5), 0, 0));
            this._perfsPanel.add((Component)analysisPanel, new GridBagConstraints(0, idxPanel++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 2, 5), 0, 0));
            JPanel fieldsPanel = new JPanel();
            fieldsPanel.setLayout(new GridBagLayout());
            fieldsPanel.setBorder(BorderFactory.createTitledBorder(ResMsgVoc.getString((String)"VOC_FIELDS")));
            fieldsPanel.add((Component)this.createIHM(PREF_FIELDS_NUMBER), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(2, 5, 2, 10), 0, 0));
            fieldsPanel.add((Component)this.createIHM(PREF_FIELDS_LAW), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 17, 2, new Insets(2, 5, 2, 10), 0, 0));
            fieldsPanel.add((Component)this.createIHM(PREF_FIELDS_OCCURENCE), new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 17, 2, new Insets(2, 5, 2, 10), 0, 0));
            fieldsPanel.add((Component)this.createIHM(PREF_FIELDS_COMMENT), new GridBagConstraints(0, 3, 1, 1, 0.5, 0.0, 17, 2, new Insets(2, 5, 2, 10), 0, 0));
            fieldsPanel.add((Component)this.createIHM(PREF_FIELDS_BTP), new GridBagConstraints(0, 4, 1, 1, 0.5, 0.0, 17, 2, new Insets(2, 5, 2, 10), 0, 0));
            fieldsPanel.add((Component)this.createIHM(PREF_FIELDS_INSPECTED), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 13, 2, new Insets(2, 10, 2, 5), 0, 0));
            fieldsPanel.add((Component)this.createIHM(PREF_FIELDS_INFLIGHTTESTED), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 13, 2, new Insets(2, 10, 2, 5), 0, 0));
            fieldsPanel.add((Component)this.createIHM(PREF_FIELDS_PROPERTIES), new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 13, 2, new Insets(2, 10, 2, 5), 0, 0));
            fieldsPanel.add((Component)this.createIHM(PREF_FIELDS_ATTRIBUTES), new GridBagConstraints(1, 3, 1, 1, 0.5, 0.0, 13, 2, new Insets(2, 10, 2, 5), 0, 0));
            fieldsPanel.add((Component)this.createIHM(PREF_FIELDS_FMEA), new GridBagConstraints(1, 4, 1, 1, 0.5, 0.0, 13, 2, new Insets(2, 10, 2, 5), 0, 0));
            this._perfsPanel.add((Component)fieldsPanel, new GridBagConstraints(0, idxPanel++, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
            JPanel caaPanel = new JPanel();
            caaPanel.setLayout(new GridBagLayout());
            caaPanel.setBorder(BorderFactory.createTitledBorder(ResCompute.getString("CAA_EXPLICATION")));
            caaPanel.add((Component)this.createIHM(PREF_CONT_CAA), new GridBagConstraints(0, 0, 2, 1, 0.5, 0.0, 17, 2, new Insets(2, 5, 2, 10), 0, 0));
            caaPanel.add((Component)new JLabel(ResCompute.getString("EXPORT_CAA_FILTER")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 10), 0, 0));
            caaPanel.add((Component)this._ctrlDefaultLevel, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 17, 0, new Insets(2, 10, 2, 5), 0, 0));
            this._perfsPanel.add((Component)caaPanel, new GridBagConstraints(0, idxPanel++, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
            this._perfsPanel.add((Component)new JPanel(), new GridBagConstraints(0, idxPanel++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 5, 5), 0, 0));
        }
        return this._perfsPanel;
    }

    JComponent createIHM(String keyPref) {
        return this.getPref(keyPref).createCheckBox();
    }

    public String getKey() {
        return PREF_KEY;
    }

    public String getInfo(String key) {
        if ("plugin.key".equals(key)) {
            return PREF_KEY;
        }
        if ("plugin.key.path".equals(key)) {
            return "FAULTTREE/PRINT";
        }
        if ("plugin.name".equals(key)) {
            return ResCompute.getString("PLUG_CMD_NOMINAL_NAME");
        }
        if ("plugin.title".equals(key)) {
            return ResCompute.getString("PLUG_CMD_NOMINAL_NAME");
        }
        if ("plugin.description".equals(key)) {
            return ResMsgCore.getString((String)"PREF_GENERAL_PRINT_TITLE") + " - " + ResCompute.getString("PLUG_CMD_NOMINAL_NAME");
        }
        return null;
    }

    public Icon getIcon(String key) {
        return ResIcoCompute.getImageIcon("PLUGIN_MCS");
    }

    protected void copy(PrefFieldsCategory src) {
        super.copy(src);
        this._valueDefaultLevel = ((PrintExportMCS)src).getPrefLevel();
    }
}

