/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.dbobj.faulttree.criticity.ListCriticityUtility;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import com.dassault.cecilia.plugin.faulttree.compute.results.CriticityResultTableModelFromStore;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class CriticityResultPanel
extends JPanel {
    private final ListCriticityUtility.CriticityResult _criticityResult;
    private final BooleanStore _store;
    private final ArborRenderer _renderer;

    public CriticityResultPanel(BooleanStore store, BooleanResult result, ArborRenderer renderer) {
        super(new GridBagLayout());
        this._criticityResult = result.getCriticityResult();
        this._store = store;
        this._renderer = renderer;
        this.createPanel();
        this.setBorder(BorderFactory.createTitledBorder(ResMsgVoc.getString((String)"VOC_CRITICITY")));
    }

    private final void createPanel() {
        JTable table = new JTable((TableModel)((Object)new CriticityResultTableModelFromStore(this._criticityResult, this._store, this._renderer)));
        table.setDefaultRenderer(ListCriticityUtility.CriticityResult.OKKO.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable tablee, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(tablee, value, isSelected, hasFocus, row, column);
                if (value == null) {
                    return this;
                }
                if (value == ListCriticityUtility.CriticityResult.OKKO.KO) {
                    this.setForeground(Color.RED);
                } else if (value == ListCriticityUtility.CriticityResult.OKKO.OK) {
                    this.setForeground(Color.GREEN);
                } else if (value == ListCriticityUtility.CriticityResult.OKKO.NaN) {
                    this.setForeground(Color.BLACK);
                }
                this.setToolTipText(value.toString());
                return this;
            }
        });
        table.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable tablee, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(tablee, value, isSelected, hasFocus, row, column);
                if (value == null) {
                    return this;
                }
                try {
                    String valStr = value.toString();
                    if (valStr.indexOf(46) == -1) {
                        this.setToolTipText(null);
                        return this;
                    }
                    if (valStr.indexOf(40) != -1) {
                        String valNumStr = valStr.substring(valStr.indexOf(40) + 1, valStr.indexOf(41));
                        double d = Double.parseDouble(valNumStr);
                        valNumStr = CriticityResultPanel.this._renderer.formatNumber(d);
                        String newValStr = valStr.substring(0, valStr.indexOf(40) + 1) + valNumStr + ')';
                        this.setText(newValStr);
                        this.setToolTipText(valStr);
                    } else {
                        double d = Double.parseDouble(valStr);
                        this.setText(CriticityResultPanel.this._renderer.formatNumber(d));
                        this.setToolTipText(valStr);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return this;
            }
        });
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
    }
}

