/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.Util;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.PartialCheckBox;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.dbobj.general.attrib.AttrCriterion;
import com.dassault.cecilia.dbobj.general.attrib.gui.AttributeCriterionPanel;
import com.dassault.cecilia.lib.util.format.StringUtilities;
import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.Evt;
import com.dassault.cecilia.plugin.faulttree.compute.MCS;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilter;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilterSorter;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSTableCellRendererOrder;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSTableCellRendererProbability;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MCSFilterStandard
extends MCSFilterSorter {
    MCS _mcsOrigin;
    ArborRenderer _renderer;
    boolean _withOrder;
    boolean _orderEnable;
    boolean[] _ordersSelect;
    int[] _ordersNumber;
    double[] _ordersProbability;
    Boolean _nameEnable;
    String _nameFilter;
    Vector _nameUtilitySearch;
    Boolean _remarkEnable;
    String _remarkFilter;
    Vector _remarkUtilitySearch;
    boolean _withProbability;
    Boolean _probaEnable;
    Double _probaLimit;
    Boolean _attrEnable;
    AttrCriterion _attrCriterion;
    Map<Attr.Key, Set<String>> _attrMap;
    boolean _withAttribute;
    MCSFilterDlg _dlg = null;

    public MCSFilterStandard(MCS mcs) {
        this._withOrder = mcs != null;
        this._orderEnable = false;
        this._nameEnable = false;
        this._nameFilter = "*";
        this._remarkEnable = false;
        this._remarkFilter = "*";
        this._withProbability = true;
        this._probaEnable = false;
        this._probaLimit = 0.0;
        this._withAttribute = false;
        this._attrEnable = false;
        this._attrCriterion = null;
        if (mcs != null) {
            this.prepareOrders(mcs);
        }
        this._renderer = null;
        this._attrMap = null;
    }

    public MCSFilterStandard(MCS mcs, ArborRenderer renderer, boolean withProbability, Map<Attr.Key, Set<String>> attrMap) {
        this._withOrder = mcs != null;
        this._orderEnable = false;
        this._nameEnable = false;
        this._nameFilter = "*";
        this._remarkEnable = false;
        this._remarkFilter = "*";
        this._probaEnable = false;
        this._probaLimit = 0.0;
        this._attrEnable = false;
        this._attrCriterion = null;
        this.prepareOrders(mcs);
        this._withProbability = withProbability;
        this._renderer = renderer;
        this._attrMap = attrMap;
        this._withAttribute = this._attrMap != null && this._attrMap.size() > 0;
    }

    public final Boolean withFilterName() {
        return this._nameEnable;
    }

    public void setWithFilterName(Boolean withNameEnable) {
        this._nameEnable = withNameEnable;
    }

    public final String getFilterName() {
        if (this._nameFilter.isEmpty()) {
            return null;
        }
        return this._nameFilter;
    }

    public final void setFilterName(String filterName) {
        this._nameFilter = filterName;
    }

    public final Boolean withFilterRemark() {
        return this._remarkEnable;
    }

    public void setWithFilterRemark(Boolean withRemarkEnable) {
        this._remarkEnable = withRemarkEnable;
    }

    public final String getFilterRemark() {
        if (this._remarkFilter.isEmpty()) {
            return null;
        }
        return this._remarkFilter;
    }

    public final void setFilterRemark(String filterRemark) {
        this._remarkFilter = filterRemark;
    }

    public final Boolean withFilterProbability() {
        return this._probaEnable;
    }

    public void setWithFilterProbability(Boolean withProbaEnable) {
        this._probaEnable = withProbaEnable;
    }

    public final Double getProbabilityFilter() {
        return this._probaLimit;
    }

    public final void setProbabilityFilter(Double probFilt) {
        this._probaLimit = probFilt;
    }

    public void setWithFilterAttr(Boolean attrEnable) {
        this._attrEnable = attrEnable;
    }

    public Boolean withFilterAttr() {
        return this._attrEnable;
    }

    public final AttrCriterion getAttrCriterion() {
        return this._attrCriterion;
    }

    public final void setAttrCriterion(AttrCriterion attrCrit) {
        this._attrCriterion = attrCrit;
    }

    @Override
    public MCSFilter getCopy() {
        MCSFilterStandard copy = new MCSFilterStandard(null);
        copy._withOrder = this._withOrder;
        if (this._withOrder) {
            copy._orderEnable = this._orderEnable;
            copy._ordersSelect = new boolean[this._ordersSelect.length];
            System.arraycopy(this._ordersSelect, 0, copy._ordersSelect, 0, this._ordersSelect.length);
            copy._ordersNumber = new int[this._ordersNumber.length];
            System.arraycopy(this._ordersNumber, 0, copy._ordersNumber, 0, this._ordersNumber.length);
            copy._ordersProbability = new double[this._ordersProbability.length];
            System.arraycopy(this._ordersProbability, 0, copy._ordersProbability, 0, this._ordersProbability.length);
        }
        copy._nameEnable = this._nameEnable;
        copy._nameFilter = this._nameFilter;
        copy._remarkEnable = this._remarkEnable;
        copy._remarkFilter = this._remarkFilter;
        copy._withProbability = this._withProbability;
        copy._probaEnable = this._probaEnable;
        copy._probaLimit = this._probaLimit;
        copy._withAttribute = this._withAttribute;
        copy._attrEnable = this._attrEnable;
        copy._attrCriterion = this._attrCriterion != null ? this._attrCriterion.getCopy() : null;
        copy._attrMap = this._attrMap;
        copy._mcsOrigin = this._mcsOrigin;
        copy._renderer = this._renderer;
        return copy;
    }

    public void setWithOrder(boolean value) {
        this._withOrder = value && this._ordersSelect != null;
    }

    public void setWithProbability(boolean value) {
        this._withProbability = value;
    }

    public void setWithAttribute(boolean value) {
        this._withOrder = value && this._attrMap != null && this._attrMap.size() > 0;
    }

    private void prepareOrders(MCS mcs) {
        if (this._mcsOrigin == mcs) {
            return;
        }
        this._mcsOrigin = mcs;
        int orderMax = mcs.getOrderMax();
        this._ordersSelect = new boolean[orderMax];
        this._ordersNumber = new int[orderMax];
        this._ordersProbability = new double[orderMax];
        for (int i = 0; i < orderMax; ++i) {
            this._ordersSelect[i] = true;
            this._ordersNumber[i] = mcs.getOrderNumber(i);
            this._ordersProbability[i] = mcs.getOrderProbability(i);
        }
    }

    @Override
    public void prepareFilter() {
        if (this._nameEnable.booleanValue()) {
            this._nameUtilitySearch = StringUtilities.buildTabSearchString((String)this._nameFilter);
        }
        if (this._remarkEnable.booleanValue()) {
            this._remarkUtilitySearch = StringUtilities.buildTabSearchString((String)this._remarkFilter);
        }
    }

    @Override
    public boolean keepCut(Cut cut) {
        Evt evt;
        int i;
        boolean find;
        double probaCut;
        if (this._orderEnable) {
            int order = cut.getOrder();
            if (order >= this._ordersSelect.length) {
                return false;
            }
            if (!this._ordersSelect[order]) {
                return false;
            }
        }
        if (this._probaEnable.booleanValue() && (probaCut = cut.getProbability()) >= 0.0 && !Double.isNaN(probaCut) && probaCut < this._probaLimit) {
            return false;
        }
        if (this._nameEnable.booleanValue()) {
            find = false;
            for (i = cut.getOrder() - 1; i >= 0 && !find; --i) {
                evt = cut.getEvent(i);
                if (!StringUtilities.isASearchEvent((String)evt.getName(), (List)this._nameUtilitySearch)) continue;
                find = true;
            }
            if (!find) {
                return false;
            }
        }
        if (this._remarkEnable.booleanValue()) {
            find = false;
            for (i = cut.getOrder() - 1; i >= 0 && !find; --i) {
                evt = cut.getEvent(i);
                if (!StringUtilities.isASearchEvent((String)evt.getInfo(Evt.KeyInfo.COMMENT, this._renderer).toString(), (List)this._remarkUtilitySearch)) continue;
                find = true;
            }
            if (!find) {
                return false;
            }
        }
        if (this._attrEnable.booleanValue()) {
            find = false;
            block2: for (i = cut.getOrder() - 1; i >= 0 && !find; --i) {
                evt = cut.getEvent(i);
                for (Attr attr : evt.getAttributs()) {
                    if (!this._attrCriterion.match(attr)) continue;
                    find = true;
                    continue block2;
                }
            }
            if (!find) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getTitle() {
        return ResCompute.getString("DLG_RESULT_FILTER_STD");
    }

    @Override
    public String getAbstract() {
        StringBuffer sb = new StringBuffer(512);
        sb.append(this.getTitle()).append(" : \n");
        if (this._orderEnable) {
            sb.append("  ");
            sb.append(ResCompute.getString("DLG_RESULT_ORDER"));
            sb.append(" : ");
            for (int i = 1; i < this._ordersSelect.length; ++i) {
                if (!this._ordersSelect[i]) continue;
                sb.append(i).append(", ");
            }
            int len = sb.length();
            if (len > 2 && sb.charAt(len - 2) == ',' && sb.charAt(len - 1) == ' ') {
                sb.delete(len - 2, len);
            }
            sb.append("\n");
        }
        if (this._nameEnable == null) {
            sb.append(" ");
            sb.append(ResCompute.getString("DLG_RESULT_FILTER_NAME"));
            sb.append(" : ").append(ResCompute.getString("DLG_RESULT_FILTER_MULTIPLE_VALUES")).append("\n");
        } else if (this._nameEnable.booleanValue() && this._nameFilter != null) {
            sb.append("  ");
            sb.append(ResCompute.getString("DLG_RESULT_FILTER_NAME"));
            sb.append(" : ").append(this._nameFilter).append("\n");
        }
        if (this._remarkEnable == null) {
            sb.append(" ");
            sb.append(ResCompute.getString("DLG_RESULT_FILTER_REMARK"));
            sb.append(" : ").append(ResCompute.getString("DLG_RESULT_FILTER_MULTIPLE_VALUES")).append("\n");
        } else if (this._remarkEnable.booleanValue() && this._remarkFilter != null) {
            sb.append("  ");
            sb.append(ResCompute.getString("DLG_RESULT_FILTER_REMARK"));
            sb.append(" : ").append(this._remarkFilter).append("\n");
        }
        if (this._probaEnable == null && this._probaLimit != null) {
            sb.append(" ");
            sb.append(ResCompute.getString("DLG_RESULT_PROBA"));
            sb.append(" : ").append(ResCompute.getString("DLG_RESULT_FILTER_MULTIPLE_VALUES")).append("\n");
        } else if (this._probaEnable.booleanValue()) {
            sb.append("  ");
            sb.append(ResCompute.getString("DLG_RESULT_PROBA"));
            sb.append(" : ").append(this._probaLimit).append("\n");
        }
        if (this._attrEnable == null) {
            sb.append(" ");
            sb.append(ResMsgVoc.getString((String)"VOC_ATTRIBUTE"));
            sb.append(" : ").append(ResCompute.getString("DLG_RESULT_FILTER_MULTIPLE_VALUES")).append("\n");
        } else if (this._attrEnable.booleanValue() && this._attrCriterion != null) {
            sb.append("  ");
            sb.append(ResMsgVoc.getString((String)"VOC_ATTRIBUTE"));
            sb.append(" : ").append(this._attrCriterion.toString()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean withProbability() {
        return this._withProbability && this._probaEnable != false;
    }

    @Override
    public void configure(Map<Attr.Key, Set<String>> attrs) {
        this._attrMap = attrs;
        this._withAttribute = this._attrMap != null && this._attrMap.size() > 0;
    }

    @Override
    public String checkAttributes(Map<Attr.Key, Set<String>> attrs) {
        if (!this._attrEnable.booleanValue()) {
            return null;
        }
        if (this._attrCriterion == null) {
            return null;
        }
        if (Attr.Key.containsAttribut(attrs, (Attr.Key)this._attrCriterion.getKey())) {
            return null;
        }
        return this._attrCriterion.getName();
    }

    @Override
    public boolean withDialog() {
        return true;
    }

    @Override
    public boolean selectFilter(Component owner) {
        if (!(this._orderEnable && this._withOrder || this._nameEnable != null && this._nameEnable.booleanValue() || this._remarkEnable != null && this._remarkEnable.booleanValue() || this._probaEnable != null && this._probaEnable.booleanValue() && this._withProbability || this._attrEnable != null && this._attrEnable.booleanValue() && this._withAttribute)) {
            return this.displayDialog(owner);
        }
        return true;
    }

    private final void createDialog(Component owner) {
        if (this._dlg == null) {
            this._dlg = new MCSFilterDlg(SwingUtilities.getWindowAncestor(owner));
            this._dlg.create();
            this._dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf((Component)owner));
        }
    }

    public boolean displayDialog(Component owner, boolean multiMode) {
        this.createDialog(owner);
        this._dlg.setIsInMultiEditionMode(multiMode);
        return this.displayDialog(owner);
    }

    @Override
    public boolean displayDialog(Component owner) {
        int i;
        ListSelectionModel selectTable;
        this.createDialog(owner);
        if (this._withOrder) {
            selectTable = this._dlg._orderTable.getSelectionModel();
            this._dlg._orderCheck.setEnabled(this._withOrder);
            this._dlg._orderCheck.setSelected(this._orderEnable);
            selectTable.clearSelection();
            for (i = 1; i < this._ordersSelect.length; ++i) {
                if (!this._ordersSelect[i]) continue;
                selectTable.addSelectionInterval(i - 1, i - 1);
            }
        }
        if (this._nameEnable == null) {
            this._dlg._evtNameCheck.setPartial(true);
            this._dlg._evtNameText.setEditable(false);
            this._dlg._evtNameCheck.updateUI();
        } else {
            this._dlg._evtNameCheck.setSelected(this._nameEnable.booleanValue());
            this._dlg._evtNameText.setEditable(this._nameEnable);
        }
        this._dlg._evtNameText.setText(this._nameFilter);
        if (this._remarkEnable == null) {
            this._dlg._evtRemarkCheck.setPartial(true);
            this._dlg._evtRemarkText.setEditable(false);
            this._dlg._evtRemarkCheck.updateUI();
        } else {
            this._dlg._evtRemarkCheck.setSelected(this._remarkEnable.booleanValue());
            this._dlg._evtRemarkText.setEditable(this._remarkEnable);
        }
        this._dlg._evtRemarkText.setText(this._remarkFilter);
        if (this._probaEnable == null) {
            this._dlg._probaCheck.setPartial(true);
            this._dlg._probaText.setEditable(false);
            this._dlg._probaCheck.updateUI();
        } else {
            this._dlg._probaCheck.setSelected(this._probaEnable.booleanValue());
            this._dlg._probaText.setEditable(this._probaEnable);
        }
        this._dlg._probaText.setText(this._probaLimit == null ? null : this._probaLimit.toString());
        if (this._attrEnable == null) {
            this._dlg._evtAttrCheck.setPartial(true);
            this._dlg._evtAttrPanel.setEditable(false);
            this._dlg._evtAttrCheck.updateUI();
        } else {
            this._dlg._evtAttrCheck.setSelected(this._attrEnable.booleanValue());
            this._dlg._evtAttrPanel.setEditable(this._attrEnable.booleanValue());
        }
        this._dlg._evtAttrPanel.setCurrentAttributeCriterion(this._attrCriterion);
        this._dlg.setVisible(true);
        if (!this._dlg.getResult()) {
            return false;
        }
        if (this._withOrder) {
            selectTable = this._dlg._orderTable.getSelectionModel();
            this._orderEnable = this._dlg._orderCheck.isSelected();
            selectTable = this._dlg._orderTable.getSelectionModel();
            for (i = 1; i < this._ordersSelect.length; ++i) {
                this._ordersSelect[i] = selectTable.isSelectedIndex(i - 1);
            }
        }
        this._nameEnable = this._dlg._evtNameCheck.isPartial() ? null : Boolean.valueOf(this._dlg._evtNameCheck.isSelected());
        this._nameFilter = this._dlg._evtNameText.getText();
        this._remarkEnable = this._dlg._evtRemarkCheck.isPartial() ? null : Boolean.valueOf(this._dlg._evtRemarkCheck.isSelected());
        this._remarkFilter = this._dlg._evtRemarkText.getText();
        this._probaEnable = this._dlg._probaCheck.isPartial() ? null : Boolean.valueOf(this._dlg._probaCheck.isSelected());
        if (this._probaEnable != null && this._probaEnable.booleanValue()) {
            this._probaLimit = this._dlg._probaText.getText() != null && !this._dlg._probaText.getText().isEmpty() ? Double.valueOf(Double.parseDouble(this._dlg._probaText.getText())) : null;
        }
        this._attrEnable = this._dlg._evtAttrCheck.isPartial() ? null : Boolean.valueOf(this._dlg._evtAttrCheck.isSelected());
        if (this._attrEnable != null && this._attrEnable.booleanValue()) {
            this._attrCriterion = this._dlg._evtAttrPanel.getCurrentAttributeCriterion();
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof MCSFilterStandard)) {
            return false;
        }
        MCSFilterStandard filterStandard = (MCSFilterStandard)obj;
        if (filterStandard._attrEnable != this._attrEnable) {
            return false;
        }
        if (filterStandard._attrCriterion == null ^ this._attrCriterion == null) {
            return false;
        }
        if (filterStandard._attrCriterion != null && !filterStandard._attrCriterion.equals((Object)this._attrCriterion)) {
            return false;
        }
        if (filterStandard._orderEnable != this._orderEnable) {
            return false;
        }
        if (filterStandard._ordersSelect == null ^ this._ordersSelect == null) {
            return false;
        }
        if (filterStandard._ordersSelect != null && !filterStandard._ordersSelect.equals(this._ordersSelect)) {
            return false;
        }
        if (filterStandard._ordersNumber == null ^ this._ordersNumber == null) {
            return false;
        }
        if (filterStandard._ordersNumber != null && !filterStandard._ordersNumber.equals(this._ordersNumber)) {
            return false;
        }
        if (filterStandard._ordersProbability == null ^ this._ordersProbability == null) {
            return false;
        }
        if (filterStandard._ordersProbability != null && !filterStandard._ordersProbability.equals(this._ordersProbability)) {
            return false;
        }
        if (filterStandard._nameEnable != this._nameEnable) {
            return false;
        }
        if (!filterStandard._nameFilter.equals(this._nameFilter)) {
            return false;
        }
        if (filterStandard._remarkEnable != this._remarkEnable) {
            return false;
        }
        if (filterStandard._remarkFilter == null ^ this._remarkFilter == null) {
            return false;
        }
        if (filterStandard._remarkFilter != null && !filterStandard._remarkFilter.equals(this._remarkFilter)) {
            return false;
        }
        if (filterStandard._probaEnable != this._probaEnable) {
            return false;
        }
        if (filterStandard._probaLimit == null ^ this._probaLimit == null) {
            return false;
        }
        return filterStandard._probaLimit == null || filterStandard._probaLimit.equals(this._probaLimit);
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = 13 * hashCode + (this._orderEnable ? 1 : 0);
        hashCode = 17 * hashCode + (this._ordersSelect != null ? this._ordersSelect.hashCode() : 0);
        hashCode = 19 * hashCode + (this._ordersNumber != null ? this._ordersNumber.hashCode() : 0);
        hashCode = 23 * hashCode + (this._ordersProbability != null ? this._ordersProbability.hashCode() : 0);
        hashCode = 29 * hashCode + (this._nameEnable != false ? 1 : 0);
        hashCode = 31 * hashCode + (this._nameFilter != null ? this._nameFilter.hashCode() : 0);
        hashCode = 37 * hashCode + (this._nameUtilitySearch != null ? this._nameUtilitySearch.hashCode() : 0);
        hashCode = 41 * hashCode + (this._remarkEnable != false ? 1 : 0);
        hashCode = 43 * hashCode + (this._remarkFilter != null ? this._remarkFilter.hashCode() : 0);
        hashCode = 47 * hashCode + (this._remarkUtilitySearch != null ? this._remarkUtilitySearch.hashCode() : 0);
        hashCode = 59 * hashCode + (this._probaEnable != false ? 1 : 0);
        hashCode = 61 * hashCode + (this._probaLimit != null ? this._probaLimit.hashCode() : 0);
        hashCode = 67 * hashCode + (this._attrEnable != false ? 1 : 0);
        hashCode = 71 * hashCode + (this._attrCriterion != null ? this._attrCriterion.hashCode() : 0);
        return hashCode;
    }

    @Override
    public void saveToXML(Appendable output, String indent) throws IOException {
        if (this._nameEnable.booleanValue()) {
            output.append(indent).append("<filter-name value='");
            Util.appendForXml((Appendable)output, (String)this._nameFilter).append("'/>\n");
        }
        if (this._remarkEnable.booleanValue()) {
            output.append(indent).append("<filter-remark value='");
            Util.appendForXml((Appendable)output, (String)this._remarkFilter).append("'/>\n");
        }
        if (this._probaEnable.booleanValue()) {
            output.append(indent).append("<filter-probability value='");
            output.append(Double.toString(this._probaLimit)).append("'/>\n");
        }
        if (this._attrEnable.booleanValue()) {
            output.append(indent).append("<filter-attribute");
            this._attrCriterion.saveToXML(output);
            output.append("/>\n");
        }
    }

    @Override
    public void loadFromXML(Element xmlTgt) throws SAXException, IOException {
        NodeList childs = xmlTgt.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node xmlChild = childs.item(i);
            if (xmlChild.getNodeName().equals("filter-name")) {
                this._nameFilter = ((Element)xmlChild).getAttribute("value");
                this._nameEnable = true;
                continue;
            }
            if (xmlChild.getNodeName().equals("filter-remark")) {
                this._remarkFilter = ((Element)xmlChild).getAttribute("value");
                this._remarkEnable = true;
                continue;
            }
            if (xmlChild.getNodeName().equals("filter-probability")) {
                try {
                    this._probaLimit = Double.parseDouble(((Element)xmlChild).getAttribute("value"));
                    this._probaEnable = true;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new SAXException(nfe);
                }
            }
            if (!xmlChild.getNodeName().equals("filter-attribute")) continue;
            this._attrCriterion = AttrCriterion.loadFromXML((Element)((Element)xmlChild));
            this._attrEnable = true;
        }
    }

    protected class MCSFilterDlg
    extends JDialogCecilia {
        boolean _isInMultiEditionMode;
        JCheckBox _orderCheck;
        JButton _orderAllBut;
        JTable _orderTable;
        PartialCheckBox _probaCheck;
        JTextField _probaText;
        PartialCheckBox _evtNameCheck;
        JTextField _evtNameText;
        PartialCheckBox _evtRemarkCheck;
        JTextField _evtRemarkText;
        PartialCheckBox _evtAttrCheck;
        AttributeCriterionPanel _evtAttrPanel;

        JTextField createTextField() {
            JTextField result = new JTextField("");
            result.setColumns(20);
            result.setEditable(false);
            return result;
        }

        public void setIsInMultiEditionMode(boolean isInMultiEditionMode) {
            this._isInMultiEditionMode = isInMultiEditionMode;
        }

        void prepareStringFilter(JPanel owner, int idxRow, final JCheckBox check, final JTextField text) {
            owner.add((Component)check, new GridBagConstraints(0, idxRow, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 5), 0, 0));
            owner.add((Component)text, new GridBagConstraints(1, idxRow, 5, 1, 1.0, 0.0, 13, 2, new Insets(10, 5, 5, 5), 0, 0));
            check.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    text.setEditable(check.isSelected());
                }
            });
        }

        MCSFilterDlg(Window win) {
            super(win, ResCompute.getString("DLG_RESULT_FILTER_STD"), true);
        }

        protected void create() {
            this.getContentPane().setLayout(new BorderLayout());
            JPanel centerPanel = new JPanel(new GridBagLayout());
            int idxRow = 0;
            if (MCSFilterStandard.this._withOrder) {
                this._orderCheck = new JCheckBox(ResCompute.getString("DLG_RESULT_ORDER"));
                this._orderAllBut = new JButton(ResMsgVoc.getString((String)"VOC_ALL"));
                this._orderAllBut.setMargin(new Insets(2, 2, 2, 2));
                this._orderTable = new JTable(new MCSFilterOrdersTableModel()){

                    @Override
                    public void createDefaultColumnsFromModel() {
                        super.createDefaultColumnsFromModel();
                        this.getColumnModel().getColumn(0).setPreferredWidth(50);
                    }
                };
                this._orderTable.setPreferredScrollableViewportSize(new Dimension(60, 80));
                JScrollPane orderScroll = new JScrollPane(this._orderTable);
                centerPanel.add((Component)this._orderCheck, new GridBagConstraints(0, idxRow, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 5, 5), 0, 0));
                centerPanel.add((Component)this._orderAllBut, new GridBagConstraints(0, idxRow + 1, 1, 1, 0.0, 0.0, 14, 0, new Insets(10, 5, 5, 5), 0, 0));
                centerPanel.add((Component)orderScroll, new GridBagConstraints(1, idxRow, 5, 2, 2.0, 2.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
                this._orderCheck.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MCSFilterDlg.this.updateOrderCtrls();
                    }
                });
                this._orderAllBut.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MCSFilterDlg.this._orderTable.getSelectionModel().addSelectionInterval(0, MCSFilterDlg.this._orderTable.getRowCount());
                        MCSFilterDlg.this.updateOrderCtrls();
                    }
                });
                this._orderTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        MCSFilterDlg.this.updateOrderCtrls();
                    }
                });
                this._orderTable.setSelectionBackground(this._orderTable.getTableHeader().getBackground().darker());
                this._orderTable.setDefaultRenderer(Number.class, new MCSTableCellRendererOrder());
                this._orderTable.setDefaultRenderer(Double.class, new MCSTableCellRendererProbability(MCSFilterStandard.this._renderer));
                idxRow += 2;
            }
            this._evtNameCheck = new PartialCheckBox(ResCompute.getString("DLG_RESULT_FILTER_NAME"));
            this._evtNameCheck.setAsymetricChangeValue(true);
            this._evtNameText = this.createTextField();
            this.prepareStringFilter(centerPanel, idxRow++, (JCheckBox)this._evtNameCheck, this._evtNameText);
            this._evtRemarkCheck = new PartialCheckBox(ResCompute.getString("DLG_RESULT_FILTER_REMARK"));
            this._evtRemarkCheck.setAsymetricChangeValue(true);
            this._evtRemarkText = this.createTextField();
            this.prepareStringFilter(centerPanel, idxRow++, (JCheckBox)this._evtRemarkCheck, this._evtRemarkText);
            this._probaCheck = new PartialCheckBox(ResCompute.getString("DLG_RESULT_PROBA"));
            this._probaCheck.setAsymetricChangeValue(true);
            this._probaText = this.createTextField();
            this.prepareStringFilter(centerPanel, idxRow++, (JCheckBox)this._probaCheck, this._probaText);
            this._evtAttrCheck = new PartialCheckBox(ResMsgVoc.getString((String)"VOC_ATTRIBUTE"));
            this._evtAttrCheck.setAsymetricChangeValue(true);
            this._evtAttrPanel = new AttributeCriterionPanel(MCSFilterStandard.this._attrMap);
            this._evtAttrPanel.setBorder(BorderFactory.createEtchedBorder());
            centerPanel.add((Component)this._evtAttrCheck, new GridBagConstraints(0, idxRow, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 5, 5), 0, 0));
            centerPanel.add((Component)this._evtAttrPanel, new GridBagConstraints(1, idxRow, 5, 1, 1.0, 0.0, 13, 2, new Insets(10, 5, 5, 5), 0, 0));
            this._evtAttrCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MCSFilterDlg.this._evtAttrPanel.setEditable(MCSFilterDlg.this._evtAttrCheck.isSelected());
                }
            });
            ++idxRow;
            this.getContentPane().add((Component)centerPanel, "Center");
            this.getContentPane().add((Component)this.createButPanel(true), "South");
            this.pack();
        }

        void setEnabledOrderTable(boolean enabled) {
            if (this._orderTable.isEnabled() == enabled) {
                return;
            }
            this._orderTable.setEnabled(enabled);
            if (enabled) {
                this._orderTable.setBackground((Color)UIManager.get("TextField.background"));
                this._orderTable.setSelectionBackground(this._orderTable.getSelectionBackground().brighter());
                this._orderTable.getTableHeader().setBackground(this._orderTable.getTableHeader().getBackground().brighter());
            } else {
                this._orderTable.setBackground((Color)UIManager.get("TextField.inactiveBackground"));
                this._orderTable.setSelectionBackground(this._orderTable.getSelectionBackground().darker());
                this._orderTable.getTableHeader().setBackground(this._orderTable.getTableHeader().getBackground().darker());
            }
        }

        void updateOrderCtrls() {
            boolean orderSelect = this._orderCheck.isSelected();
            this.setEnabledOrderTable(orderSelect);
            boolean orderAllButEnable = orderSelect;
            if (orderAllButEnable) {
                orderAllButEnable = false;
                for (int i = 0; i < this._orderTable.getRowCount() && !orderAllButEnable; ++i) {
                    if (this._orderTable.getSelectionModel().isSelectedIndex(i)) continue;
                    orderAllButEnable = true;
                }
            }
            this._orderAllBut.setEnabled(orderAllButEnable);
        }

        protected boolean verifyParameters() {
            if (this._isInMultiEditionMode) {
                return true;
            }
            if (MCSFilterStandard.this._withOrder && this._orderCheck.isSelected()) {
                boolean select = false;
                for (int i = 0; i < this._orderTable.getRowCount() && !select; ++i) {
                    if (!this._orderTable.getSelectionModel().isSelectedIndex(i)) continue;
                    select = true;
                }
                if (!select) {
                    return false;
                }
            }
            if (this._evtNameCheck.isSelected() && !this._evtNameCheck.isPartial() && this._evtNameText.getText().trim().length() == 0) {
                return false;
            }
            if (this._evtRemarkCheck.isSelected() && !this._evtRemarkCheck.isPartial() && this._evtRemarkText.getText().trim().length() == 0) {
                return false;
            }
            if (MCSFilterStandard.this._withProbability && this._probaCheck.isSelected() && !this._probaCheck.isPartial()) {
                try {
                    Double.parseDouble(this._probaText.getText());
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (MCSFilterStandard.this._withAttribute && this._evtAttrCheck.isSelected() && !this._evtAttrCheck.isPartial() && !this._evtAttrPanel.verifyParameters()) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this._evtAttrPanel), ResCompute.getString("DLG_PARAM_ERR_ATTRIB"));
                return false;
            }
            return true;
        }
    }

    protected class MCSFilterOrdersTableModel
    implements TableModel {
        protected EventListenerList _listenerList = new EventListenerList();

        protected MCSFilterOrdersTableModel() {
        }

        @Override
        public int getRowCount() {
            return MCSFilterStandard.this._ordersNumber.length - 1;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ResCompute.getString("DLG_RESULT_ORDERS");
                }
                case 1: {
                    return ResCompute.getString("DLG_RESULT_CUTS");
                }
                case 2: {
                    return ResCompute.getString("DLG_RESULT_PROBAS");
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 2: {
                    return Double.class;
                }
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return rowIndex + 1;
                }
                case 1: {
                    return MCSFilterStandard.this._ordersNumber[rowIndex + 1];
                }
                case 2: {
                    return MCSFilterStandard.this._ordersProbability[rowIndex + 1];
                }
            }
            return "Error";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this._listenerList.add(TableModelListener.class, l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this._listenerList.remove(TableModelListener.class, l);
        }
    }
}

