/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.MCS;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilter;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorter;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorterProba;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSortingInProba;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MCSFilterWeight
extends MCSFilter {
    private static Logger _LOG = Logger.getLogger(MCSFilterWeight.class.getPackage().getName());
    Double _weight;

    public MCSFilterWeight(double weight) {
        if (weight < 0.0 || weight > 100.0) {
            throw new IllegalArgumentException();
        }
        this._weight = weight;
    }

    public final Double getWeight() {
        return this._weight;
    }

    public final void setWeight(Double weight) {
        if (weight == null) {
            this._weight = null;
        } else {
            if (weight < 0.0 || weight > 100.0) {
                throw new IllegalArgumentException();
            }
            this._weight = weight;
        }
    }

    @Override
    public MCSFilter getCopy() {
        return new MCSFilterWeight(this._weight);
    }

    @Override
    public MCSSorter.Type getTypeSorter() {
        return MCSSorter.Type.PROBA_ORDER_LEXIC;
    }

    @Override
    public int getRankLimit() {
        return -1;
    }

    @Override
    public boolean withProbability() {
        return true;
    }

    @Override
    public MCS filterMCS(MCS source) {
        double sumProba = 0.0;
        for (int i = source.getOrderMax() - 1; i >= 0; --i) {
            sumProba += source.getOrderProbability(i);
        }
        if (Double.isNaN(sumProba)) {
            _LOG.log(Level.SEVERE, "Filtre des coupes sur le poid relatif inoperationnel :\n  Erreur dans la somme des probas du MCS source");
            return source;
        }
        sumProba = sumProba * this._weight / 100.0;
        FilterSumProbability filter = new FilterSumProbability(sumProba, 1000);
        MCS.CutIterator iter = source.cutIterate();
        while (iter.hasNext()) {
            filter.addCut(iter.next());
        }
        Cut[] cuts = filter.getResults();
        return new MCSSortingInProba(cuts);
    }

    @Override
    public String getTitle() {
        return ResCompute.getString("DLG_RESULT_FILTER_WEIGHT");
    }

    @Override
    public String getAbstract() {
        StringBuffer sb = new StringBuffer(512);
        sb.append(ResCompute.getString("DLG_RESULT_FILTER_WEIGHT_LABEL"));
        sb.append(" = ").append(this._weight);
        return sb.toString();
    }

    @Override
    public boolean withDialog() {
        return true;
    }

    @Override
    public boolean selectFilter(Component owner) {
        if (this._weight != null && this._weight == 0.0) {
            return this.displayDialog(owner);
        }
        return true;
    }

    @Override
    public boolean displayDialog(Component owner) {
        boolean canBeEmptyString;
        boolean bl = canBeEmptyString = this._weight == null;
        String result;
        while ((result = JOptionPane.showInputDialog(JOptionCecilia.getTopContainerOf((Component)owner), ResCompute.getString("DLG_RESULT_FILTER_WEIGHT_LABEL"), this._weight)) != null) {
            if (result.isEmpty() && canBeEmptyString) {
                return false;
            }
            try {
                double weight = Double.parseDouble(result);
                if (!(weight >= 0.0) || !(weight <= 100.0)) continue;
                this._weight = weight;
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            break;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof MCSFilterWeight)) {
            return false;
        }
        return ((MCSFilterWeight)obj)._weight == this._weight;
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        return hashCode * 3 + (this._weight != null ? this._weight.hashCode() : 0);
    }

    @Override
    public void saveToXML(Appendable output, String indent) throws IOException {
        output.append(indent).append("<filter-weight value='");
        output.append(Double.toString(this._weight)).append("'/>\n");
    }

    @Override
    public void loadFromXML(Element xmlTgt) throws SAXException, IOException {
        NodeList childs = xmlTgt.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node xmlChild = childs.item(i);
            if (!xmlChild.getNodeName().equals("filter-weight")) continue;
            try {
                this._weight = Double.parseDouble(((Element)xmlChild).getAttribute("value"));
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new SAXException(nfe);
            }
        }
    }

    static class FilterSumProbability {
        double _maxSum;
        double _limit;
        Cut[] _stack;
        int _stackIdx;
        ArrayList<Cut> _results;

        FilterSumProbability(double maxSum, int stackSize) {
            this._maxSum = maxSum;
            this._stack = new Cut[stackSize];
            this._stackIdx = 0;
            this._limit = -1.0;
            this._results = new ArrayList();
        }

        Cut[] getResults() {
            if (this._stackIdx > 0) {
                Arrays.sort(this._stack, 0, this._stackIdx, MCSSorterProba._comparator);
                this._results = this.mergeCuts(this._results, this._stack, this._stackIdx);
            }
            Cut[] cuts = new Cut[this._results.size()];
            return this._results.toArray(cuts);
        }

        void addCut(Cut cut) {
            double curProba = cut.getProbability();
            if (curProba < 0.0) {
                _LOG.log(Level.SEVERE, "Probabilite de la coupe inferieur a 0 :" + cut.toString());
                return;
            }
            if (curProba < this._limit) {
                return;
            }
            this._stack[this._stackIdx++] = cut;
            if (this._stackIdx >= this._stack.length) {
                Arrays.sort(this._stack, MCSSorterProba._comparator);
                this._results = this.mergeCuts(this._results, this._stack, this._stackIdx);
                this._stackIdx = 0;
            }
        }

        private ArrayList<Cut> mergeCuts(List<Cut> src1, Cut[] src2, int size2) {
            double curProba;
            Cut cut2;
            Cut cut1;
            int idx1 = 0;
            int idx2 = 0;
            int size1 = src1.size();
            double sumProba = 0.0;
            ArrayList<Cut> result = new ArrayList<Cut>();
            Comparator<Cut> comparator = MCSSorterProba._comparator;
            this._limit = -1.0;
            while (idx1 < size1 && idx2 < size2) {
                cut1 = src1.get(idx1);
                if (comparator.compare(cut1, cut2 = src2[idx2]) <= 0) {
                    ++idx1;
                    curProba = cut1.getProbability();
                    if (curProba < this._limit) break;
                    if (this._limit < 0.0 && (sumProba += curProba) > this._maxSum) {
                        this._limit = curProba;
                    }
                    result.add(cut1);
                    continue;
                }
                ++idx2;
                curProba = cut2.getProbability();
                if (curProba < this._limit) break;
                if (this._limit < 0.0 && (sumProba += curProba) > this._maxSum) {
                    this._limit = curProba;
                }
                result.add(cut2);
            }
            while (idx1 < size1 && !((curProba = (cut1 = src1.get(idx1++)).getProbability()) < this._limit)) {
                if (this._limit < 0.0 && (sumProba += curProba) > this._maxSum) {
                    this._limit = curProba;
                }
                result.add(cut1);
            }
            while (idx2 < size2 && !((curProba = (cut2 = src2[idx2++]).getProbability()) < this._limit)) {
                if (this._limit < 0.0 && (sumProba += curProba) > this._maxSum) {
                    this._limit = curProba;
                }
                result.add(cut2);
            }
            return result;
        }
    }
}

