/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorterOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MCSSorterOrderRank
extends MCSSorterOrder {
    int _limitRank;
    Cut _limitCut;
    int _addCutCpt;
    int _addCutLimit;
    private static final Logger _LOG = Logger.getLogger(MCSSorterOrderRank.class.getName());
    public static final String PROP_SORTER_ORDER_RANK_DEBUG = "cecilia.ft.compute.mcs.SorterOrderRankXTraTrace";
    private static boolean _FINESTLOG = Boolean.getBoolean("cecilia.ft.compute.mcs.SorterOrderRankXTraTrace") && _LOG.isLoggable(Level.FINEST);

    public MCSSorterOrderRank(boolean sorterProba, int rank) {
        super(sorterProba);
        this._limitRank = rank;
        this._limitCut = null;
        this._addCutLimit = Math.max(1000, rank * 2);
        this._addCutCpt = 0;
    }

    protected void mergeResults() {
        int i;
        if (this._resCuts == null) {
            this._resCuts = new ArrayList();
        }
        int nbrCut = 0;
        int order = this._tmpCuts.size();
        while (this._resCuts.size() < order) {
            this._resCuts.add(new Cut[0]);
        }
        for (i = 0; i < order; ++i) {
            List tmpCuts = (List)this._tmpCuts.get(i);
            if (((Cut[])this._resCuts.get(i)).length == 0) {
                Cut[] resCuts = new Cut[tmpCuts.size()];
                resCuts = tmpCuts.toArray(resCuts);
                Arrays.sort(resCuts, this._comparator);
                int nr = resCuts.length;
                if (nr + nbrCut > this._limitRank) {
                    nr = this._limitRank - nbrCut;
                    Cut[] tmp = new Cut[nr];
                    System.arraycopy(resCuts, 0, tmp, 0, nr);
                    resCuts = tmp;
                }
                this._resCuts.set(i, resCuts);
                nbrCut += resCuts.length;
            } else {
                Cut[] cur2 = new Cut[tmpCuts.size()];
                cur2 = tmpCuts.toArray(cur2);
                Arrays.sort(cur2, this._comparator);
                Cut[] cur1 = (Cut[])this._resCuts.get(i);
                int nr = cur1.length + cur2.length;
                if (nr + nbrCut > this._limitRank) {
                    nr = this._limitRank - nbrCut;
                }
                Cut[] res = new Cut[nr];
                int i1 = 0;
                int i2 = 0;
                int ir = 0;
                while (ir < nr && i1 < cur1.length && i2 < cur2.length) {
                    if (this._comparator.compare(cur1[i1], cur2[i2]) <= 0) {
                        res[ir++] = cur1[i1++];
                        continue;
                    }
                    res[ir++] = cur2[i2++];
                }
                while (ir < nr && i1 < cur1.length) {
                    res[ir++] = cur1[i1++];
                }
                while (ir < nr && i2 < cur2.length) {
                    res[ir++] = cur2[i2++];
                }
                this._resCuts.set(i, res);
                nbrCut += res.length;
            }
            this._tmpCuts.set(i, null);
            if (nbrCut < this._limitRank) continue;
            for (int j = order - 1; j > i; --j) {
                this._resCuts.remove(j);
            }
            break;
        }
        this._tmpCuts.clear();
        this._limitCut = null;
        for (i = this._resCuts.size() - 1; i >= 0; --i) {
            Cut[] cuts = (Cut[])this._resCuts.get(i);
            if (cuts.length == 0) continue;
            this._limitCut = cuts[cuts.length - 1];
            break;
        }
        if (_LOG.isLoggable(Level.FINEST)) {
            _LOG.finest("MergeCuts - lastElement : " + (this._limitCut != null ? this._limitCut.toString() : "<null>"));
        }
        this._addCutCpt = 0;
        this._addCutLimit = this._limitRank;
    }

    @Override
    public void addCut(Cut cut) {
        if (this._limitCut != null && this._comparator.compare(this._limitCut, cut) < 0) {
            if (_FINESTLOG) {
                _LOG.finest("~ addCut : " + cut.toString());
            }
            return;
        }
        if (_FINESTLOG) {
            _LOG.finest("  addCut : " + cut.toString());
        }
        super.addCut(cut);
        if (++this._addCutCpt >= this._addCutLimit) {
            this.mergeResults();
        }
    }

    @Override
    protected void finishSorter() {
        this.mergeResults();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof MCSSorterOrderRank)) {
            return false;
        }
        MCSSorterOrderRank sorterOrderRank = (MCSSorterOrderRank)obj;
        return sorterOrderRank._limitRank == this._limitRank;
    }

    @Override
    public int hashCode() {
        int hashcode = super.hashCode();
        hashcode = hashcode * 11 + this._limitRank;
        return hashcode;
    }
}

