/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.Evt;
import com.dassault.cecilia.plugin.faulttree.compute.MCS;
import java.util.ArrayList;
import java.util.List;

public class MCSSortingInProba
implements MCS {
    Entry _root;
    List<Integer> _beginCuts;
    int _nbrRow;
    int _nbrCut;
    List<MCS.InfoOrder> _infoOrders = new ArrayList<MCS.InfoOrder>(16);
    private int _cacheRowCutKey = -1;
    private Cut _cacheRowCut = null;
    private int _cacheRowIdxKey = -1;
    private int _cacheRowIdx = -1;
    private int _cacheRowEvtKey = -1;
    private Evt _cacheRowEvt = null;

    private Entry createAVL(Cut[] cuts, int minIdx, int maxIdx) {
        Entry result = null;
        if (minIdx == maxIdx) {
            result = new Entry(cuts[minIdx]);
            result._idxCut = minIdx;
        } else {
            int idxPivot = (maxIdx + minIdx) / 2;
            result = new Entry(cuts[idxPivot]);
            result._idxCut = idxPivot;
            if (idxPivot != minIdx) {
                result._left = this.createAVL(cuts, minIdx, idxPivot - 1);
            }
            result._right = this.createAVL(cuts, idxPivot + 1, maxIdx);
        }
        return result;
    }

    private int computeAVLWeight(Entry entry, int addRight) {
        entry._maxRow = entry._cut.getOrder();
        while (entry._maxRow >= this._infoOrders.size()) {
            this._infoOrders.add(new MCS.InfoOrder(entry._maxRow, 0, 0.0));
        }
        MCS.InfoOrder info = this._infoOrders.get(entry._maxRow);
        info.incInfo(1, entry._cut.getProbability());
        if (entry._left != null) {
            entry._maxRow += this.computeAVLWeight(entry._left, addRight);
        } else {
            entry._maxRow += addRight;
            if (entry._right == null) {
                return entry._maxRow;
            }
        }
        return this.computeAVLWeight(entry._right, entry._maxRow);
    }

    public MCSSortingInProba(Cut[] cuts) {
        if (cuts.length > 0) {
            this._root = this.createAVL(cuts, 0, cuts.length - 1);
            this._nbrRow = this.computeAVLWeight(this._root, 0);
            this._nbrCut = cuts.length;
        } else {
            this._nbrRow = 0;
            this._nbrCut = 0;
        }
    }

    public String debugInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("NbrCut=").append(this._nbrCut).append("\n");
        sb.append("NbrRow=").append(this._nbrRow).append("\n");
        if (this._root != null) {
            sb.append("Cuts : \n");
            this.debugInfo_rec(this._root, sb);
        }
        return sb.toString();
    }

    private void debugInfo_rec(Entry entry, StringBuffer out) {
        if (entry._left != null) {
            this.debugInfo_rec(entry._left, out);
        }
        out.append(entry._cut.toString()).append(":").append(entry._maxRow).append("\n");
        if (entry._right != null) {
            this.debugInfo_rec(entry._right, out);
        }
    }

    @Override
    public int getOrderMax() {
        return this._infoOrders.size();
    }

    @Override
    public int getOrderNumber(int idx) {
        return this._infoOrders.get(idx).getNumber();
    }

    @Override
    public double getOrderProbability(int idx) {
        return this._infoOrders.get(idx).getProbability();
    }

    @Override
    public int getCutCount() {
        return this._nbrCut;
    }

    @Override
    public MCS.CutIterator cutIterate() {
        class EntryCutIterator
        implements MCS.CutIterator {
            List<Entry> _stack = new ArrayList<Entry>(32);

            EntryCutIterator(Entry current) {
                this.addEntry(current);
            }

            void addEntry(Entry current) {
                while (current != null) {
                    this._stack.add(current);
                    current = current._left;
                }
            }

            private void findNext(Entry current) {
                int idx = this._stack.size() - 1;
                Entry parent = null;
                while (idx >= 0) {
                    this._stack.remove(idx--);
                    if (idx < 0) continue;
                    parent = this._stack.get(idx);
                    if (parent._left == current) break;
                    current = parent;
                }
            }

            @Override
            public boolean hasNext() {
                return !this._stack.isEmpty();
            }

            @Override
            public Cut next() {
                Entry current = this._stack.get(this._stack.size() - 1);
                if (current._right != null) {
                    this.addEntry(current._right);
                } else {
                    this.findNext(current);
                }
                return current._cut;
            }
        }
        return new EntryCutIterator(this._root);
    }

    @Override
    public int getRowCount() {
        return this._nbrRow;
    }

    @Override
    public Cut getRowCut(int row) {
        if (row < 0 || row >= this._nbrRow) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        if (this._cacheRowCutKey == row) {
            return this._cacheRowCut;
        }
        this._cacheRowCutKey = row;
        Entry entry = this.getRowEntry_rec(this._root, row + 1, true);
        this._cacheRowCut = entry == null ? null : entry._cut;
        return this._cacheRowCut;
    }

    private Entry getRowEntry_rec(Entry entry, int row, boolean exact) {
        if (row > entry._maxRow) {
            return this.getRowEntry_rec(entry._right, row, exact);
        }
        if (row <= entry._maxRow - entry._cut.getOrder()) {
            return this.getRowEntry_rec(entry._left, row, exact);
        }
        if (!exact) {
            return entry;
        }
        if (row - 1 == entry._maxRow - entry._cut.getOrder()) {
            return entry;
        }
        return null;
    }

    @Override
    public int getRowIndexCut(int row) {
        if (row < 0 || row >= this._nbrRow) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        if (this._cacheRowIdxKey == row) {
            return this._cacheRowIdx;
        }
        this._cacheRowIdxKey = row;
        Entry entry = this.getRowEntry_rec(this._root, row + 1, false);
        this._cacheRowIdx = entry._idxCut;
        return this._cacheRowIdx;
    }

    @Override
    public Evt getRowEvent(int row) {
        if (row < 0 || row >= this._nbrRow) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        if (this._cacheRowEvtKey == row) {
            return this._cacheRowEvt;
        }
        this._cacheRowEvtKey = row;
        this._cacheRowEvt = this.getRowEvent_rec(this._root, row + 1);
        return this._cacheRowEvt;
    }

    private Evt getRowEvent_rec(Entry entry, int row) {
        if (row > entry._maxRow) {
            return this.getRowEvent_rec(entry._right, row);
        }
        if (row <= entry._maxRow - entry._cut.getOrder()) {
            return this.getRowEvent_rec(entry._left, row);
        }
        return entry._cut.getEvent(entry._cut.getOrder() - (entry._maxRow - row) - 1);
    }

    static class Entry {
        Cut _cut;
        int _maxRow;
        int _idxCut;
        Entry _left = null;
        Entry _right = null;

        Entry(Cut cut) {
            this._cut = cut;
            this._maxRow = cut.getOrder();
        }
    }
}

