/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.task;

import com.dassault.cecilia.plugin.faulttree.compute.compute.MCSInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DebugLoadMCS {
    private static Logger _LOG = Logger.getLogger(DebugLoadMCS.class.getPackage().getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean printCuts(File fileMCS, int nbrLeaves, Writer output, boolean printCut) {
        if (fileMCS == null) {
            throw new NullPointerException();
        }
        boolean bSuccess = false;
        FilterInputStream inStream = null;
        try {
            int i;
            inStream = new MCSInputStream(new BufferedInputStream(new FileInputStream(fileMCS)), nbrLeaves + 2);
            int format = inStream.read();
            output.write("Format:" + format + "\n");
            if (format != 1) {
                throw new IOException("Incompatible data format [format = " + format + "]");
            }
            int nbrCuts = -1;
            nbrCuts = ((MCSInputStream)inStream).readInt();
            output.write("NbrCuts:" + nbrCuts + "\n");
            if (nbrCuts < 0) {
                throw new IOException("Bad number cuts (nbrCuts=" + nbrCuts + ")");
            }
            long[] orders = new long[16];
            for (i = 0; i < nbrCuts; ++i) {
                int order = ((MCSInputStream)inStream).readIndex();
                if (printCut) {
                    output.write("Cut(" + order + ")[" + i + "] ");
                }
                if (order < 0) {
                    throw new IOException("Bad order cut (idxCut=" + i + ", order=" + order + ")");
                }
                int n = order;
                orders[n] = orders[n] + 1L;
                for (int j = 0; j < order; ++j) {
                    int idx = ((MCSInputStream)inStream).readIndex();
                    if (idx < 0 || idx >= nbrLeaves) {
                        throw new IOException("Bad index event for cut (idxCut=" + i + ", idxEvt=" + j + ", idx=" + idx + ")");
                    }
                    if (!printCut) continue;
                    if (j > 0) {
                        output.write(", ");
                    }
                    output.write("" + idx);
                }
                if (!printCut) continue;
                output.write("\n");
            }
            for (i = 0; i < orders.length; ++i) {
                if (orders[i] <= 0L) continue;
                output.write("#Order(" + i + ")=" + orders[i] + "\n");
            }
            bSuccess = true;
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Error during save 'cuts file'", e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    _LOG.log(Level.INFO, "Error during close 'cuts file'", e);
                }
            }
        }
        if (bSuccess) {
            _LOG.finest("Load cuts < " + fileMCS.toString());
        }
        return bSuccess;
    }

    public static void main(String[] args) {
        Writer output = new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                System.out.print(new String(cbuf, off, len));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
        DebugLoadMCS.printCuts(new File("D:/Projets/Cecilia-2023/BCuts.bin"), 1224, output, false);
    }
}

