/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.task;

import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.plugin.faulttree.compute.ActionControl;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.ParamCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainer;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskItem;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskIResultProbability
extends TaskItem {
    private static Logger _LOG = Logger.getLogger(TaskIResultProbability.class.getPackage().getName());
    BooleanResult _boolResult;
    TypeProbability _typePr;
    double _missionTime;
    boolean _error;
    boolean _requestStop = false;

    public TaskIResultProbability(TaskContainer container, BooleanResult result, ParamCompute parameters) {
        super(container);
        this._boolResult = result;
        this._typePr = parameters.getTypeProbability();
        this._missionTime = parameters.getMissionTimeH();
        this._error = false;
    }

    @Override
    public void run() {
        ActionControl ctrl = new ActionControl(){

            @Override
            public boolean isCanceled() {
                return TaskIResultProbability.this._requestStop;
            }
        };
        try {
            this._boolResult.computeProbabilities(this._typePr, this._missionTime, ctrl);
        }
        catch (Throwable e) {
            this._error = true;
            this.addError(ResCompute.getString("MSG_RESULT_ERR_COMPUTE_PROBA"));
            _LOG.log(Level.WARNING, "IOException during compute probability" + e.getMessage(), e);
        }
    }

    @Override
    public String getInfo() {
        return ResCompute.getString("TASK_INFO_RESULT_PROBA");
    }

    @Override
    public void requestStop() {
        this._requestStop = true;
    }

    @Override
    public boolean continueWhenFinnished() {
        return !this._error;
    }
}

