/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.task;

import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMEL;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ComputeMELAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainer;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultSaveAbstract;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskIResultSaveMEL
extends TaskIResultSaveAbstract {
    private static Logger _LOG = Logger.getLogger(TaskIResultSaveMEL.class.getPackage().getName());
    ComputeMELAbstract _compute;
    InfoDatum _idatum;
    Plugable _plugable;

    public TaskIResultSaveMEL(TaskContainer container, ComputeMELAbstract compute, InfoDatum idatum, Plugable plugable) {
        super(container, compute);
        this._compute = compute;
        this._idatum = idatum;
        this._plugable = plugable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveMEL(BooleanMEL results, ParamComputeAbstract parameters) {
        File file = null;
        try {
            file = File.createTempFile("BMel", ".bin");
            file.deleteOnExit();
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Error during create 'mel file'", e);
            return null;
        }
        boolean bSuccess = false;
        FilterOutputStream outStream = null;
        try {
            outStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            ((DataOutputStream)outStream).writeInt(3);
            ((DataOutputStream)outStream).writeBoolean(results.isSimplified());
            boolean withProba = parameters.getTypeProbability() != TypeProbability.NONE;
            ((DataOutputStream)outStream).writeBoolean(withProba);
            int nbrTargets = results.getNbrItems();
            ((DataOutputStream)outStream).writeInt(nbrTargets);
            int nbrOrders = results.getMaxOrder();
            ((DataOutputStream)outStream).writeInt(nbrOrders);
            TaskIResultSaveMEL.saveItem((DataOutputStream)outStream, results.getNominalItem(), nbrOrders, withProba);
            for (int i = 0; i < nbrTargets; ++i) {
                BooleanMEL.Item item = results.getItemAt(i);
                int idx = item.getNode().getIndex();
                ((DataOutputStream)outStream).writeInt(idx);
                ((DataOutputStream)outStream).writeUTF(item.getNode().getName());
                TaskIResultSaveMEL.saveItem((DataOutputStream)outStream, item, nbrOrders, withProba);
            }
            ((DataOutputStream)outStream).flush();
            bSuccess = true;
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Error during save 'mel file'", e);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    _LOG.log(Level.INFO, "Error during close 'mel file'", e);
                }
            }
        }
        if (!bSuccess && file.exists()) {
            file.delete();
        }
        return file;
    }

    private static void saveItem(DataOutputStream outStream, BooleanMEL.Item item, int nbrOrders, boolean withProba) throws IOException {
        int j;
        outStream.writeBoolean(item.isAlwaysTrue());
        outStream.writeBoolean(item.isAlwaysFalse());
        String warning = item.getWarning();
        if (warning != null) {
            outStream.writeBoolean(true);
            outStream.writeUTF(warning);
        } else {
            outStream.writeBoolean(false);
        }
        for (j = 0; j <= nbrOrders; ++j) {
            outStream.writeLong(item.getOrderNumber(j));
        }
        if (withProba) {
            outStream.writeDouble(item.getProbability());
            for (j = 0; j <= nbrOrders; ++j) {
                outStream.writeDouble(item.getOrderProbability(j));
            }
        }
    }

    @Override
    public void run() {
        File paramsFile;
        File melFile = TaskIResultSaveMEL.saveMEL(this._compute.getResults(), this._compute.getParameters());
        if (melFile == null) {
            return;
        }
        if (this._idatum.getKey().endsWith("MCS")) {
            this._compute.getParameters().setSimplifiedMode(false);
            this._idatum.setKey("Tree.Compute.MEL");
            this._idatum.getParameters().put("Key", "Tree.Compute.MEL");
            this._idatum.getParameters().put("Compute", "MEL");
            this._idatum.getInputFiles().remove("result.cuts");
            this._idatum.getInputFiles().remove("result.abstract");
        }
        if ((paramsFile = TaskIResultSaveMEL.saveParameters(this._compute.getStore(), this._compute.getParameters())) == null) {
            return;
        }
        this._idatum.getInputFiles().put("result.mel", melFile);
        this._idatum.getInputFiles().put("result.parameters", paramsFile);
        this._idatum.getParameters().put("result.save", "true");
        this._plugable.setDatum(this._idatum, this._plugable);
    }

    @Override
    public String getInfo() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.getInfo()).append(" [");
        buffer.append(ResCompute.getString("PLUG_CMD_MEL_ABREV"));
        buffer.append("]");
        return buffer.toString();
    }
}

