/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.cstepper;

import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.util.io.XMLWriter;
import com.dassault.cecilia.plugin.mbsa.cstepper.PluginCmdXTree;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import com.dassault.cecilia.plugin.mbsa.viewer.UtilityPluginTargetsDB;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class UtilityPluginTargetsXTree
extends UtilityPluginTargetsDB {
    PluginCmdXTree _plugin;
    String _dbConflictOption;

    public UtilityPluginTargetsXTree(PluginCmdXTree owner, List<TargetModel> tgts, String dbConflictOption) {
        super(tgts);
        this._plugin = owner;
        this._dbConflictOption = dbConflictOption;
    }

    protected String getTitle() {
        return this._plugin.getInfo("plugin.name");
    }

    protected File createFile(Plugable launch, String base, String ext) {
        return this._plugin.createFile(launch, base, ext);
    }

    @Override
    protected void defineUserProperties(Plugable launch, BanEntry entry) {
        entry.setUserProperty("itree.rewrite", Boolean.toString(PlugableUtility.getBoolOpt((Plugable)launch, (String)PluginCmdXTree.OPT_FLATNESS, (boolean)true)));
        entry.setUserProperty("itree.rewrite.not", Boolean.toString(PlugableUtility.getBoolOpt((Plugable)launch, (String)PluginCmdXTree.OPT_SIMPLIFY_NOT_DOUBLE, (boolean)false)));
        entry.setUserProperty("itree.rewrite.cardinality", Boolean.toString(PlugableUtility.getBoolOpt((Plugable)launch, (String)PluginCmdXTree.OPT_SIMPLIFY_COMBINAISON, (boolean)true)));
        entry.setUserProperty("itree.rewrite.neg", Boolean.toString(PlugableUtility.getBoolOpt((Plugable)launch, (String)PluginCmdXTree.OPT_SIMPLIFY_NOT_UNLESS, (boolean)false)));
        entry.setUserProperty("itree.generator.loop", Boolean.toString(PlugableUtility.getBoolOpt((Plugable)launch, (String)PluginCmdXTree.OPT_UNLOOP_CTRL, (boolean)false)));
    }

    @Override
    protected void writeTargetToBanScript(Plugable plugable, Writer writer, TargetModel tgt, int cpt, int nbr) throws IOException {
        this.writeProgressToBanScript(writer, tgt, cpt, nbr);
        writer.write("<callfunct ref=\"itree-launch\">\n");
        writer.write("<value valuable=\"false\" value=\"");
        writer.write(XMLWriter.toXML((String)tgt.getVarTarget()));
        writer.write("\"/>\n");
        writer.write("<value valuable=\"false\" value=\"");
        writer.write(XMLWriter.toXML((String)tgt.getValTarget()));
        writer.write("\"/>\n");
        writer.write("<value valuable=\"false\" value=\"");
        writer.write(XMLWriter.toXML((String)tgt.getFilePath()));
        writer.write("\"/>\n");
        writer.write("<value valuable=\"false\" value=\"");
        writer.write(XMLWriter.toXML((String)Boolean.toString(cpt > 1)));
        writer.write("\"/>\n");
        writer.write("</callfunct>\n");
    }

    @Override
    protected String getDBConflictOption() {
        return this._dbConflictOption;
    }

    @Override
    protected String withDestination() {
        return "  <destination file='${itree.log.path}'>\n    <param name='Append' value='%{logappend}'/>\n    <layout name='txt'>\n      <param name='Info' value='" + Boolean.getBoolean("cecilia.mbsa.plugin.abc.DBImportWithInfo") + "'/>\n      <param name='Output' value='true'/>\n    </layout>\n  </destination>\n";
    }
}

