/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.general.examples;

import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Date;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class PluginCmdChangeProperties
extends AbstractPluginModel
implements PluginMAction {
    private JDialog _dlg = null;
    private JTextField _propertyCtrl;
    private JTextField _valueCtrl;
    private JButton _changeCtrl;
    private JButton _refreshCtrl;
    private JTextArea _propertiesCtrl;

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshProperties(String property) {
        Properties props = System.getProperties();
        StringWriter writer = new StringWriter(1024);
        BufferedWriter bw = new BufferedWriter(writer);
        int start = -1;
        int end = -1;
        try {
            bw.write("#" + new Date().toString());
            bw.newLine();
            Properties properties = props;
            synchronized (properties) {
                TreeSet<Object> set = new TreeSet<Object>(props.keySet());
                for (Object key : set) {
                    String val = (String)props.get(key);
                    if (property != null && start == -1 && property.equals(key)) {
                        bw.flush();
                        start = writer.getBuffer().length();
                    }
                    bw.write(this.saveConvert((String)key, true));
                    bw.write("=");
                    bw.write(this.saveConvert(val, false));
                    if (property != null && end == -1 && property.equals(key)) {
                        bw.flush();
                        end = writer.getBuffer().length();
                    }
                    bw.newLine();
                }
            }
            bw.flush();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        this._propertiesCtrl.setText(writer.toString());
        if (start != -1 && end != -1) {
            this._propertiesCtrl.select(start, end);
        }
    }

    private void createDialog(Window win) {
        this._dlg = new JDialog(win);
        this._dlg.setTitle(this.getInfo("plugin.name"));
        this._dlg.getContentPane().setLayout(new BorderLayout());
        JPanel affectPanel = new JPanel();
        affectPanel.setBorder(BorderFactory.createTitledBorder("Modify property"));
        this._propertyCtrl = new JTextField(30);
        this._valueCtrl = new JTextField(10);
        this._changeCtrl = new JButton("Change");
        this._refreshCtrl = new JButton("Refresh");
        affectPanel.add(this._propertyCtrl);
        affectPanel.add(new JLabel(" = "));
        affectPanel.add(this._valueCtrl);
        affectPanel.add(this._changeCtrl);
        affectPanel.add(new JLabel("       "));
        affectPanel.add(this._refreshCtrl);
        this._dlg.getContentPane().add((Component)affectPanel, "North");
        this._propertiesCtrl = new JTextArea(20, 30);
        this._propertiesCtrl.setFont(new Font("Monospaced", 0, 12));
        this._propertiesCtrl.setEditable(false);
        this._dlg.getContentPane().add((Component)new JScrollPane(this._propertiesCtrl), "Center");
        this._changeCtrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String property = PluginCmdChangeProperties.this._propertyCtrl.getText().trim();
                if (property.length() == 0) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)PluginCmdChangeProperties.this._propertyCtrl), "Property empty");
                    PluginCmdChangeProperties.this._propertyCtrl.requestFocus();
                    return;
                }
                String value = PluginCmdChangeProperties.this._valueCtrl.getText().trim();
                if (value.length() == 0) {
                    System.clearProperty(property);
                } else {
                    System.setProperty(property, value);
                    PluginCmdChangeProperties.this.refreshProperties(property);
                }
            }
        });
        this._refreshCtrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginCmdChangeProperties.this.refreshProperties(null);
            }
        });
        this._dlg.pack();
        this._dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf((Component)win));
    }

    public void createSession(Plugable launcher, Object parameters) {
        if (this._dlg == null) {
            this.createDialog(launcher.getWindow());
        }
        if (this._dlg.isVisible()) {
            this._dlg.requestFocus();
        } else {
            this._dlg.setVisible(true);
        }
    }

    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return "ChangeProperties";
        }
        if (key.equals("plugin.description")) {
            return "Open dialog for change properties";
        }
        return super.getInfo(key);
    }
}

