/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.general.robot;

import java.awt.AWTException;
import java.awt.Robot;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RobotPlay
implements Runnable {
    private File _cmdsFile;
    private LinkedList<String> _basePathLst = new LinkedList();
    private Robot _robot;
    protected StringBuffer _errorBuffer;

    public RobotPlay(File cmds) throws AWTException {
        this._cmdsFile = cmds;
        this._robot = new Robot();
        this._errorBuffer = new StringBuffer(128);
    }

    @Override
    public void run() {
        this.play(this._cmdsFile.getAbsolutePath());
    }

    public boolean withError() {
        return this._errorBuffer.length() > 0;
    }

    public String getErrorMsg() {
        return this._errorBuffer.toString();
    }

    protected boolean getBoolOpt(HashMap<String, String> attrs, String key, boolean def) {
        if (!attrs.containsKey(key)) {
            return def;
        }
        String val = attrs.get(key);
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        if (val.equalsIgnoreCase("accept")) {
            return true;
        }
        if (val.equalsIgnoreCase("yes")) {
            return true;
        }
        if (val.equalsIgnoreCase("false")) {
            return false;
        }
        if (val.equalsIgnoreCase("no")) {
            return false;
        }
        return def;
    }

    protected int getIntOpt(HashMap<String, String> attrs, String key, int def) {
        if (!attrs.containsKey(key)) {
            return def;
        }
        String val = attrs.get(key);
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    protected String getStringOpt(HashMap<String, String> attrs, String key, String def) {
        if (!attrs.containsKey(key)) {
            return def;
        }
        return attrs.get(key);
    }

    protected void startAction(String key, HashMap<String, String> attrs) throws SAXException {
        String act;
        if (key.equals("mouse")) {
            act = attrs.get("act");
            int x = this.getIntOpt(attrs, "x", -1);
            int y = this.getIntOpt(attrs, "y", -1);
            if (act == null || x == -1 || y == -1) {
                this._errorBuffer.append("Mouse error");
                return;
            }
            if (act.equals("press")) {
                int but = this.getIntOpt(attrs, "but", 1024);
                this._robot.mouseMove(x, y);
                this._robot.mousePress(but);
            } else if (act.equals("release")) {
                int but = this.getIntOpt(attrs, "but", 1024);
                this._robot.mouseMove(x, y);
                this._robot.mouseRelease(but);
            } else if (act.equals("move")) {
                this._robot.mouseMove(x, y);
            }
        }
        if (key.equals("keybd")) {
            act = attrs.get("act");
            int cKey = this.getIntOpt(attrs, "key", -1);
            if (act == null || cKey == -1) {
                this._errorBuffer.append("Keybd error");
                return;
            }
            if (act.equals("press")) {
                this._robot.keyPress(cKey);
            } else if (act.equals("release")) {
                this._robot.keyRelease(cKey);
            }
        }
        if (key.equals("sleep")) {
            int delay = this.getIntOpt(attrs, "delay", -1);
            if (delay == -1) {
                this._errorBuffer.append("Sleep error");
                return;
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                throw new SAXException("InterruptedException", e);
            }
        }
        if (key.equals("include")) {
            String file = this.getStringOpt(attrs, "file", null);
            if (file == null) {
                this._errorBuffer.append("Include error");
                return;
            }
            if (!this.play(file)) {
                throw new SAXException("SubScript error");
            }
        }
    }

    protected void endAction(String key, HashMap<String, String> attrs, String txt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean play(String child) {
        String parent = this._basePathLst.size() > 0 ? this._basePathLst.getLast() : null;
        File file = new File(parent, child);
        parent = file.getParent();
        this._basePathLst.addLast(parent);
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            ActionsHandler handler = new ActionsHandler();
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse(file, (DefaultHandler)handler);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this._errorBuffer.append("RobotPlay=>IOException : ");
            this._errorBuffer.append(e.getMessage());
            this._errorBuffer.append("\n\t");
            this._errorBuffer.append(file.getName());
            this._errorBuffer.append("\n");
        }
        catch (ParserConfigurationException e) {
            this._errorBuffer.append("RobotPlay=>ParserConfigurationException : ");
            this._errorBuffer.append(e.getMessage());
            this._errorBuffer.append("\n\t");
            this._errorBuffer.append(file.getName());
            this._errorBuffer.append("\n");
        }
        catch (SAXParseException e) {
            this._errorBuffer.append("RobotPlay=>SAXParseException [");
            this._errorBuffer.append(e.getLineNumber());
            this._errorBuffer.append("] : ");
            this._errorBuffer.append(e.getMessage());
            this._errorBuffer.append("\n\t");
            this._errorBuffer.append(file.getName());
            this._errorBuffer.append("\n");
        }
        catch (SAXException e) {
            this._errorBuffer.append("RobotPlay=>SAXException : ");
            this._errorBuffer.append(e.getMessage());
            this._errorBuffer.append("\n\t");
            this._errorBuffer.append(file.getName());
            this._errorBuffer.append("\n");
        }
        finally {
            this._basePathLst.removeLast();
        }
        return false;
    }

    class ActionsHandler
    extends DefaultHandler {
        LinkedList<myElement> _lifo = new LinkedList();
        Locator _locator;

        ActionsHandler() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this._locator = locator;
            super.setDocumentLocator(locator);
        }

        @Override
        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
            myElement elem = new myElement(sName, qName, attrs);
            this._lifo.addLast(elem);
            RobotPlay.this.startAction(elem._name, elem._attrs);
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            myElement elem = this._lifo.removeLast();
            RobotPlay.this.endAction(elem._name, elem._attrs, elem._text == null ? "" : elem._text.toString());
        }

        @Override
        public void characters(char[] buf, int offset, int len) throws SAXException {
            String s = new String(buf, offset, len);
            myElement elem = this._lifo.getLast();
            if (elem._text == null) {
                elem._text = new StringBuffer(s);
            } else {
                elem._text.append(s);
            }
        }

        class myElement {
            String _name;
            HashMap<String, String> _attrs = new HashMap();
            StringBuffer _text;

            myElement(String sName, String qName, Attributes attrs) {
                this._name = sName;
                if ("".equals(this._name)) {
                    this._name = qName;
                }
                if (attrs != null) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        String aName = attrs.getLocalName(i);
                        if ("".equals(aName)) {
                            aName = attrs.getQName(i);
                        }
                        this._attrs.put(aName, attrs.getValue(i));
                    }
                }
            }
        }
    }
}

