/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.txtsimul;

import com.dassault.cecilia.plugin.mbsa.txtsimul.ResSimul;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class TableModelNode
extends AbstractTableModel {
    private ArrayList nodes = new ArrayList();
    public int selectIdx;

    public void setNodes(JTable table, Collection all) {
        this.nodes = new ArrayList(all);
        this.selectIdx = -1;
        this.fireTableDataChanged();
        if (this.selectIdx == -1 && this.nodes.size() == 1) {
            this.selectIdx = 0;
        }
        if (this.selectIdx != -1) {
            table.setRowSelectionInterval(this.selectIdx, this.selectIdx);
        }
    }

    public void recupNodes(JTable table, File file) {
        this.nodes.clear();
        this.selectIdx = -1;
        if (!file.isDirectory()) {
            try {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(file));
                boolean next = false;
                while ((line = in.readLine()) != null) {
                    StringTokenizer t = new StringTokenizer(line);
                    while (t.hasMoreTokens()) {
                        String token = t.nextToken();
                        if (next) {
                            if (token.equalsIgnoreCase("main")) {
                                this.selectIdx = this.nodes.size();
                            }
                            this.nodes.add(token);
                            next = false;
                            continue;
                        }
                        next = token.equals("node");
                    }
                }
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.fireTableDataChanged();
        if (this.selectIdx == -1 && this.nodes.size() == 1) {
            this.selectIdx = 0;
        }
        if (this.selectIdx != -1) {
            table.setRowSelectionInterval(this.selectIdx, this.selectIdx);
        }
    }

    @Override
    public int getRowCount() {
        return this.nodes.size();
    }

    @Override
    public Object getValueAt(int arg0, int arg1) {
        return this.nodes.get(arg0);
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int column) {
        return ResSimul.getString("DLG_SELNODE_MODEL");
    }

    public String getNodeModel() {
        if (this.selectIdx == -1) {
            return null;
        }
        if (this.nodes.size() < this.selectIdx) {
            return null;
        }
        return (String)this.nodes.get(this.selectIdx);
    }
}

