/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.compute;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.compute.ARALIAComputor;
import com.dassault.cecilia.lib.distrib.compute.CmdLauncher;
import com.dassault.cecilia.lib.distrib.compute.CopyStream;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.request.Request;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ARALIA4Computor
extends ARALIAComputor {
    public static final String ARALIA4MEMORYERR = "Memory exhausted";
    public static final String ARALIA4TIMEERR = "Time elapsed";
    public static final String ARALIA4LICENSEERR = "Incorrect or absent license key";
    public static final String ARALIA4VERSION = "aralia version ";
    public static final String ARALIA4NODLL = "No DLL";
    public static final String ARALIA4YOURANSWER = "Your answer";
    public static final String ARALIA4UNABLETOOPENFILE = "Unable to open file";
    public static final String ARALIA4QUIT = "(q): Quit.";

    public ARALIA4Computor() {
        File lowstart = null;
        String propLowstart = System.getProperty("cecilia.jxta.aralia4.lowstart.exec");
        if (propLowstart != null) {
            lowstart = new File(propLowstart);
            if (!lowstart.exists()) {
                Loggeur.log(this.getClass(), Loggeur.ERROR, "cecilia.jxta.aralia4.lowstart.exec " + ResJXTA.getString("ENGINE_WRONG_PATH"));
                return;
            }
            this._bUseLowstart = true;
        } else {
            this._bUseLowstart = false;
        }
        File engine = new File(System.getProperty("cecilia.jxta.aralia4.exec", "aralia4.exe"));
        if (!engine.exists()) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, "cecilia.jxta.aralia4.exec " + ResJXTA.getString("ENGINE_WRONG_PATH"));
            return;
        }
        this._processLaunchArray = new ArrayList();
        if (this._bUseLowstart) {
            this._processLaunchArray.add(lowstart.getAbsolutePath());
            String lowstartOptions = System.getProperty("cecilia.jxta.aralia4.lowstart.options");
            if (lowstartOptions != null) {
                ARALIA4Computor.parseArguments(lowstartOptions, this._processLaunchArray);
            }
        }
        this._processLaunchArray.add(engine.getAbsolutePath());
        File config = new File(System.getProperty("cecilia.jxta.aralia4.config", "aralia4.cfg"));
        if (config.exists()) {
            this._configurationPath = config.getAbsolutePath();
        } else {
            Loggeur.log(this.getClass(), Loggeur.WARNING, "cecilia.jxta.aralia4.config " + ResJXTA.getString("ENGINE_WRONG_PATH"));
        }
    }

    @Override
    protected void initErrorMessage() {
        this.versionMessage = ARALIA4VERSION;
    }

    @Override
    public int containsErrorDuringTest(String line, boolean out) {
        if (line.contains(ARALIA4LICENSEERR)) {
            return -300;
        }
        if (line.contains(ARALIA4NODLL)) {
            return -400;
        }
        return 12345;
    }

    @Override
    public int containsErrorDuringComputing(String line, boolean out) {
        if (out) {
            if (line.contains(ARALIA4YOURANSWER)) {
                return -600;
            }
            if (line.equals(ARALIA4QUIT)) {
                return -600;
            }
            if (line.contains(ARALIA4MEMORYERR)) {
                return -100;
            }
            if (line.contains(ARALIA4TIMEERR)) {
                return -200;
            }
            if (line.contains(ARALIA4LICENSEERR)) {
                return -300;
            }
            if (line.contains(ARALIA4NODLL)) {
                return -400;
            }
        } else {
            if (line.contains(ARALIA4MEMORYERR)) {
                return -100;
            }
            if (line.contains(ARALIA4TIMEERR)) {
                return -200;
            }
            if (line.contains(ARALIA4YOURANSWER)) {
                return -600;
            }
            if (line.equals(ARALIA4QUIT)) {
                return -600;
            }
            if (line.contains(ARALIA4LICENSEERR)) {
                return -300;
            }
            if (line.contains(ARALIA4NODLL)) {
                return -400;
            }
            if (line.contains(ARALIA4UNABLETOOPENFILE)) {
                return -700;
            }
        }
        return 12345;
    }

    @Override
    public boolean verifyEngine() {
        block7: {
            block6: {
                if (this._processLaunchArray == null) {
                    return false;
                }
                this._computingState = 0;
                try {
                    String[] cmd = new String[this._processLaunchArray.size()];
                    cmd = this._processLaunchArray.toArray(cmd);
                    this._proc = CmdLauncher.execute(null, cmd, null, JXTAProperties.getTempDir());
                    CopyStream outThread = new CopyStream("ENGINE-OUT-ARALIA4"){

                        @Override
                        protected void println(String line) {
                            super.println(line);
                            int err = ARALIA4Computor.this.containsErrorDuringTest(line, true);
                            if (err != 12345) {
                                ARALIA4Computor.this._computingState = err;
                            }
                            if (line.contains(ARALIA4Computor.this.versionMessage)) {
                                ARALIA4Computor.this.version = ARALIA4Computor.this.getVersion(line);
                            }
                        }
                    };
                    outThread.setIn(this._proc.getInputStream());
                    outThread.setOut(System.out);
                    outThread.start();
                    CopyStream errThread = new CopyStream("ENGINE-ERR-ARALIA4"){

                        @Override
                        protected void println(String line) {
                            super.println(line);
                            int err = ARALIA4Computor.this.containsErrorDuringTest(line, false);
                            if (err != 12345) {
                                ARALIA4Computor.this._computingState = err;
                            }
                        }
                    };
                    errThread.setIn(this._proc.getErrorStream());
                    errThread.setOut(System.err);
                    errThread.start();
                    OutputStream entreeStd = this._proc.getOutputStream();
                    byte[] loadexit = "exit;\n".getBytes();
                    entreeStd.write(loadexit);
                    entreeStd.flush();
                    entreeStd.close();
                    this._proc.waitFor();
                    Thread.sleep(100L);
                    if (this._computingState != -300) break block6;
                    Loggeur.log(this.getClass(), Loggeur.INFO, ResJXTA.getString("ENGINE_ARALIA_ERROR_BAD_LICENSE"));
                    this._proc.destroy();
                    return false;
                }
                catch (Exception e) {
                    Loggeur.log(this.getClass(), Loggeur.ERROR, ResJXTA.msgFormat("ENGINE_ERROR", ""));
                    e.printStackTrace();
                    return false;
                }
            }
            if (this._computingState != -400) break block7;
            Loggeur.log(this.getClass(), Loggeur.INFO, ResJXTA.getString("ENGINE_ARALIA_ERROR_NO_DLL"));
            this._proc.destroy();
            return false;
        }
        if (this.version.equals("") || !this.version.substring(0, 1).equals("4")) {
            Loggeur.log(this.getClass(), Loggeur.INFO, ResJXTA.getString("ENGINE_ARALIA_ERROR_VERSION"));
            this._computingState = -500;
            return false;
        }
        return true;
    }

    @Override
    protected void launchExecutable(Request req) throws IOException {
        String cmdFileName = req.getCmdFileName();
        List<String> neededFiles = req.getNeededFiles();
        int nbrFile = 0;
        if (this._configurationPath != null) {
            ++nbrFile;
        }
        nbrFile += neededFiles.size();
        if (!neededFiles.contains(cmdFileName)) {
            ++nbrFile;
        }
        String[] cmds = new String[nbrFile + this._processLaunchArray.size()];
        cmds = this._processLaunchArray.toArray(cmds);
        int idx = this._processLaunchArray.size();
        if (this._configurationPath != null) {
            cmds[idx++] = this._configurationPath;
        }
        for (String uniqueFileName : neededFiles) {
            if (uniqueFileName.equals(cmdFileName)) continue;
            File neededFile = new File(JXTAProperties.getTempDir(), uniqueFileName);
            cmds[idx++] = neededFile.getAbsolutePath();
        }
        File cmdFile = new File(JXTAProperties.getTempDir(), cmdFileName);
        cmds[idx++] = cmdFile.getAbsolutePath();
        this._proc = CmdLauncher.execute(req.getShortNumber(), cmds, null, JXTAProperties.getTempDir());
    }
}

