/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.compute;

import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.ban.BanLicenseManager;
import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessEvent;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.BanProcessListener;
import com.dassault.cecilia.lib.ban.CryptData;
import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.compute.BANExternalComputorTestLaunch;
import com.dassault.cecilia.lib.distrib.compute.CmdLauncher;
import com.dassault.cecilia.lib.distrib.compute.CopyStream;
import com.dassault.cecilia.lib.distrib.compute.ProcessComputor;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.request.Request;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BANExternalComputor
extends ProcessComputor {
    public static final int BAN_ERROR_NO_COMMAND = -100;
    public static final int BAN_ERROR_ADD = 10000;
    public static final String NUMBER_OF_ERROR = "dban.result";
    public static final String BASE_DIR_PROPERTY = "dban.basedir";
    public static final String BAN_ERRHEADER = "Ban computor Exception : ";
    protected List<String> _processLaunchArray;
    static final String VERSION_TAG = "Version=";
    static final String VERSION_START = "6.";
    private String _version = "";
    static final int ENGINE_ERROR_EXCEPTION = 10;
    static final int ENGINE_ERROR_VERSION = 11;
    File _launchFile;
    private boolean _errorInStdErr = false;
    public static final int XBAN_RESULT_ERR_PROCESS = -1;
    public static final int XBAN_RESULT_ERR_SYNTAX = -2;
    public static final int XBAN_RESULT_ERR_EXCEPTION = -3;
    public static final int XBAN_RESULT_ERR_FINISH = -4;
    public static final int XBAN_RESULT_ERR_LICENSE = -5;
    public static final int XBAN_RESULT_ERR_CODE = -6;
    private static final Logger _LOG = Logger.getLogger(BANExternalComputor.class.getPackage().getName());

    public BANExternalComputor() {
        File lowstart = null;
        String propLowstart = System.getProperty("cecilia.jxta.ban.lowstart.exec");
        if (propLowstart != null) {
            lowstart = new File(propLowstart);
            if (!lowstart.exists()) {
                Loggeur.log(this.getClass(), Loggeur.ERROR, "cecilia.jxta.ban.lowstart.exec " + ResJXTA.getString("ENGINE_WRONG_PATH"));
                return;
            }
            this._bUseLowstart = true;
        } else {
            this._bUseLowstart = false;
        }
        File engine = new File(System.getProperty("cecilia.jxta.ban.java.exec", "java.exe"));
        if (!engine.exists()) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, "cecilia.jxta.ban.java.exec " + ResJXTA.getString("ENGINE_WRONG_PATH"));
            return;
        }
        String engineOptions = System.getProperty("cecilia.jxta.ban.java.options", "");
        this._processLaunchArray = new ArrayList<String>();
        if (this._bUseLowstart) {
            this._processLaunchArray.add(lowstart.getAbsolutePath());
            String lowstartOptions = System.getProperty("cecilia.jxta.ban.lowstart.options");
            if (lowstartOptions != null) {
                BANExternalComputor.parseArguments(lowstartOptions, this._processLaunchArray);
            }
        }
        this._processLaunchArray.add(engine.getAbsolutePath());
        if (engineOptions.length() > 0) {
            BANExternalComputor.parseArguments(engineOptions, this._processLaunchArray);
        }
    }

    @Override
    public boolean sendResultIfError() {
        return true;
    }

    @Override
    public boolean verifyEngine() {
        block5: {
            if (this._processLaunchArray == null) {
                return false;
            }
            this._computingState = 0;
            try {
                String[] cmds = new String[this._processLaunchArray.size() + 1];
                cmds = this._processLaunchArray.toArray(cmds);
                cmds[this._processLaunchArray.size()] = BANExternalComputorTestLaunch.class.getName();
                this._proc = CmdLauncher.execute(null, cmds, null, new File(JXTAProperties.getDistributedDir()));
                CopyStream outThread = new CopyStream("ENGINE-OUT-XBAN"){

                    @Override
                    protected void println(String line) {
                        super.println(line);
                        if (line.startsWith(BANExternalComputor.VERSION_TAG)) {
                            BANExternalComputor.this._version = line.substring(BANExternalComputor.VERSION_TAG.length());
                        }
                    }
                };
                outThread.setIn(this._proc.getInputStream());
                outThread.setOut(System.out);
                outThread.start();
                CopyStream errThread = new CopyStream("ENGINE-ERR-XBAN"){

                    @Override
                    protected void println(String line) {
                        super.println(line);
                        BANExternalComputor.this._computingState = 10;
                    }
                };
                errThread.setIn(this._proc.getErrorStream());
                errThread.setOut(System.err);
                errThread.start();
                this._proc.waitFor();
                Thread.sleep(100L);
                if (this._computingState != 10) break block5;
                return false;
            }
            catch (Exception e) {
                Loggeur.log(this.getClass(), Loggeur.ERROR, ResJXTA.msgFormat("ENGINE_ERROR", ""));
                e.printStackTrace();
                return false;
            }
        }
        if (this._version.length() == 0 || !this._version.startsWith(VERSION_START)) {
            Loggeur.log(this.getClass(), Loggeur.INFO, ResJXTA.getString("ENGINE_XBAN_ERROR_VERSION"));
            this._computingState = 11;
            return false;
        }
        return true;
    }

    @Override
    protected void launchExecutable(Request req) throws IOException {
        this._launchFile = null;
        this._errorInStdErr = false;
        String banoptions = req.getEngineOptions();
        Loggeur.log(this.getClass(), Loggeur.INFO, "BAN " + banoptions);
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(banoptions, ",");
        while (st.hasMoreTokens()) {
            String data = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(data, "=");
            String key = null;
            String objet = null;
            if (st2.hasMoreTokens()) {
                key = st2.nextToken();
            }
            if (st2.hasMoreTokens()) {
                objet = st2.nextToken();
            }
            if (key != null) {
                if (objet == null) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Null value for ban option ");
                    sb.append(String.valueOf(key));
                    Loggeur.log(this.getClass(), Loggeur.WARNING, sb.toString());
                    objet = "";
                }
                optionsMap.put(key, objet);
                continue;
            }
            Loggeur.log(this.getClass(), Loggeur.WARNING, "Null key for ban option");
        }
        File scriptFile = null;
        String cmdFileName = (String)optionsMap.get("COMMAND");
        if (cmdFileName == null) {
            req.setInfo(String.valueOf(-100));
            return;
        }
        scriptFile = new File(JXTAProperties.getTempDir(), cmdFileName);
        optionsMap.remove("COMMAND");
        this._launchFile = File.createTempFile("Launch", ".ini", JXTAProperties.getTempDir());
        if (Boolean.getBoolean("cecilia.jxta.ban.ErrorPropertiesIni")) {
            try (FileWriter writer = null;){
                writer = new FileWriter(this._launchFile);
                writer.write(this._launchFile.getAbsolutePath());
            }
        }
        Properties props = new Properties();
        for (Map.Entry entry : optionsMap.entrySet()) {
            if (((String)entry.getValue()).contains("\n")) {
                StringBuffer sb = new StringBuffer();
                sb.append("LineBreak in option ");
                sb.append((String)entry.getKey());
                sb.append(" val = ");
                sb.append((String)entry.getValue());
                Loggeur.log(this.getClass(), Loggeur.FINE, sb.toString());
            }
            props.put(entry.getKey(), ((String)entry.getValue()).replace("\n", ""));
        }
        props.put(BASE_DIR_PROPERTY, JXTAProperties.getTempDir().getAbsolutePath());
        try (FileWriter writer = null;){
            writer = new FileWriter(this._launchFile);
            props.store(writer, "");
        }
        String[] cmds = new String[this._processLaunchArray.size() + 4];
        cmds = this._processLaunchArray.toArray(cmds);
        int idx = this._processLaunchArray.size();
        cmds[idx++] = XBanMain.class.getName();
        cmds[idx++] = scriptFile.getAbsolutePath();
        cmds[idx++] = "-launch";
        cmds[idx++] = Boolean.getBoolean("cecilia.jxta.ban.ErrorFileIni") ? String.valueOf(this._launchFile.getAbsolutePath()) + ".err" : this._launchFile.getAbsolutePath();
        this._proc = CmdLauncher.execute(null, cmds, null, new File(JXTAProperties.getDistributedDir()));
    }

    @Override
    protected int filterExecutable(Request req, int exitValue) {
        if (exitValue > 10000) {
            int nbErr = exitValue - 10000;
            req.setInfo(nbErr + " " + ResJXTA.getString("GLOBAL_ERRORS"));
            req.setNumberOfErr(nbErr);
            exitValue = 0;
        }
        if (exitValue == 0 && this._errorInStdErr) {
            return 10;
        }
        return super.filterExecutable(req, exitValue);
    }

    @Override
    protected void finalizeExecutable(Request req) {
        if (this._launchFile != null && this._launchFile.exists() && !this._launchFile.delete()) {
            this._launchFile.deleteOnExit();
        }
        this._launchFile = null;
        this._errorInStdErr = false;
    }

    @Override
    public int containsErrorDuringComputing(String line, boolean out) {
        if (out) {
            return 12345;
        }
        this._errorInStdErr = true;
        return 12345;
    }

    @Override
    public String createMessage(int err) {
        switch (err) {
            case 11: {
                return ResJXTA.getString("ENGINE_XBAN_ERROR_VERSION");
            }
            case 10: {
                return ResJXTA.getString("ENGINE_XBAN_ERROR_EXCEPTION");
            }
        }
        return super.createMessage(err);
    }

    public static class XBanMain
    implements BanProcessListener {
        private boolean _banFinnished = false;
        private int _errorsInBan = 0;
        private BanEntry banProcess = null;

        public static void main(String[] args) {
            class BanOCASLicenseManager
            extends BanLicenseManager {
                BanOCASLicenseManager() {
                }

                protected void validLicense(BanProcess process) throws BanLicenseException {
                }

                protected byte[] getData(int value) {
                    String name = "JXTABAN";
                    switch (value) {
                        case 1: {
                            return name.getBytes();
                        }
                        case 2: {
                            return CryptData.cryptData((String)name, (String)"zertyghjklmpqwxc").getBytes();
                        }
                        case 3: {
                            return "zertyghjklmpqwxc".getBytes();
                        }
                    }
                    return null;
                }
            }
            BanLicenseManager.defineManager((BanLicenseManager)new BanOCASLicenseManager());
            XBanMain xBan = new XBanMain();
            int result = xBan.Main(args);
            System.exit(result);
        }

        public void messageLogged(BanProcessEvent event) {
        }

        public void processFinished(BanProcessEvent event) {
            this._banFinnished = true;
        }

        public void processStarted(BanProcessEvent event) {
        }

        public void unitFinished(BanProcessEvent event) {
        }

        public void unitProgressed(BanProcessEvent event) {
        }

        public void unitStarted(BanProcessEvent event) {
        }

        private void logError(String msg) {
            _LOG.severe(msg);
            System.err.println(msg);
        }

        private void logException(String msg, Throwable e) {
            _LOG.log(Level.SEVERE, msg, e);
            System.err.println(String.valueOf(msg) + ": " + e.getMessage());
        }

        private int Main(String[] args) {
            if (args.length < 1) {
                this.logError("Syntax launch error");
                return -2;
            }
            File script = new File(args[0]);
            if (!(script.exists() && script.isFile() && script.canRead())) {
                this.logError("Script file error");
                return -2;
            }
            try {
                this.banProcess = new BanEntry();
            }
            catch (BanLicenseException e) {
                this.logException("License exception", e);
                return -5;
            }
            int result = this.readArgs(this.banProcess, args);
            if (result != 0) {
                return result;
            }
            this.banProcess.addProcessListener((BanProcessListener)this);
            try {
                this.banProcess.execute(script);
                Object nbErrObj = this.banProcess.getValueOfVariable(BANExternalComputor.NUMBER_OF_ERROR);
                if (nbErrObj == null) {
                    nbErrObj = this.banProcess.getValueOfVariable("seqgen.result");
                }
                if (nbErrObj != null) {
                    this._errorsInBan = Integer.parseInt(nbErrObj.toString());
                    if (this._errorsInBan > 0) {
                        this._errorsInBan += 10000;
                    }
                } else {
                    this._errorsInBan = -6;
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (BanProcessException e) {
                this.logException("Process exception", e);
                return -1;
            }
            catch (Exception e) {
                this.logException("Unknow exception", e);
                return -3;
            }
            catch (Error e) {
                this.logException("Unknow error", e);
                return -3;
            }
            if (this._banFinnished) {
                return this._errorsInBan;
            }
            return -4;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int readArgs(BanEntry ban, String[] args) {
            int i = 1;
            while (i < args.length) {
                String arg = args[i];
                if (arg.startsWith("-lang=")) {
                    String lang = arg.substring("-lang=".length());
                    System.setProperty("user.language", lang);
                } else {
                    if (arg.startsWith("-launch")) {
                        if (++i >= args.length) {
                            this.logError("Syntax launch error");
                            return -2;
                        }
                        String path = args[i];
                        File input = new File(path);
                        if (!input.exists()) {
                            this.logError("Launch file don't exist [" + path + "]");
                            return -2;
                        }
                        if (!input.isFile()) {
                            this.logError("Launch file is not file [" + path + "]");
                            return -2;
                        }
                        if (!input.canRead()) {
                            this.logError("Launch file is not readeable [" + path + "]");
                            return -2;
                        }
                        try {
                            Properties props = new Properties();
                            FileInputStream fis = new FileInputStream(input);
                            props.load(fis);
                            fis.close();
                            Enumeration<?> values = props.propertyNames();
                            while (values.hasMoreElements()) {
                                String key = (String)values.nextElement();
                                String value = props.getProperty(key).trim();
                                ban.setUserProperty(key, value);
                            }
                        }
                        catch (IOException e) {
                            this.logException("Launch file reading exception [" + path + "]", e);
                            return -2;
                        }
                    }
                    if (arg.startsWith("-D")) {
                        String data = arg.substring(2);
                        int pos = data.indexOf(61);
                        if (pos == -1) {
                            ban.setUserProperty(data, "true");
                        } else {
                            String key = data.substring(0, pos);
                            String val = data.substring(pos + 1);
                            int len = val.length();
                            if (len >= 2 && val.charAt(0) == '\"' && val.charAt(len - 1) == '\"') {
                                val = val.substring(1, len - 1);
                            }
                            ban.setUserProperty(key, val);
                        }
                    } else {
                        File input = new File(arg);
                        if (!(!input.exists() || input.isFile() && input.canRead())) {
                            this.logError("Input file error [" + arg + "]");
                            return -2;
                        }
                    }
                }
                ++i;
            }
            return 0;
        }
    }
}

