/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.compute;

import com.dassault.cecilia.lib.distrib.compute.PreAndPostProcessor;
import com.dassault.cecilia.lib.distrib.peers.AppPeer;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.distrib.request.Request;
import java.util.HashMap;
import java.util.Map;

public class ClientProcessor {
    protected Map<String, PreAndPostProcessor> _computors;
    protected CECILIAClient _client;

    public ClientProcessor(CECILIAClient client) {
        this._client = client;
        this._computors = new HashMap<String, PreAndPostProcessor>();
    }

    public boolean isEngineOK(Request req) {
        PreAndPostProcessor computor = this._computors.get(req.getEngine());
        return computor != null;
    }

    public void addComputor(String name, PreAndPostProcessor computor) {
        if (this._computors.get(name) == null) {
            this._computors.put(name, computor);
        }
    }

    public boolean preProcess(Request req) {
        PreAndPostProcessor computor = this._computors.get(req.getEngine());
        return computor.preProcess(req);
    }

    public String createMessage(String engine, int err) {
        PreAndPostProcessor computor = this._computors.get(engine);
        return computor.createMessage(err);
    }

    public void setCurrentProcess(Process proc) {
    }

    public Process getCurrentProcess() {
        return null;
    }

    public AppPeer getCeciliaPeer() {
        return this._client;
    }

    public void manageRequestError(Request req) {
        PreAndPostProcessor computor = this._computors.get(req.getEngine());
        computor.manageReqError(req, this._client.getServersApp().getServer(req.getServerID()), this._client);
    }

    public boolean doSpecificThreatment(Request req) {
        PreAndPostProcessor computor = this._computors.get(req.getEngine());
        return computor.manageFinishedRequest(req);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (String key : this._computors.keySet()) {
            sb.append(key).append(",");
        }
        sb.replace(sb.length() - 1, sb.length() - 1, "}");
        return sb.toString();
    }
}

